/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.app.drawer;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.transition.Slide;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.lifecycle.Observer;
import cloud.pace.sdk.R;
import cloud.pace.sdk.appkit.app.drawer.AppDrawerViewModel;
import cloud.pace.sdk.appkit.model.App;
import cloud.pace.sdk.utils.CloudSDKKoinComponent;
import cloud.pace.sdk.utils.Event;
import cloud.pace.sdk.utils.ExtensionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0001NB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0012H\u0002J\u0010\u0010=\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0012H\u0002J\u0006\u0010>\u001a\u00020\u0015J\u0012\u0010?\u001a\u00020\u00122\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0006\u0010<\u001a\u00020\u0015J\u0010\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020\u0012H\u0002J\b\u0010D\u001a\u00020\u0015H\u0014J\b\u0010E\u001a\u00020\u0015H\u0014J\u001e\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u0018J\u000e\u0010K\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010L\u001a\u00020$H\u0002J\u0006\u0010M\u001a\u00020\u0015R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(R(\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u000b\u001a\u0004\u0018\u00010)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0016\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010,\"\u0004\b3\u0010.R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020)0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00105\u001a\u0002068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b7\u00108\u00a8\u0006O"}, d2={"Lcloud/pace/sdk/appkit/app/drawer/AppDrawer;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Lcloud/pace/sdk/utils/CloudSDKKoinComponent;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "backgroundObserver", "Landroidx/lifecycle/Observer;", "", "value", "backgroundTint", "getBackgroundTint", "()I", "setBackgroundTint", "(I)V", "cancelClick", "", "closeEventObserver", "Lcloud/pace/sdk/utils/Event;", "", "currentWidth", "expandModeClickListener", "Landroid/view/View$OnClickListener;", "icon", "getIcon", "setIcon", "iconBackgroundObserver", "iconTint", "getIconTint", "setIconTint", "initialX", "", "isExpanded", "logoObserver", "Landroid/graphics/Bitmap;", "maxBackgroundWidth", "minBackgroundWidth", "shouldExpand", "Ljava/lang/Boolean;", "", "subtitle", "getSubtitle", "()Ljava/lang/String;", "setSubtitle", "(Ljava/lang/String;)V", "subtitleObserver", "textColorObserver", "title", "getTitle", "setTitle", "titleObserver", "viewModel", "Lcloud/pace/sdk/appkit/app/drawer/AppDrawerViewModel;", "getViewModel", "()Lcloud/pace/sdk/appkit/app/drawer/AppDrawerViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "animateIconBackground", "expand", "animateView", "collapse", "dispatchTouchEvent", "ev", "Landroid/view/MotionEvent;", "handleCloseButton", "enable", "onAttachedToWindow", "onDetachedFromWindow", "setApp", "app", "Lcloud/pace/sdk/appkit/model/App;", "darkBackground", "listener", "setExpandedModeOnClickListener", "bitmap", "show", "Companion", "cloud.pace.sdk"})
public final class AppDrawer
extends ConstraintLayout
implements CloudSDKKoinComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    private final int minBackgroundWidth;
    @Nullable
    private View.OnClickListener expandModeClickListener;
    private int maxBackgroundWidth;
    private float initialX;
    private int currentWidth;
    @Nullable
    private Boolean shouldExpand;
    private boolean isExpanded;
    private boolean cancelClick;
    @NotNull
    private String title;
    @Nullable
    private String subtitle;
    private int icon;
    @ColorInt
    private int iconTint;
    @ColorInt
    private int backgroundTint;
    @NotNull
    private final Observer<String> titleObserver;
    @NotNull
    private final Observer<String> subtitleObserver;
    @NotNull
    private final Observer<Integer> backgroundObserver;
    @NotNull
    private final Observer<Integer> iconBackgroundObserver;
    @NotNull
    private final Observer<Bitmap> logoObserver;
    @NotNull
    private final Observer<Integer> textColorObserver;
    @NotNull
    private final Observer<Event<Unit>> closeEventObserver;
    private static final int TOUCH_TOLERANCE = 50;
    private static final float START_MARGIN = 20.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppDrawer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.viewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<AppDrawerViewModel>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AppDrawerViewModel invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(AppDrawerViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(AppDrawerViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.minBackgroundWidth = (int)context.getResources().getDimension(R.dimen.app_drawer_height);
        this.title = "";
        this.icon = R.drawable.ic_default;
        this.iconTint = context.getColor(R.color.highlight);
        this.backgroundTint = context.getColor(R.color.background_dark);
        this.titleObserver = arg_0 -> AppDrawer.titleObserver$lambda-0(this, arg_0);
        this.subtitleObserver = arg_0 -> AppDrawer.subtitleObserver$lambda-1(this, arg_0);
        this.backgroundObserver = arg_0 -> AppDrawer.backgroundObserver$lambda-2(this, arg_0);
        this.iconBackgroundObserver = arg_0 -> AppDrawer.iconBackgroundObserver$lambda-3(this, arg_0);
        this.logoObserver = arg_0 -> AppDrawer.logoObserver$lambda-4(this, arg_0);
        this.textColorObserver = arg_0 -> AppDrawer.textColorObserver$lambda-5(this, arg_0);
        this.closeEventObserver = arg_0 -> AppDrawer.closeEventObserver$lambda-6(this, arg_0);
        ConstraintLayout.inflate((Context)context, (int)R.layout.app_drawer, (ViewGroup)((ViewGroup)this));
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AppDrawer, 0, 0);
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$_init__u24lambda_u2d7 = typedArray;
        boolean bl3 = false;
        try {
            String string = $this$_init__u24lambda_u2d7.getString(R.styleable.AppDrawer_title);
            this.setTitle(string == null ? "" : string);
            this.setSubtitle($this$_init__u24lambda_u2d7.getString(R.styleable.AppDrawer_subtitle));
            this.setIcon($this$_init__u24lambda_u2d7.getResourceId(R.styleable.AppDrawer_icon, R.drawable.ic_default));
            this.setIconTint(context.getColor($this$_init__u24lambda_u2d7.getResourceId(R.styleable.AppDrawer_iconTint, R.color.highlight)));
            this.setBackgroundTint(context.getColor(R.color.highlight));
        }
        finally {
            $this$_init__u24lambda_u2d7.recycle();
        }
        this.currentWidth = this.maxBackgroundWidth = this.getResources().getDisplayMetrics().widthPixels - ExtensionsKt.getDp(20.0f);
        ((ImageView)this.findViewById(R.id.icon_button)).setOnClickListener(arg_0 -> AppDrawer._init_$lambda-8(this, arg_0));
        ((ImageButton)this.findViewById(R.id.expanded_background)).setOnClickListener(arg_0 -> AppDrawer._init_$lambda-9(this, arg_0));
        ((LinearLayout)this.findViewById(R.id.close_button)).setOnClickListener(arg_0 -> AppDrawer._init_$lambda-10(this, arg_0));
    }

    private final AppDrawerViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (AppDrawerViewModel)((Object)lazy.getValue());
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.title = value;
        ((TextView)this.findViewById(R.id.title_view)).setText((CharSequence)value);
        this.requestLayout();
    }

    @Nullable
    public final String getSubtitle() {
        return this.subtitle;
    }

    public final void setSubtitle(@Nullable String value) {
        this.subtitle = value;
        ((TextView)this.findViewById(R.id.subtitle_view)).setText((CharSequence)value);
        this.requestLayout();
    }

    public final int getIcon() {
        return this.icon;
    }

    public final void setIcon(int value) {
        this.icon = value;
        ((ImageView)this.findViewById(R.id.icon_button)).setImageResource(value);
        this.requestLayout();
    }

    public final int getIconTint() {
        return this.iconTint;
    }

    public final void setIconTint(int value) {
        this.iconTint = value;
        ((ImageView)this.findViewById(R.id.icon_button)).setBackgroundTintList(ColorStateList.valueOf((int)value));
        this.requestLayout();
    }

    public final int getBackgroundTint() {
        return this.backgroundTint;
    }

    public final void setBackgroundTint(int value) {
        this.backgroundTint = value;
        ((ImageButton)this.findViewById(R.id.expanded_background)).setBackgroundTintList(ColorStateList.valueOf((int)value));
        this.requestLayout();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewModel().onCreate();
        this.getViewModel().getTitle().observeForever(this.titleObserver);
        this.getViewModel().getSubtitle().observeForever(this.subtitleObserver);
        this.getViewModel().getBackground().observeForever(this.backgroundObserver);
        this.getViewModel().getIconBackground().observeForever(this.iconBackgroundObserver);
        this.getViewModel().getTextColor().observeForever(this.textColorObserver);
        this.getViewModel().getLogo().observeForever(this.logoObserver);
        this.getViewModel().getCloseEvent().observeForever(this.closeEventObserver);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewModel().onDestroy();
        this.getViewModel().getTitle().removeObserver(this.titleObserver);
        this.getViewModel().getSubtitle().removeObserver(this.subtitleObserver);
        this.getViewModel().getBackground().removeObserver(this.backgroundObserver);
        this.getViewModel().getIconBackground().removeObserver(this.iconBackgroundObserver);
        this.getViewModel().getTextColor().removeObserver(this.textColorObserver);
        this.getViewModel().getLogo().removeObserver(this.logoObserver);
        this.getViewModel().getCloseEvent().removeObserver(this.closeEventObserver);
    }

    public final void setApp(@NotNull App app, boolean darkBackground, @NotNull View.OnClickListener listener2) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.getViewModel().init(app, darkBackground);
        this.setExpandedModeOnClickListener(listener2);
    }

    private final void setIcon(Bitmap bitmap) {
        ((ImageView)this.findViewById(R.id.icon_button)).setImageBitmap(bitmap);
    }

    public final void setExpandedModeOnClickListener(@NotNull View.OnClickListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.expandModeClickListener = listener2;
    }

    public final void show() {
        Slide transition = new Slide(0x800005);
        transition.addTarget((View)this);
        ViewParent viewParent = this.getParent();
        ViewGroup parent = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
        viewParent = parent;
        if (viewParent != null) {
            ViewParent viewParent2 = viewParent;
            boolean bl = false;
            boolean bl2 = false;
            ViewParent it = viewParent2;
            boolean bl3 = false;
            TransitionManager.beginDelayedTransition((ViewGroup)it, (Transition)((Transition)transition));
            this.setVisibility(0);
        }
    }

    public final void expand() {
        this.animateView(true);
    }

    public final void collapse() {
        this.animateView(false);
    }

    private final void animateIconBackground(boolean expand) {
        ValueAnimator valueAnimator;
        float[] fArray;
        Drawable drawable2 = ((ImageView)this.findViewById(R.id.icon_button)).getBackground();
        if (drawable2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
        }
        GradientDrawable drawable3 = (GradientDrawable)drawable2;
        float radius = this.getContext().getResources().getDimension(R.dimen.app_drawer_icon_radius);
        if (expand) {
            fArray = new float[]{0.0f, radius};
            valueAnimator = ValueAnimator.ofFloat((float[])fArray);
        } else {
            fArray = new float[]{radius, 0.0f};
            valueAnimator = ValueAnimator.ofFloat((float[])fArray);
        }
        ValueAnimator animator = valueAnimator;
        animator.setDuration(500L).addUpdateListener(arg_0 -> AppDrawer.animateIconBackground$lambda-12(drawable3, radius, arg_0));
        animator.start();
    }

    public boolean dispatchTouchEvent(@Nullable MotionEvent ev) {
        MotionEvent motionEvent = ev;
        if (motionEvent != null) {
            MotionEvent motionEvent2 = motionEvent;
            boolean bl = false;
            boolean bl2 = false;
            MotionEvent it = motionEvent2;
            boolean bl3 = false;
            int n = it.getAction();
            switch (n) {
                case 0: {
                    this.initialX = it.getRawX();
                    break;
                }
                case 2: {
                    if (it.getRawX() > this.initialX) {
                        this.shouldExpand = false;
                        float diffInPx = it.getRawX() - this.initialX;
                        if (this.currentWidth == this.maxBackgroundWidth && diffInPx < 50.0f) {
                            return true;
                        }
                        float newWidth = (float)this.currentWidth - diffInPx;
                        if (newWidth > (float)this.minBackgroundWidth) {
                            ((ImageButton)this.findViewById((int)R.id.expanded_background)).getLayoutParams().width = (int)newWidth;
                            ((ImageButton)this.findViewById(R.id.expanded_background)).setLayoutParams(((ImageButton)this.findViewById(R.id.expanded_background)).getLayoutParams());
                            this.currentWidth = (int)newWidth;
                            this.initialX = it.getRawX();
                        }
                    } else if (it.getRawX() < this.initialX) {
                        this.shouldExpand = true;
                        float diffInPx = this.initialX - it.getRawX();
                        float newWidth = (float)this.currentWidth + diffInPx;
                        if (newWidth < (float)this.maxBackgroundWidth) {
                            ((ImageButton)this.findViewById((int)R.id.expanded_background)).getLayoutParams().width = (int)newWidth;
                            ((ImageButton)this.findViewById(R.id.expanded_background)).setLayoutParams(((ImageButton)this.findViewById(R.id.expanded_background)).getLayoutParams());
                            this.currentWidth = (int)newWidth;
                            this.initialX = it.getRawX();
                        }
                    }
                    break;
                }
                case 1: {
                    if (this.currentWidth <= this.minBackgroundWidth + 50) {
                        this.animateView(true);
                        break;
                    }
                    if (this.currentWidth != this.maxBackgroundWidth) {
                        Boolean bl4 = this.shouldExpand;
                        if (bl4 == null) break;
                        Boolean bl5 = bl4;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        boolean it2 = bl5;
                        boolean bl8 = false;
                        this.animateView(it2);
                    }
                    break;
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private final void animateView(boolean expand) {
        int endWidth = expand ? this.maxBackgroundWidth : this.minBackgroundWidth;
        int[] nArray = new int[]{this.currentWidth, expand ? this.maxBackgroundWidth : this.minBackgroundWidth};
        ValueAnimator anim = ValueAnimator.ofInt((int[])nArray);
        anim.setDuration(200L);
        anim.addUpdateListener(arg_0 -> AppDrawer.animateView$lambda-15(this, arg_0));
        anim.addListener(new Animator.AnimatorListener(this, expand){
            final /* synthetic */ AppDrawer this$0;
            final /* synthetic */ boolean $expand;
            {
                this.this$0 = $receiver;
                this.$expand = $expand;
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }

            public void onAnimationStart(@Nullable Animator animation) {
                AppDrawer.access$setCancelClick$p(this.this$0, true);
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                AppDrawer.access$setCancelClick$p(this.this$0, false);
                AppDrawer.access$handleCloseButton(this.this$0, this.$expand);
            }
        });
        anim.start();
        this.currentWidth = endWidth;
        this.shouldExpand = expand;
        if (this.isExpanded != expand) {
            this.animateIconBackground(expand);
        }
        this.isExpanded = expand;
    }

    private final void handleCloseButton(boolean enable2) {
        ((ImageView)this.findViewById(R.id.close_button_icon)).setVisibility(enable2 ? 0 : 4);
        ((LinearLayout)this.findViewById(R.id.close_button)).setVisibility(enable2 ? 0 : 8);
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return CloudSDKKoinComponent.DefaultImpls.getKoin(this);
    }

    public void _$_clearFindViewByIdCache() {
    }

    private static final void titleObserver$lambda-0(AppDrawer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.setTitle(it);
    }

    private static final void subtitleObserver$lambda-1(AppDrawer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setSubtitle(it);
    }

    private static final void backgroundObserver$lambda-2(AppDrawer this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.setBackgroundTint(it);
    }

    private static final void iconBackgroundObserver$lambda-3(AppDrawer this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.setIconTint(it);
    }

    private static final void logoObserver$lambda-4(AppDrawer this$0, Bitmap it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.setIcon(it);
    }

    private static final void textColorObserver$lambda-5(AppDrawer this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TextView textView = (TextView)this$0.findViewById(R.id.title_view);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        textView.setTextColor(it.intValue());
        ((TextView)this$0.findViewById(R.id.subtitle_view)).setTextColor(it.intValue());
        ((ImageView)this$0.findViewById(R.id.close_button_icon)).setImageTintList(ColorStateList.valueOf((int)it));
    }

    private static final void closeEventObserver$lambda-6(AppDrawer this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!it.getHasBeenHandled()) {
            ViewGroup viewGroup;
            ViewParent viewParent = this$0.getParent();
            ViewGroup viewGroup2 = viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeView((View)this$0);
            }
        }
    }

    private static final void _init_$lambda-8(AppDrawer this$0, View it) {
        View.OnClickListener onClickListener;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.currentWidth == this$0.maxBackgroundWidth && !this$0.cancelClick && (onClickListener = this$0.expandModeClickListener) != null) {
            onClickListener.onClick(it);
        }
    }

    private static final void _init_$lambda-9(AppDrawer this$0, View it) {
        View.OnClickListener onClickListener;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.currentWidth == this$0.maxBackgroundWidth && !this$0.cancelClick && (onClickListener = this$0.expandModeClickListener) != null) {
            onClickListener.onClick(it);
        }
    }

    private static final void _init_$lambda-10(AppDrawer this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.cancelClick) {
            this$0.animateView(false);
        }
    }

    private static final void animateIconBackground$lambda-12(GradientDrawable $drawable, float $radius, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)$drawable, (String)"$drawable");
        Object object = animation.getAnimatedValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        float value = ((Float)object).floatValue();
        object = new float[8];
        object[0] = $radius;
        object[1] = $radius;
        object[2] = value;
        object[3] = value;
        object[4] = value;
        object[5] = value;
        object[6] = $radius;
        object[7] = $radius;
        $drawable.setCornerRadii((float[])object);
    }

    private static final void animateView$lambda-15(AppDrawer this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = it.getAnimatedValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        int animatedValue = (Integer)object;
        ViewGroup.LayoutParams layoutParams = ((ImageButton)this$0.findViewById(R.id.expanded_background)).getLayoutParams();
        layoutParams.width = animatedValue;
        ((ImageButton)this$0.findViewById(R.id.expanded_background)).setLayoutParams(layoutParams);
    }

    public static final /* synthetic */ void access$setCancelClick$p(AppDrawer $this, boolean bl) {
        $this.cancelClick = bl;
    }

    public static final /* synthetic */ void access$handleCloseButton(AppDrawer $this, boolean enable2) {
        $this.handleCloseButton(enable2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcloud/pace/sdk/appkit/app/drawer/AppDrawer$Companion;", "", "()V", "START_MARGIN", "", "TOUCH_TOLERANCE", "", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

