/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.app.webview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import cloud.pace.sdk.R;
import cloud.pace.sdk.appkit.AppKit;
import cloud.pace.sdk.appkit.app.webview.AppWebViewClient;
import cloud.pace.sdk.appkit.app.webview.AppWebViewModel;
import cloud.pace.sdk.appkit.communication.generated.CommunicationManager;
import cloud.pace.sdk.appkit.network.NetworkFailureView;
import cloud.pace.sdk.appkit.utils.BiometricUtils;
import cloud.pace.sdk.utils.CloudSDKKoinComponent;
import cloud.pace.sdk.utils.Event;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.parameter.ParametersHolderKt;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0013J\b\u0010#\u001a\u00020\u0011H\u0014J\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010%\u001a\u00020\u0011R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lcloud/pace/sdk/appkit/app/webview/AppWebView;", "Landroid/widget/RelativeLayout;", "Lcloud/pace/sdk/utils/CloudSDKKoinComponent;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "biometricRequestObserver", "Landroidx/lifecycle/Observer;", "Lcloud/pace/sdk/utils/Event;", "Lcloud/pace/sdk/appkit/app/webview/AppWebViewModel$BiometricRequest;", "communicationManager", "Lcloud/pace/sdk/appkit/communication/generated/CommunicationManager;", "fragment", "Landroidx/fragment/app/Fragment;", "goBackObserver", "", "initObserver", "", "isInErrorStateObserver", "", "loadingIndicatorRunnable", "Ljava/lang/Runnable;", "showLoadingIndicatorObserver", "webViewModel", "Lcloud/pace/sdk/appkit/app/webview/AppWebViewModel;", "getWebViewModel", "()Lcloud/pace/sdk/appkit/app/webview/AppWebViewModel;", "webViewModel$delegate", "Lkotlin/Lazy;", "init", "parent", "url", "loadUrl", "onAttachedToWindow", "onBackPressed", "onDestroy", "CommunicationHandler", "cloud.pace.sdk"})
public final class AppWebView
extends RelativeLayout
implements CloudSDKKoinComponent {
    @NotNull
    private final Lazy webViewModel$delegate;
    @NotNull
    private final CommunicationManager communicationManager;
    @Nullable
    private Fragment fragment;
    @NotNull
    private final Runnable loadingIndicatorRunnable;
    @NotNull
    private final Observer<Event<String>> initObserver;
    @NotNull
    private final Observer<Event<Boolean>> isInErrorStateObserver;
    @NotNull
    private final Observer<Event<Boolean>> showLoadingIndicatorObserver;
    @NotNull
    private final Observer<Event<AppWebViewModel.BiometricRequest>> biometricRequestObserver;
    @NotNull
    private final Observer<Event<Unit>> goBackObserver;

    /*
     * WARNING - void declaration
     */
    public AppWebView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        void $this$inject_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        KoinComponent koinComponent = this;
        Function0 parameters$iv = (Function0)new Function0<ParametersHolder>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final ParametersHolder invoke() {
                Object[] objectArray = new Object[]{this.$context};
                return ParametersHolderKt.parametersOf((Object[])objectArray);
            }
        };
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        boolean $i$f$inject = false;
        this.webViewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<AppWebViewModel>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AppWebViewModel invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(AppWebViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(AppWebViewModel.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.loadingIndicatorRunnable = () -> AppWebView.loadingIndicatorRunnable$lambda-0(this);
        this.initObserver = arg_0 -> AppWebView.initObserver$lambda-1(this, context, arg_0);
        this.isInErrorStateObserver = arg_0 -> AppWebView.isInErrorStateObserver$lambda-2(this, arg_0);
        this.showLoadingIndicatorObserver = arg_0 -> AppWebView.showLoadingIndicatorObserver$lambda-4(this, arg_0);
        this.biometricRequestObserver = arg_0 -> AppWebView.biometricRequestObserver$lambda-6(this, arg_0);
        this.goBackObserver = arg_0 -> AppWebView.goBackObserver$lambda-8(this, arg_0);
        this.addView(View.inflate((Context)context, (int)R.layout.app_web_view, null));
        CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this.findViewById(R.id.webView), true);
        koinComponent = ((WebView)this.findViewById(R.id.webView)).getSettings();
        boolean bl = false;
        boolean bl2 = false;
        KoinComponent $this$_init__u24lambda_u2d9 = koinComponent;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d9.setJavaScriptEnabled(true);
        $this$_init__u24lambda_u2d9.setDomStorageEnabled(true);
        $this$_init__u24lambda_u2d9.setSupportMultipleWindows(true);
        $this$_init__u24lambda_u2d9.setUserAgentString(AppKit.INSTANCE.getUserAgent$cloud_pace_sdk());
        this.communicationManager = new CommunicationManager(this.getWebViewModel(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((WebView)this.findViewById(R.id.webView)).evaluateJavascript("window.postMessage('" + it + "', window.origin)", 2::invoke$lambda-0);
            }

            private static final void invoke$lambda-0(String it) {
            }
        }));
        ((WebView)this.findViewById(R.id.webView)).addJavascriptInterface((Object)new CommunicationHandler(), "pace_native_api");
        ((NetworkFailureView)this.findViewById(R.id.failureView)).setButtonClickListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                ((WebView)this.findViewById(R.id.webView)).reload();
            }
        }));
    }

    private final AppWebViewModel getWebViewModel() {
        Lazy lazy = this.webViewModel$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (AppWebViewModel)lazy.getValue();
    }

    public final void init(@NotNull Fragment parent, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebView.setWebContentsDebuggingEnabled((boolean)true);
        this.fragment = parent;
        this.getWebViewModel().init(url);
    }

    public final void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)url, (Object)"cloudsdk://close")) {
            this.getWebViewModel().closeApp();
        } else {
            WebView webView = (WebView)this.findViewById(R.id.webView);
            if (webView != null) {
                webView.loadUrl(url);
            }
        }
    }

    public final void onBackPressed() {
        if (((WebView)this.findViewById(R.id.webView)).canGoBack()) {
            ((WebView)this.findViewById(R.id.webView)).goBack();
        }
    }

    public final void onDestroy() {
        ((WebView)this.findViewById(R.id.webView)).destroy();
    }

    protected void onAttachedToWindow() {
        LifecycleOwner lifecycleOwner;
        super.onAttachedToWindow();
        Context context = this.getContext();
        LifecycleOwner lifecycleOwner2 = lifecycleOwner = context instanceof LifecycleOwner ? (LifecycleOwner)context : null;
        if (lifecycleOwner == null) {
            throw new RuntimeException("lifecycle owner not found ");
        }
        LifecycleOwner lifecycleOwner3 = lifecycleOwner;
        this.getWebViewModel().getInit().observe(lifecycleOwner3, this.initObserver);
        this.getWebViewModel().isInErrorState().observe(lifecycleOwner3, this.isInErrorStateObserver);
        this.getWebViewModel().getShowLoadingIndicator().observe(lifecycleOwner3, this.showLoadingIndicatorObserver);
        this.getWebViewModel().getBiometricRequest().observe(lifecycleOwner3, this.biometricRequestObserver);
        this.getWebViewModel().getGoBack().observe(lifecycleOwner3, this.goBackObserver);
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return CloudSDKKoinComponent.DefaultImpls.getKoin(this);
    }

    public void _$_clearFindViewByIdCache() {
    }

    private static final void loadingIndicatorRunnable$lambda-0(AppWebView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrameLayout frameLayout = (FrameLayout)this$0.findViewById(R.id.loadingIndicator);
        if (frameLayout != null) {
            frameLayout.setVisibility(0);
        }
    }

    private static final void initObserver$lambda-1(AppWebView this$0, Context $context, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        String string = (String)it.getContentIfNotHandled();
        if (string == null) {
            return;
        }
        String url = string;
        AppWebViewClient appWebViewClient = new AppWebViewClient(url, this$0.getWebViewModel(), $context);
        ((WebView)this$0.findViewById(R.id.webView)).setWebViewClient((WebViewClient)appWebViewClient);
        ((WebView)this$0.findViewById(R.id.webView)).setWebChromeClient(appWebViewClient.getChromeClient());
        this$0.loadUrl(url);
    }

    private static final void isInErrorStateObserver$lambda-2(AppWebView this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = (Boolean)it.getContentIfNotHandled();
        if (object == null) {
            return;
        }
        boolean isInErrorState = object;
        if (isInErrorState) {
            object = (WebView)this$0.findViewById(R.id.webView);
            if (object != null) {
                object.setVisibility(8);
            }
            object = (NetworkFailureView)this$0.findViewById(R.id.failureView);
            if (object != null) {
                object.setVisibility(0);
            }
        } else {
            object = (NetworkFailureView)this$0.findViewById(R.id.failureView);
            if (object != null) {
                object.setVisibility(8);
            }
            object = (WebView)this$0.findViewById(R.id.webView);
            if (object != null) {
                object.setVisibility(0);
            }
        }
    }

    private static final void showLoadingIndicatorObserver$lambda-4(AppWebView this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Boolean bl = (Boolean)it.getContentIfNotHandled();
        if (bl == null) {
            return;
        }
        boolean showLoadingIndicator = bl;
        bl = (FrameLayout)this$0.findViewById(R.id.loadingIndicator);
        if (bl != null) {
            Boolean bl2 = bl;
            boolean bl3 = false;
            boolean bl4 = false;
            Boolean $this$showLoadingIndicatorObserver_u24lambda_u2d4_u24lambda_u2d3 = bl2;
            boolean bl5 = false;
            if (showLoadingIndicator) {
                $this$showLoadingIndicatorObserver_u24lambda_u2d4_u24lambda_u2d3.postDelayed(this$0.loadingIndicatorRunnable, 500L);
            } else {
                $this$showLoadingIndicatorObserver_u24lambda_u2d4_u24lambda_u2d3.removeCallbacks(this$0.loadingIndicatorRunnable);
                $this$showLoadingIndicatorObserver_u24lambda_u2d4_u24lambda_u2d3.setVisibility(8);
            }
        }
    }

    private static final void biometricRequestObserver$lambda-6(AppWebView this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AppWebViewModel.BiometricRequest biometricRequest = (AppWebViewModel.BiometricRequest)it.getContentIfNotHandled();
        if (biometricRequest == null) {
            return;
        }
        AppWebViewModel.BiometricRequest callback2 = biometricRequest;
        biometricRequest = this$0.fragment;
        if (biometricRequest != null) {
            AppWebViewModel.BiometricRequest biometricRequest2 = biometricRequest;
            boolean bl = false;
            boolean bl2 = false;
            AppWebViewModel.BiometricRequest it2 = biometricRequest2;
            boolean bl3 = false;
            String string = this$0.getResources().getString(callback2.getTitle());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resources.getString(callback.title)");
            BiometricUtils.requestAuthentication$default(BiometricUtils.INSTANCE, (Fragment)it2, string, null, null, false, callback2.getOnSuccess(), callback2.getOnFailure(), 28, null);
        }
    }

    private static final void goBackObserver$lambda-8(AppWebView this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Unit unit = (Unit)it.getContentIfNotHandled();
        if (unit != null) {
            Unit unit2 = unit;
            boolean bl = false;
            boolean bl2 = false;
            Unit it2 = unit2;
            boolean bl3 = false;
            if (((WebView)this$0.findViewById(R.id.webView)).canGoBack()) {
                ((WebView)this$0.findViewById(R.id.webView)).goBack();
            } else {
                this$0.getWebViewModel().closeApp();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcloud/pace/sdk/appkit/app/webview/AppWebView$CommunicationHandler;", "", "(Lcloud/pace/sdk/appkit/app/webview/AppWebView;)V", "postMessage", "", "message", "", "cloud.pace.sdk"})
    public final class CommunicationHandler {
        public CommunicationHandler() {
            Intrinsics.checkNotNullParameter((Object)AppWebView.this, (String)"this$0");
        }

        @JavascriptInterface
        public final void postMessage(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            AppWebView.this.communicationManager.handleMessage(message);
        }
    }
}

