/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.geofences;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ProcessLifecycleOwner;
import cloud.pace.sdk.R;
import cloud.pace.sdk.appkit.geofences.GeofenceBroadcastReceiver;
import cloud.pace.sdk.appkit.geofences.GeofenceCallback;
import cloud.pace.sdk.appkit.geofences.GeofenceManager;
import cloud.pace.sdk.appkit.geofences.GeofenceManagerImpl;
import cloud.pace.sdk.appkit.utils.NotificationUtils;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.tasks.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016JV\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00170\u001d2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\u0004\u0012\u00020\u00170\u001dH\u0016\u00f8\u0001\u0000JW\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\u0004\u0012\u00020\u00170\u001d2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00170\u001dH\u0016\u00f8\u0001\u0000J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcloud/pace/sdk/appkit/geofences/GeofenceManagerImpl;", "Lcloud/pace/sdk/appkit/geofences/GeofenceManager;", "()V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context$delegate", "Lkotlin/Lazy;", "geofenceCallback", "Lcloud/pace/sdk/appkit/geofences/GeofenceCallback;", "getGeofenceCallback", "()Lcloud/pace/sdk/appkit/geofences/GeofenceCallback;", "geofenceCallback$delegate", "geofencingClient", "Lcom/google/android/gms/location/GeofencingClient;", "getGeofencingClient", "()Lcom/google/android/gms/location/GeofencingClient;", "geofencingClient$delegate", "lastNotification", "", "Ljava/lang/Integer;", "disable", "", "enable", "locations", "", "Lcloud/pace/sdk/appkit/geofences/GeofenceManager$GeofenceLocation;", "callback", "Lkotlin/Function1;", "Lcom/google/android/gms/location/GeofencingEvent;", "Lkotlin/ParameterName;", "name", "event", "setupCallback", "Lkotlin/Result;", "Ljava/lang/Void;", "activity", "Ljava/lang/Class;", "Landroidx/fragment/app/FragmentActivity;", "notificationCallback", "", "getIntent", "Landroid/app/PendingIntent;", "cloud.pace.sdk"})
public final class GeofenceManagerImpl
extends GeofenceManager {
    @NotNull
    private final Lazy context$delegate;
    @NotNull
    private final Lazy geofenceCallback$delegate;
    @NotNull
    private final Lazy geofencingClient$delegate;
    @Nullable
    private Integer lastNotification;

    public GeofenceManagerImpl() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.context$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<Context>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Context invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Context.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Context.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.geofenceCallback$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<GeofenceCallback>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GeofenceCallback invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GeofenceCallback.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GeofenceCallback.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.geofencingClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<GeofencingClient>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GeofencingClient invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GeofencingClient.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GeofencingClient.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    private final Context getContext() {
        Lazy lazy = this.context$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Context)lazy.getValue();
    }

    private final GeofenceCallback getGeofenceCallback() {
        Lazy lazy = this.geofenceCallback$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (GeofenceCallback)lazy.getValue();
    }

    private final GeofencingClient getGeofencingClient() {
        Lazy lazy = this.geofencingClient$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (GeofencingClient)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enable(@NotNull List<GeofenceManager.GeofenceLocation> locations, @NotNull Function1<? super GeofencingEvent, Unit> callback2, @NotNull Function1<? super Result<Void>, Unit> setupCallback) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter(setupCallback, (String)"setupCallback");
        if (locations.isEmpty()) {
            return;
        }
        this.getGeofenceCallback().setCallback(callback2);
        Iterable $this$map$iv = locations;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GeofenceManager.GeofenceLocation geofenceLocation = (GeofenceManager.GeofenceLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Geofence geofence = new Geofence.Builder().setRequestId(it.getId()).setCircularRegion(it.getLat(), it.getLon(), it.getRadius()).setExpirationDuration(-1L).setTransitionTypes(7).setLoiteringDelay(3000).build();
            collection.add(geofence);
        }
        List geofenceList = (List)destination$iv$iv;
        GeofencingRequest.Builder $i$f$map22 = new GeofencingRequest.Builder();
        boolean bl = false;
        boolean bl2 = false;
        GeofencingRequest.Builder $this$enable_u24lambda_u2d1 = $i$f$map22;
        boolean bl3 = false;
        $this$enable_u24lambda_u2d1.setInitialTrigger(5);
        $this$enable_u24lambda_u2d1.addGeofences(geofenceList);
        GeofencingRequest request = $i$f$map22.build();
        PendingIntent pendingIntent = this.getIntent(this.getContext());
        this.getGeofencingClient().removeGeofences(pendingIntent);
        try {
            Task task = this.getGeofencingClient().addGeofences(request, pendingIntent);
            if (task != null) {
                Task task2 = task;
                boolean bl4 = false;
                boolean bl5 = false;
                Task $this$enable_u24lambda_u2d4 = task2;
                boolean bl6 = false;
                $this$enable_u24lambda_u2d4.addOnSuccessListener(arg_0 -> GeofenceManagerImpl.enable$lambda-4$lambda-2(locations, setupCallback, arg_0));
                $this$enable_u24lambda_u2d4.addOnFailureListener(arg_0 -> GeofenceManagerImpl.enable$lambda-4$lambda-3(setupCallback, arg_0));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void enable(@NotNull List<GeofenceManager.GeofenceLocation> locations, @NotNull Class<? extends FragmentActivity> activity, @NotNull Function1<? super Result<Void>, Unit> setupCallback, @NotNull Function1<? super String, Unit> notificationCallback) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Intrinsics.checkNotNullParameter(activity, (String)"activity");
        Intrinsics.checkNotNullParameter(setupCallback, (String)"setupCallback");
        Intrinsics.checkNotNullParameter(notificationCallback, (String)"notificationCallback");
        this.enable(locations, (Function1<? super GeofencingEvent, Unit>)((Function1)new Function1<GeofencingEvent, Unit>(this, activity, notificationCallback){
            final /* synthetic */ GeofenceManagerImpl this$0;
            final /* synthetic */ Class<? extends FragmentActivity> $activity;
            final /* synthetic */ Function1<String, Unit> $notificationCallback;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
                this.$notificationCallback = $notificationCallback;
                super(1);
            }

            public final void invoke(@NotNull GeofencingEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getTriggeringGeofences();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.triggeringGeofences");
                String triggeringGeofenceIDs2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, (Function1)enable.triggeringGeofenceIDs.1.INSTANCE, (int)31, null);
                Timber.Forest.d("Triggering geofences = " + triggeringGeofenceIDs2, new Object[0]);
                Timber.Forest.d("Geofence location: lat = " + event.getTriggeringLocation().getLatitude() + " lon = " + event.getTriggeringLocation().getLongitude(), new Object[0]);
                if (event.getGeofenceTransition() == 4 && !ProcessLifecycleOwner.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                    boolean bl;
                    Object object2;
                    Timber.Forest.i("Geofence DWELL", new Object[0]);
                    object = GeofenceManagerImpl.access$getLastNotification$p(this.this$0);
                    if (object != null) {
                        object2 = object;
                        GeofenceManagerImpl geofenceManagerImpl = this.this$0;
                        bl = false;
                        boolean bl2 = false;
                        int it = ((Number)object2).intValue();
                        boolean bl3 = false;
                        NotificationUtils.INSTANCE.removeNotification(GeofenceManagerImpl.access$getContext(geofenceManagerImpl), it);
                        GeofenceManagerImpl.access$setLastNotification$p(geofenceManagerImpl, null);
                    }
                    object2 = new Intent(GeofenceManagerImpl.access$getContext(this.this$0), this.$activity);
                    boolean bl4 = false;
                    bl = false;
                    Object $this$invoke_u24lambda_u2d1 = object2;
                    boolean bl5 = false;
                    $this$invoke_u24lambda_u2d1.setFlags(131072);
                    $this$invoke_u24lambda_u2d1.putExtra("geofence_notification", true);
                    Object intent = object2;
                    Context context = GeofenceManagerImpl.access$getContext(this.this$0);
                    object2 = GeofenceManagerImpl.access$getContext(this.this$0).getString(R.string.geofence_notification_title);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.getString(R.stri\u2026fence_notification_title)");
                    Object object3 = object2;
                    object2 = GeofenceManagerImpl.access$getContext(this.this$0).getString(R.string.geofence_notification_text);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.getString(R.stri\u2026ofence_notification_text)");
                    GeofenceManagerImpl.access$setLastNotification$p(this.this$0, NotificationUtils.INSTANCE.sendNotification(context, (String)object3, (String)object2, R.drawable.ic_cofu, (Intent)intent));
                    this.$notificationCallback.invoke((Object)StringsKt.take((String)triggeringGeofenceIDs2, (int)100));
                    Timber.Forest.i("Geofence notification sent", new Object[0]);
                } else if (event.getGeofenceTransition() == 1) {
                    Timber.Forest.i("Geofence ENTER", new Object[0]);
                } else if (event.getGeofenceTransition() == 2) {
                    Timber.Forest.i("Geofence EXIT", new Object[0]);
                    object = GeofenceManagerImpl.access$getLastNotification$p(this.this$0);
                    if (object != null) {
                        Object object4 = object;
                        GeofenceManagerImpl geofenceManagerImpl = this.this$0;
                        boolean bl = false;
                        boolean bl6 = false;
                        int it = ((Number)object4).intValue();
                        boolean bl7 = false;
                        NotificationUtils.INSTANCE.removeNotification(GeofenceManagerImpl.access$getContext(geofenceManagerImpl), it);
                        GeofenceManagerImpl.access$setLastNotification$p(geofenceManagerImpl, null);
                        Timber.Forest.i("Geofence notification removed", new Object[0]);
                    }
                }
            }
        }), setupCallback);
    }

    @Override
    public void disable() {
        this.getGeofencingClient().removeGeofences(this.getIntent(this.getContext()));
    }

    private final PendingIntent getIntent(Context context) {
        Intent intent = new Intent(context, GeofenceBroadcastReceiver.class);
        int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)flags);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(context, 0, intent, flags)");
        return pendingIntent;
    }

    private static final void enable$lambda-4$lambda-2(List $locations, Function1 $setupCallback, Void it) {
        Intrinsics.checkNotNullParameter((Object)$locations, (String)"$locations");
        Intrinsics.checkNotNullParameter((Object)$setupCallback, (String)"$setupCallback");
        Timber.Forest.d("Added " + $locations.size() + " geofences: " + CollectionsKt.joinToString$default((Iterable)$locations, null, null, null, (int)0, null, (Function1)enable.1.1.1.INSTANCE, (int)31, null), new Object[0]);
        Result.Companion companion = Result.Companion;
        boolean bl = false;
        $setupCallback.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)it)));
    }

    private static final void enable$lambda-4$lambda-3(Function1 $setupCallback, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$setupCallback, (String)"$setupCallback");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Timber.Forest.e((Throwable)it, "Failed adding geofences", new Object[0]);
        Result.Companion companion = Result.Companion;
        Throwable throwable = it;
        boolean bl = false;
        $setupCallback.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable))));
    }

    public static final /* synthetic */ Integer access$getLastNotification$p(GeofenceManagerImpl $this) {
        return $this.lastNotification;
    }

    public static final /* synthetic */ Context access$getContext(GeofenceManagerImpl $this) {
        return $this.getContext();
    }

    public static final /* synthetic */ void access$setLastNotification$p(GeofenceManagerImpl $this, Integer n) {
        $this.lastNotification = n;
    }
}

