/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.utils;

import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import dev.turingcomplete.kotlinonetimepassword.HmacAlgorithm;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordConfig;
import dev.turingcomplete.kotlinonetimepassword.TimeBasedOneTimePasswordGenerator;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J0\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcloud/pace/sdk/appkit/utils/EncryptionUtils;", "", "()V", "AES_MODE", "", "FIXED_IV", "", "KEY_ALIAS", "KEY_STORE", "decrypt", "data", "encrypt", "generateOTP", "decryptedSecret", "digits", "", "period", "algorithm", "date", "Ljava/util/Date;", "stringToAlgorithm", "Ldev/turingcomplete/kotlinonetimepassword/HmacAlgorithm;", "cloud.pace.sdk"})
public final class EncryptionUtils {
    @NotNull
    public static final EncryptionUtils INSTANCE = new EncryptionUtils();
    @NotNull
    private static final String KEY_STORE = "AndroidKeyStore";
    @NotNull
    private static final String AES_MODE = "AES/GCM/NoPadding";
    @NotNull
    private static final String KEY_ALIAS = "PWAKIT_KEY";
    @NotNull
    private static final byte[] FIXED_IV;

    private EncryptionUtils() {
    }

    @NotNull
    public final String encrypt(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE);
        keyStore.load(null);
        if (!keyStore.containsAlias(KEY_ALIAS)) {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", KEY_STORE);
            String[] stringArray = new String[]{"GCM"};
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(KEY_ALIAS, 3).setBlockModes(stringArray);
            stringArray = new String[]{"NoPadding"};
            keyGenerator.init((AlgorithmParameterSpec)builder.setEncryptionPaddings(stringArray).setRandomizedEncryptionRequired(false).build());
            keyGenerator.generateKey();
        }
        Key key = keyStore.getKey(KEY_ALIAS, null);
        Cipher cipher = Cipher.getInstance(AES_MODE);
        cipher.init(1, key, new GCMParameterSpec(128, FIXED_IV));
        String string2 = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] encodedBytes = cipher.doFinal(byArray);
        string2 = Base64.encodeToString((byte[])encodedBytes, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(encodedBytes, Base64.DEFAULT)");
        return string2;
    }

    @NotNull
    public final String decrypt(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE);
        keyStore.load(null);
        Key key = keyStore.getKey(KEY_ALIAS, null);
        Cipher cipher = Cipher.getInstance(AES_MODE);
        cipher.init(2, key, new GCMParameterSpec(128, FIXED_IV));
        byte[] decoded = cipher.doFinal(Base64.decode((String)data, (int)0));
        Intrinsics.checkNotNullExpressionValue((Object)decoded, (String)"decoded");
        byte[] byArray = decoded;
        boolean bl = false;
        return new String(byArray, Charsets.UTF_8);
    }

    @Nullable
    public final HmacAlgorithm stringToAlgorithm(@NotNull String algorithm) {
        HmacAlgorithm hmacAlgorithm;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        String string2 = algorithm;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        switch (string4) {
            case "sha1": {
                hmacAlgorithm = HmacAlgorithm.SHA1;
                break;
            }
            case "sha256": {
                hmacAlgorithm = HmacAlgorithm.SHA256;
                break;
            }
            case "sha512": {
                hmacAlgorithm = HmacAlgorithm.SHA512;
                break;
            }
            default: {
                Timber.Forest.w("Unknown algorithm: " + algorithm, new Object[0]);
                hmacAlgorithm = null;
            }
        }
        return hmacAlgorithm;
    }

    @NotNull
    public final String generateOTP(@NotNull String decryptedSecret, int digits, int period, @NotNull String algorithm, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)decryptedSecret, (String)"decryptedSecret");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        HmacAlgorithm hmacAlgorithm = this.stringToAlgorithm(algorithm);
        Object object = hmacAlgorithm == null ? HmacAlgorithm.SHA1 : hmacAlgorithm;
        long l = period;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        TimeBasedOneTimePasswordConfig config = new TimeBasedOneTimePasswordConfig(l, timeUnit, digits, object);
        object = new Base32().decode(decryptedSecret);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Base32().decode(decryptedSecret)");
        return new TimeBasedOneTimePasswordGenerator((byte[])object, config).generate(date);
    }

    public static /* synthetic */ String generateOTP$default(EncryptionUtils encryptionUtils, String string2, int n, int n2, String string3, Date date, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            date = new Date();
        }
        return encryptionUtils.generateOTP(string2, n, n2, string3, date);
    }

    static {
        byte[] byArray = new byte[]{55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44};
        FIXED_IV = byArray;
    }
}

