/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.utils;

import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.DrawableRes;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import cloud.pace.sdk.R;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcloud/pace/sdk/appkit/utils/NotificationUtils;", "", "()V", "CHANNEL_ID", "", "createNotificationChannel", "", "context", "Landroid/content/Context;", "removeNotification", "id", "", "sendNotification", "title", "text", "icon", "intent", "Landroid/content/Intent;", "cloud.pace.sdk"})
public final class NotificationUtils {
    @NotNull
    public static final NotificationUtils INSTANCE = new NotificationUtils();
    @NotNull
    private static final String CHANNEL_ID = "AppKit Notifications";

    private NotificationUtils() {
    }

    public final int sendNotification(@NotNull Context context, @NotNull String title, @NotNull String text, @DrawableRes int icon, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.createNotificationChannel(context);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0xC000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_ID).setSmallIcon(icon).setColor(context.getResources().getColor(R.color.pace_blue, context.getTheme())).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)text)).setPriority(1).setContentIntent(pendingIntent).setAutoCancel(true);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, CHANNEL\u2026     .setAutoCancel(true)");
        NotificationCompat.Builder builder2 = builder;
        int id2 = (int)new Date().getTime();
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
        boolean bl = false;
        boolean bl2 = false;
        NotificationManagerCompat $this$sendNotification_u24lambda_u2d0 = notificationManagerCompat;
        boolean bl3 = false;
        $this$sendNotification_u24lambda_u2d0.notify(id2, builder2.build());
        return id2;
    }

    public static /* synthetic */ int sendNotification$default(NotificationUtils notificationUtils, Context context, String string2, String string3, int n, Intent intent, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        return notificationUtils.sendNotification(context, string2, string3, n, intent);
    }

    public final void removeNotification(@NotNull Context context, int id2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
        boolean bl = false;
        boolean bl2 = false;
        NotificationManagerCompat $this$removeNotification_u24lambda_u2d1 = notificationManagerCompat;
        boolean bl3 = false;
        $this$removeNotification_u24lambda_u2d1.cancel(id2);
    }

    private final void createNotificationChannel(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_ID, 4);
            NotificationManagerCompat.from((Context)context).createNotificationChannel(channel);
        }
    }
}

