/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.idkit.authorization;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.api.API;
import cloud.pace.sdk.appkit.persistence.SharedPreferencesModel;
import cloud.pace.sdk.idkit.IDKit;
import cloud.pace.sdk.idkit.authorization.AuthorizationManager;
import cloud.pace.sdk.idkit.model.FailedRetrievingConfigurationWhileDiscovering;
import cloud.pace.sdk.idkit.model.FailedRetrievingSessionWhileAuthorizing;
import cloud.pace.sdk.idkit.model.FailedRetrievingSessionWhileEnding;
import cloud.pace.sdk.idkit.model.InternalError;
import cloud.pace.sdk.idkit.model.InvalidSession;
import cloud.pace.sdk.idkit.model.OIDConfiguration;
import cloud.pace.sdk.idkit.model.OperationCanceled;
import cloud.pace.sdk.idkit.model.ServiceConfiguration;
import cloud.pace.sdk.idkit.model.UserEndpointNotDefined;
import cloud.pace.sdk.idkit.userinfo.UserInfoApiClient;
import cloud.pace.sdk.idkit.userinfo.UserInfoResponse;
import cloud.pace.sdk.utils.Canceled;
import cloud.pace.sdk.utils.CloudSDKKoinComponent;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.Failure;
import cloud.pace.sdk.utils.IntentResult;
import cloud.pace.sdk.utils.IntentResultResolverFragmentKt;
import cloud.pace.sdk.utils.Ok;
import cloud.pace.sdk.utils.SetupLogger;
import cloud.pace.sdk.utils.Success;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.openid.appauth.AuthState;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.AuthorizationService;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.ClientAuthentication;
import net.openid.appauth.ClientSecretBasic;
import net.openid.appauth.EndSessionRequest;
import net.openid.appauth.EndSessionResponse;
import net.openid.appauth.RegistrationResponse;
import net.openid.appauth.TokenRequest;
import net.openid.appauth.TokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.koin.core.Koin;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013H\u0000\u00a2\u0006\u0002\b\u0015J7\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u001dJ7\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010 J%\u0010\u0012\u001a\u00020\u00162\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0002\b\u0015J\u000f\u0010$\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u000bH\u0002J\n\u0010/\u001a\u0004\u0018\u000100H\u0002J/\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u001c2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020\u0016H\u0003J\u000f\u00106\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b7J5\u00106\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b7\u0010\u001dJ5\u00106\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b7\u0010 J%\u00106\u001a\u00020\u000b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\"H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u000209H\u0002J1\u0010:\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00132\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0000\u00a2\u0006\u0002\b;J/\u0010<\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00132\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0000\u00a2\u0006\u0002\b=J8\u0010>\u001a\u00020\u00162\b\u0010?\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010B2\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\r\u0010C\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bDJ\n\u0010E\u001a\u0004\u0018\u00010\u0011H\u0002J,\u0010F\u001a\u00020\u00162\u0006\u0010G\u001a\u00020H2\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\u0010\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u0011H\u0002J3\u0010K\u001a\u00020\u00162\b\b\u0002\u0010L\u001a\u00020\u000b2\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0000\u00a2\u0006\u0002\bMJ#\u0010N\u001a\u00020\u00162\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010PH\u0000\u00a2\u0006\u0002\bQJ\u001f\u0010R\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bSJ/\u0010T\u001a\u00020\u00162\u0006\u0010U\u001a\u00020\u001c2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0000\u00a2\u0006\u0002\bWR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006X"}, d2={"Lcloud/pace/sdk/idkit/authorization/AuthorizationManager;", "Lcloud/pace/sdk/utils/CloudSDKKoinComponent;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "authorizationService", "Lnet/openid/appauth/AuthorizationService;", "sharedPreferencesModel", "Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;", "(Landroid/content/Context;Lnet/openid/appauth/AuthorizationService;Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;)V", "additionalCaching", "", "authorizationRequest", "Lnet/openid/appauth/AuthorizationRequest;", "configuration", "Lcloud/pace/sdk/idkit/model/OIDConfiguration;", "session", "Lnet/openid/appauth/AuthState;", "authorize", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "authorize$cloud_pace_sdk", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "completion", "Lkotlin/Function1;", "Lcloud/pace/sdk/utils/Completion;", "", "(Landroidx/appcompat/app/AppCompatActivity;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "completedActivity", "Ljava/lang/Class;", "canceledActivity", "cachedToken", "cachedToken$cloud_pace_sdk", "containsAuthorizationResponse", "intent", "containsAuthorizationResponse$cloud_pace_sdk", "containsEndSessionResponse", "containsEndSessionResponse$cloud_pace_sdk", "containsException", "containsException$cloud_pace_sdk", "createAuthorizationRequest", "createNewSession", "createEndSessionRequest", "Lnet/openid/appauth/EndSessionRequest;", "discoverConfiguration", "issuerUri", "Lcloud/pace/sdk/idkit/model/ServiceConfiguration;", "discoverConfiguration$cloud_pace_sdk", "dispose", "endSession", "endSession$cloud_pace_sdk", "getAuthorizationServiceConfiguration", "Lnet/openid/appauth/AuthorizationServiceConfiguration;", "handleAuthorizationResponse", "handleAuthorizationResponse$cloud_pace_sdk", "handleEndSessionResponse", "handleEndSessionResponse$cloud_pace_sdk", "handleTokenResponse", "tokenResponse", "Lnet/openid/appauth/TokenResponse;", "exception", "Lnet/openid/appauth/AuthorizationException;", "isAuthorizationValid", "isAuthorizationValid$cloud_pace_sdk", "loadSession", "performTokenRequest", "request", "Lnet/openid/appauth/TokenRequest;", "persistSession", "authState", "refreshToken", "force", "refreshToken$cloud_pace_sdk", "setAdditionalParameters", "params", "", "setAdditionalParameters$cloud_pace_sdk", "setup", "setup$cloud_pace_sdk", "userInfo", "accessToken", "Lcloud/pace/sdk/idkit/userinfo/UserInfoResponse;", "userInfo$cloud_pace_sdk", "cloud.pace.sdk"})
public final class AuthorizationManager
implements CloudSDKKoinComponent,
LifecycleObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final SharedPreferencesModel sharedPreferencesModel;
    private OIDConfiguration configuration;
    private AuthorizationRequest authorizationRequest;
    private AuthState session;
    private boolean additionalCaching;

    public AuthorizationManager(@NotNull Context context, @NotNull AuthorizationService authorizationService, @NotNull SharedPreferencesModel sharedPreferencesModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)sharedPreferencesModel, (String)"sharedPreferencesModel");
        this.context = context;
        this.authorizationService = authorizationService;
        this.sharedPreferencesModel = sharedPreferencesModel;
        this.additionalCaching = true;
    }

    public final void setup$cloud_pace_sdk(@NotNull OIDConfiguration configuration, boolean additionalCaching) {
        AuthState authState;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
        this.configuration = configuration;
        this.additionalCaching = additionalCaching;
        this.createAuthorizationRequest(true);
        if (additionalCaching && (authState = this.loadSession()) != null) {
            AuthState authState2 = authState;
            boolean bl = false;
            boolean bl2 = false;
            AuthState it = authState2;
            boolean bl3 = false;
            this.session = it;
        }
    }

    public static /* synthetic */ void setup$cloud_pace_sdk$default(AuthorizationManager authorizationManager, OIDConfiguration oIDConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        authorizationManager.setup$cloud_pace_sdk(oIDConfiguration, bl);
    }

    public final void setAdditionalParameters$cloud_pace_sdk(@Nullable Map<String, String> params) {
        if (this.configuration != null) {
            OIDConfiguration oIDConfiguration;
            OIDConfiguration oIDConfiguration2 = this.configuration;
            if (oIDConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            } else {
                oIDConfiguration = oIDConfiguration2;
            }
            oIDConfiguration.setAdditionalParameters(params);
            this.createAuthorizationRequest(false);
        } else {
            SetupLogger.INSTANCE.logSDKWarningIfNeeded();
        }
    }

    public final void discoverConfiguration$cloud_pace_sdk(@NotNull String issuerUri, @NotNull Function1<? super Completion<ServiceConfiguration>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)issuerUri, (String)"issuerUri");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        AuthorizationServiceConfiguration.fetchFromIssuer((Uri)Uri.parse((String)issuerUri), (arg_0, arg_1) -> AuthorizationManager.discoverConfiguration$lambda-1(completion, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object authorize$cloud_pace_sdk(@NotNull AppCompatActivity var1_1, @NotNull Function1<? super Completion<String>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof authorize.1)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.authorize$cloud_pace_sdk((AppCompatActivity)null, (Function1<? super Completion<String>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = (Activity)activity;
                var5_7 = this.authorize$cloud_pace_sdk();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"authorize()");
                $continuation.L$0 = this;
                $continuation.L$1 = completion;
                $continuation.label = 1;
                v1 = IntentResultResolverFragmentKt.getResultFor(v0, var5_7, (Continuation<? super IntentResult>)$continuation);
                if (v1 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                completion = (Function1)$continuation.L$1;
                this = (AuthorizationManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                if ((result = (IntentResult)v1) instanceof Ok) {
                    var6_9 = ((Ok)result).getData();
                    if (var6_9 == null) {
                        v2 = null;
                    } else {
                        var7_10 = var6_9;
                        var8_11 = false;
                        var9_12 = false;
                        it = var7_10;
                        $i$a$-let-AuthorizationManager$authorize$2 = false;
                        this.handleAuthorizationResponse$cloud_pace_sdk(it, (Function1<? super Completion<String>, Unit>)completion);
                        v2 = var5_7 = Unit.INSTANCE;
                    }
                    if (var5_7 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object authorize$cloud_pace_sdk(@NotNull Fragment var1_1, @NotNull Function1<? super Completion<String>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof authorize.3)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.authorize$cloud_pace_sdk((Fragment)null, (Function1<? super Completion<String>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = this.authorize$cloud_pace_sdk();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"authorize()");
                $continuation.L$0 = this;
                $continuation.L$1 = completion;
                $continuation.label = 1;
                v0 = IntentResultResolverFragmentKt.getResultFor((Fragment)fragment, var5_7, (Continuation<? super IntentResult>)$continuation);
                if (v0 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                completion = (Function1)$continuation.L$1;
                this = (AuthorizationManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((result = (IntentResult)v0) instanceof Ok) {
                    var6_9 = ((Ok)result).getData();
                    if (var6_9 == null) {
                        v1 = null;
                    } else {
                        var7_10 = var6_9;
                        var8_11 = false;
                        var9_12 = false;
                        it = var7_10;
                        $i$a$-let-AuthorizationManager$authorize$4 = false;
                        this.handleAuthorizationResponse$cloud_pace_sdk(it, (Function1<? super Completion<String>, Unit>)completion);
                        v1 = var5_7 = Unit.INSTANCE;
                    }
                    if (var5_7 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void authorize$cloud_pace_sdk(@NotNull Class<?> completedActivity, @NotNull Class<?> canceledActivity) {
        AuthorizationRequest authorizationRequest;
        Intrinsics.checkNotNullParameter(completedActivity, (String)"completedActivity");
        Intrinsics.checkNotNullParameter(canceledActivity, (String)"canceledActivity");
        int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
        AuthorizationRequest authorizationRequest2 = this.authorizationRequest;
        if (authorizationRequest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
            authorizationRequest = null;
        } else {
            authorizationRequest = authorizationRequest2;
        }
        this.authorizationService.performAuthorizationRequest(authorizationRequest, PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, completedActivity), (int)flags), PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, canceledActivity), (int)flags));
    }

    public final Intent authorize$cloud_pace_sdk() {
        AuthorizationRequest authorizationRequest;
        AuthorizationRequest authorizationRequest2 = this.authorizationRequest;
        if (authorizationRequest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
            authorizationRequest = null;
        } else {
            authorizationRequest = authorizationRequest2;
        }
        return this.authorizationService.getAuthorizationRequestIntent(authorizationRequest);
    }

    public final void handleAuthorizationResponse$cloud_pace_sdk(@NotNull Intent intent, @NotNull Function1<? super Completion<String>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        AuthorizationResponse response = AuthorizationResponse.fromIntent((Intent)intent);
        AuthorizationException exception = AuthorizationException.fromIntent((Intent)intent);
        if (exception != null) {
            AuthState authState;
            AuthState authState2 = this.session;
            if (authState2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            } else {
                authState = authState2;
            }
            authState.update(response, exception);
            Timber.Forest.e((Throwable)exception, "Failed to handle authorization response", new Object[0]);
            completion.invoke(new Failure((Throwable)exception));
        } else if (response != null) {
            AuthState authState;
            AuthState authState3 = this.session;
            if (authState3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            } else {
                authState = authState3;
            }
            authState.update(response, exception);
            authState3 = response.createTokenExchangeRequest();
            Intrinsics.checkNotNullExpressionValue((Object)authState3, (String)"response.createTokenExchangeRequest()");
            this.performTokenRequest((TokenRequest)authState3, completion);
        } else {
            FailedRetrievingSessionWhileAuthorizing throwable = FailedRetrievingSessionWhileAuthorizing.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to handle authorization response", new Object[0]);
            completion.invoke(new Failure(throwable));
        }
    }

    public final void refreshToken$cloud_pace_sdk(boolean force, @NotNull Function1<? super Completion<String>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.isAuthorizationValid$cloud_pace_sdk()) {
            AuthState authState;
            AuthState authState2;
            AuthState authState3;
            if (force) {
                AuthState authState4;
                authState3 = this.session;
                if (authState3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                    authState4 = null;
                } else {
                    authState4 = authState3;
                }
                authState4.setNeedsTokenRefresh(true);
            }
            if ((authState2 = this.session) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            } else {
                authState = authState2;
            }
            authState3 = authState.createTokenRefreshRequest();
            Intrinsics.checkNotNullExpressionValue((Object)authState3, (String)"session.createTokenRefreshRequest()");
            this.performTokenRequest((TokenRequest)authState3, completion);
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public static /* synthetic */ void refreshToken$cloud_pace_sdk$default(AuthorizationManager authorizationManager, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        authorizationManager.refreshToken$cloud_pace_sdk(bl, (Function1<? super Completion<String>, Unit>)function1);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object endSession$cloud_pace_sdk(@NotNull AppCompatActivity var1_1, @NotNull Function1<? super Completion<Unit>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof endSession.1)) ** GOTO lbl-1000
        var20_4 = var3_3;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.endSession$cloud_pace_sdk((AppCompatActivity)null, (Function1<? super Completion<Unit>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = this.endSession$cloud_pace_sdk();
                if (var5_7 != null) ** GOTO lbl16
                v0 = null;
                ** GOTO lbl53
lbl16:
                // 1 sources

                var6_8 = var5_7;
                var7_9 = false;
                var8_10 = false;
                intent = var6_8;
                $i$a$-let-AuthorizationManager$endSession$2 = false;
                $continuation.L$0 = completion;
                $continuation.label = 1;
                v1 = IntentResultResolverFragmentKt.getResultFor((Activity)activity, intent, (Continuation<? super IntentResult>)$continuation);
                if (v1 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$a$-let-AuthorizationManager$endSession$2 = false;
                completion = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                if ((result = (IntentResult)v1) instanceof Ok) {
                    var12_15 = ((Ok)result).getData();
                    if (var12_15 == null) {
                        v2 = null;
                    } else {
                        var13_16 = var12_15;
                        var14_17 = false;
                        var15_18 = false;
                        it = var13_16;
                        $i$a$-let-AuthorizationManager$endSession$2$1 = false;
                        IDKit.INSTANCE.handleEndSessionResponse(it, (Function1<? super Completion<Unit>, Unit>)completion);
                        v2 = var18_21 = Unit.INSTANCE;
                    }
                    if (var18_21 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                v0 = var4_22 = Unit.INSTANCE;
lbl53:
                // 2 sources

                if (var4_22 == null) {
                    completion.invoke(new Failure<T>(FailedRetrievingSessionWhileEnding.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object endSession$cloud_pace_sdk(@NotNull Fragment var1_1, @NotNull Function1<? super Completion<Unit>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof endSession.3)) ** GOTO lbl-1000
        var20_4 = var3_3;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.endSession$cloud_pace_sdk((Fragment)null, (Function1<? super Completion<Unit>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = this.endSession$cloud_pace_sdk();
                if (var5_7 != null) ** GOTO lbl16
                v0 = null;
                ** GOTO lbl53
lbl16:
                // 1 sources

                var6_8 = var5_7;
                var7_9 = false;
                var8_10 = false;
                intent = var6_8;
                $i$a$-let-AuthorizationManager$endSession$4 = false;
                $continuation.L$0 = completion;
                $continuation.label = 1;
                v1 = IntentResultResolverFragmentKt.getResultFor((Fragment)fragment, intent, (Continuation<? super IntentResult>)$continuation);
                if (v1 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$a$-let-AuthorizationManager$endSession$4 = false;
                completion = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                if ((result = (IntentResult)v1) instanceof Ok) {
                    var12_15 = ((Ok)result).getData();
                    if (var12_15 == null) {
                        v2 = null;
                    } else {
                        var13_16 = var12_15;
                        var14_17 = false;
                        var15_18 = false;
                        it = var13_16;
                        $i$a$-let-AuthorizationManager$endSession$4$1 = false;
                        IDKit.INSTANCE.handleEndSessionResponse(it, (Function1<? super Completion<Unit>, Unit>)completion);
                        v2 = var18_21 = Unit.INSTANCE;
                    }
                    if (var18_21 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                v0 = var4_22 = Unit.INSTANCE;
lbl53:
                // 2 sources

                if (var4_22 == null) {
                    completion.invoke(new Failure<T>(FailedRetrievingSessionWhileEnding.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean endSession$cloud_pace_sdk(@NotNull Class<?> completedActivity, @NotNull Class<?> canceledActivity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(completedActivity, (String)"completedActivity");
        Intrinsics.checkNotNullParameter(canceledActivity, (String)"canceledActivity");
        int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
        EndSessionRequest endSessionRequest = this.createEndSessionRequest();
        if (endSessionRequest == null) {
            bl = false;
        } else {
            boolean bl2;
            EndSessionRequest endSessionRequest2 = endSessionRequest;
            boolean bl3 = false;
            boolean bl4 = false;
            EndSessionRequest it = endSessionRequest2;
            boolean bl5 = false;
            this.authorizationService.performEndSessionRequest(it, PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, completedActivity), (int)flags), PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, canceledActivity), (int)flags));
            bl = bl2 = true;
        }
        return bl;
    }

    @Nullable
    public final Intent endSession$cloud_pace_sdk() {
        Intent intent;
        EndSessionRequest endSessionRequest = this.createEndSessionRequest();
        if (endSessionRequest == null) {
            intent = null;
        } else {
            EndSessionRequest endSessionRequest2 = endSessionRequest;
            boolean bl = false;
            boolean bl2 = false;
            EndSessionRequest it = endSessionRequest2;
            boolean bl3 = false;
            intent = this.authorizationService.getEndSessionRequestIntent(it);
        }
        return intent;
    }

    public final void handleEndSessionResponse$cloud_pace_sdk(@NotNull Intent intent, @NotNull Function1<? super Completion<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        EndSessionResponse response = EndSessionResponse.fromIntent((Intent)intent);
        AuthorizationException exception = AuthorizationException.fromIntent((Intent)intent);
        if (exception != null) {
            Timber.Forest.e((Throwable)exception, "Failed to handle end session response", new Object[0]);
            completion.invoke(new Failure((Throwable)exception));
        } else if (response != null) {
            AuthState authState;
            AuthState authState2;
            IDKit.INSTANCE.disableBiometricAuthentication();
            API.INSTANCE.addAuthorizationHeader(null);
            AuthState authState3 = this.session;
            if (authState3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState2 = null;
            } else {
                authState2 = authState3;
            }
            AuthorizationServiceConfiguration serviceConfiguration = authState2.getAuthorizationServiceConfiguration();
            if (serviceConfiguration != null) {
                AuthState authState4;
                AuthState clearedState = new AuthState(serviceConfiguration);
                AuthState authState5 = this.session;
                if (authState5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                    authState4 = null;
                } else {
                    authState4 = authState5;
                }
                RegistrationResponse lastRegistrationResponse = authState4.getLastRegistrationResponse();
                if (lastRegistrationResponse != null) {
                    clearedState.update(lastRegistrationResponse);
                }
                this.session = clearedState;
            }
            if ((authState3 = this.session) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            } else {
                authState = authState3;
            }
            this.persistSession(authState);
            completion.invoke(new Success<Unit>(Unit.INSTANCE));
        } else {
            FailedRetrievingSessionWhileEnding throwable = FailedRetrievingSessionWhileEnding.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to handle end session response", new Object[0]);
            completion.invoke(new Failure(throwable));
        }
    }

    public final boolean isAuthorizationValid$cloud_pace_sdk() {
        AuthState authState;
        AuthState authState2 = this.session;
        if (authState2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState = null;
        } else {
            authState = authState2;
        }
        return authState.isAuthorized();
    }

    public final boolean containsAuthorizationResponse$cloud_pace_sdk(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.hasExtra("net.openid.appauth.AuthorizationResponse");
    }

    public final boolean containsEndSessionResponse$cloud_pace_sdk(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.hasExtra("net.openid.appauth.EndSessionResponse");
    }

    public final boolean containsException$cloud_pace_sdk(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.hasExtra("net.openid.appauth.AuthorizationException");
    }

    @Nullable
    public final String cachedToken$cloud_pace_sdk() {
        String string2;
        if (this.session != null) {
            AuthState authState;
            AuthState authState2 = this.session;
            if (authState2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            } else {
                authState = authState2;
            }
            string2 = authState.getAccessToken();
        } else {
            string2 = null;
        }
        return string2;
    }

    public final void userInfo$cloud_pace_sdk(@NotNull String accessToken, @NotNull Function1<? super Completion<UserInfoResponse>, Unit> completion) {
        OIDConfiguration oIDConfiguration;
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Object object = this.configuration;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        } else {
            oIDConfiguration = object;
        }
        object = oIDConfiguration.getUserInfoEndpoint();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (it != null) {
            new UserInfoApiClient((String)it, accessToken).getUserInfo(completion);
        } else {
            UserEndpointNotDefined throwable = UserEndpointNotDefined.INSTANCE;
            Timber.Forest.e((Throwable)throwable);
            completion.invoke(new Failure(throwable));
        }
    }

    private final void createAuthorizationRequest(boolean createNewSession) {
        OIDConfiguration oIDConfiguration;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        OIDConfiguration oIDConfiguration2;
        AuthorizationServiceConfiguration serviceConfiguration = this.getAuthorizationServiceConfiguration();
        if (createNewSession) {
            this.session = new AuthState(serviceConfiguration);
        }
        boolean bl2 = false;
        Map additionalParameters = new LinkedHashMap();
        Object object4 = this.configuration;
        if (object4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration2 = null;
        } else {
            oIDConfiguration2 = object4;
        }
        Map map = oIDConfiguration2.getAdditionalParameters();
        if (map != null) {
            object4 = map;
            boolean bl3 = false;
            bl = false;
            Object it = object4;
            boolean bl4 = false;
            additionalParameters.putAll(it);
        }
        if (!additionalParameters.containsKey("utm_source")) {
            map = additionalParameters;
            object4 = "utm_source";
            String string2 = PACECloudSDK.INSTANCE.getConfiguration$cloud_pace_sdk().getClientAppName();
            bl = false;
            map.put(object4, string2);
        }
        if ((object4 = this.configuration) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            object3 = null;
        } else {
            object3 = object4;
        }
        String string3 = ((OIDConfiguration)object3).getClientId();
        object4 = this.configuration;
        if (object4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            object2 = null;
        } else {
            object2 = object4;
        }
        String string4 = ((OIDConfiguration)object2).getResponseType();
        object4 = this.configuration;
        if (object4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            object = null;
        } else {
            object = object4;
        }
        AuthorizationRequest.Builder builder = new AuthorizationRequest.Builder(serviceConfiguration, string3, string4, Uri.parse((String)((OIDConfiguration)object).getRedirectUri()));
        OIDConfiguration oIDConfiguration3 = this.configuration;
        if (oIDConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        } else {
            oIDConfiguration = oIDConfiguration3;
        }
        List<String> list = oIDConfiguration.getScopes();
        object4 = list == null ? null : CollectionsKt.plus((Collection)list, (Object)"openid");
        map = builder.setScopes((Iterable)(object4 == null ? CollectionsKt.listOf((Object)"openid") : object4)).setAdditionalParameters(additionalParameters).build();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"Builder(serviceConfigura\u2026ers)\n            .build()");
        this.authorizationRequest = map;
    }

    private final EndSessionRequest createEndSessionRequest() {
        EndSessionRequest endSessionRequest;
        AuthState authState;
        Object object = this.session;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState = null;
        } else {
            authState = object;
        }
        String string2 = authState.getIdToken();
        if (string2 == null) {
            endSessionRequest = null;
        } else {
            OIDConfiguration oIDConfiguration;
            object = string2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            EndSessionRequest.Builder builder = new EndSessionRequest.Builder(this.getAuthorizationServiceConfiguration()).setIdTokenHint((String)it);
            OIDConfiguration oIDConfiguration2 = this.configuration;
            if (oIDConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            } else {
                oIDConfiguration = oIDConfiguration2;
            }
            endSessionRequest = builder.setPostLogoutRedirectUri(Uri.parse((String)oIDConfiguration.getRedirectUri())).build();
        }
        return endSessionRequest;
    }

    private final AuthorizationServiceConfiguration getAuthorizationServiceConfiguration() {
        OIDConfiguration oIDConfiguration;
        OIDConfiguration oIDConfiguration2;
        OIDConfiguration oIDConfiguration3;
        OIDConfiguration oIDConfiguration4 = this.configuration;
        if (oIDConfiguration4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration3 = null;
        } else {
            oIDConfiguration3 = oIDConfiguration4;
        }
        Uri uri = Uri.parse((String)oIDConfiguration3.getAuthorizationEndpoint());
        oIDConfiguration4 = this.configuration;
        if (oIDConfiguration4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration2 = null;
        } else {
            oIDConfiguration2 = oIDConfiguration4;
        }
        Uri uri2 = Uri.parse((String)oIDConfiguration2.getTokenEndpoint());
        oIDConfiguration4 = this.configuration;
        if (oIDConfiguration4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        } else {
            oIDConfiguration = oIDConfiguration4;
        }
        return new AuthorizationServiceConfiguration(uri, uri2, null, Uri.parse((String)oIDConfiguration.getEndSessionEndpoint()));
    }

    private final void performTokenRequest(TokenRequest request, Function1<? super Completion<String>, Unit> completion) {
        ClientAuthentication clientAuthentication;
        OIDConfiguration oIDConfiguration;
        Timber.Forest.i("Trying to refresh token...", new Object[0]);
        OIDConfiguration oIDConfiguration2 = this.configuration;
        if (oIDConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        } else {
            oIDConfiguration = oIDConfiguration2;
        }
        String clientSecret = oIDConfiguration.getClientSecret();
        if (clientSecret != null) {
            clientAuthentication = (ClientAuthentication)new ClientSecretBasic(clientSecret);
        } else {
            AuthState authState;
            try {
                AuthState authState2;
                authState = this.session;
                if (authState == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                    authState2 = null;
                } else {
                    authState2 = authState;
                }
                authState = authState2.getClientAuthentication();
            }
            catch (ClientAuthentication.UnsupportedAuthenticationMethod e) {
                Timber.Forest.e((Throwable)e, "Token request cannot be made, client authentication for the token endpoint could not be constructed", new Object[0]);
                completion.invoke(new Failure(e));
                return;
            }
            AuthState authState3 = authState;
            Intrinsics.checkNotNullExpressionValue((Object)authState3, (String)"{\n            try {\n    \u2026n\n            }\n        }");
            clientAuthentication = authState3;
        }
        ClientAuthentication clientAuthentication2 = clientAuthentication;
        this.authorizationService.performTokenRequest(request, clientAuthentication2, (arg_0, arg_1) -> AuthorizationManager.performTokenRequest$lambda-13(this, completion, arg_0, arg_1));
    }

    private final void handleTokenResponse(TokenResponse tokenResponse, AuthorizationException exception, Function1<? super Completion<String>, Unit> completion) {
        AuthState authState;
        Object object = this.session;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState = null;
        } else {
            authState = object;
        }
        authState.update(tokenResponse, exception);
        if (this.additionalCaching) {
            AuthState authState2;
            object = this.session;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState2 = null;
            } else {
                authState2 = object;
            }
            this.persistSession(authState2);
        }
        if (exception != null) {
            Timber.Forest.e((Throwable)exception, "Failed to handle token response", new Object[0]);
            completion.invoke(new Failure((Throwable)exception));
        } else if (tokenResponse != null) {
            Object object2;
            AuthState authState3;
            AuthState authState4 = this.session;
            if (authState4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState3 = null;
            } else {
                authState3 = authState4;
            }
            object = authState3.getAccessToken();
            if (object != null) {
                authState4 = object;
                boolean bl = false;
                boolean bl2 = false;
                AuthState it = authState4;
                boolean bl3 = false;
                API.INSTANCE.addAuthorizationHeader((String)it);
            }
            object = this.session;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                object2 = null;
            } else {
                object2 = object;
            }
            completion.invoke(new Success<String>(object2.getAccessToken()));
            Timber.Forest.i("Token refresh successful", new Object[0]);
        } else {
            FailedRetrievingSessionWhileAuthorizing throwable = FailedRetrievingSessionWhileAuthorizing.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to handle token response", new Object[0]);
            completion.invoke(new Failure(throwable));
        }
    }

    private final void persistSession(AuthState authState) {
        Timber.Forest.i("Persisting session to SharedPreferences", new Object[0]);
        String string2 = authState.jsonSerializeString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authState.jsonSerializeString()");
        this.sharedPreferencesModel.putString("sessionCache", string2);
    }

    private final AuthState loadSession() {
        Object object;
        Timber.Forest.i("Loading session from SharedPreferences", new Object[0]);
        String jsonString = SharedPreferencesModel.DefaultImpls.getString$default(this.sharedPreferencesModel, "sessionCache", null, 2, null);
        CharSequence charSequence = jsonString;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                charSequence = AuthState.jsonDeserialize((String)jsonString);
            }
            catch (JSONException jsonException) {
                Timber.Forest.e((Throwable)jsonException, "Failed retrieving session from SharedPreferences", new Object[0]);
                charSequence = null;
            }
            object = charSequence;
        } else {
            object = null;
        }
        return object;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    private final void dispose() {
        this.authorizationService.dispose();
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return CloudSDKKoinComponent.DefaultImpls.getKoin(this);
    }

    private static final void discoverConfiguration$lambda-1(Function1 $completion, AuthorizationServiceConfiguration configuration, AuthorizationException exception) {
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        if (exception != null) {
            Timber.Forest.e((Throwable)exception, "Failed to discover configuration", new Object[0]);
            $completion.invoke(new Failure((Throwable)exception));
        } else if (configuration != null) {
            Timber.Forest.i("Configuration discovery successful", new Object[0]);
            Uri uri = configuration.authorizationEndpoint;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"configuration.authorizationEndpoint");
            Uri uri2 = uri;
            uri = configuration.tokenEndpoint;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"configuration.tokenEndpoint");
            $completion.invoke(new Success<ServiceConfiguration>(new ServiceConfiguration(uri2, uri, configuration.endSessionEndpoint, configuration.registrationEndpoint)));
        } else {
            FailedRetrievingConfigurationWhileDiscovering throwable = FailedRetrievingConfigurationWhileDiscovering.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to discover configuration", new Object[0]);
            $completion.invoke(new Failure(throwable));
        }
    }

    private static final void performTokenRequest$lambda-13(AuthorizationManager this$0, Function1 $completion, TokenResponse tokenResponse, AuthorizationException exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        this$0.handleTokenResponse(tokenResponse, exception, (Function1<? super Completion<String>, Unit>)$completion);
    }
}

