/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.database;

import android.database.Cursor;
import androidx.room.Database;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import cloud.pace.sdk.poikit.database.Converters;
import cloud.pace.sdk.poikit.database.GasStationDAO;
import cloud.pace.sdk.poikit.poi.GasStation;
import cloud.pace.sdk.poikit.poi.Geometry;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Lcloud/pace/sdk/poikit/database/POIKitDatabase;", "Landroidx/room/RoomDatabase;", "()V", "gasStationDao", "Lcloud/pace/sdk/poikit/database/GasStationDAO;", "Companion", "cloud.pace.sdk"})
@Database(entities={GasStation.class}, version=6)
@TypeConverters(value={Converters.class})
public abstract class POIKitDatabase
extends RoomDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DATABASE_NAME = "poikit_database";
    @NotNull
    private static final Migration migration1to2 = new Migration(){

        public void migrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE GasStation ADD COLUMN latitude REAL;");
            database.execSQL("ALTER TABLE GasStation ADD COLUMN longitude REAL;");
            Cursor cursor = database.query("SELECT * FROM GasStation");
            Type typeGeometry2 = new TypeToken<ArrayList<Geometry.CommandGeo>>(){}.getType();
            Gson gson = new Gson();
            while (cursor.moveToNext()) {
                int index = cursor.getColumnIndex("geometry");
                String geometryString = cursor.getString(index);
                Object object = gson.fromJson(geometryString, typeGeometry2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(geometryString, typeGeometry)");
                ArrayList geometry = (ArrayList)object;
                double lat = 0.0;
                double lon = 0.0;
                Iterable $this$forEach$iv = geometry;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Geometry.CommandGeo it = (Geometry.CommandGeo)element$iv;
                    boolean bl = false;
                    lat += it.getLocationPoint().getLat();
                    lon += it.getLocationPoint().getLon();
                }
                lat /= (double)geometry.size();
                lon /= (double)geometry.size();
                int idIndex = cursor.getColumnIndex("id");
                if (idIndex < 0) continue;
                String id2 = cursor.getString(idIndex);
                database.execSQL("UPDATE GasStation SET latitude = " + lat + ", longitude = " + lon + " WHERE id = '" + id2 + "'");
            }
        }
    };
    @NotNull
    private static final Migration migration2to3 = new Migration(){

        public void migrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE GasStation ADD COLUMN priceFormat TEXT;");
        }
    };
    @NotNull
    private static final Migration migration3to4 = new Migration(){

        public void migrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE GasStation ADD COLUMN brand TEXT;");
        }
    };
    @NotNull
    private static final Migration migration4to5 = new Migration(){

        public void migrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE GasStation ADD COLUMN priceComparisonOptOut INTEGER");
        }
    };
    @NotNull
    private static final Migration migration5to6 = new Migration(){

        public void migrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            database.execSQL("ALTER TABLE GasStation ADD COLUMN cofuPaymentMethods TEXT NOT NULL DEFAULT ''");
        }
    };

    @NotNull
    public abstract GasStationDAO gasStationDao();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lcloud/pace/sdk/poikit/database/POIKitDatabase$Companion;", "", "()V", "DATABASE_NAME", "", "migration1to2", "Landroidx/room/migration/Migration;", "getMigration1to2", "()Landroidx/room/migration/Migration;", "migration2to3", "getMigration2to3", "migration3to4", "getMigration3to4", "migration4to5", "getMigration4to5", "migration5to6", "getMigration5to6", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Migration getMigration1to2() {
            return migration1to2;
        }

        @NotNull
        public final Migration getMigration2to3() {
            return migration2to3;
        }

        @NotNull
        public final Migration getMigration3to4() {
            return migration3to4;
        }

        @NotNull
        public final Migration getMigration4to5() {
            return migration4to5;
        }

        @NotNull
        public final Migration getMigration5to6() {
            return migration5to6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

