/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.poi;

import android.os.Parcel;
import android.os.Parcelable;
import cloud.pace.sdk.poikit.poi.download.TileInformation;
import cloud.pace.sdk.poikit.utils.GeoMathUtils;
import cloud.pace.sdk.poikit.utils.POIKitConfig;
import com.google.android.gms.maps.model.LatLng;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0014\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0016J\u0019\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006)"}, d2={"Lcloud/pace/sdk/poikit/poi/LocationPoint;", "Landroid/os/Parcelable;", "lat", "", "lon", "(DD)V", "getLat", "()D", "getLon", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "getBearingTo", "locationPoint", "getDistanceInMetersTo", "lp", "hashCode", "isIn", "polygon", "", "move", "distanceKm", "bearingDegrees", "tileInfo", "Lcloud/pace/sdk/poikit/poi/download/TileInformation;", "zoom", "toLatLn", "Lcom/google/android/gms/maps/model/LatLng;", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "cloud.pace.sdk"})
@Parcelize
public final class LocationPoint
implements Parcelable {
    private final double lat;
    private final double lon;
    @NotNull
    public static final Parcelable.Creator<LocationPoint> CREATOR;

    public LocationPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double getLon() {
        return this.lon;
    }

    @NotNull
    public final TileInformation tileInfo(int zoom) {
        int tileX = GeoMathUtils.INSTANCE.long2tilex(this.lon, zoom);
        int tileY = GeoMathUtils.INSTANCE.lat2tiley(this.lat, zoom);
        return new TileInformation(zoom, tileX, tileY);
    }

    @NotNull
    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public boolean equals(@Nullable Object other) {
        LocationPoint locationPoint2;
        LocationPoint locationPoint3 = locationPoint2 = other instanceof LocationPoint ? (LocationPoint)other : null;
        if (locationPoint2 == null) {
            return false;
        }
        LocationPoint locationPoint4 = locationPoint2;
        return this.getDistanceInMetersTo(locationPoint4) < 5.0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public final LocationPoint move(double distanceKm, double bearingDegrees) {
        double distanceRadians = distanceKm / POIKitConfig.INSTANCE.getEARTH_RADIUS_KM();
        double bearingRadians = GeoMathUtils.INSTANCE.toRadian(bearingDegrees);
        double fromLatRadians = GeoMathUtils.INSTANCE.toRadian(this.lat);
        double fromLonRadians = GeoMathUtils.INSTANCE.toRadian(this.lon);
        boolean bl = false;
        bl = false;
        bl = false;
        bl = false;
        bl = false;
        double d = Math.sin(fromLatRadians) * Math.cos(distanceRadians) + Math.cos(fromLatRadians) * Math.sin(distanceRadians) * Math.cos(bearingRadians);
        boolean bl2 = false;
        double toLatRadians = Math.asin(d);
        bl2 = false;
        bl2 = false;
        bl2 = false;
        double d2 = Math.sin(bearingRadians) * Math.sin(distanceRadians) * Math.cos(fromLatRadians);
        boolean bl3 = false;
        bl3 = false;
        bl3 = false;
        double d3 = Math.cos(distanceRadians) - Math.sin(fromLatRadians) * Math.sin(toLatRadians);
        boolean bl4 = false;
        double toLonRadians = fromLonRadians + Math.atan2(d2, d3);
        toLonRadians = (toLonRadians + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new LocationPoint(GeoMathUtils.INSTANCE.toDegrees(toLatRadians), GeoMathUtils.INSTANCE.toDegrees(toLonRadians));
    }

    public final double getDistanceInMetersTo(@NotNull LocationPoint lp) {
        Intrinsics.checkNotNullParameter((Object)lp, (String)"lp");
        double hp = Math.PI / 180;
        double d = (lp.lat - this.lat) * hp;
        boolean bl = false;
        double d2 = 0.5 - Math.cos(d) / 2.0;
        d = this.lat * hp;
        bl = false;
        double d3 = Math.cos(d);
        d = lp.lat * hp;
        bl = false;
        double d4 = d3 * Math.cos(d);
        d = (lp.lon - this.lon) * hp;
        bl = false;
        double aa = d2 + d4 * (1.0 - Math.cos(d)) / 2.0;
        boolean bl2 = false;
        double d5 = Math.sqrt(aa);
        bl = false;
        return 2.0 * POIKitConfig.INSTANCE.getEARTH_RADIUS_KM() * 1000.0 * Math.asin(d5);
    }

    public final double getBearingTo(@NotNull LocationPoint locationPoint2) {
        Intrinsics.checkNotNullParameter((Object)locationPoint2, (String)"locationPoint");
        double lat1 = GeoMathUtils.INSTANCE.toRadian(this.lat);
        double lon1 = GeoMathUtils.INSTANCE.toRadian(this.lon);
        double lat2 = GeoMathUtils.INSTANCE.toRadian(locationPoint2.lat);
        double lon2 = GeoMathUtils.INSTANCE.toRadian(locationPoint2.lon);
        double deltaLon = lon2 - lon1;
        double tmpy = Math.sin(deltaLon) * Math.cos(lat2);
        double tmpx = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        double radiansBearing = Math.atan2(tmpy, tmpx);
        return (GeoMathUtils.INSTANCE.toDegrees(radiansBearing) + 360.0) % 360.0;
    }

    public final boolean isIn(@NotNull List<LocationPoint> polygon) {
        Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
        LocationPoint locationPoint2 = (LocationPoint)CollectionsKt.lastOrNull(polygon);
        if (locationPoint2 == null) {
            return false;
        }
        LocationPoint j = locationPoint2;
        boolean isInPolygon = false;
        for (LocationPoint i : polygon) {
            boolean b;
            boolean a = i.lon > this.lon != j.lon > this.lon;
            boolean bl = b = this.lat < (j.lat - i.lat) * (this.lon - i.lon) / (j.lon - i.lon) + i.lat;
            if (a && b) {
                isInPolygon = !isInPolygon;
            }
            j = i;
        }
        return isInPolygon;
    }

    @NotNull
    public final LatLng toLatLn() {
        return new LatLng(this.lat, this.lon);
    }

    public final double component1() {
        return this.lat;
    }

    public final double component2() {
        return this.lon;
    }

    @NotNull
    public final LocationPoint copy(double lat, double lon) {
        return new LocationPoint(lat, lon);
    }

    public static /* synthetic */ LocationPoint copy$default(LocationPoint locationPoint2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = locationPoint2.lat;
        }
        if ((n & 2) != 0) {
            d2 = locationPoint2.lon;
        }
        return locationPoint2.copy(d, d2);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeDouble(this.lat);
        out.writeDouble(this.lon);
    }

    static {
        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<LocationPoint> {
            @NotNull
            public final LocationPoint[] newArray(int size) {
                return new LocationPoint[size];
            }

            @NotNull
            public final LocationPoint createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new LocationPoint(parcel.readDouble(), parcel.readDouble());
            }
        }
        CREATOR = new Creator();
    }
}

