/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.poi;

import androidx.room.Embedded;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import cloud.pace.sdk.poikit.poi.Address;
import cloud.pace.sdk.poikit.poi.AddressKt;
import cloud.pace.sdk.poikit.poi.Geometry;
import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.poi.POILayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010;\u001a\u00020)2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010=\u001a\u00020>H\u0016J\u001c\u0010?\u001a\u00020@2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000306H\u0016J\b\u0010A\u001a\u00020\u0003H\u0016R \u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR\u0012\u0010$\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001e\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R,\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u0001068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006B"}, d2={"Lcloud/pace/sdk/poikit/poi/PointOfInterest;", "", "id", "", "geometry", "Ljava/util/ArrayList;", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandGeo;", "(Ljava/lang/String;Ljava/util/ArrayList;)V", "address", "Lcloud/pace/sdk/poikit/poi/Address;", "getAddress", "()Lcloud/pace/sdk/poikit/poi/Address;", "setAddress", "(Lcloud/pace/sdk/poikit/poi/Address;)V", "center", "Lcloud/pace/sdk/poikit/poi/LocationPoint;", "getCenter", "()Lcloud/pace/sdk/poikit/poi/LocationPoint;", "getGeometry", "()Ljava/util/ArrayList;", "setGeometry", "(Ljava/util/ArrayList;)V", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "latitude", "", "getLatitude", "()Ljava/lang/Double;", "setLatitude", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "longitude", "getLongitude", "setLongitude", "poiLayer", "Lcloud/pace/sdk/poikit/poi/POILayer;", "getPoiLayer", "()Lcloud/pace/sdk/poikit/poi/POILayer;", "temporary", "", "getTemporary", "()Ljava/lang/Boolean;", "setTemporary", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "updatedAt", "Ljava/util/Date;", "getUpdatedAt", "()Ljava/util/Date;", "setUpdatedAt", "(Ljava/util/Date;)V", "values", "Ljava/util/HashMap;", "getValues", "()Ljava/util/HashMap;", "setValues", "(Ljava/util/HashMap;)V", "equals", "other", "hashCode", "", "init", "", "toString", "cloud.pace.sdk"})
public abstract class PointOfInterest {
    @PrimaryKey(autoGenerate=false)
    @NotNull
    private String id;
    @NotNull
    private ArrayList<Geometry.CommandGeo> geometry;
    @Ignore
    @Nullable
    private HashMap<String, String> values;
    @Nullable
    private Boolean temporary;
    @Embedded
    @Nullable
    private Address address;
    @Nullable
    private Date updatedAt;
    @Nullable
    private Double latitude;
    @Nullable
    private Double longitude;

    public PointOfInterest(@NotNull String id2, @NotNull ArrayList<Geometry.CommandGeo> geometry) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        this.id = id2;
        this.geometry = geometry;
        Collection collection = this.geometry;
        boolean bl = false;
        if (!collection.isEmpty()) {
            double lat = 0.0;
            double lon = 0.0;
            Iterable $this$forEach$iv = this.geometry;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Geometry.CommandGeo it = (Geometry.CommandGeo)element$iv;
                boolean bl2 = false;
                lat += it.getLocationPoint().getLat();
                lon += it.getLocationPoint().getLon();
            }
            this.latitude = lat /= (double)this.geometry.size();
            this.longitude = lon /= (double)this.geometry.size();
        }
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.id = string2;
    }

    @NotNull
    public final ArrayList<Geometry.CommandGeo> getGeometry() {
        return this.geometry;
    }

    public final void setGeometry(@NotNull ArrayList<Geometry.CommandGeo> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.geometry = arrayList;
    }

    @NotNull
    public abstract POILayer getPoiLayer();

    @Nullable
    public final HashMap<String, String> getValues() {
        return this.values;
    }

    public final void setValues(@Nullable HashMap<String, String> hashMap) {
        this.values = hashMap;
    }

    @Nullable
    public final Boolean getTemporary() {
        return this.temporary;
    }

    public final void setTemporary(@Nullable Boolean bl) {
        this.temporary = bl;
    }

    @Nullable
    public final Address getAddress() {
        return this.address;
    }

    public final void setAddress(@Nullable Address address) {
        this.address = address;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    public final void setUpdatedAt(@Nullable Date date) {
        this.updatedAt = date;
    }

    @Nullable
    public final Double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(@Nullable Double d) {
        this.latitude = d;
    }

    @Nullable
    public final Double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(@Nullable Double d) {
        this.longitude = d;
    }

    @Nullable
    public final LocationPoint getCenter() {
        Double d = this.latitude;
        if (d == null) {
            return null;
        }
        double latitude = d;
        Double d2 = this.longitude;
        if (d2 == null) {
            return null;
        }
        double longitude = d2;
        return new LocationPoint(latitude, longitude);
    }

    public void init(@NotNull HashMap<String, String> values) {
        boolean bl;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = values;
        String string2 = values.get("tp");
        if (string2 == null) {
            bl = false;
        } else {
            String string3 = string2;
            boolean bl2 = false;
            bl = Integer.parseInt(string3) == 1;
        }
        this.temporary = bl;
        this.address = AddressKt.toAddress(values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Pair it;
        if (!(other instanceof PointOfInterest)) return false;
        if (!Intrinsics.areEqual((Object)((PointOfInterest)other).id, (Object)this.id)) return false;
        if (((PointOfInterest)other).getPoiLayer() != this.getPoiLayer()) return false;
        if (((PointOfInterest)other).geometry.size() != this.geometry.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)((PointOfInterest)other).geometry, (Iterable)this.geometry);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Pair)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()));
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        return "id: " + this.id + "\ntemporary: " + this.temporary + "\n";
    }
}

