/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.poi.download;

import cloud.pace.sdk.api.utils.InterceptorUtils;
import cloud.pace.sdk.poikit.poi.GasStation;
import cloud.pace.sdk.poikit.poi.Geometry;
import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.poi.download.TileInformation;
import cloud.pace.sdk.poikit.utils.ApiException;
import cloud.pace.sdk.poikit.utils.GeoMathUtils;
import cloud.pace.sdk.poikit.utils.POIKitConfig;
import cloud.pace.sdk.utils.CallbackUtilsKt;
import cloud.pace.sdk.utils.Environment;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;
import vector_tile.VectorTile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J1\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001e\u0010\u0019\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b\u0012\u0004\u0012\u00020\u001e0\u001a\u00f8\u0001\u0000J(\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\fj\b\u0012\u0004\u0012\u00020\u001d`\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcloud/pace/sdk/poikit/poi/download/TileDownloader;", "", "environment", "Lcloud/pace/sdk/utils/Environment;", "(Lcloud/pace/sdk/utils/Environment;)V", "client", "Lokhttp3/OkHttpClient;", "mediaType", "Lokhttp3/MediaType;", "poiTileBaseUrl", "", "buildGeometry", "Ljava/util/ArrayList;", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandGeo;", "Lkotlin/collections/ArrayList;", "feature", "Lvector_tile/VectorTile$Tile$Feature;", "tileInformation", "Lcloud/pace/sdk/poikit/poi/download/TileInformation;", "extent", "", "load", "Lokhttp3/Call;", "job", "LTileQueryRequestOuterClass$TileQueryRequest;", "handler", "Lkotlin/Function1;", "Lkotlin/Result;", "", "Lcloud/pace/sdk/poikit/poi/GasStation;", "", "loadPois", "vectorTile", "LTileQueryResponseOuterClass$TileQueryResponse$VectorTile;", "cloud.pace.sdk"})
public final class TileDownloader {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private String poiTileBaseUrl;
    @Nullable
    private final MediaType mediaType;

    public TileDownloader(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        OkHttpClient.Builder this_$iv = new OkHttpClient.Builder();
        boolean bl = false;
        this.client = this_$iv.addInterceptor(new Interceptor(){

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain it = chain;
                boolean bl = false;
                return it.proceed(it.request().newBuilder().header("User-Agent", InterceptorUtils.getUserAgent$default(InterceptorUtils.INSTANCE, null, 0, 3, null)).header("uber-trace-id", InterceptorUtils.INSTANCE.getUberTraceId$cloud_pace_sdk()).build());
            }
        }).connectTimeout(POIKitConfig.INSTANCE.getCONNECT_TIMEOUT(), TimeUnit.SECONDS).readTimeout(POIKitConfig.INSTANCE.getREAD_TIMEOUT(), TimeUnit.SECONDS).build();
        this.poiTileBaseUrl = environment.getApiUrl() + "/poi/v1/tiles/query";
        this.mediaType = MediaType.Companion.parse("application/protobuf");
    }

    @NotNull
    public final Call load(@NotNull TileQueryRequestOuterClass.TileQueryRequest job, @NotNull Function1<? super Result<? extends List<? extends GasStation>>, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        byte[] content = job.toByteArray();
        Request.Builder builder = new Request.Builder().url(this.poiTileBaseUrl);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
        Request request = builder.method("POST", RequestBody.Companion.create(content, this.mediaType, 0, content.length)).build();
        Call call = this.client.newCall(request);
        call.enqueue(new Callback(handler, this){
            final /* synthetic */ Function1<Result<? extends List<? extends GasStation>>, Unit> $handler;
            final /* synthetic */ TileDownloader this$0;
            {
                this.$handler = $handler;
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Timber.Forest.e((Throwable)e, "Request failed for URL: " + call.request().url(), new Object[0]);
                Result.Companion companion = Result.Companion;
                boolean bl = false;
                this.$handler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    Timber.Forest.e((Throwable)new ApiException(response.code(), response.message(), CallbackUtilsKt.getRequestId(response)), "Request unsuccessful for URL: " + call.request().url(), new Object[0]);
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new Exception("Request failed with code: " + response.code());
                    boolean bl = false;
                    this.$handler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable))));
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    Timber.Forest.e((Throwable)new ApiException(response.code(), response.message(), CallbackUtilsKt.getRequestId(response)), "Missing response body for URL: " + call.request().url(), new Object[0]);
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new Exception("Missing response body");
                    boolean bl = false;
                    this.$handler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable))));
                    return;
                }
                try {
                    void $this$forEach$iv;
                    TileQueryResponseOuterClass.TileQueryResponse result2 = TileQueryResponseOuterClass.TileQueryResponse.parseFrom(body.byteStream());
                    boolean bl = false;
                    List pois = new ArrayList<E>();
                    Result.Companion companion = result2.getVectorTilesList();
                    Intrinsics.checkNotNullExpressionValue(companion, (String)"result.vectorTilesList");
                    companion = (Iterable)companion;
                    TileDownloader tileDownloader = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        TileQueryResponseOuterClass.TileQueryResponse.VectorTile vectorTile = (TileQueryResponseOuterClass.TileQueryResponse.VectorTile)element$iv;
                        boolean bl2 = false;
                        TileInformation tileInformation = new TileInformation(result2.getZoom(), vectorTile.getGeo().getX(), vectorTile.getGeo().getY());
                        Intrinsics.checkNotNullExpressionValue((Object)vectorTile, (String)"vectorTile");
                        pois.addAll(TileDownloader.access$loadPois(tileDownloader, vectorTile, tileInformation));
                    }
                    companion = Result.Companion;
                    boolean bl3 = false;
                    this.$handler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)pois)));
                }
                catch (InvalidProtocolBufferException e) {
                    Timber.Forest.e((Throwable)new ApiException(response.code(), response.message(), CallbackUtilsKt.getRequestId(response)), "Failed to parse protobuffer response for URL: " + call.request().url(), new Object[0]);
                    Result.Companion companion = Result.Companion;
                    boolean bl = false;
                    this.$handler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
                }
            }
        });
        return call;
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<GasStation> loadPois(TileQueryResponseOuterClass.TileQueryResponse.VectorTile vectorTile, TileInformation tileInformation) {
        void $this$filterTo$iv$iv;
        VectorTile.Tile tile = VectorTile.Tile.parseFrom(vectorTile.getVectorTiles().toByteArray());
        List<VectorTile.Tile.Layer> list = tile.getLayersList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tile.layersList");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VectorTile.Tile.Layer it = (VectorTile.Tile.Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"pois")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        VectorTile.Tile.Layer poiLayer = (VectorTile.Tile.Layer)((List)destination$iv$iv).get(0);
        ArrayList<GasStation> pois = new ArrayList<GasStation>();
        for (VectorTile.Tile.Feature feature : poiLayer.getFeaturesList()) {
            Object element$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)feature, (String)"feature");
            Intrinsics.checkNotNullExpressionValue((Object)poiLayer, (String)"poiLayer");
            HashMap<String, String> values = GeoMathUtils.INSTANCE.getValues(feature, poiLayer);
            ArrayList<Geometry.CommandGeo> commands = this.buildGeometry(feature, tileInformation, poiLayer.getExtent());
            String string2 = values.get("t");
            if (string2 == null) continue;
            Object typeString = element$iv$iv = string2;
            String bl = values.get("id");
            if (bl == null) continue;
            String id2 = string2 = bl;
            string2 = typeString;
            if (!Intrinsics.areEqual((Object)string2, (Object)"gasStation")) continue;
            GasStation poi2 = new GasStation(id2, commands);
            poi2.init(values);
            pois.add(poi2);
        }
        return pois;
    }

    private final ArrayList<Geometry.CommandGeo> buildGeometry(VectorTile.Tile.Feature feature, TileInformation tileInformation, int extent) {
        ArrayList<Geometry.Command> commands = Geometry.Companion.processGeometry(feature);
        ArrayList<Geometry.CommandGeo> commandsGeo = new ArrayList<Geometry.CommandGeo>();
        for (Geometry.Command command : commands) {
            double size = (double)extent * Math.pow(2.0, tileInformation.getZoomLevel());
            double castX = tileInformation.getX() * extent;
            double castY = tileInformation.getY() * extent;
            double lonDeg = (command.getPoint().getCoordX() + castX) * 360.0 / size - 180.0;
            double latRad = 180.0 - (command.getPoint().getCoordY() + castY) * 360.0 / size;
            double d = latRad * Math.PI / 180.0;
            boolean bl = false;
            d = Math.exp(d);
            bl = false;
            double latDeg = 114.59155902616465 * Math.atan(d) - 90.0;
            LocationPoint locationPoint2 = new LocationPoint(latDeg, lonDeg);
            Geometry.CommandGeo commandGeo = new Geometry.CommandGeo(command.getType(), locationPoint2);
            commandsGeo.add(commandGeo);
        }
        return commandsGeo;
    }

    public static final /* synthetic */ ArrayList access$loadPois(TileDownloader $this, TileQueryResponseOuterClass.TileQueryResponse.VectorTile vectorTile, TileInformation tileInformation) {
        return $this.loadPois(vectorTile, tileInformation);
    }
}

