/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.pricehistory;

import cloud.pace.sdk.api.utils.EnumConverterFactory;
import cloud.pace.sdk.api.utils.InterceptorUtils;
import cloud.pace.sdk.poikit.pricehistory.PriceHistory;
import cloud.pace.sdk.poikit.pricehistory.PriceHistoryAPI;
import cloud.pace.sdk.poikit.pricehistory.PriceHistoryFuelType;
import cloud.pace.sdk.utils.CallbackUtilsKt;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.Environment;
import cloud.pace.sdk.utils.ExtensionsKt;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002JF\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014\u0012\u0004\u0012\u00020\u000b0\u0013JN\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00150\u0014\u0012\u0004\u0012\u00020\u000b0\u0013JF\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014\u0012\u0004\u0012\u00020\u000b0\u0013JN\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00150\u0014\u0012\u0004\u0012\u00020\u000b0\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcloud/pace/sdk/poikit/pricehistory/PriceHistoryClient;", "", "environment", "Lcloud/pace/sdk/utils/Environment;", "(Lcloud/pace/sdk/utils/Environment;)V", "service", "Lcloud/pace/sdk/poikit/pricehistory/PriceHistoryAPI;", "create", "baseUrl", "", "getPricesByCountry", "", "countryCode", "since", "Ljava/util/Date;", "granularity", "forecast", "", "completion", "Lkotlin/Function1;", "Lcloud/pace/sdk/utils/Completion;", "", "Lcloud/pace/sdk/poikit/pricehistory/PriceHistory;", "fuelType", "Lcloud/pace/sdk/poikit/pricehistory/PriceHistoryFuelType;", "getPricesByStation", "stationId", "cloud.pace.sdk"})
public final class PriceHistoryClient {
    @NotNull
    private final PriceHistoryAPI service;

    public PriceHistoryClient(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this.service = this.create(environment.getApiUrl() + "/price-service/");
    }

    public final void getPricesByCountry(@NotNull String countryCode, @NotNull Date since, @NotNull String granularity, boolean forecast, @NotNull Function1<? super Completion<List<PriceHistory>>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        CallbackUtilsKt.handleCallback(this.service.getPricesByCountry(countryCode, ExtensionsKt.toIso8601(since), granularity, forecast), completion);
    }

    public final void getPricesByCountry(@NotNull String countryCode, @NotNull String fuelType, @NotNull Date since, @NotNull String granularity, boolean forecast, @NotNull Function1<? super Completion<List<PriceHistoryFuelType>>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)fuelType, (String)"fuelType");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        CallbackUtilsKt.handleCallback(this.service.getPricesByCountry(countryCode, fuelType, ExtensionsKt.toIso8601(since), granularity, forecast), completion);
    }

    public final void getPricesByStation(@NotNull String stationId, @NotNull Date since, @NotNull String granularity, boolean forecast, @NotNull Function1<? super Completion<List<PriceHistory>>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)stationId, (String)"stationId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        CallbackUtilsKt.handleCallback(this.service.getPricesByStation(stationId, ExtensionsKt.toIso8601(since), granularity, forecast), completion);
    }

    public final void getPricesByStation(@NotNull String stationId, @NotNull String fuelType, @NotNull Date since, @NotNull String granularity, boolean forecast, @NotNull Function1<? super Completion<List<PriceHistoryFuelType>>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)stationId, (String)"stationId");
        Intrinsics.checkNotNullParameter((Object)fuelType, (String)"fuelType");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        CallbackUtilsKt.handleCallback(this.service.getPricesByStation(stationId, fuelType, ExtensionsKt.toIso8601(since), granularity, forecast), completion);
    }

    private final PriceHistoryAPI create(String baseUrl) {
        OkHttpClient.Builder client = new OkHttpClient.Builder().addNetworkInterceptor(InterceptorUtils.INSTANCE.getInterceptor("application/vnd.api+json", "application/vnd.api+json", true)).authenticator(InterceptorUtils.INSTANCE.getAuthenticator());
        Object object = new Retrofit.Builder().client(client.build()).baseUrl(baseUrl).addConverterFactory((Converter.Factory)new EnumConverterFactory()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)new Moshi.Builder().add((Type)((Object)Date.class), new Rfc3339DateJsonAdapter().nullSafe()).add((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build())).build().create(PriceHistoryAPI.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Builder()\n            .c\u2026ceHistoryAPI::class.java)");
        return (PriceHistoryAPI)object;
    }
}

