/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.utils;

import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.poi.download.TileInformation;
import cloud.pace.sdk.poikit.utils.POIKitConfig;
import com.google.android.gms.maps.model.LatLng;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vector_tile.VectorTile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n\u00a8\u0006)"}, d2={"Lcloud/pace/sdk/poikit/utils/GeoMathUtils;", "", "()V", "getAdjacentTile", "Lcloud/pace/sdk/poikit/poi/download/TileInformation;", "tile", "compass", "Lcloud/pace/sdk/poikit/utils/GeoMathUtils$Compass;", "getDistanceToTileBorderSide", "Lkotlin/Pair;", "", "location", "Lcloud/pace/sdk/poikit/poi/LocationPoint;", "heading", "getTileCount", "", "zoom", "getValues", "Ljava/util/HashMap;", "", "feature", "Lvector_tile/VectorTile$Tile$Feature;", "layer", "Lvector_tile/VectorTile$Tile$Layer;", "lat2tiley", "lat", "lat2y", "locationPointToLatLng", "Lcom/google/android/gms/maps/model/LatLng;", "long2tilex", "lon", "long2x", "tilex2long", "tileX", "tiley2lat", "tileY", "toDegrees", "rad", "toRadian", "degrees", "Compass", "cloud.pace.sdk"})
public final class GeoMathUtils {
    @NotNull
    public static final GeoMathUtils INSTANCE = new GeoMathUtils();

    private GeoMathUtils() {
    }

    public final int long2tilex(double lon, int zoom) {
        return (int)Math.floor(this.long2x(lon, zoom));
    }

    public final int lat2tiley(double lat, int zoom) {
        return (int)Math.floor(this.lat2y(lat, zoom));
    }

    public final double long2x(double lon, int zoom) {
        return (lon + 180.0) / 360.0 * Math.pow(2.0, zoom);
    }

    public final double lat2y(double lat, int zoom) {
        return (1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) / 2.0 * Math.pow(2.0, zoom);
    }

    public final double tilex2long(double tileX, int zoom) {
        return tileX / Math.pow(2.0, zoom) * 360.0 - 180.0;
    }

    public final double tiley2lat(double tileY, int zoom) {
        double number = Math.PI - Math.PI * 2 * tileY / Math.pow(2.0, zoom);
        return 57.29577951308232 * Math.atan(0.5 * (Math.exp(number) - Math.exp(-number)));
    }

    @NotNull
    public final HashMap<String, String> getValues(@NotNull VectorTile.Tile.Feature feature, @NotNull VectorTile.Tile.Layer layer) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        HashMap<String, String> values = new HashMap<String, String>();
        for (int index = 0; index < feature.getTagsCount(); index += 2) {
            int keyTag = feature.getTags(index);
            int nameTag = feature.getTags(index + 1);
            String key = layer.getKeys(keyTag);
            String value = layer.getValues(nameTag).getStringValue();
            Map map = values;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            String string2 = key;
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            String string3 = value;
            boolean bl = false;
            map.put(string2, string3);
        }
        return values;
    }

    public final double toDegrees(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public final double toRadian(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public final int getTileCount(int zoom) {
        return zoom == POIKitConfig.INSTANCE.getZOOMLEVEL() ? 65536 : (int)Math.pow(2.0, zoom);
    }

    @NotNull
    public final TileInformation getAdjacentTile(@NotNull TileInformation tile, @NotNull Compass compass) {
        TileInformation tileInformation;
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        Intrinsics.checkNotNullParameter((Object)((Object)compass), (String)"compass");
        int tileCount = this.getTileCount(tile.getZoomLevel());
        Compass compass2 = compass;
        int n = WhenMappings.$EnumSwitchMapping$0[compass2.ordinal()];
        switch (n) {
            case 1: {
                tileInformation = new TileInformation(tile.getZoomLevel(), tile.getX(), (tile.getY() + tileCount - 1) % tileCount);
                break;
            }
            case 2: {
                tileInformation = new TileInformation(tile.getZoomLevel(), tile.getX(), (tile.getY() + 1) % tileCount);
                break;
            }
            case 3: {
                tileInformation = new TileInformation(tile.getZoomLevel(), (tile.getX() + 1) % tileCount, tile.getY());
                break;
            }
            case 4: {
                tileInformation = new TileInformation(tile.getZoomLevel(), (tile.getX() + tileCount - 1) % tileCount, tile.getY());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tileInformation;
    }

    @NotNull
    public final Pair<Double, Compass> getDistanceToTileBorderSide(@NotNull TileInformation tile, @NotNull LocationPoint location2, @NotNull Compass heading) {
        double southDistance;
        double locY;
        double northDistance;
        double eastDistance;
        double locX;
        double westDistance;
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)heading), (String)"heading");
        Pair pair = heading == Compass.NORTH || heading == Compass.SOUTH ? ((westDistance = (locX = this.long2x(location2.getLon(), tile.getZoomLevel())) - Math.floor(locX)) < (eastDistance = Math.ceil(locX) - locX) ? new Pair((Object)new LocationPoint(location2.getLat(), this.tilex2long(Math.floor(locX), tile.getZoomLevel())).getDistanceInMetersTo(location2), (Object)Compass.WEST) : new Pair((Object)new LocationPoint(location2.getLat(), this.tilex2long(Math.ceil(locX), tile.getZoomLevel())).getDistanceInMetersTo(location2), (Object)Compass.EAST)) : ((northDistance = (locY = this.lat2y(location2.getLat(), tile.getZoomLevel())) - Math.floor(locY)) < (southDistance = Math.ceil(locY) - locY) ? new Pair((Object)new LocationPoint(this.tiley2lat(Math.floor(locY), tile.getZoomLevel()), location2.getLon()).getDistanceInMetersTo(location2), (Object)Compass.NORTH) : new Pair((Object)new LocationPoint(this.tiley2lat(Math.ceil(locY), tile.getZoomLevel()), location2.getLon()).getDistanceInMetersTo(location2), (Object)Compass.SOUTH));
        return pair;
    }

    private final LatLng locationPointToLatLng(LocationPoint location2) {
        return new LatLng(location2.getLat(), location2.getLon());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcloud/pace/sdk/poikit/utils/GeoMathUtils$Compass;", "", "(Ljava/lang/String;I)V", "NORTH", "SOUTH", "EAST", "WEST", "cloud.pace.sdk"})
    public static final class Compass
    extends Enum<Compass> {
        public static final /* enum */ Compass NORTH = new Compass();
        public static final /* enum */ Compass SOUTH = new Compass();
        public static final /* enum */ Compass EAST = new Compass();
        public static final /* enum */ Compass WEST = new Compass();
        private static final /* synthetic */ Compass[] $VALUES;

        public static Compass[] values() {
            return (Compass[])$VALUES.clone();
        }

        public static Compass valueOf(String value) {
            return Enum.valueOf(Compass.class, value);
        }

        static {
            $VALUES = compassArray = new Compass[]{Compass.NORTH, Compass.SOUTH, Compass.EAST, Compass.WEST};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compass.values().length];
            nArray[Compass.NORTH.ordinal()] = 1;
            nArray[Compass.SOUTH.ordinal()] = 2;
            nArray[Compass.EAST.ordinal()] = 3;
            nArray[Compass.WEST.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

