/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.utils;

import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.utils.LatLngKt;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.VisibleRegion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0001\u00a8\u0006\u0011"}, d2={"LatLngBounds", "Lcom/google/android/gms/maps/model/LatLngBounds;", "center", "Lcom/google/android/gms/maps/model/LatLng;", "radius", "", "lat", "lng", "LatLngBoundsRadius", "contains", "", "point", "Lcloud/pace/sdk/poikit/poi/LocationPoint;", "distanceTo", "bounds", "toVisibleRegion", "Lcom/google/android/gms/maps/model/VisibleRegion;", "cloud.pace.sdk"})
public final class LatLngBoundsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean contains(@NotNull LatLngBounds $this$contains, @NotNull LocationPoint point) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double d = $this$contains.southwest.latitude;
        double d2 = $this$contains.northeast.latitude;
        double d3 = point.getLat();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = $this$contains.southwest.longitude;
        d2 = $this$contains.northeast.longitude;
        d3 = point.getLon();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        return true;
    }

    public static final double distanceTo(@NotNull LatLngBounds $this$distanceTo, @NotNull LatLngBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        LatLng latLng = $this$distanceTo.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"center");
        LatLng latLng2 = latLng;
        latLng = bounds.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"bounds.center");
        return LatLngKt.distanceTo(latLng2, latLng);
    }

    @NotNull
    public static final LatLngBounds LatLngBounds(@NotNull LatLng center, double radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        LatLng southwest = LatLngKt.offsetBy(center, radius, 225.0);
        LatLng northeast = LatLngKt.offsetBy(center, radius, 45.0);
        return new LatLngBounds(southwest, northeast);
    }

    @NotNull
    public static final LatLngBounds LatLngBounds(double lat, double lng, double radius) {
        return LatLngBoundsKt.LatLngBounds(new LatLng(lat, lng), radius);
    }

    @NotNull
    public static final LatLngBounds LatLngBoundsRadius(@NotNull LatLng center, double radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        LatLngBounds latLngBounds = new LatLngBounds.Builder().include(LatLngKt.offsetBy(center, radius, 0.0)).include(LatLngKt.offsetBy(center, radius, 90.0)).include(LatLngKt.offsetBy(center, radius, 180.0)).include(LatLngKt.offsetBy(center, radius, 270.0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)latLngBounds, (String)"Builder()\n        .inclu\u2026 270.0))\n        .build()");
        return latLngBounds;
    }

    @NotNull
    public static final VisibleRegion toVisibleRegion(@NotNull LatLngBounds $this$toVisibleRegion) {
        Intrinsics.checkNotNullParameter((Object)$this$toVisibleRegion, (String)"<this>");
        LatLng latLng = $this$toVisibleRegion.southwest;
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"southwest");
        LatLng nearLeft = latLng;
        LatLng farLeft = new LatLng($this$toVisibleRegion.northeast.latitude, $this$toVisibleRegion.southwest.longitude);
        LatLng nearRight = new LatLng($this$toVisibleRegion.southwest.latitude, $this$toVisibleRegion.northeast.longitude);
        LatLng latLng2 = $this$toVisibleRegion.northeast;
        Intrinsics.checkNotNullExpressionValue((Object)latLng2, (String)"northeast");
        LatLng farRight = latLng2;
        LatLngBounds bounds = new LatLngBounds(nearLeft, farRight);
        return new VisibleRegion(nearLeft, nearRight, farLeft, farRight, bounds);
    }
}

