/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.utils;

import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.poi.LocationPointKt;
import cloud.pace.sdk.poikit.poi.download.TileInformation;
import cloud.pace.sdk.poikit.utils.LatLngKt;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.VisibleRegion;
import com.google.maps.android.SphericalUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0001\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\t\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\t\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0004\u001a\u0012\u0010\u0011\u001a\u00020\t*\u00020\t2\u0006\u0010\r\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"BOUNDS_PADDING_FACTOR", "", "incrementalPadding", "maxIncrements", "", "currentIncrement", "maxPadding", "minPadding", "addPadding", "Lcom/google/android/gms/maps/model/VisibleRegion;", "padding", "center", "Lcom/google/android/gms/maps/model/LatLng;", "diameter", "toTileQueryRequest", "LTileQueryRequestOuterClass$TileQueryRequest;", "zoomLevel", "zoomToDiameter", "cloud.pace.sdk"})
public final class VisibleRegionKt {
    private static final double BOUNDS_PADDING_FACTOR = 0.975;

    public static final double diameter(@NotNull VisibleRegion $this$diameter) {
        Intrinsics.checkNotNullParameter((Object)$this$diameter, (String)"<this>");
        LatLng latLng = $this$diameter.nearLeft;
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"nearLeft");
        LocationPoint locationPoint2 = LocationPointKt.toLocationPoint(latLng);
        latLng = $this$diameter.farRight;
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"farRight");
        return locationPoint2.getDistanceInMetersTo(LocationPointKt.toLocationPoint(latLng));
    }

    @NotNull
    public static final LatLng center(@NotNull VisibleRegion $this$center) {
        Intrinsics.checkNotNullParameter((Object)$this$center, (String)"<this>");
        LatLng latLng = $this$center.latLngBounds.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"latLngBounds.center");
        return latLng;
    }

    @NotNull
    public static final VisibleRegion zoomToDiameter(@NotNull VisibleRegion $this$zoomToDiameter, double diameter) {
        Intrinsics.checkNotNullParameter((Object)$this$zoomToDiameter, (String)"<this>");
        double paddedDiameter = diameter * 0.975;
        LatLng latLng = $this$zoomToDiameter.latLngBounds.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"latLngBounds.center");
        LatLng center = latLng;
        double d = paddedDiameter / 2.0;
        LatLng latLng2 = $this$zoomToDiameter.nearLeft;
        Intrinsics.checkNotNullExpressionValue((Object)latLng2, (String)"nearLeft");
        LatLng nearLeft = SphericalUtil.computeOffset((LatLng)center, (double)d, (double)LatLngKt.headingTo(center, latLng2));
        double d2 = paddedDiameter / 2.0;
        LatLng latLng3 = $this$zoomToDiameter.nearRight;
        Intrinsics.checkNotNullExpressionValue((Object)latLng3, (String)"nearRight");
        LatLng nearRight = SphericalUtil.computeOffset((LatLng)center, (double)d2, (double)LatLngKt.headingTo(center, latLng3));
        double d3 = paddedDiameter / 2.0;
        LatLng latLng4 = $this$zoomToDiameter.farLeft;
        Intrinsics.checkNotNullExpressionValue((Object)latLng4, (String)"farLeft");
        LatLng farLeft = SphericalUtil.computeOffset((LatLng)center, (double)d3, (double)LatLngKt.headingTo(center, latLng4));
        double d4 = paddedDiameter / 2.0;
        LatLng latLng5 = $this$zoomToDiameter.farRight;
        Intrinsics.checkNotNullExpressionValue((Object)latLng5, (String)"farRight");
        LatLng farRight = SphericalUtil.computeOffset((LatLng)center, (double)d4, (double)LatLngKt.headingTo(center, latLng5));
        LatLngBounds latLngBounds = new LatLngBounds.Builder().include(nearLeft).include(nearRight).include(farLeft).include(farRight).build();
        Intrinsics.checkNotNullExpressionValue((Object)latLngBounds, (String)"Builder()\n        .inclu\u2026arRight)\n        .build()");
        LatLngBounds bounds = latLngBounds;
        return new VisibleRegion(nearLeft, nearRight, farLeft, farRight, bounds);
    }

    @NotNull
    public static final VisibleRegion addPadding(@NotNull VisibleRegion $this$addPadding, double padding) {
        Intrinsics.checkNotNullParameter((Object)$this$addPadding, (String)"<this>");
        double diameter = VisibleRegionKt.diameter($this$addPadding);
        double paddedDiameter = diameter + diameter * padding;
        LatLng latLng = $this$addPadding.latLngBounds.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"latLngBounds.center");
        LatLng center = latLng;
        double d = paddedDiameter / 2.0;
        LatLng latLng2 = $this$addPadding.nearLeft;
        Intrinsics.checkNotNullExpressionValue((Object)latLng2, (String)"nearLeft");
        LatLng nearLeft = SphericalUtil.computeOffset((LatLng)center, (double)d, (double)LatLngKt.headingTo(center, latLng2));
        double d2 = paddedDiameter / 2.0;
        LatLng latLng3 = $this$addPadding.nearRight;
        Intrinsics.checkNotNullExpressionValue((Object)latLng3, (String)"nearRight");
        LatLng nearRight = SphericalUtil.computeOffset((LatLng)center, (double)d2, (double)LatLngKt.headingTo(center, latLng3));
        double d3 = paddedDiameter / 2.0;
        LatLng latLng4 = $this$addPadding.farLeft;
        Intrinsics.checkNotNullExpressionValue((Object)latLng4, (String)"farLeft");
        LatLng farLeft = SphericalUtil.computeOffset((LatLng)center, (double)d3, (double)LatLngKt.headingTo(center, latLng4));
        double d4 = paddedDiameter / 2.0;
        LatLng latLng5 = $this$addPadding.farRight;
        Intrinsics.checkNotNullExpressionValue((Object)latLng5, (String)"farRight");
        LatLng farRight = SphericalUtil.computeOffset((LatLng)center, (double)d4, (double)LatLngKt.headingTo(center, latLng5));
        LatLngBounds latLngBounds = new LatLngBounds.Builder().include(nearLeft).include(nearRight).include(farLeft).include(farRight).build();
        Intrinsics.checkNotNullExpressionValue((Object)latLngBounds, (String)"Builder()\n        .inclu\u2026arRight)\n        .build()");
        LatLngBounds bounds = latLngBounds;
        return new VisibleRegion(nearLeft, nearRight, farLeft, farRight, bounds);
    }

    public static final double incrementalPadding(int maxIncrements, int currentIncrement, double maxPadding, double minPadding) {
        double paddingDifference = maxPadding - minPadding;
        int factor = maxIncrements - currentIncrement;
        double relativePadding = paddingDifference / (double)maxIncrements * (double)factor;
        double padding = relativePadding + minPadding;
        return RangesKt.coerceIn((double)padding, (double)minPadding, (double)maxPadding);
    }

    public static /* synthetic */ double incrementalPadding$default(int n, int n2, double d, double d2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 0.85;
        }
        if ((n3 & 8) != 0) {
            d2 = 0.2;
        }
        return VisibleRegionKt.incrementalPadding(n, n2, d, d2);
    }

    @NotNull
    public static final TileQueryRequestOuterClass.TileQueryRequest toTileQueryRequest(@NotNull VisibleRegion $this$toTileQueryRequest, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$toTileQueryRequest, (String)"<this>");
        LatLng latLng = $this$toTileQueryRequest.latLngBounds.northeast;
        Intrinsics.checkNotNullExpressionValue((Object)latLng, (String)"this.latLngBounds.northeast");
        TileInformation northEast = LocationPointKt.toLocationPoint(latLng).tileInfo(zoomLevel);
        LatLng latLng2 = $this$toTileQueryRequest.latLngBounds.southwest;
        Intrinsics.checkNotNullExpressionValue((Object)latLng2, (String)"this.latLngBounds.southwest");
        TileInformation southWest = LocationPointKt.toLocationPoint(latLng2).tileInfo(zoomLevel);
        TileQueryRequestOuterClass.TileQueryRequest.AreaQuery.Builder builder = TileQueryRequestOuterClass.TileQueryRequest.AreaQuery.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TileQueryRequestOuterClass.TileQueryRequest.AreaQuery.Builder it = builder;
        boolean bl3 = false;
        it.setNorthEast((TileQueryRequestOuterClass.TileQueryRequest.Coordinate)TileQueryRequestOuterClass.TileQueryRequest.Coordinate.newBuilder().setX(northEast.getX()).setY(northEast.getY()).build());
        it.setSouthWest((TileQueryRequestOuterClass.TileQueryRequest.Coordinate)TileQueryRequestOuterClass.TileQueryRequest.Coordinate.newBuilder().setX(southWest.getX()).setY(southWest.getY()).build());
        TileQueryRequestOuterClass.TileQueryRequest.AreaQuery.Builder areaQuery = builder;
        builder = TileQueryRequestOuterClass.TileQueryRequest.newBuilder().addAreas(areaQuery).setZoom(zoomLevel).build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n        .ad\u2026omLevel)\n        .build()");
        return (TileQueryRequestOuterClass.TileQueryRequest)((Object)builder);
    }
}

