/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import cloud.pace.sdk.poikit.utils.ApiException;
import cloud.pace.sdk.utils.CallbackUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\t\u001a\u00020\u0006H\u0016J$\u0010\u000f\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016R9\u0010\u0004\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR.\u0010\u000f\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcloud/pace/sdk/utils/CallBackKt;", "T", "Lretrofit2/Callback;", "()V", "onFailure", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "t", "", "getOnFailure", "()Lkotlin/jvm/functions/Function1;", "setOnFailure", "(Lkotlin/jvm/functions/Function1;)V", "onResponse", "Lretrofit2/Response;", "getOnResponse", "setOnResponse", "call", "Lretrofit2/Call;", "response", "cloud.pace.sdk"})
public final class CallBackKt<T>
implements Callback<T> {
    @Nullable
    private Function1<? super Response<T>, Unit> onResponse;
    @Nullable
    private Function1<? super Throwable, Unit> onFailure;

    @Nullable
    public final Function1<Response<T>, Unit> getOnResponse() {
        return this.onResponse;
    }

    public final void setOnResponse(@Nullable Function1<? super Response<T>, Unit> function1) {
        this.onResponse = function1;
    }

    @Nullable
    public final Function1<Throwable, Unit> getOnFailure() {
        return this.onFailure;
    }

    public final void setOnFailure(@Nullable Function1<? super Throwable, Unit> function1) {
        this.onFailure = function1;
    }

    public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Timber.Forest.e(t, "Request failed for URL: " + call.request().url(), new Object[0]);
        Function1<? super Throwable, Unit> function1 = this.onFailure;
        if (function1 != null) {
            function1.invoke((Object)t);
        }
    }

    public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
        Object object;
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        if (!response.isSuccessful()) {
            int n = response.code();
            object = response.message();
            Intrinsics.checkNotNullExpressionValue(object, (String)"response.message()");
            Timber.Forest.e((Throwable)new ApiException(n, (String)object, CallbackUtilsKt.getRequestId(response)), "Request unsuccessful for URL: " + call.request().url(), new Object[0]);
        }
        if ((object = this.onResponse) != null) {
            object.invoke(response);
        }
    }
}

