/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcloud/pace/sdk/utils/DeviceUtils;", "", "()V", "filterString", "", "string", "getAndroidVersion", "getDeviceModel", "getDeviceModelVersion", "getDeviceName", "cloud.pace.sdk"})
public final class DeviceUtils {
    @NotNull
    public static final DeviceUtils INSTANCE = new DeviceUtils();

    private DeviceUtils() {
    }

    @NotNull
    public final String getAndroidVersion() {
        String string2 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RELEASE");
        return string2;
    }

    @NotNull
    public final String getDeviceName() {
        return this.getDeviceModel() + " (" + this.getDeviceModelVersion() + ")";
    }

    @NotNull
    public final String getDeviceModelVersion() {
        String string2;
        CharSequence charSequence = Build.PRODUCT;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = Build.PRODUCT;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"PRODUCT");
            string2 = this.filterString((String)charSequence);
        } else {
            charSequence = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"DEVICE");
            string2 = this.filterString((String)charSequence);
        }
        return string2;
    }

    @NotNull
    public final String getDeviceModel() {
        CharSequence charSequence = Build.BRAND;
        boolean bl = false;
        boolean bl2 = false;
        String manufacturer = !(charSequence == null || charSequence.length() == 0) ? Build.BRAND : Build.MANUFACTURER;
        return this.filterString(manufacturer + " " + Build.MODEL);
    }

    private final String filterString(String string2) {
        int codePoint;
        for (int i = 0; i < string2.length(); i += Character.charCount(codePoint)) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            codePoint = string4.codePointAt(i);
            if ((codePoint > 31 || codePoint == 9) && codePoint < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string2, 0, i);
            for (int j = i; j < string2.length(); j += Character.charCount(codePoint)) {
                String string5 = string2;
                boolean bl2 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                codePoint = string6.codePointAt(j);
                buffer.writeUtf8CodePoint(codePoint > 31 && codePoint < 127 ? codePoint : 63);
            }
            return buffer.readUtf8();
        }
        return string2;
    }
}

