/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.CoroutineUtilsKt;
import cloud.pace.sdk.utils.Failure;
import cloud.pace.sdk.utils.LocationProvider;
import cloud.pace.sdk.utils.LocationProviderImpl;
import cloud.pace.sdk.utils.LocationState;
import cloud.pace.sdk.utils.NoLocationFound;
import cloud.pace.sdk.utils.PermissionDenied;
import cloud.pace.sdk.utils.Success;
import cloud.pace.sdk.utils.SystemManager;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.tasks.CancellationTokenSource;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0003\u0013\u0018\"\u0018\u0000 L2\u00020\u0001:\u0001LB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u00100\u001a\u0004\u0018\u000101H\u0002J!\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f032\u0006\u00104\u001a\u000205H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u000f03H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J+\u00109\u001a\u0004\u0018\u00010\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u000f2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=H\u0002\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J8\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u0001012\u0006\u0010C\u001a\u0002052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010D2\u0010\b\u0002\u0010E\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010FH\u0002J!\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f032\u0006\u00104\u001a\u000205H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\b\u0010H\u001a\u00020AH\u0016J\b\u0010I\u001a\u00020AH\u0016J&\u0010J\u001a\u00020A2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010D2\u0010\b\u0002\u0010E\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010FH\u0002J\u001a\u0010K\u001a\u00020A2\u0010\b\u0002\u0010E\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010FH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\f\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\f\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\f\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R#\u0010$\u001a\n &*\u0004\u0018\u00010%0%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\f\u001a\u0004\b'\u0010(R\"\u0010*\u001a\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010,0,0+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006M"}, d2={"Lcloud/pace/sdk/utils/LocationProviderImpl;", "Lcloud/pace/sdk/utils/LocationProvider;", "context", "Landroid/content/Context;", "systemManager", "Lcloud/pace/sdk/utils/SystemManager;", "(Landroid/content/Context;Lcloud/pace/sdk/utils/SystemManager;)V", "fusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "getFusedLocationClient", "()Lcom/google/android/gms/location/FusedLocationProviderClient;", "fusedLocationClient$delegate", "Lkotlin/Lazy;", "location", "Landroidx/lifecycle/MutableLiveData;", "Landroid/location/Location;", "getLocation", "()Landroidx/lifecycle/MutableLiveData;", "locationCallback", "cloud/pace/sdk/utils/LocationProviderImpl$locationCallback$2$1", "getLocationCallback", "()Lcloud/pace/sdk/utils/LocationProviderImpl$locationCallback$2$1;", "locationCallback$delegate", "locationListener", "cloud/pace/sdk/utils/LocationProviderImpl$locationListener$2$1", "getLocationListener", "()Lcloud/pace/sdk/utils/LocationProviderImpl$locationListener$2$1;", "locationListener$delegate", "locationManager", "Landroid/location/LocationManager;", "getLocationManager", "()Landroid/location/LocationManager;", "locationManager$delegate", "locationProviderReceiver", "cloud/pace/sdk/utils/LocationProviderImpl$locationProviderReceiver$1", "Lcloud/pace/sdk/utils/LocationProviderImpl$locationProviderReceiver$1;", "locationRequest", "Lcom/google/android/gms/location/LocationRequest;", "kotlin.jvm.PlatformType", "getLocationRequest", "()Lcom/google/android/gms/location/LocationRequest;", "locationRequest$delegate", "locationState", "Landroidx/lifecycle/LiveData;", "Lcloud/pace/sdk/utils/LocationState;", "getLocationState", "()Landroidx/lifecycle/LiveData;", "poiKitLocationState", "checkLocationState", "", "currentLocation", "Lcloud/pace/sdk/utils/Completion;", "validate", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "firstValidLocation", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLocationIfValid", "minAccuracy", "", "startTime", "", "(Landroid/location/Location;Ljava/lang/Integer;J)Landroid/location/Location;", "getNeededAccuracy", "handleLocationStateChange", "", "provider", "isProviderEnabled", "Landroid/location/LocationListener;", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "lastKnownLocation", "removeLocationUpdates", "requestLocationUpdates", "resumeWithNoLocationFound", "resumeWithPermissionDenied", "Companion", "cloud.pace.sdk"})
public final class LocationProviderImpl
implements LocationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final SystemManager systemManager;
    @NotNull
    private final locationProviderReceiver.1 locationProviderReceiver;
    @NotNull
    private final Lazy fusedLocationClient$delegate;
    @NotNull
    private final Lazy locationManager$delegate;
    @NotNull
    private final Lazy locationRequest$delegate;
    @NotNull
    private final Lazy locationCallback$delegate;
    @NotNull
    private final Lazy locationListener$delegate;
    @NotNull
    private final MutableLiveData<LocationState> poiKitLocationState;
    @NotNull
    private final LiveData<LocationState> locationState;
    @NotNull
    private final MutableLiveData<Location> location;
    private static final long LOCATION_REQUEST_INTERVAL = 500L;
    private static final long LOCATION_REQUEST_FASTEST_INTERVAL = 200L;
    private static final int LOCATION_REQUEST_PRIORITY = 100;
    private static final float LOCATION_REQUEST_SMALLEST_DISPLACEMENT = 0.0f;
    private static final long LOCATION_TIMEOUT = 30000L;
    private static final int LOCATION_SEGMENTS = 5;
    private static final int MAX_LOCATION_AGE = 30000;
    private static final int BEST_ACCURACY = 20;
    private static final int MEDIUM_ACCURACY = 50;
    private static final int LOW_ACCURACY = 250;

    public LocationProviderImpl(@NotNull Context context, @NotNull SystemManager systemManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)systemManager, (String)"systemManager");
        this.context = context;
        this.systemManager = systemManager;
        this.locationProviderReceiver = new BroadcastReceiver(this){
            final /* synthetic */ LocationProviderImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                this.this$0.requestLocationUpdates();
            }
        };
        this.fusedLocationClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FusedLocationProviderClient>(this){
            final /* synthetic */ LocationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FusedLocationProviderClient invoke() {
                return LocationProviderImpl.access$getSystemManager$p(this.this$0).getFusedLocationProviderClient();
            }
        }));
        this.locationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocationManager>(this){
            final /* synthetic */ LocationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LocationManager invoke() {
                return LocationProviderImpl.access$getSystemManager$p(this.this$0).getLocationManager();
            }
        }));
        this.locationRequest$delegate = LazyKt.lazy((Function0)locationRequest.2.INSTANCE);
        this.locationCallback$delegate = LazyKt.lazy((Function0)((Function0)new Function0<locationCallback.1>(this){
            final /* synthetic */ LocationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final locationCallback.1 invoke() {
                return new LocationCallback(this.this$0){
                    final /* synthetic */ LocationProviderImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onLocationResult(@Nullable LocationResult locationResult) {
                        Location location2;
                        LocationResult locationResult2 = locationResult;
                        Location location3 = location2 = locationResult2 == null ? null : locationResult2.getLastLocation();
                        if (location2 == null) {
                            return;
                        }
                        Location lastLocation = location2;
                        this.this$0.getLocation().postValue((Object)lastLocation);
                    }
                };
            }
        }));
        this.locationListener$delegate = LazyKt.lazy((Function0)((Function0)new Function0<locationListener.1>(this){
            final /* synthetic */ LocationProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final locationListener.1 invoke() {
                return new LocationListener(this.this$0){
                    final /* synthetic */ LocationProviderImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onLocationChanged(@NotNull Location newLocation) {
                        Intrinsics.checkNotNullParameter((Object)newLocation, (String)"newLocation");
                        this.this$0.getLocation().postValue((Object)newLocation);
                    }

                    public void onProviderEnabled(@NotNull String provider) {
                        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                        LocationProviderImpl.handleLocationStateChange$default(this.this$0, provider, true, null, null, 12, null);
                    }

                    public void onProviderDisabled(@NotNull String provider) {
                        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                        LocationProviderImpl.resumeWithNoLocationFound$default(this.this$0, null, null, 3, null);
                    }

                    public void onStatusChanged(@Nullable String provider, int status, @Nullable Bundle extras) {
                        LocationManager locationManager2;
                        LocationProviderImpl.handleLocationStateChange$default(this.this$0, provider, provider != null && ((locationManager2 = LocationProviderImpl.access$getLocationManager(this.this$0)) == null ? false : locationManager2.isProviderEnabled(provider)), null, null, 12, null);
                    }
                };
            }
        }));
        this.poiKitLocationState = new MutableLiveData();
        LiveData $this$distinctUntilChanged$iv = (LiveData)this.poiKitLocationState;
        boolean $i$f$distinctUntilChanged = false;
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)$this$distinctUntilChanged$iv);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"distinctUntilChanged(this)");
        this.locationState = liveData;
        this.location = new MutableLiveData();
    }

    private final FusedLocationProviderClient getFusedLocationClient() {
        Lazy lazy = this.fusedLocationClient$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (FusedLocationProviderClient)lazy.getValue();
    }

    private final LocationManager getLocationManager() {
        Lazy lazy = this.locationManager$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (LocationManager)lazy.getValue();
    }

    private final LocationRequest getLocationRequest() {
        Lazy lazy = this.locationRequest$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (LocationRequest)lazy.getValue();
    }

    private final locationCallback.1 getLocationCallback() {
        Lazy lazy = this.locationCallback$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Object)lazy.getValue();
    }

    private final locationListener.1 getLocationListener() {
        Lazy lazy = this.locationListener$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return lazy.getValue();
    }

    @Override
    @NotNull
    public LiveData<LocationState> getLocationState() {
        return this.locationState;
    }

    @NotNull
    public MutableLiveData<Location> getLocation() {
        return this.location;
    }

    @Override
    public void requestLocationUpdates() {
        this.context.registerReceiver((BroadcastReceiver)this.locationProviderReceiver, new IntentFilter("android.location.PROVIDERS_CHANGED"));
        if (this.systemManager.isLocationPermissionGranted()) {
            try {
                LocationManager locationManager2;
                String provider = this.checkLocationState();
                if (this.systemManager.isGooglePlayServicesAvailable()) {
                    this.getFusedLocationClient().requestLocationUpdates(this.getLocationRequest(), (LocationCallback)this.getLocationCallback(), Looper.getMainLooper());
                } else if (provider != null && (locationManager2 = this.getLocationManager()) != null) {
                    locationManager2.requestLocationUpdates(provider, 500L, 0.0f, (LocationListener)this.getLocationListener(), Looper.getMainLooper());
                }
            }
            catch (SecurityException e) {
                LocationProviderImpl.resumeWithPermissionDenied$default(this, null, 1, null);
            }
        } else {
            LocationProviderImpl.resumeWithPermissionDenied$default(this, null, 1, null);
        }
    }

    @Override
    public void removeLocationUpdates() {
        try {
            this.context.unregisterReceiver((BroadcastReceiver)this.locationProviderReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.systemManager.isGooglePlayServicesAvailable()) {
            this.getFusedLocationClient().removeLocationUpdates((LocationCallback)this.getLocationCallback());
        } else {
            LocationManager locationManager2 = this.getLocationManager();
            if (locationManager2 != null) {
                locationManager2.removeUpdates((LocationListener)this.getLocationListener());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object firstValidLocation(@NotNull Continuation<? super Completion<Location>> var1_1) {
        if (!(var1_1 instanceof firstValidLocation.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ LocationProviderImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.firstValidLocation((Continuation<? super Completion<Location>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                timeoutMillis$iv = 30000L;
                $i$f$suspendCoroutineWithTimeout = false;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeout((long)timeoutMillis$iv, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Location>, Object>(null, this){
                    Object L$0;
                    int label;
                    final /* synthetic */ LocationProviderImpl this$0;
                    {
                        this.this$0 = locationProviderImpl;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $i$f$suspendCancellableCoroutine = false;
                                this.label = 1;
                                uCont$iv = (Continuation)this;
                                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                                cancellable$iv.initCancellability();
                                continuation = (CancellableContinuation)cancellable$iv;
                                $i$a$-suspendCoroutineWithTimeout-LocationProviderImpl$firstValidLocation$location$1 = false;
                                if (!LocationProviderImpl.access$getSystemManager$p(this.this$0).isLocationPermissionGranted()) ** GOTO lbl38
                                try {
                                    startTime = LocationProviderImpl.access$getSystemManager$p(this.this$0).getCurrentTimeMillis();
                                    provider = LocationProviderImpl.access$checkLocationState(this.this$0);
                                    if (!LocationProviderImpl.access$getSystemManager$p(this.this$0).isGooglePlayServicesAvailable()) ** GOTO lbl26
                                    client = LocationProviderImpl.access$getSystemManager$p(this.this$0).getFusedLocationProviderClient();
                                    callback = new LocationCallback(this.this$0, startTime, client, (CancellableContinuation<? super Location>)continuation){
                                        final /* synthetic */ LocationProviderImpl this$0;
                                        final /* synthetic */ long $startTime;
                                        final /* synthetic */ FusedLocationProviderClient $client;
                                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                                        {
                                            this.this$0 = $receiver;
                                            this.$startTime = $startTime;
                                            this.$client = $client;
                                            this.$continuation = $continuation;
                                        }

                                        public void onLocationResult(@Nullable LocationResult locationResult) {
                                            LocationResult locationResult2 = locationResult;
                                            Location location2 = LocationProviderImpl.access$getLocationIfValid(this.this$0, locationResult2 == null ? null : locationResult2.getLastLocation(), null, this.$startTime);
                                            if (location2 != null) {
                                                locationResult2 = location2;
                                                FusedLocationProviderClient fusedLocationProviderClient = this.$client;
                                                CancellableContinuation<Location> cancellableContinuation = this.$continuation;
                                                boolean bl = false;
                                                boolean bl2 = false;
                                                LocationResult it = locationResult2;
                                                boolean bl3 = false;
                                                fusedLocationProviderClient.removeLocationUpdates((LocationCallback)this);
                                                CoroutineUtilsKt.resumeIfActive(cancellableContinuation, it);
                                            }
                                        }
                                    };
                                    client.requestLocationUpdates(LocationProviderImpl.access$getLocationRequest(this.this$0), callback, Looper.getMainLooper()).addOnFailureListener(new OnFailureListener(this.this$0, (CancellableContinuation<? super Location>)continuation){
                                        final /* synthetic */ LocationProviderImpl this$0;
                                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                                        {
                                            this.this$0 = $receiver;
                                            this.$continuation = $continuation;
                                        }

                                        public final void onFailure(@NotNull Exception it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            Timber.Forest.e((Throwable)it, "Could no request location updates with Fused Location Provider API", new Object[0]);
                                            LocationProviderImpl.access$getPoiKitLocationState$p(this.this$0).postValue((Object)((Object)LocationState.NO_LOCATION_FOUND));
                                            CoroutineUtilsKt.resumeWithExceptionIfActive(this.$continuation, it);
                                        }
                                    });
                                    continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(client, callback){
                                        final /* synthetic */ FusedLocationProviderClient $client;
                                        final /* synthetic */ firstValidLocation.location.1.callback.1 $callback;
                                        {
                                            this.$client = $client;
                                            this.$callback = $callback;
                                            super(1);
                                        }

                                        public final void invoke(@Nullable Throwable it) {
                                            this.$client.removeLocationUpdates((LocationCallback)this.$callback);
                                        }
                                    });
                                    ** GOTO lbl40
lbl26:
                                    // 1 sources

                                    if (provider == null) ** GOTO lbl33
                                    listener = new LocationListener(this.this$0, startTime, (CancellableContinuation<? super Location>)continuation){
                                        final /* synthetic */ LocationProviderImpl this$0;
                                        final /* synthetic */ long $startTime;
                                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                                        {
                                            this.this$0 = $receiver;
                                            this.$startTime = $startTime;
                                            this.$continuation = $continuation;
                                        }

                                        public void onLocationChanged(@NotNull Location location2) {
                                            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                                            Location location3 = LocationProviderImpl.access$getLocationIfValid(this.this$0, location2, null, this.$startTime);
                                            if (location3 != null) {
                                                Location location4 = location3;
                                                LocationProviderImpl locationProviderImpl = this.this$0;
                                                CancellableContinuation<Location> cancellableContinuation = this.$continuation;
                                                boolean bl = false;
                                                boolean bl2 = false;
                                                Location it = location4;
                                                boolean bl3 = false;
                                                LocationManager locationManager2 = LocationProviderImpl.access$getLocationManager(locationProviderImpl);
                                                if (locationManager2 != null) {
                                                    locationManager2.removeUpdates((LocationListener)this);
                                                }
                                                CoroutineUtilsKt.resumeIfActive(cancellableContinuation, it);
                                            }
                                        }

                                        public void onProviderEnabled(@NotNull String provider) {
                                            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                                            LocationProviderImpl.access$handleLocationStateChange(this.this$0, provider, true, this, this.$continuation);
                                        }

                                        public void onProviderDisabled(@NotNull String provider) {
                                            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                                            LocationProviderImpl.access$resumeWithNoLocationFound(this.this$0, this, this.$continuation);
                                        }

                                        public void onStatusChanged(@Nullable String provider, int status, @Nullable Bundle extras) {
                                            LocationManager locationManager2;
                                            LocationProviderImpl.access$handleLocationStateChange(this.this$0, provider, provider != null && ((locationManager2 = LocationProviderImpl.access$getLocationManager(this.this$0)) == null ? false : locationManager2.isProviderEnabled(provider)), this, this.$continuation);
                                        }
                                    };
                                    var13_15 = LocationProviderImpl.access$getLocationManager(this.this$0);
                                    if (var13_15 != null) {
                                        var13_15.requestLocationUpdates(provider, 500L, 0.0f, listener, Looper.getMainLooper());
                                    }
                                    continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this.this$0, listener){
                                        final /* synthetic */ LocationProviderImpl this$0;
                                        final /* synthetic */ firstValidLocation.location.1.listener.1 $listener;
                                        {
                                            this.this$0 = $receiver;
                                            this.$listener = $listener;
                                            super(1);
                                        }

                                        public final void invoke(@Nullable Throwable it) {
                                            LocationManager locationManager2 = LocationProviderImpl.access$getLocationManager(this.this$0);
                                            if (locationManager2 != null) {
                                                locationManager2.removeUpdates((LocationListener)this.$listener);
                                            }
                                        }
                                    });
                                    ** GOTO lbl40
lbl33:
                                    // 1 sources

                                    LocationProviderImpl.resumeWithNoLocationFound$default(this.this$0, null, continuation, 1, null);
                                }
                                catch (SecurityException var14_16) {
                                    LocationProviderImpl.access$resumeWithPermissionDenied(this.this$0, continuation);
                                }
                                ** GOTO lbl40
lbl38:
                                // 1 sources

                                LocationProviderImpl.access$resumeWithPermissionDenied(this.this$0, continuation);
lbl40:
                                // 5 sources

                                v0 = cancellable$iv.getResult();
                                if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                                }
                                v1 = v0;
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl52
                            }
                            case 1: {
                                $i$f$suspendCancellableCoroutine = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl52:
                                // 2 sources

                                return v1;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Location> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var8_4) goto lbl20
lbl19:
                // 1 sources

                return var8_4;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                $i$f$suspendCoroutineWithTimeout = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    var3_6 = (Location)v0;
                }
                catch (Exception e) {
                    return new Failure<T>(e);
                }
                location = var3_6;
                return new Success<Location>(location);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object currentLocation(boolean var1_1, @NotNull Continuation<? super Completion<Location>> var2_2) {
        if (!(var2_2 instanceof currentLocation.1)) ** GOTO lbl-1000
        var17_3 = var2_2;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ LocationProviderImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.currentLocation(false, (Continuation<? super Completion<Location>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.Z$0 = validate;
                $continuation.label = 1;
                uCont$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                cancellable$iv.initCancellability();
                continuation = (CancellableContinuation)cancellable$iv;
                $i$a$-suspendCancellableCoroutine-LocationProviderImpl$currentLocation$location$1 = false;
                if (!LocationProviderImpl.access$getSystemManager$p(this).isLocationPermissionGranted()) ** GOTO lbl51
                try {
                    startTime = LocationProviderImpl.access$getSystemManager$p(this).getCurrentTimeMillis();
                    provider = LocationProviderImpl.access$checkLocationState(this);
                    if (!LocationProviderImpl.access$getSystemManager$p(this).isGooglePlayServicesAvailable()) ** GOTO lbl34
                    LocationProviderImpl.access$getSystemManager$p(this).getFusedLocationProviderClient().getCurrentLocation(100, new CancellationTokenSource().getToken()).addOnSuccessListener(new OnSuccessListener((CancellableContinuation<? super Location>)continuation, validate != false, this, startTime){
                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                        final /* synthetic */ boolean $validate;
                        final /* synthetic */ LocationProviderImpl this$0;
                        final /* synthetic */ long $startTime;
                        {
                            this.$continuation = $continuation;
                            this.$validate = $validate;
                            this.this$0 = $receiver;
                            this.$startTime = $startTime;
                        }

                        public final void onSuccess(Location it) {
                            CoroutineUtilsKt.resumeIfActive(this.$continuation, this.$validate ? LocationProviderImpl.access$getLocationIfValid(this.this$0, it, 250, this.$startTime) : it);
                        }
                    }).addOnFailureListener(new OnFailureListener(this, (CancellableContinuation<? super Location>)continuation){
                        final /* synthetic */ LocationProviderImpl this$0;
                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                        {
                            this.this$0 = $receiver;
                            this.$continuation = $continuation;
                        }

                        public final void onFailure(@NotNull Exception it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Timber.Forest.e((Throwable)it, "Could no request location updates with Fused Location Provider API", new Object[0]);
                            LocationProviderImpl.access$getPoiKitLocationState$p(this.this$0).postValue((Object)((Object)LocationState.NO_LOCATION_FOUND));
                            CoroutineUtilsKt.resumeWithExceptionIfActive(this.$continuation, it);
                        }
                    });
                    ** GOTO lbl53
lbl34:
                    // 1 sources

                    if (provider == null) ** GOTO lbl46
                    if (Build.VERSION.SDK_INT >= 30) {
                        var13_16 = LocationProviderImpl.access$getLocationManager(this);
                        if (var13_16 != null) {
                            var13_16.getCurrentLocation(provider, null, ContextCompat.getMainExecutor((Context)LocationProviderImpl.access$getContext$p(this)), new Consumer((CancellableContinuation<? super Location>)continuation, validate != false, this, startTime){
                                final /* synthetic */ CancellableContinuation<Location> $continuation;
                                final /* synthetic */ boolean $validate;
                                final /* synthetic */ LocationProviderImpl this$0;
                                final /* synthetic */ long $startTime;
                                {
                                    this.$continuation = $continuation;
                                    this.$validate = $validate;
                                    this.this$0 = $receiver;
                                    this.$startTime = $startTime;
                                }

                                public final void accept(Location it) {
                                    if (it != null) {
                                        CoroutineUtilsKt.resumeIfActive(this.$continuation, this.$validate ? LocationProviderImpl.access$getLocationIfValid(this.this$0, it, 250, this.$startTime) : it);
                                    } else {
                                        Timber.Forest.w("No current location available with LocationManager", new Object[0]);
                                        LocationProviderImpl.resumeWithNoLocationFound$default(this.this$0, null, this.$continuation, 1, null);
                                    }
                                }
                            });
                        }
                    } else {
                        listener = new LocationListener(this, (CancellableContinuation<? super Location>)continuation, validate != false, startTime){
                            final /* synthetic */ LocationProviderImpl this$0;
                            final /* synthetic */ CancellableContinuation<Location> $continuation;
                            final /* synthetic */ boolean $validate;
                            final /* synthetic */ long $startTime;
                            {
                                this.this$0 = $receiver;
                                this.$continuation = $continuation;
                                this.$validate = $validate;
                                this.$startTime = $startTime;
                            }

                            public void onLocationChanged(@NotNull Location location2) {
                                Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                                LocationManager locationManager2 = LocationProviderImpl.access$getLocationManager(this.this$0);
                                if (locationManager2 != null) {
                                    locationManager2.removeUpdates((LocationListener)this);
                                }
                                CoroutineUtilsKt.resumeIfActive(this.$continuation, this.$validate ? LocationProviderImpl.access$getLocationIfValid(this.this$0, location2, 250, this.$startTime) : location2);
                            }

                            public void onProviderEnabled(@NotNull String provider) {
                                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                                LocationProviderImpl.access$handleLocationStateChange(this.this$0, provider, true, this, this.$continuation);
                            }

                            public void onProviderDisabled(@NotNull String provider) {
                                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                                LocationProviderImpl.access$resumeWithNoLocationFound(this.this$0, this, this.$continuation);
                            }

                            public void onStatusChanged(@Nullable String provider, int status, @Nullable Bundle extras) {
                                LocationManager locationManager2;
                                LocationProviderImpl.access$handleLocationStateChange(this.this$0, provider, provider != null && ((locationManager2 = LocationProviderImpl.access$getLocationManager(this.this$0)) == null ? false : locationManager2.isProviderEnabled(provider)), this, this.$continuation);
                            }
                        };
                        var14_18 = LocationProviderImpl.access$getLocationManager(this);
                        if (var14_18 != null) {
                            var14_18.requestSingleUpdate(provider, listener, Looper.getMainLooper());
                        }
                        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this, listener){
                            final /* synthetic */ LocationProviderImpl this$0;
                            final /* synthetic */ currentLocation.location.1.listener.1 $listener;
                            {
                                this.this$0 = $receiver;
                                this.$listener = $listener;
                                super(1);
                            }

                            public final void invoke(@Nullable Throwable it) {
                                LocationManager locationManager2 = LocationProviderImpl.access$getLocationManager(this.this$0);
                                if (locationManager2 != null) {
                                    locationManager2.removeUpdates((LocationListener)this.$listener);
                                }
                            }
                        });
                    }
                    ** GOTO lbl53
lbl46:
                    // 1 sources

                    LocationProviderImpl.resumeWithNoLocationFound$default(this, null, continuation, 1, null);
                }
                catch (SecurityException var15_19) {
                    LocationProviderImpl.access$resumeWithPermissionDenied(this, continuation);
                }
                ** GOTO lbl53
lbl51:
                // 1 sources

                LocationProviderImpl.access$resumeWithPermissionDenied(this, continuation);
lbl53:
                // 6 sources

                v0 = cancellable$iv.getResult();
                if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v1 = v0;
                if (v0 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl69
            }
            case 1: {
                $i$f$suspendCancellableCoroutine = false;
                var1_1 = $continuation.Z$0;
                this = (LocationProviderImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl69:
                    // 2 sources

                    var4_7 = (Location)v1;
                }
                catch (Exception e) {
                    return new Failure<T>(e);
                }
                location = var4_7;
                return new Success<Location>(location);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object lastKnownLocation(boolean var1_1, @NotNull Continuation<? super Completion<Location>> var2_2) {
        if (!(var2_2 instanceof lastKnownLocation.1)) ** GOTO lbl-1000
        var17_3 = var2_2;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ LocationProviderImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.lastKnownLocation(false, (Continuation<? super Completion<Location>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.Z$0 = validate;
                $continuation.label = 1;
                uCont$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                cancellable$iv.initCancellability();
                continuation = (CancellableContinuation)cancellable$iv;
                $i$a$-suspendCancellableCoroutine-LocationProviderImpl$lastKnownLocation$location$1 = false;
                if (!LocationProviderImpl.access$getSystemManager$p(this).isLocationPermissionGranted()) ** GOTO lbl48
                try {
                    startTime = LocationProviderImpl.access$getSystemManager$p(this).getCurrentTimeMillis();
                    provider = LocationProviderImpl.access$checkLocationState(this);
                    if (!LocationProviderImpl.access$getSystemManager$p(this).isGooglePlayServicesAvailable()) ** GOTO lbl34
                    LocationProviderImpl.access$getSystemManager$p(this).getFusedLocationProviderClient().getLastLocation().addOnSuccessListener(new OnSuccessListener((CancellableContinuation<? super Location>)continuation, validate != false, this, startTime){
                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                        final /* synthetic */ boolean $validate;
                        final /* synthetic */ LocationProviderImpl this$0;
                        final /* synthetic */ long $startTime;
                        {
                            this.$continuation = $continuation;
                            this.$validate = $validate;
                            this.this$0 = $receiver;
                            this.$startTime = $startTime;
                        }

                        public final void onSuccess(Location it) {
                            CoroutineUtilsKt.resumeIfActive(this.$continuation, this.$validate ? LocationProviderImpl.access$getLocationIfValid(this.this$0, it, 250, this.$startTime) : it);
                        }
                    }).addOnFailureListener(new OnFailureListener(this, (CancellableContinuation<? super Location>)continuation){
                        final /* synthetic */ LocationProviderImpl this$0;
                        final /* synthetic */ CancellableContinuation<Location> $continuation;
                        {
                            this.this$0 = $receiver;
                            this.$continuation = $continuation;
                        }

                        public final void onFailure(@NotNull Exception it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Timber.Forest.e((Throwable)it, "Could no request location updates with Fused Location Provider API", new Object[0]);
                            LocationProviderImpl.access$getPoiKitLocationState$p(this.this$0).postValue((Object)((Object)LocationState.NO_LOCATION_FOUND));
                            CoroutineUtilsKt.resumeWithExceptionIfActive(this.$continuation, it);
                        }
                    });
                    ** GOTO lbl50
lbl34:
                    // 1 sources

                    if (provider == null) ** GOTO lbl43
                    var13_16 = LocationProviderImpl.access$getLocationManager(this);
                    v0 = location = var13_16 == null ? null : var13_16.getLastKnownLocation(provider);
                    if (location != null) {
                        CoroutineUtilsKt.resumeIfActive(continuation, validate != false ? LocationProviderImpl.access$getLocationIfValid(this, location, Boxing.boxInt((int)250), startTime) : location);
                    } else {
                        Timber.Forest.w("No last known location available with LocationManager", new Object[0]);
                        LocationProviderImpl.resumeWithNoLocationFound$default(this, null, continuation, 1, null);
                    }
                    ** GOTO lbl50
lbl43:
                    // 1 sources

                    LocationProviderImpl.resumeWithNoLocationFound$default(this, null, continuation, 1, null);
                }
                catch (SecurityException var15_18) {
                    LocationProviderImpl.access$resumeWithPermissionDenied(this, continuation);
                }
                ** GOTO lbl50
lbl48:
                // 1 sources

                LocationProviderImpl.access$resumeWithPermissionDenied(this, continuation);
lbl50:
                // 6 sources

                v1 = cancellable$iv.getResult();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v2 = v1;
                if (v1 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl66
            }
            case 1: {
                $i$f$suspendCancellableCoroutine = false;
                var1_1 = $continuation.Z$0;
                this = (LocationProviderImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl66:
                    // 2 sources

                    var4_7 = (Location)v2;
                }
                catch (Exception e) {
                    return new Failure<T>(e);
                }
                location = var4_7;
                return new Success<Location>(location);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String checkLocationState() {
        String string2;
        LocationManager locationManager2 = this.getLocationManager();
        if (locationManager2 == null ? false : locationManager2.isProviderEnabled("gps")) {
            this.poiKitLocationState.postValue((Object)LocationState.LOCATION_HIGH_ACCURACY);
            string2 = "gps";
        } else {
            locationManager2 = this.getLocationManager();
            if (locationManager2 == null ? false : locationManager2.isProviderEnabled("network")) {
                this.poiKitLocationState.postValue((Object)LocationState.LOCATION_LOW_ACCURACY);
                string2 = "network";
            } else {
                Timber.Forest.w((Throwable)NoLocationFound.INSTANCE);
                this.poiKitLocationState.postValue((Object)LocationState.NO_LOCATION_FOUND);
                string2 = null;
            }
        }
        return string2;
    }

    private final void handleLocationStateChange(String provider, boolean isProviderEnabled, LocationListener locationListener2, CancellableContinuation<? super Location> continuation) {
        if (provider != null && isProviderEnabled) {
            String string2 = provider;
            if (Intrinsics.areEqual((Object)string2, (Object)"gps")) {
                this.poiKitLocationState.postValue((Object)LocationState.LOCATION_HIGH_ACCURACY);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"network")) {
                this.poiKitLocationState.postValue((Object)LocationState.LOCATION_LOW_ACCURACY);
            } else {
                this.resumeWithNoLocationFound(locationListener2, continuation);
            }
        } else {
            this.resumeWithNoLocationFound(locationListener2, continuation);
        }
    }

    static /* synthetic */ void handleLocationStateChange$default(LocationProviderImpl locationProviderImpl, String string2, boolean bl, LocationListener locationListener2, CancellableContinuation cancellableContinuation, int n, Object object) {
        if ((n & 4) != 0) {
            locationListener2 = null;
        }
        if ((n & 8) != 0) {
            cancellableContinuation = null;
        }
        locationProviderImpl.handleLocationStateChange(string2, bl, locationListener2, (CancellableContinuation<? super Location>)cancellableContinuation);
    }

    private final void resumeWithNoLocationFound(LocationListener locationListener2, CancellableContinuation<? super Location> continuation) {
        LocationManager locationManager2;
        Timber.Forest.w((Throwable)NoLocationFound.INSTANCE);
        this.poiKitLocationState.postValue((Object)LocationState.NO_LOCATION_FOUND);
        if (locationListener2 != null && (locationManager2 = this.getLocationManager()) != null) {
            locationManager2.removeUpdates(locationListener2);
        }
        if ((locationManager2 = continuation) != null) {
            CoroutineUtilsKt.resumeWithExceptionIfActive(locationManager2, NoLocationFound.INSTANCE);
        }
    }

    static /* synthetic */ void resumeWithNoLocationFound$default(LocationProviderImpl locationProviderImpl, LocationListener locationListener2, CancellableContinuation cancellableContinuation, int n, Object object) {
        if ((n & 1) != 0) {
            locationListener2 = null;
        }
        if ((n & 2) != 0) {
            cancellableContinuation = null;
        }
        locationProviderImpl.resumeWithNoLocationFound(locationListener2, (CancellableContinuation<? super Location>)cancellableContinuation);
    }

    private final void resumeWithPermissionDenied(CancellableContinuation<? super Location> continuation) {
        Timber.Forest.w((Throwable)PermissionDenied.INSTANCE);
        this.poiKitLocationState.postValue((Object)LocationState.PERMISSION_DENIED);
        CancellableContinuation<? super Location> cancellableContinuation = continuation;
        if (cancellableContinuation != null) {
            CoroutineUtilsKt.resumeWithExceptionIfActive(cancellableContinuation, PermissionDenied.INSTANCE);
        }
    }

    static /* synthetic */ void resumeWithPermissionDenied$default(LocationProviderImpl locationProviderImpl, CancellableContinuation cancellableContinuation, int n, Object object) {
        if ((n & 1) != 0) {
            cancellableContinuation = null;
        }
        locationProviderImpl.resumeWithPermissionDenied((CancellableContinuation<? super Location>)cancellableContinuation);
    }

    private final Location getLocationIfValid(Location location2, Integer minAccuracy, long startTime) {
        int accuracy;
        if (location2 == null) {
            Timber.Forest.w("Discard null location", new Object[0]);
            return null;
        }
        Integer n = minAccuracy;
        int n2 = accuracy = n == null ? this.getNeededAccuracy(startTime) : n.intValue();
        if (location2.getAccuracy() > (float)accuracy) {
            Timber.Forest.w("Discard inaccurate location: location.accuracy (" + location2.getAccuracy() + " m) > minAccuracy (" + accuracy + " m)", new Object[0]);
            return null;
        }
        if (this.systemManager.getCurrentTimeMillis() - location2.getTime() >= 30000L) {
            Timber.Forest.w("Discard old location: location.time (" + location2.getTime() + " ms) >= MAX_LOCATION_AGE (30000 ms)", new Object[0]);
            return null;
        }
        Timber.Forest.d("Location found: lat = " + location2.getLatitude() + " lon = " + location2.getLongitude(), new Object[0]);
        return location2;
    }

    private final int getNeededAccuracy(long startTime) {
        Integer n;
        long currentTime = this.systemManager.getCurrentTimeMillis();
        long requestedTime = currentTime - startTime;
        long segmentTime = 6000L;
        return requestedTime <= segmentTime ? 20 : (requestedTime <= segmentTime * (long)2 ? 50 : ((n = PACECloudSDK.INSTANCE.getConfiguration$cloud_pace_sdk().getLocationAccuracy()) == null ? 250 : n));
    }

    public static final /* synthetic */ SystemManager access$getSystemManager$p(LocationProviderImpl $this) {
        return $this.systemManager;
    }

    public static final /* synthetic */ String access$checkLocationState(LocationProviderImpl $this) {
        return $this.checkLocationState();
    }

    public static final /* synthetic */ Location access$getLocationIfValid(LocationProviderImpl $this, Location location2, Integer minAccuracy, long startTime) {
        return $this.getLocationIfValid(location2, minAccuracy, startTime);
    }

    public static final /* synthetic */ LocationRequest access$getLocationRequest(LocationProviderImpl $this) {
        return $this.getLocationRequest();
    }

    public static final /* synthetic */ MutableLiveData access$getPoiKitLocationState$p(LocationProviderImpl $this) {
        return $this.poiKitLocationState;
    }

    public static final /* synthetic */ void access$handleLocationStateChange(LocationProviderImpl $this, String provider, boolean isProviderEnabled, LocationListener locationListener2, CancellableContinuation continuation) {
        $this.handleLocationStateChange(provider, isProviderEnabled, locationListener2, (CancellableContinuation<? super Location>)continuation);
    }

    public static final /* synthetic */ void access$resumeWithNoLocationFound(LocationProviderImpl $this, LocationListener locationListener2, CancellableContinuation continuation) {
        $this.resumeWithNoLocationFound(locationListener2, (CancellableContinuation<? super Location>)continuation);
    }

    public static final /* synthetic */ LocationManager access$getLocationManager(LocationProviderImpl $this) {
        return $this.getLocationManager();
    }

    public static final /* synthetic */ void access$resumeWithPermissionDenied(LocationProviderImpl $this, CancellableContinuation continuation) {
        $this.resumeWithPermissionDenied((CancellableContinuation<? super Location>)continuation);
    }

    public static final /* synthetic */ Context access$getContext$p(LocationProviderImpl $this) {
        return $this.context;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcloud/pace/sdk/utils/LocationProviderImpl$Companion;", "", "()V", "BEST_ACCURACY", "", "LOCATION_REQUEST_FASTEST_INTERVAL", "", "LOCATION_REQUEST_INTERVAL", "LOCATION_REQUEST_PRIORITY", "LOCATION_REQUEST_SMALLEST_DISPLACEMENT", "", "LOCATION_SEGMENTS", "LOCATION_TIMEOUT", "LOW_ACCURACY", "MAX_LOCATION_AGE", "MEDIUM_ACCURACY", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

