/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.idkit.model.OIDConfiguration;
import cloud.pace.sdk.utils.Environment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u000200R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0016\"\u0004\b%\u0010\u0018R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0006\"\u0004\b.\u0010\b\u00a8\u00064"}, d2={"Lcloud/pace/sdk/utils/SetupLogger;", "", "()V", "apiKey", "", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "appAuthRedirectScheme", "getAppAuthRedirectScheme", "setAppAuthRedirectScheme", "checkRedirectScheme", "", "getCheckRedirectScheme", "()Ljava/lang/Boolean;", "setCheckRedirectScheme", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "domainACL", "", "getDomainACL", "()Ljava/util/List;", "setDomainACL", "(Ljava/util/List;)V", "environment", "Lcloud/pace/sdk/utils/Environment;", "getEnvironment", "()Lcloud/pace/sdk/utils/Environment;", "setEnvironment", "(Lcloud/pace/sdk/utils/Environment;)V", "missingIDKitValues", "", "getMissingIDKitValues", "setMissingIDKitValues", "missingValues", "getMissingValues", "setMissingValues", "oidConfiguration", "Lcloud/pace/sdk/idkit/model/OIDConfiguration;", "getOidConfiguration", "()Lcloud/pace/sdk/idkit/model/OIDConfiguration;", "setOidConfiguration", "(Lcloud/pace/sdk/idkit/model/OIDConfiguration;)V", "redirectScheme", "getRedirectScheme", "setRedirectScheme", "logBiometryWarningIfNeeded", "", "logSDKWarningIfNeeded", "preCheckIDKitSetup", "preCheckSetup", "cloud.pace.sdk"})
public final class SetupLogger {
    @NotNull
    public static final SetupLogger INSTANCE = new SetupLogger();
    @Nullable
    private static String apiKey;
    @Nullable
    private static String redirectScheme;
    @Nullable
    private static Environment environment;
    @Nullable
    private static List<String> domainACL;
    @Nullable
    private static Boolean checkRedirectScheme;
    @NotNull
    private static List<String> missingValues;
    @Nullable
    private static String appAuthRedirectScheme;
    @Nullable
    private static OIDConfiguration oidConfiguration;
    @NotNull
    private static List<String> missingIDKitValues;

    private SetupLogger() {
    }

    @Nullable
    public final String getApiKey() {
        return apiKey;
    }

    public final void setApiKey(@Nullable String string2) {
        apiKey = string2;
    }

    @Nullable
    public final String getRedirectScheme() {
        return redirectScheme;
    }

    public final void setRedirectScheme(@Nullable String string2) {
        redirectScheme = string2;
    }

    @Nullable
    public final Environment getEnvironment() {
        return environment;
    }

    public final void setEnvironment(@Nullable Environment environment) {
        SetupLogger.environment = environment;
    }

    @Nullable
    public final List<String> getDomainACL() {
        return domainACL;
    }

    public final void setDomainACL(@Nullable List<String> list) {
        domainACL = list;
    }

    @Nullable
    public final Boolean getCheckRedirectScheme() {
        return checkRedirectScheme;
    }

    public final void setCheckRedirectScheme(@Nullable Boolean bl) {
        checkRedirectScheme = bl;
    }

    @NotNull
    public final List<String> getMissingValues() {
        return missingValues;
    }

    public final void setMissingValues(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        missingValues = list;
    }

    @Nullable
    public final String getAppAuthRedirectScheme() {
        return appAuthRedirectScheme;
    }

    public final void setAppAuthRedirectScheme(@Nullable String string2) {
        appAuthRedirectScheme = string2;
    }

    @Nullable
    public final OIDConfiguration getOidConfiguration() {
        return oidConfiguration;
    }

    public final void setOidConfiguration(@Nullable OIDConfiguration oIDConfiguration) {
        oidConfiguration = oIDConfiguration;
    }

    @NotNull
    public final List<String> getMissingIDKitValues() {
        return missingIDKitValues;
    }

    public final void setMissingIDKitValues(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        missingIDKitValues = list;
    }

    public final void preCheckSetup() {
        Object object = apiKey;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.length() == 0) {
            missingValues.add("API key");
        }
        object = redirectScheme;
        bl = false;
        bl2 = false;
        if ((object == null || object.length() == 0) && Intrinsics.areEqual((Object)checkRedirectScheme, (Object)true)) {
            missingValues.add("Redirect scheme");
        }
        if (environment == null) {
            missingValues.add("Environment");
        }
        if (environment != Environment.PRODUCTION) {
            object = environment;
            Timber.Forest.w("Current environment is not set to 'production' but to: " + (object == null ? null : ((Enum)object).name()), new Object[0]);
        }
        if (missingValues.isEmpty()) {
            object = redirectScheme;
            Object object2 = object == null ? "disabled" : object;
            object = environment;
            Timber.Forest.i("PACECloudSDK setup successful. You are currently running the SDK as follows:\nAPI key is set\nRedirect scheme: " + object2 + "\nEnviromment: " + (object == null ? null : ((Enum)object).name()), new Object[0]);
        } else {
            Timber.Forest.w("We've noticed PACECloudSDK setup is missing values for: " + CollectionsKt.joinToString$default((Iterable)missingValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        }
    }

    public final void preCheckIDKitSetup() {
        CharSequence charSequence = appAuthRedirectScheme;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            missingIDKitValues.add("appAuthRedirectScheme");
        }
        if (oidConfiguration == null) {
            missingIDKitValues.add("oidConfiguration");
        }
        if (missingIDKitValues.isEmpty()) {
            Timber.Forest.i("IDKit setup successful", new Object[0]);
        } else {
            Timber.Forest.w("We've noticed IDKit setup is missing values for: " + CollectionsKt.joinToString$default((Iterable)missingIDKitValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        }
    }

    public final void logSDKWarningIfNeeded() {
        if (!PACECloudSDK.INSTANCE.isSetup()) {
            Timber.Forest.e("PACECloudSDK.setup() has not been called. Please do so before using any functions of its Kit's", new Object[0]);
        }
        Collection collection = missingValues;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Timber.Forest.w("You haven't set any PACECloudSDK values for: " + CollectionsKt.joinToString$default((Iterable)missingValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), new Object[0]);
        }
    }

    public final void logBiometryWarningIfNeeded() {
        Collection collection = domainACL;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            Timber.Forest.w("We've noticed that you are using IDKits's 2FA methods but haven't set up a valid 'domainACL' yet. Please do so in your PACECloudSDK's configuration", new Object[0]);
        }
    }

    static {
        boolean bl = false;
        missingValues = new ArrayList();
        bl = false;
        missingIDKitValues = new ArrayList();
    }
}

