/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import android.content.Context;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.os.Handler;
import android.os.Looper;
import androidx.core.content.ContextCompat;
import cloud.pace.sdk.utils.SystemManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcloud/pace/sdk/utils/SystemManagerImpl;", "Lcloud/pace/sdk/utils/SystemManager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getConnectivityManager", "Landroid/net/ConnectivityManager;", "getCurrentTimeMillis", "", "getFusedLocationProviderClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "getHandler", "Landroid/os/Handler;", "getLocationManager", "Landroid/location/LocationManager;", "isGooglePlayServicesAvailable", "", "isLocationPermissionGranted", "cloud.pace.sdk"})
public final class SystemManagerImpl
implements SystemManager {
    @NotNull
    private final Context context;

    public SystemManagerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public boolean isLocationPermissionGranted() {
        return ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    @Override
    public boolean isGooglePlayServicesAvailable() {
        return GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.context) == 0;
    }

    @Override
    @NotNull
    public FusedLocationProviderClient getFusedLocationProviderClient() {
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(context)");
        return fusedLocationProviderClient;
    }

    @Override
    @Nullable
    public LocationManager getLocationManager() {
        return (LocationManager)this.context.getSystemService("location");
    }

    @Override
    @Nullable
    public ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)this.context.getSystemService("connectivity");
    }

    @Override
    @NotNull
    public Handler getHandler() {
        return new Handler(Looper.getMainLooper());
    }

    @Override
    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

