/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moe.banana.jsonapi2.ArrayDocument;
import moe.banana.jsonapi2.Error;
import moe.banana.jsonapi2.JsonBuffer;
import moe.banana.jsonapi2.ObjectDocument;
import moe.banana.jsonapi2.Resource;
import moe.banana.jsonapi2.ResourceIdentifier;

public abstract class Document
implements Serializable {
    List<Error> errors = new ArrayList<Error>(0);
    Map<ResourceIdentifier, Resource> included = new HashMap<ResourceIdentifier, Resource>(0);
    private JsonBuffer meta;
    private JsonBuffer links;
    private JsonBuffer jsonApi;

    public Document() {
    }

    public Document(Document document) {
        this.meta = document.meta;
        this.links = document.links;
        this.jsonApi = document.jsonApi;
        this.included.putAll(document.included);
        this.errors.addAll(document.errors);
    }

    @Deprecated
    public boolean include(Resource resource) {
        return this.addInclude(resource);
    }

    @Deprecated
    public boolean exclude(Resource resource) {
        return this.getIncluded().remove(resource);
    }

    public boolean addInclude(Resource resource) {
        return this.getIncluded().add(resource);
    }

    public Collection<Resource> getIncluded() {
        return new Collection<Resource>(){

            @Override
            public int size() {
                return Document.this.included.size();
            }

            @Override
            public boolean isEmpty() {
                return Document.this.included.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return Document.this.included.containsValue(o);
            }

            @Override
            public Iterator<Resource> iterator() {
                return Document.this.included.values().iterator();
            }

            @Override
            public Object[] toArray() {
                return Document.this.included.values().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return Document.this.included.values().toArray(a);
            }

            @Override
            public boolean add(Resource resource) {
                Document.bindDocument(Document.this, resource);
                Document.this.included.put(new ResourceIdentifier(resource), resource);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof ResourceIdentifier) {
                    Resource resource = Document.this.included.remove(new ResourceIdentifier((ResourceIdentifier)o));
                    Document.bindDocument(null, resource);
                    return resource != null;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return Document.this.included.values().containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends Resource> c) {
                for (Resource resource : c) {
                    this.add(resource);
                }
                return true;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                for (Object o : c) {
                    this.remove(o);
                }
                return true;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return false;
            }

            @Override
            public void clear() {
                Document.bindDocument(null, Document.this.included.values());
                Document.this.included.clear();
            }
        };
    }

    public <T extends Resource> T find(ResourceIdentifier resourceIdentifier) {
        return (T)this.included.get(resourceIdentifier);
    }

    public <T extends Resource> T find(String type, String id) {
        return this.find(new ResourceIdentifier(type, id));
    }

    @Deprecated
    public boolean errors(List<Error> errors) {
        return this.setErrors(errors);
    }

    @Deprecated
    public List<Error> errors() {
        return this.getErrors();
    }

    public boolean addError(Error error) {
        return this.errors.add(error);
    }

    public boolean setErrors(Collection<Error> errors) {
        this.errors.clear();
        if (errors != null) {
            this.errors.addAll(errors);
        }
        return true;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean hasError() {
        return this.errors.size() != 0;
    }

    public JsonBuffer getMeta() {
        return this.meta;
    }

    public void setMeta(JsonBuffer meta) {
        this.meta = meta;
    }

    public JsonBuffer getLinks() {
        return this.links;
    }

    public void setLinks(JsonBuffer links) {
        this.links = links;
    }

    public JsonBuffer getJsonApi() {
        return this.jsonApi;
    }

    public void setJsonApi(JsonBuffer jsonApi) {
        this.jsonApi = jsonApi;
    }

    public <DATA extends ResourceIdentifier> ArrayDocument<DATA> asArrayDocument() {
        if (this instanceof ArrayDocument) {
            return (ArrayDocument)this;
        }
        if (this instanceof ObjectDocument) {
            ArrayDocument document = new ArrayDocument(this);
            Object data = ((ObjectDocument)this).get();
            if (data != null) {
                document.add(data);
            }
            return document;
        }
        throw new AssertionError((Object)"unexpected document type");
    }

    public <DATA extends ResourceIdentifier> ObjectDocument<DATA> asObjectDocument() {
        return this.asObjectDocument(0);
    }

    public <DATA extends ResourceIdentifier> ObjectDocument<DATA> asObjectDocument(int position) {
        if (this instanceof ObjectDocument) {
            return (ObjectDocument)this;
        }
        if (this instanceof ArrayDocument) {
            ObjectDocument<Object> document = new ObjectDocument<Object>(this);
            if (((ArrayDocument)this).size() > position) {
                document.set(((ArrayDocument)this).get(position));
            }
            return document;
        }
        throw new AssertionError((Object)"unexpected document type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        if (!this.included.equals(document.included)) {
            return false;
        }
        if (!this.errors.equals(document.errors)) {
            return false;
        }
        if (this.meta != null ? !this.meta.equals(document.meta) : document.meta != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(document.links) : document.links != null) {
            return false;
        }
        return this.jsonApi != null ? this.jsonApi.equals(document.jsonApi) : document.jsonApi == null;
    }

    public int hashCode() {
        int result = this.included.hashCode();
        result = 31 * result + this.errors.hashCode();
        result = 31 * result + (this.meta != null ? this.meta.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.jsonApi != null ? this.jsonApi.hashCode() : 0);
        return result;
    }

    static void bindDocument(Document document, Object resource) {
        if (resource instanceof ResourceIdentifier) {
            ((ResourceIdentifier)resource).setDocument(document);
        }
    }

    static void bindDocument(Document document, Collection<?> resources) {
        for (Object i : resources) {
            Document.bindDocument(document, i);
        }
    }
}

