/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import moe.banana.jsonapi2.Document;
import moe.banana.jsonapi2.JsonBuffer;
import moe.banana.jsonapi2.MoshiHelper;
import moe.banana.jsonapi2.Relationship;
import moe.banana.jsonapi2.Resource;
import moe.banana.jsonapi2.ResourceIdentifier;

public final class HasMany<T extends Resource>
extends Relationship<List<T>>
implements Iterable<ResourceIdentifier>,
Serializable {
    private final List<ResourceIdentifier> linkedResources = new ArrayList<ResourceIdentifier>();
    private boolean hasData = true;

    public HasMany() {
    }

    public HasMany(ResourceIdentifier ... resources) {
        if (resources == null) {
            this.hasData = false;
        } else {
            for (ResourceIdentifier resource : resources) {
                this.add(resource);
            }
        }
    }

    @Override
    public List<T> get(Document document) {
        return this.get(document, null);
    }

    public List<T> get(Document document, T defaultValue) {
        ArrayList<T> collector = new ArrayList<T>(this.linkedResources.size());
        for (ResourceIdentifier resourceId : this.linkedResources) {
            Object obj = document.find(resourceId);
            collector.add(obj == null ? defaultValue : obj);
        }
        return collector;
    }

    public ResourceIdentifier get(int position) {
        return this.linkedResources.get(position);
    }

    public List<ResourceIdentifier> get() {
        return Arrays.asList(this.linkedResources.toArray(new ResourceIdentifier[this.linkedResources.size()]));
    }

    @Override
    public Iterator<ResourceIdentifier> iterator() {
        return this.linkedResources.iterator();
    }

    public boolean add(ResourceIdentifier identifier) {
        if (identifier == null) {
            return false;
        }
        if (identifier.getClass() == ResourceIdentifier.class) {
            this.hasData = true;
            return this.linkedResources.add(identifier);
        }
        return this.add(identifier.getType(), identifier.getId());
    }

    public boolean add(String type, String id) {
        return this.add(new ResourceIdentifier(type, id));
    }

    public boolean remove(ResourceIdentifier identifier) {
        return this.remove(identifier.getType(), identifier.getId());
    }

    public boolean remove(String type, String id) {
        return this.linkedResources.remove(new ResourceIdentifier(type, id));
    }

    public int size() {
        return this.linkedResources.size();
    }

    public boolean hasData() {
        return this.hasData;
    }

    public String toString() {
        return "HasMany{linkedResources=" + this.linkedResources + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasMany hasMany = (HasMany)o;
        return this.linkedResources.equals(hasMany.linkedResources);
    }

    public int hashCode() {
        return this.linkedResources.hashCode();
    }

    static class Adapter<T extends Resource>
    extends JsonAdapter<HasMany<T>> {
        JsonAdapter<ResourceIdentifier> resourceIdentifierJsonAdapter;
        JsonAdapter<JsonBuffer> jsonBufferJsonAdapter;

        public Adapter(Moshi moshi) {
            this.resourceIdentifierJsonAdapter = moshi.adapter(ResourceIdentifier.class);
            this.jsonBufferJsonAdapter = moshi.adapter(JsonBuffer.class);
        }

        public HasMany<T> fromJson(JsonReader reader) throws IOException {
            HasMany relationship = new HasMany();
            reader.beginObject();
            block10: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "data": {
                        if (reader.peek() == JsonReader.Token.NULL) {
                            relationship.hasData = false;
                            reader.nextNull();
                            continue block10;
                        }
                        reader.beginArray();
                        while (reader.hasNext()) {
                            relationship.add((ResourceIdentifier)this.resourceIdentifierJsonAdapter.fromJson(reader));
                        }
                        reader.endArray();
                        continue block10;
                    }
                    case "meta": {
                        relationship.setMeta(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block10;
                    }
                    case "links": {
                        relationship.setLinks(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return relationship;
        }

        public void toJson(JsonWriter writer, HasMany<T> value) throws IOException {
            writer.beginObject();
            writer.name("data");
            if (!((HasMany)value).hasData) {
                MoshiHelper.writeNull(writer, true);
            } else {
                writer.beginArray();
                for (ResourceIdentifier resource : ((HasMany)value).linkedResources) {
                    this.resourceIdentifierJsonAdapter.toJson(writer, (Object)resource);
                }
                writer.endArray();
            }
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "meta", value.getMeta());
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "links", value.getLinks());
            writer.endObject();
        }
    }
}

