/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.io.Serializable;
import moe.banana.jsonapi2.Document;
import moe.banana.jsonapi2.JsonBuffer;
import moe.banana.jsonapi2.MoshiHelper;
import moe.banana.jsonapi2.Relationship;
import moe.banana.jsonapi2.Resource;
import moe.banana.jsonapi2.ResourceIdentifier;

public final class HasOne<T extends Resource>
extends Relationship<T>
implements Serializable {
    private ResourceIdentifier linkedResource;

    public HasOne() {
    }

    public HasOne(String type, String id) {
        this(new ResourceIdentifier(type, id));
    }

    public HasOne(ResourceIdentifier linkedResource) {
        this.set(linkedResource);
    }

    @Override
    public T get(Document document) {
        return this.get(document, null);
    }

    public T get(Document document, T defaultValue) {
        Object obj = document.find(this.linkedResource);
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public ResourceIdentifier get() {
        return this.linkedResource;
    }

    public void set(ResourceIdentifier identifier) {
        if (identifier == null) {
            this.linkedResource = null;
        } else if (ResourceIdentifier.class == identifier.getClass()) {
            this.linkedResource = identifier;
        } else {
            this.set(identifier.getType(), identifier.getId());
        }
    }

    public void set(String type, String id) {
        this.set(new ResourceIdentifier(type, id));
    }

    public String toString() {
        return "HasOne{linkedResource=" + this.linkedResource + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasOne hasOne = (HasOne)o;
        return this.linkedResource != null ? this.linkedResource.equals(hasOne.linkedResource) : hasOne.linkedResource == null;
    }

    public int hashCode() {
        return this.linkedResource != null ? this.linkedResource.hashCode() : 0;
    }

    static class Adapter<T extends Resource>
    extends JsonAdapter<HasOne<T>> {
        JsonAdapter<ResourceIdentifier> resourceIdentifierJsonAdapter;
        JsonAdapter<JsonBuffer> jsonBufferJsonAdapter;

        public Adapter(Moshi moshi) {
            this.resourceIdentifierJsonAdapter = moshi.adapter(ResourceIdentifier.class);
            this.jsonBufferJsonAdapter = moshi.adapter(JsonBuffer.class);
        }

        public HasOne<T> fromJson(JsonReader reader) throws IOException {
            HasOne relationship = new HasOne();
            reader.beginObject();
            block10: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "data": {
                        relationship.set(MoshiHelper.nextNullableObject(reader, this.resourceIdentifierJsonAdapter));
                        continue block10;
                    }
                    case "meta": {
                        relationship.setMeta(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block10;
                    }
                    case "links": {
                        relationship.setLinks(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return relationship;
        }

        public void toJson(JsonWriter writer, HasOne<T> value) throws IOException {
            writer.beginObject();
            MoshiHelper.writeNullable(writer, this.resourceIdentifierJsonAdapter, "data", ((HasOne)value).linkedResource, true);
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "meta", value.getMeta());
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "links", value.getLinks());
            writer.endObject();
        }
    }
}

