/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import moe.banana.jsonapi2.MoshiHelper;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class JsonBuffer<T>
implements Serializable {
    private byte[] buffer;

    private JsonBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public <R extends T> R get(JsonAdapter<R> adapter) {
        try {
            Buffer buffer = new Buffer();
            buffer.write(this.buffer);
            return (R)adapter.fromJson((BufferedSource)buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("JsonBuffer failed to deserialize value with [" + adapter.getClass() + "]", e);
        }
    }

    public static <T> JsonBuffer<T> create(JsonAdapter<T> adapter, T value) {
        try {
            Buffer buffer = new Buffer();
            adapter.toJson((BufferedSink)buffer, value);
            return new JsonBuffer<T>(buffer.readByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("JsonBuffer failed to serialize value with [" + adapter.getClass() + "]", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonBuffer that = (JsonBuffer)o;
        return Arrays.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    public static class Adapter<T>
    extends JsonAdapter<JsonBuffer<T>> {
        public JsonBuffer<T> fromJson(JsonReader reader) throws IOException {
            Buffer buffer = new Buffer();
            MoshiHelper.dump(reader, (BufferedSink)buffer);
            return new JsonBuffer(buffer.readByteArray());
        }

        public void toJson(JsonWriter writer, JsonBuffer<T> value) throws IOException {
            Buffer buffer = new Buffer();
            buffer.write(((JsonBuffer)value).buffer);
            MoshiHelper.dump((BufferedSource)buffer, writer);
        }
    }
}

