/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import okio.BufferedSink;
import okio.BufferedSource;

public final class MoshiHelper {
    public static void dump(BufferedSource source, JsonWriter writer) throws IOException {
        MoshiHelper.dump(JsonReader.of((BufferedSource)source), writer);
    }

    public static void dump(JsonReader reader, BufferedSink sink) throws IOException {
        MoshiHelper.dump(reader, JsonWriter.of((BufferedSink)sink));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(JsonReader reader, JsonWriter writer) throws IOException {
        int nested = 0;
        boolean nullFlag = writer.getSerializeNulls();
        writer.setSerializeNulls(true);
        try {
            while (reader.peek() != JsonReader.Token.END_DOCUMENT) {
                switch (reader.peek()) {
                    case BEGIN_ARRAY: {
                        ++nested;
                        reader.beginArray();
                        writer.beginArray();
                        break;
                    }
                    case END_ARRAY: {
                        reader.endArray();
                        writer.endArray();
                        if (0 != --nested) break;
                        return;
                    }
                    case BEGIN_OBJECT: {
                        ++nested;
                        reader.beginObject();
                        writer.beginObject();
                        break;
                    }
                    case END_OBJECT: {
                        reader.endObject();
                        writer.endObject();
                        if (0 != --nested) break;
                        return;
                    }
                    case NAME: {
                        writer.name(reader.nextName());
                        break;
                    }
                    case NUMBER: {
                        try {
                            writer.value(reader.nextLong());
                        }
                        catch (Exception ignored) {
                            writer.value(reader.nextDouble());
                        }
                        break;
                    }
                    case BOOLEAN: {
                        writer.value(reader.nextBoolean());
                        break;
                    }
                    case STRING: {
                        writer.value(reader.nextString());
                        break;
                    }
                    case NULL: {
                        reader.nextNull();
                        writer.nullValue();
                    }
                }
            }
        }
        finally {
            writer.setSerializeNulls(nullFlag);
        }
    }

    public static String nextNullableString(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue();
            return null;
        }
        return reader.nextString();
    }

    public static <T> T nextNullableObject(JsonReader reader, JsonAdapter<T> adapter) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue();
            return null;
        }
        return (T)adapter.fromJson(reader);
    }

    public static <T> void writeNullable(JsonWriter writer, JsonAdapter<T> valueAdapter, String name, T value) throws IOException {
        MoshiHelper.writeNullable(writer, valueAdapter, name, value, false);
    }

    public static <T> void writeNullable(JsonWriter writer, JsonAdapter<T> valueAdapter, String name, T value, boolean enforced) throws IOException {
        writer.name(name);
        MoshiHelper.writeNullableValue(writer, valueAdapter, value, enforced);
    }

    public static <T> void writeNullableValue(JsonWriter writer, JsonAdapter<T> adapter, T value, boolean enforced) throws IOException {
        if (value != null) {
            adapter.toJson(writer, value);
        } else {
            MoshiHelper.writeNull(writer, enforced);
        }
    }

    public static void writeNull(JsonWriter writer, boolean enforced) throws IOException {
        if (enforced) {
            boolean serializeFlag = writer.getSerializeNulls();
            try {
                writer.setSerializeNulls(true);
                writer.nullValue();
            }
            finally {
                writer.setSerializeNulls(serializeFlag);
            }
        } else {
            writer.nullValue();
        }
    }
}

