/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.banana.jsonapi2.AnnotationUtils;
import moe.banana.jsonapi2.JsonBuffer;
import moe.banana.jsonapi2.JsonNameMapping;
import moe.banana.jsonapi2.MoshiHelper;
import moe.banana.jsonapi2.Relationship;
import moe.banana.jsonapi2.Resource;
import moe.banana.jsonapi2.ResourceIdentifier;

class ResourceAdapter<T extends Resource>
extends JsonAdapter<T> {
    private final Constructor<T> constructor;
    private static final int TYPE_ATTRIBUTE = 1;
    private static final int TYPE_RELATIONSHIP = 3;
    private final Map<String, FieldAdapter> bindings = new LinkedHashMap<String, FieldAdapter>();
    private final JsonAdapter<JsonBuffer> jsonBufferJsonAdapter;

    ResourceAdapter(Class<T> type, JsonNameMapping jsonNameMapping, Moshi moshi) {
        this.jsonBufferJsonAdapter = moshi.adapter(JsonBuffer.class);
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No default constructor on [" + type + "]", e);
        }
        for (Field field : ResourceAdapter.listFields(type, Resource.class)) {
            String name;
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
            if (!Modifier.isPublic(modifiers)) {
                field.setAccessible(true);
            }
            if (this.bindings.containsKey(name = jsonNameMapping.getJsonName(field))) {
                throw new IllegalArgumentException("Duplicated field '" + name + "' in [" + type + "].");
            }
            this.bindings.put(name, new FieldAdapter(field, Relationship.class.isAssignableFrom(Types.getRawType((Type)field.getGenericType())) ? 3 : 1, moshi.adapter(field.getGenericType(), AnnotationUtils.jsonAnnotations(field.getAnnotations()))));
        }
    }

    public T fromJson(JsonReader reader) throws IOException {
        Resource resource;
        try {
            resource = (Resource)this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        reader.beginObject();
        block17: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "id": {
                    resource.setId(MoshiHelper.nextNullableString(reader));
                    continue block17;
                }
                case "type": {
                    resource.setType(MoshiHelper.nextNullableString(reader));
                    continue block17;
                }
                case "attributes": 
                case "relationships": {
                    this.readFields(reader, resource);
                    continue block17;
                }
                case "meta": {
                    resource.setMeta(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                    continue block17;
                }
                case "links": {
                    resource.setLinks(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                    continue block17;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return (T)resource;
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        writer.beginObject();
        writer.name("type").value(((ResourceIdentifier)value).getType());
        writer.name("id").value(((ResourceIdentifier)value).getId());
        this.writeFields(writer, 1, "attributes", value);
        this.writeFields(writer, 3, "relationships", value);
        MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "meta", ((ResourceIdentifier)value).getMeta());
        MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "links", ((Resource)value).getLinks());
        writer.endObject();
    }

    private void readFields(JsonReader reader, Object resource) throws IOException {
        reader.beginObject();
        while (reader.hasNext()) {
            FieldAdapter fieldAdapter = this.bindings.get(reader.nextName());
            if (fieldAdapter != null) {
                fieldAdapter.readFrom(reader, resource);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private void writeFields(JsonWriter writer, int fieldType, String name, Object value) throws IOException {
        boolean skipFlag = true;
        for (Map.Entry<String, FieldAdapter> entry : this.bindings.entrySet()) {
            FieldAdapter adapter = entry.getValue();
            if (adapter.fieldType != fieldType || adapter.get(value) == null && !writer.getSerializeNulls()) continue;
            if (skipFlag) {
                writer.name(name).beginObject();
                skipFlag = false;
            }
            writer.name(entry.getKey());
            adapter.writeTo(writer, value);
        }
        if (!skipFlag) {
            writer.endObject();
        }
    }

    private static List<Field> listFields(Class<?> type, Class<?> baseType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = type; clazz != baseType; clazz = clazz.getSuperclass()) {
            Collections.addAll(fields, clazz.getDeclaredFields());
        }
        return fields;
    }

    private static class FieldAdapter<T> {
        final Field field;
        final JsonAdapter<T> adapter;
        final int fieldType;

        FieldAdapter(Field field, int fieldType, JsonAdapter<T> adapter) {
            this.field = field;
            this.fieldType = fieldType;
            this.adapter = adapter;
        }

        void set(Object target, T value) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        T get(Object object) {
            try {
                return (T)this.field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        void readFrom(JsonReader reader, Object object) throws IOException {
            this.set(object, MoshiHelper.nextNullableObject(reader, this.adapter));
        }

        void writeTo(JsonWriter writer, Object object) throws IOException {
            MoshiHelper.writeNullableValue(writer, this.adapter, this.get(object), false);
        }
    }
}

