/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moe.banana.jsonapi2.ArrayDocument;
import moe.banana.jsonapi2.Document;
import moe.banana.jsonapi2.Error;
import moe.banana.jsonapi2.HasMany;
import moe.banana.jsonapi2.HasOne;
import moe.banana.jsonapi2.JsonApi;
import moe.banana.jsonapi2.JsonBuffer;
import moe.banana.jsonapi2.JsonNameMapping;
import moe.banana.jsonapi2.MoshiHelper;
import moe.banana.jsonapi2.MoshiJsonNameMapping;
import moe.banana.jsonapi2.ObjectDocument;
import moe.banana.jsonapi2.Policy;
import moe.banana.jsonapi2.Resource;
import moe.banana.jsonapi2.ResourceAdapter;
import moe.banana.jsonapi2.ResourceIdentifier;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public final class ResourceAdapterFactory
implements JsonAdapter.Factory {
    private Map<String, Class<?>> typeMap = new HashMap();
    private JsonNameMapping jsonNameMapping;

    private ResourceAdapterFactory(List<Class<? extends Resource>> types, JsonNameMapping jsonNameMapping) {
        this.jsonNameMapping = jsonNameMapping;
        block4: for (Class<? extends Resource> type : types) {
            JsonApi annotation = type.getAnnotation(JsonApi.class);
            String typeName = annotation.type();
            if (annotation.policy() == Policy.SERIALIZATION_ONLY) continue;
            if (this.typeMap.containsKey(typeName)) {
                JsonApi annotationOld = this.typeMap.get(typeName).getAnnotation(JsonApi.class);
                switch (annotationOld.policy()) {
                    case SERIALIZATION_AND_DESERIALIZATION: {
                        if (annotation.policy() == Policy.SERIALIZATION_AND_DESERIALIZATION) {
                            if (annotationOld.priority() < annotation.priority()) continue block4;
                            if (annotationOld.priority() > annotation.priority()) break;
                        }
                    }
                    case DESERIALIZATION_ONLY: {
                        throw new IllegalArgumentException("@JsonApi(type = \"" + typeName + "\") declaration of [" + type.getCanonicalName() + "] conflicts with [" + this.typeMap.get(typeName).getCanonicalName() + "].");
                    }
                }
            }
            this.typeMap.put(typeName, type);
        }
    }

    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        Class rawType = Types.getRawType((Type)type);
        if (rawType.equals(JsonBuffer.class)) {
            return new JsonBuffer.Adapter();
        }
        if (rawType.equals(HasMany.class)) {
            return new HasMany.Adapter(moshi);
        }
        if (rawType.equals(HasOne.class)) {
            return new HasOne.Adapter(moshi);
        }
        if (rawType.equals(Error.class)) {
            return new Error.Adapter(moshi);
        }
        if (rawType.equals(ResourceIdentifier.class)) {
            return new ResourceIdentifier.Adapter(moshi);
        }
        if (rawType.equals(Resource.class)) {
            return new GenericAdapter(this.typeMap, moshi);
        }
        if (Document.class.isAssignableFrom(rawType)) {
            Type typeParameter;
            if (type instanceof ParameterizedType && (typeParameter = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                return new DocumentAdapter((Class)typeParameter, moshi);
            }
            return new DocumentAdapter<Resource>(Resource.class, moshi);
        }
        if (Resource.class.isAssignableFrom(rawType)) {
            return new ResourceAdapter(rawType, this.jsonNameMapping, moshi);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        List<Class<? extends Resource>> types = new ArrayList<Class<? extends Resource>>();
        JsonNameMapping jsonNameMapping = new MoshiJsonNameMapping();

        private Builder() {
        }

        @SafeVarargs
        public final Builder add(Class<? extends Resource> ... type) {
            this.types.addAll(Arrays.asList(type));
            return this;
        }

        public final Builder setJsonNameMapping(JsonNameMapping mapping) {
            if (mapping == null) {
                throw new IllegalArgumentException();
            }
            this.jsonNameMapping = mapping;
            return this;
        }

        public final ResourceAdapterFactory build() {
            return new ResourceAdapterFactory(this.types, this.jsonNameMapping);
        }
    }

    private static class GenericAdapter
    extends JsonAdapter<Resource> {
        Map<String, Class<?>> typeMap;
        Moshi moshi;

        GenericAdapter(Map<String, Class<?>> typeMap, Moshi moshi) {
            this.typeMap = typeMap;
            this.moshi = moshi;
        }

        public Resource fromJson(JsonReader reader) throws IOException {
            JsonAdapter adapter;
            Buffer buffer = new Buffer();
            MoshiHelper.dump(reader, (BufferedSink)buffer);
            String typeName = GenericAdapter.findTypeOf(buffer);
            if (this.typeMap.containsKey(typeName)) {
                adapter = this.moshi.adapter(this.typeMap.get(typeName));
            } else if (this.typeMap.containsKey("default")) {
                adapter = this.moshi.adapter(this.typeMap.get("default"));
            } else {
                throw new JsonDataException("Unknown type of resource: " + typeName);
            }
            return (Resource)adapter.fromJson((BufferedSource)buffer);
        }

        public void toJson(JsonWriter writer, Resource value) throws IOException {
            this.moshi.adapter(value.getClass()).toJson(writer, (Object)value);
        }

        private static String findTypeOf(Buffer buffer) throws IOException {
            Buffer forked = new Buffer();
            buffer.copyTo(forked, 0L, buffer.size());
            JsonReader reader = JsonReader.of((BufferedSource)forked);
            reader.beginObject();
            while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "type": {
                        return reader.nextString();
                    }
                }
                reader.skipValue();
            }
            return null;
        }
    }

    static class DocumentAdapter<DATA extends ResourceIdentifier>
    extends JsonAdapter<Document> {
        JsonAdapter<JsonBuffer> jsonBufferJsonAdapter;
        JsonAdapter<Error> errorJsonAdapter;
        JsonAdapter<DATA> dataJsonAdapter;
        JsonAdapter<Resource> resourceJsonAdapter;

        public DocumentAdapter(Class<DATA> type, Moshi moshi) {
            this.jsonBufferJsonAdapter = moshi.adapter(JsonBuffer.class);
            this.resourceJsonAdapter = moshi.adapter(Resource.class);
            this.errorJsonAdapter = moshi.adapter(Error.class);
            this.dataJsonAdapter = moshi.adapter(type);
        }

        public Document fromJson(JsonReader reader) throws IOException {
            if (reader.peek() == JsonReader.Token.NULL) {
                return null;
            }
            Document document = new ObjectDocument();
            reader.beginObject();
            block16: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "data": {
                        if (reader.peek() == JsonReader.Token.BEGIN_ARRAY) {
                            document = document.asArrayDocument();
                            reader.beginArray();
                            while (reader.hasNext()) {
                                ((ArrayDocument)document).add((ResourceIdentifier)this.dataJsonAdapter.fromJson(reader));
                            }
                            reader.endArray();
                            continue block16;
                        }
                        if (reader.peek() == JsonReader.Token.BEGIN_OBJECT) {
                            document = document.asObjectDocument();
                            ((ObjectDocument)document).set((ResourceIdentifier)this.dataJsonAdapter.fromJson(reader));
                            continue block16;
                        }
                        if (reader.peek() == JsonReader.Token.NULL) {
                            reader.nextNull();
                            document = document.asObjectDocument();
                            ((ObjectDocument)document).set(null);
                            continue block16;
                        }
                        reader.skipValue();
                        continue block16;
                    }
                    case "included": {
                        reader.beginArray();
                        Collection<Resource> includes = document.getIncluded();
                        while (reader.hasNext()) {
                            includes.add((Resource)this.resourceJsonAdapter.fromJson(reader));
                        }
                        reader.endArray();
                        continue block16;
                    }
                    case "errors": {
                        reader.beginArray();
                        List<Error> errors = document.getErrors();
                        while (reader.hasNext()) {
                            errors.add((Error)this.errorJsonAdapter.fromJson(reader));
                        }
                        reader.endArray();
                        continue block16;
                    }
                    case "links": {
                        document.setLinks(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block16;
                    }
                    case "meta": {
                        document.setMeta(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block16;
                    }
                    case "jsonapi": {
                        document.setJsonApi(MoshiHelper.nextNullableObject(reader, this.jsonBufferJsonAdapter));
                        continue block16;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return document;
        }

        public void toJson(JsonWriter writer, Document value) throws IOException {
            writer.beginObject();
            if (value instanceof ArrayDocument) {
                writer.name("data");
                writer.beginArray();
                for (ResourceIdentifier resourceIdentifier : (ArrayDocument)value) {
                    this.dataJsonAdapter.toJson(writer, (Object)resourceIdentifier);
                }
                writer.endArray();
            } else if (value instanceof ObjectDocument) {
                MoshiHelper.writeNullable(writer, this.dataJsonAdapter, "data", ((ObjectDocument)value).get(), ((ObjectDocument)value).hasData());
            }
            if (value.included.size() > 0) {
                writer.name("included");
                writer.beginArray();
                for (Resource resource : value.included.values()) {
                    this.resourceJsonAdapter.toJson(writer, (Object)resource);
                }
                writer.endArray();
            }
            if (value.errors.size() > 0) {
                writer.name("error");
                writer.beginArray();
                for (Error error : value.errors) {
                    this.errorJsonAdapter.toJson(writer, (Object)error);
                }
                writer.endArray();
            }
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "meta", value.getMeta());
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "links", value.getLinks());
            MoshiHelper.writeNullable(writer, this.jsonBufferJsonAdapter, "jsonapi", value.getJsonApi());
            writer.endObject();
        }
    }
}

