/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk;

import android.content.Context;
import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.api.API;
import cloud.pace.sdk.appkit.AppKit;
import cloud.pace.sdk.idkit.IDKit;
import cloud.pace.sdk.idkit.model.CustomOIDConfiguration;
import cloud.pace.sdk.utils.Configuration;
import cloud.pace.sdk.utils.DeviceUtils;
import cloud.pace.sdk.utils.Environment;
import cloud.pace.sdk.utils.ErrorListener;
import cloud.pace.sdk.utils.ExtensionsKt;
import cloud.pace.sdk.utils.KoinConfig;
import cloud.pace.sdk.utils.SetupLogger;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010%J\u0019\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010(H\u0000\u00a2\u0006\u0004\b)\u0010*J\u001a\u0010+\u001a\u00020 2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010,\u001a\u00020 2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.J\u0016\u0010/\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u0010\u0011\u001a\u00020\u0012R<\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001c\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcloud/pace/sdk/PACECloudSDK;", "", "()V", "value", "", "", "additionalQueryParams", "getAdditionalQueryParams", "()Ljava/util/Map;", "setAdditionalQueryParams", "(Ljava/util/Map;)V", "cloudSDKTree", "Ltimber/log/Timber$DebugTree;", "getCloudSDKTree", "()Ltimber/log/Timber$DebugTree;", "cloudSDKTree$delegate", "Lkotlin/Lazy;", "configuration", "Lcloud/pace/sdk/utils/Configuration;", "getConfiguration$cloud_pace_sdk", "()Lcloud/pace/sdk/utils/Configuration;", "setConfiguration$cloud_pace_sdk", "(Lcloud/pace/sdk/utils/Configuration;)V", "", "isLoggingEnabled", "()Z", "setLoggingEnabled", "(Z)V", "isSetup", "setSetup", "loggingListener", "Lkotlin/Function1;", "", "simpleDateFormat", "Ljava/text/SimpleDateFormat;", "setErrorListener", "errorListener", "Lcloud/pace/sdk/utils/ErrorListener;", "setLocationAccuracy", "locationAccuracy", "", "setLocationAccuracy$cloud_pace_sdk", "(Ljava/lang/Integer;)V", "setLoggingListener", "setUserAgentExtensions", "extensions", "", "setup", "context", "Landroid/content/Context;", "cloud.pace.sdk"})
public final class PACECloudSDK {
    @NotNull
    public static final PACECloudSDK INSTANCE = new PACECloudSDK();
    public static Configuration configuration;
    private static boolean isSetup;
    @NotNull
    private static Map<String, String> additionalQueryParams;
    @Nullable
    private static Function1<? super String, Unit> loggingListener;
    @NotNull
    private static final SimpleDateFormat simpleDateFormat;
    @NotNull
    private static final Lazy cloudSDKTree$delegate;
    private static boolean isLoggingEnabled;

    private PACECloudSDK() {
    }

    @NotNull
    public final Configuration getConfiguration$cloud_pace_sdk() {
        Configuration configuration = PACECloudSDK.configuration;
        if (configuration != null) {
            return configuration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        return null;
    }

    public final void setConfiguration$cloud_pace_sdk(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<set-?>");
        PACECloudSDK.configuration = configuration;
    }

    public final boolean isSetup() {
        return isSetup;
    }

    public final void setSetup(boolean bl) {
        isSetup = bl;
    }

    @NotNull
    public final Map<String, String> getAdditionalQueryParams() {
        return additionalQueryParams;
    }

    public final void setAdditionalQueryParams(@NotNull Map<String, String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map newQueryParams = MapsKt.toMutableMap(value);
        if (configuration != null) {
            Map defaultUtmParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)"utm_source", (Object)this.getConfiguration$cloud_pace_sdk().getClientAppName()));
            for (Map.Entry entry : defaultUtmParams.entrySet()) {
                String key = (String)entry.getKey();
                String defaultValue = (String)entry.getValue();
                if (newQueryParams.containsKey(key)) continue;
                newQueryParams.put(key, defaultValue);
            }
        }
        additionalQueryParams = newQueryParams;
        if (IDKit.INSTANCE.isInitialized$cloud_pace_sdk()) {
            Map map = IDKit.INSTANCE.getAdditionalParameters();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            IDKit.INSTANCE.setAdditionalParameters(map);
        }
    }

    private final Timber.DebugTree getCloudSDKTree() {
        Lazy lazy = cloudSDKTree$delegate;
        return (Timber.DebugTree)lazy.getValue();
    }

    public final boolean isLoggingEnabled() {
        return isLoggingEnabled;
    }

    public final void setLoggingEnabled(boolean value) {
        isLoggingEnabled = value;
        if (value) {
            if (!Timber.Forest.forest().contains(this.getCloudSDKTree())) {
                Timber.Forest.plant((Timber.Tree)this.getCloudSDKTree());
            }
        } else if (Timber.Forest.forest().contains(this.getCloudSDKTree())) {
            Timber.Forest.uproot((Timber.Tree)this.getCloudSDKTree());
        }
    }

    public final void setup(@NotNull Context context, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.setConfiguration$cloud_pace_sdk(configuration);
        isSetup = true;
        this.setAdditionalQueryParams(additionalQueryParams);
        if (configuration.getEnvironment() != Environment.PRODUCTION) {
            Timber.Forest.plant((Timber.Tree)new Timber.DebugTree());
        }
        KoinConfig.INSTANCE.setupCloudSDK$cloud_pace_sdk(context, configuration.getEnvironment(), configuration.getApiKey());
        CustomOIDConfiguration customOIDConfiguration = configuration.getOidConfiguration();
        if (customOIDConfiguration != null) {
            CustomOIDConfiguration it = customOIDConfiguration;
            boolean bl = false;
            IDKit.INSTANCE.setup$cloud_pace_sdk(context, ExtensionsKt.getOIDConfiguration(configuration.getEnvironment(), it.getClientId(), it.getClientSecret(), it.getScopes(), it.getRedirectUri(), it.getResponseType(), it.getAdditionalParameters(), it.getAuthorizationEndpoint(), it.getEndSessionEndpoint(), it.getTokenEndpoint(), it.getUserInfoEndpoint(), it.getIntegrated()));
        }
        API.setup$default(API.INSTANCE, configuration.getEnvironment().getApiUrl(), configuration.getApiKey(), null, 4, null);
        AppKit.INSTANCE.setLocationAccuracy(configuration.getLocationAccuracy());
        AppKit.INSTANCE.updateUserAgent$cloud_pace_sdk();
        SetupLogger.INSTANCE.setApiKey(configuration.getApiKey());
        SetupLogger.INSTANCE.setRedirectScheme(DeviceUtils.INSTANCE.getPACERedirectScheme(context));
        SetupLogger.INSTANCE.setEnvironment(configuration.getEnvironment());
        SetupLogger.INSTANCE.setDomainACL(configuration.getDomainACL());
        SetupLogger.INSTANCE.setCheckRedirectScheme(configuration.getCheckRedirectScheme());
        SetupLogger.INSTANCE.preCheckSetup();
    }

    public final void setLoggingListener(@NotNull Function1<? super String, Unit> loggingListener) {
        Intrinsics.checkNotNullParameter(loggingListener, (String)"loggingListener");
        PACECloudSDK.loggingListener = loggingListener;
    }

    public final void setErrorListener(@Nullable ErrorListener errorListener) {
        ErrorListener.Companion.setErrorListener$cloud_pace_sdk(errorListener);
    }

    public final void setUserAgentExtensions(@NotNull List<String> extensions) {
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        if (configuration != null) {
            this.getConfiguration$cloud_pace_sdk().setExtensions(extensions);
            AppKit.INSTANCE.updateUserAgent$cloud_pace_sdk();
        }
    }

    public final void setLocationAccuracy$cloud_pace_sdk(@Nullable Integer locationAccuracy) {
        if (configuration != null) {
            this.getConfiguration$cloud_pace_sdk().setLocationAccuracy(locationAccuracy);
        }
    }

    public static final /* synthetic */ SimpleDateFormat access$getSimpleDateFormat$p() {
        return simpleDateFormat;
    }

    public static final /* synthetic */ Function1 access$getLoggingListener$p() {
        return loggingListener;
    }

    static {
        additionalQueryParams = MapsKt.emptyMap();
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);
        cloudSDKTree$delegate = LazyKt.lazy((Function0)cloudSDKTree.2.INSTANCE);
    }
}

