/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.app.deeplink;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.browser.customtabs.CustomTabsIntent;
import cloud.pace.sdk.appkit.app.deeplink.WebViewActivity;
import cloud.pace.sdk.utils.ErrorLevel;
import cloud.pace.sdk.utils.ErrorListener;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\n\u001a\u00020\u0007H\u0014J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcloud/pace/sdk/appkit/app/deeplink/DeepLinkManagementActivity;", "Landroid/app/Activity;", "()V", "isProcessStarted", "", "isChromeCustomTabsSupported", "onNewIntent", "", "intent", "Landroid/content/Intent;", "onResume", "setCanceled", "setSuccess", "redirectUri", "", "Companion", "cloud.pace.sdk"})
public final class DeepLinkManagementActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isProcessStarted;
    @NotNull
    public static final String URL = "url";
    @NotNull
    public static final String INTEGRATED = "integrated";
    @NotNull
    public static final String TO = "to";
    @NotNull
    private static final String TAG = "DeepLinkManagementActivity";

    protected void onResume() {
        super.onResume();
        if (!this.isProcessStarted) {
            Bundle bundle = this.getIntent().getExtras();
            String url = bundle == null ? null : bundle.getString(URL);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted), TuplesKt.to((Object)"URL", (Object)url)};
            ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk$default(ErrorListener.Companion, TAG, "It is the first run of the activity", MapsKt.mapOf((Pair[])pairArray), null, 8, null);
            if (url != null) {
                boolean bl;
                Bundle bundle2 = this.getIntent().getExtras();
                boolean integrated = bundle2 == null ? false : (bl = bundle2.getBoolean(INTEGRATED));
                try {
                    Intent intent;
                    Intent intent2;
                    if (integrated) {
                        intent2 = new Intent[]{TuplesKt.to((Object)INTEGRATED, (Object)integrated), TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted)};
                        ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk$default(ErrorListener.Companion, TAG, "Open URL in WebView of WebViewActivity", MapsKt.mapOf((Pair[])intent2), null, 8, null);
                        intent = new Intent((Context)this, WebViewActivity.class);
                    } else {
                        Intent intent3 = new Intent[]{TuplesKt.to((Object)INTEGRATED, (Object)integrated), TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted)};
                        ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk$default(ErrorListener.Companion, TAG, "Open URL in custom tab activity", MapsKt.mapOf((Pair[])intent3), null, 8, null);
                        Intent $this$onResume_u24lambda_u2d0 = intent3 = new CustomTabsIntent.Builder().build().intent;
                        boolean bl2 = false;
                        if (this.isChromeCustomTabsSupported()) {
                            $this$onResume_u24lambda_u2d0.setPackage("com.android.chrome");
                        }
                        intent2 = intent3;
                        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n                      \u2026  }\n                    }");
                        intent = intent2;
                    }
                    Intent intent4 = intent;
                    intent4.setData(Uri.parse((String)url));
                    this.startActivity(intent4);
                    this.isProcessStarted = true;
                }
                catch (ActivityNotFoundException e) {
                    ErrorListener.Companion.reportError$cloud_pace_sdk((Exception)((Object)e));
                    this.setCanceled();
                }
            } else {
                ErrorListener.Companion.reportError$cloud_pace_sdk(new NullPointerException("The start URL cannot be null."));
                this.setCanceled();
            }
        } else {
            Uri uri = this.getIntent().getData();
            String redirectUri = uri == null ? null : uri.getQueryParameter(TO);
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted);
            Uri uri2 = this.getIntent().getData();
            pairArray[1] = TuplesKt.to((Object)"Intent data", (Object)(uri2 == null ? null : uri2.toString()));
            ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk$default(ErrorListener.Companion, TAG, "It is the subsequent run of the activity", MapsKt.mapOf((Pair[])pairArray), null, 8, null);
            if (redirectUri != null) {
                pairArray = new Pair[]{TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted), TuplesKt.to((Object)"Redirect URL", (Object)redirectUri)};
                ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk$default(ErrorListener.Companion, TAG, "The process succeeded. Load redirect URL in original WebView.", MapsKt.mapOf((Pair[])pairArray), null, 8, null);
                this.setSuccess(redirectUri);
            } else {
                ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk(TAG, "The process failed. Load cancel URL in original WebView.", MapsKt.mapOf((Pair)TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted)), ErrorLevel.WARNING);
                this.setCanceled();
            }
        }
    }

    private final boolean isChromeCustomTabsSupported() {
        Intent serviceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        serviceIntent.setPackage("com.android.chrome");
        List list = this.getPackageManager().queryIntentServices(serviceIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryInte\u2026ervices(serviceIntent, 0)");
        List resolveInfos = list;
        return !((Collection)resolveInfos).isEmpty();
    }

    private final void setSuccess(String redirectUri) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)redirectUri));
        this.setResult(-1, intent);
        this.finish();
    }

    private final void setCanceled() {
        this.setResult(0);
        this.finish();
    }

    protected void onNewIntent(@Nullable Intent intent) {
        String string;
        super.onNewIntent(intent);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"isProcessStarted", (Object)this.isProcessStarted);
        Intent intent2 = intent;
        if (intent2 == null) {
            string = null;
        } else {
            Uri uri = intent2.getData();
            string = uri == null ? null : uri.toString();
        }
        pairArray[1] = TuplesKt.to((Object)"Intent data", string);
        ErrorListener.Companion.reportBreadcrumb$cloud_pace_sdk$default(ErrorListener.Companion, TAG, "Set new intent", MapsKt.mapOf((Pair[])pairArray), null, 8, null);
        this.setIntent(intent);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcloud/pace/sdk/appkit/app/deeplink/DeepLinkManagementActivity$Companion;", "", "()V", "INTEGRATED", "", "TAG", "TO", "URL", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

