/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.app.drawer;

import android.graphics.Bitmap;
import android.graphics.Color;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import cloud.pace.sdk.appkit.app.drawer.AppDrawerViewModel;
import cloud.pace.sdk.appkit.communication.AppEventManager;
import cloud.pace.sdk.appkit.model.App;
import cloud.pace.sdk.utils.Event;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\fH\u0016J\b\u0010&\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u001c\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\t\u00a8\u0006'"}, d2={"Lcloud/pace/sdk/appkit/app/drawer/AppDrawerViewModelImpl;", "Lcloud/pace/sdk/appkit/app/drawer/AppDrawerViewModel;", "eventManager", "Lcloud/pace/sdk/appkit/communication/AppEventManager;", "(Lcloud/pace/sdk/appkit/communication/AppEventManager;)V", "background", "Landroidx/lifecycle/MutableLiveData;", "", "getBackground", "()Landroidx/lifecycle/MutableLiveData;", "closeEvent", "Lcloud/pace/sdk/utils/Event;", "", "getCloseEvent", "disabledHostObserver", "Landroidx/lifecycle/Observer;", "", "iconBackground", "getIconBackground", "invalidAppsObserver", "", "logo", "Landroid/graphics/Bitmap;", "getLogo", "subtitle", "getSubtitle", "textColor", "getTextColor", "title", "getTitle", "url", "getUrl", "init", "app", "Lcloud/pace/sdk/appkit/model/App;", "darkBackground", "", "onCreate", "onDestroy", "cloud.pace.sdk"})
public final class AppDrawerViewModelImpl
extends AppDrawerViewModel {
    @NotNull
    private final AppEventManager eventManager;
    @NotNull
    private final MutableLiveData<String> url;
    @NotNull
    private final MutableLiveData<String> title;
    @NotNull
    private final MutableLiveData<String> subtitle;
    @NotNull
    private final MutableLiveData<Integer> background;
    @NotNull
    private final MutableLiveData<Integer> iconBackground;
    @NotNull
    private final MutableLiveData<Integer> textColor;
    @NotNull
    private final MutableLiveData<Bitmap> logo;
    @NotNull
    private final MutableLiveData<Event<Unit>> closeEvent;
    @NotNull
    private final Observer<List<String>> invalidAppsObserver;
    @NotNull
    private final Observer<String> disabledHostObserver;

    public AppDrawerViewModelImpl(@NotNull AppEventManager eventManager) {
        Intrinsics.checkNotNullParameter((Object)eventManager, (String)"eventManager");
        this.eventManager = eventManager;
        this.url = new MutableLiveData();
        this.title = new MutableLiveData();
        this.subtitle = new MutableLiveData();
        this.background = new MutableLiveData();
        this.iconBackground = new MutableLiveData();
        this.textColor = new MutableLiveData();
        this.logo = new MutableLiveData();
        this.closeEvent = new MutableLiveData();
        this.invalidAppsObserver = arg_0 -> AppDrawerViewModelImpl.invalidAppsObserver$lambda-0(this, arg_0);
        this.disabledHostObserver = arg_0 -> AppDrawerViewModelImpl.disabledHostObserver$lambda-1(this, arg_0);
    }

    @NotNull
    public MutableLiveData<String> getUrl() {
        return this.url;
    }

    @NotNull
    public MutableLiveData<String> getTitle() {
        return this.title;
    }

    @NotNull
    public MutableLiveData<String> getSubtitle() {
        return this.subtitle;
    }

    @NotNull
    public MutableLiveData<Integer> getBackground() {
        return this.background;
    }

    @NotNull
    public MutableLiveData<Integer> getIconBackground() {
        return this.iconBackground;
    }

    @NotNull
    public MutableLiveData<Integer> getTextColor() {
        return this.textColor;
    }

    @NotNull
    public MutableLiveData<Bitmap> getLogo() {
        return this.logo;
    }

    @NotNull
    public MutableLiveData<Event<Unit>> getCloseEvent() {
        return this.closeEvent;
    }

    @Override
    public void init(@NotNull App app, boolean darkBackground) {
        Bitmap bitmap;
        String it;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.getUrl().setValue((Object)app.getUrl());
        this.getTitle().setValue((Object)app.getName());
        this.getSubtitle().setValue((Object)app.getDescription());
        String string2 = app.getIconBackgroundColor();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            try {
                this.getIconBackground().setValue((Object)Color.parseColor((String)it));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        Bitmap bitmap2 = bitmap = app.getLogo();
        if (bitmap2 != null) {
            it = bitmap2;
            boolean bl = false;
            this.getLogo().setValue((Object)it);
        }
        if (app.getTextBackgroundColor() != null && app.getTextColor() != null) {
            try {
                this.getBackground().setValue((Object)Color.parseColor((String)app.getTextBackgroundColor()));
                this.getTextColor().setValue((Object)Color.parseColor((String)app.getTextColor()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onCreate() {
        this.eventManager.getInvalidApps().observeForever(this.invalidAppsObserver);
        this.eventManager.getDisabledHost().observeForever(this.disabledHostObserver);
    }

    @Override
    public void onDestroy() {
        this.eventManager.getInvalidApps().removeObserver(this.invalidAppsObserver);
        this.eventManager.getDisabledHost().removeObserver(this.disabledHostObserver);
    }

    private static final void invalidAppsObserver$lambda-0(AppDrawerViewModelImpl this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (CollectionsKt.contains((Iterable)it, (Object)this$0.getUrl().getValue())) {
            this$0.getCloseEvent().setValue(new Event<Unit>(Unit.INSTANCE));
        }
    }

    private static final void disabledHostObserver$lambda-1(AppDrawerViewModelImpl this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            String host = new URL((String)this$0.getUrl().getValue()).getHost();
            if (Intrinsics.areEqual((Object)it, (Object)host)) {
                this$0.getCloseEvent().setValue(new Event<Unit>(Unit.INSTANCE));
            }
        }
        catch (MalformedURLException e) {
            return;
        }
    }
}

