/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.persistence;

import android.content.Context;
import android.net.Uri;
import cloud.pace.sdk.api.utils.InterceptorUtils;
import cloud.pace.sdk.appkit.AppKit;
import cloud.pace.sdk.appkit.model.AppManifest;
import cloud.pace.sdk.appkit.persistence.CacheModel;
import cloud.pace.sdk.poikit.utils.ApiException;
import cloud.pace.sdk.utils.CallbackUtilsKt;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u00040\fH\u0002\u00f8\u0001\u0000J5\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00f8\u0001\u0000J5\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcloud/pace/sdk/appkit/persistence/CacheModelImpl;", "Lcloud/pace/sdk/appkit/persistence/CacheModel;", "()V", "fetch", "", "context", "Landroid/content/Context;", "url", "Ljava/net/URL;", "userAgent", "", "completion", "Lkotlin/Function1;", "Lkotlin/Result;", "", "getManifest", "Lcloud/pace/sdk/appkit/model/AppManifest;", "getUri", "Companion", "cloud.pace.sdk"})
public final class CacheModelImpl
implements CacheModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ACCEPT_LANGUAGE_KEY = "Accept-Language";
    @NotNull
    private static final String USER_AGENT_KEY = "User-Agent";
    @NotNull
    private static final String MANIFEST_FILE_NAME = "manifest.json";
    private static final long CACHE_SIZE_BYTES = 0x3200000L;

    @Override
    public void getUri(@NotNull Context context, @NotNull String url, @NotNull Function1<? super Result<byte[]>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        try {
            this.fetch(context, new URL(url), AppKit.INSTANCE.getUserAgent$cloud_pace_sdk(), completion);
        }
        catch (MalformedURLException e) {
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
        }
    }

    private final void fetch(Context context, URL url, String userAgent, Function1<? super Result<byte[]>, Unit> completion) {
        Map headers;
        Map map = headers = (Map)new LinkedHashMap();
        Object object = ACCEPT_LANGUAGE_KEY;
        String string2 = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().language");
        map.put(object, string2);
        map = headers;
        object = "uber-trace-id";
        string2 = InterceptorUtils.INSTANCE.getUberTraceId$cloud_pace_sdk();
        map.put(object, string2);
        if (userAgent != null) {
            map = headers;
            object = USER_AGENT_KEY;
            map.put(object, userAgent);
        }
        Request request = new Request.Builder().url(url).headers(Headers.Companion.of(headers)).build();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        object = context.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.cacheDir");
        builder.cache(new Cache((File)object, 0x3200000L)).addInterceptor((Interceptor)new HttpLoggingInterceptor(null, 1, null).setLevel(HttpLoggingInterceptor.Level.HEADERS)).build().newCall(request).enqueue(new Callback(completion){
            final /* synthetic */ Function1<Result<byte[]>, Unit> $completion;
            {
                this.$completion = $completion;
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                byte[] data;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                ResponseBody responseBody = response.body();
                Object object = data = (Object)(responseBody == null ? null : responseBody.bytes());
                if (response.isSuccessful() && data != null) {
                    this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)data)));
                } else {
                    Timber.Forest.e((Throwable)new ApiException(response.code(), response.message(), CallbackUtilsKt.getRequestId(response)), "Request returned with no content for URL: " + call.request().url(), new Object[0]);
                    this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Request returned with no content")))));
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Timber.Forest.e((Throwable)e, "Request failed for URL: " + call.request().url(), new Object[0]);
                this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
            }
        });
    }

    @Override
    public void getManifest(@NotNull Context context, @NotNull String url, @NotNull Function1<? super Result<AppManifest>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Uri fullUri = Uri.parse((String)url);
        String baseUrl = fullUri.getScheme() + "://" + fullUri.getHost();
        String string2 = Uri.parse((String)baseUrl).buildUpon().appendPath(MANIFEST_FILE_NAME).build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parse(baseUrl).buildUpon\u2026_NAME).build().toString()");
        String manifestUrl = string2;
        this.getUri(context, manifestUrl, (Function1<? super Result<byte[]>, Unit>)((Function1)new Function1<Result<? extends byte[]>, Unit>(completion){
            final /* synthetic */ Function1<Result<AppManifest>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result2) {
                Object object = result2;
                Function1<Result<AppManifest>, Unit> function1 = this.$completion;
                if (Result.isSuccess-impl((Object)object)) {
                    byte[] it = (byte[])object;
                    boolean bl = false;
                    try {
                        Charset charset = Charset.defaultCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                        String json = new String(it, charset);
                        AppManifest manifest = (AppManifest)new Gson().fromJson(json, AppManifest.class);
                        function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)manifest)));
                    }
                    catch (JsonSyntaxException e) {
                        function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
                    }
                    catch (FileNotFoundException e) {
                        function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
                    }
                }
                object = result2;
                function1 = this.$completion;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
                }
            }
        }));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcloud/pace/sdk/appkit/persistence/CacheModelImpl$Companion;", "", "()V", "ACCEPT_LANGUAGE_KEY", "", "CACHE_SIZE_BYTES", "", "MANIFEST_FILE_NAME", "USER_AGENT_KEY", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

