/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.persistence;

import android.content.SharedPreferences;
import cloud.pace.sdk.appkit.model.Car;
import cloud.pace.sdk.appkit.persistence.SharedPreferencesModel;
import cloud.pace.sdk.appkit.persistence.TotpSecret;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J@\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\n\u0018\u00010\u0012j\n\u0012\u0004\u0012\u00020\n\u0018\u0001`\u00132\u0006\u0010\t\u001a\u00020\n2\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\n\u0018\u00010\u0012j\n\u0012\u0004\u0012\u00020\n\u0018\u0001`\u0013H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0016J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0012j\b\u0012\u0004\u0012\u00020\n`\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010 \u001a\u00020\u00192\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0006H\u0016J\"\u0010#\u001a\u00020\u00192\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcloud/pace/sdk/appkit/persistence/SharedPreferencesImpl;", "Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "getCar", "Lcloud/pace/sdk/appkit/model/Car;", "getInt", "", "key", "", "defValue", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;", "getLong", "", "(Ljava/lang/String;Ljava/lang/Long;)Ljava/lang/Long;", "getString", "getStringSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "defValues", "getTotpSecret", "Lcloud/pace/sdk/appkit/persistence/TotpSecret;", "host", "putInt", "", "value", "putLong", "putString", "putStringSet", "values", "remove", "removeTotpSecret", "setCar", "car", "setTotpSecret", "totpSecret", "Companion", "cloud.pace.sdk"})
public final class SharedPreferencesImpl
implements SharedPreferencesModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private static final String VIN = "vin";
    @NotNull
    private static final String FUEL_TYPE = "fuelType";
    @NotNull
    private static final String EXPECTED_AMOUNT = "expectedAmount";
    @NotNull
    private static final String MILEAGE = "mileage";
    @NotNull
    public static final String SECRET = "totp_secret_secret";
    @NotNull
    public static final String PERIOD = "totp_secret_period";
    @NotNull
    public static final String DIGITS = "totp_secret_digits";
    @NotNull
    public static final String ALGORITHM = "totp_secret_algorithm";
    @NotNull
    public static final String SECURE_DATA = "secure_data";
    @NotNull
    public static final String DISABLE_TIME = "disable_time";
    @NotNull
    public static final String PAYMENT_AUTHORIZE = "payment-authorize";
    @NotNull
    public static final String SESSION_CACHE = "sessionCache";

    public SharedPreferencesImpl(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putString_u24lambda_u2d0 = editor$iv;
        boolean bl = false;
        $this$putString_u24lambda_u2d0.putString(key, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getString(key, defValue);
    }

    @Override
    public void putStringSet(@NotNull String key, @NotNull HashSet<String> values) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putStringSet_u24lambda_u2d1 = editor$iv;
        boolean bl = false;
        $this$putStringSet_u24lambda_u2d1.putStringSet(key, (Set)values);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public HashSet<String> getStringSet(@NotNull String key, @Nullable HashSet<String> defValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Set set = this.sharedPreferences.getStringSet(key, (Set)defValues);
        return set instanceof HashSet ? (HashSet)set : null;
    }

    @Override
    public void putInt(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putInt_u24lambda_u2d2 = editor$iv;
        boolean bl = false;
        $this$putInt_u24lambda_u2d2.putInt(key, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String key, @Nullable Integer defValue) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.sharedPreferences.contains(key)) {
            Integer n2 = defValue;
            n = this.sharedPreferences.getInt(key, n2 == null ? 0 : n2);
        } else {
            n = null;
        }
        return n;
    }

    @Override
    public void putLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putLong_u24lambda_u2d3 = editor$iv;
        boolean bl = false;
        $this$putLong_u24lambda_u2d3.putLong(key, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public Long getLong(@NotNull String key, @Nullable Long defValue) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.sharedPreferences.contains(key)) {
            Long l2 = defValue;
            l = this.sharedPreferences.getLong(key, l2 == null ? 0L : l2);
        } else {
            l = null;
        }
        return l;
    }

    @Override
    public void setCar(@NotNull Car car) {
        String it;
        Intrinsics.checkNotNullParameter((Object)car, (String)"car");
        String string2 = car.getVin();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.putString(VIN, it);
        }
        String string3 = car.getFuelTyp();
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            this.putString(FUEL_TYPE, it);
        }
        Integer n = car.getExpectedAmount();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            this.putInt(EXPECTED_AMOUNT, it2);
        }
        Integer n2 = car.getMileage();
        if (n2 != null) {
            int it3 = ((Number)n2).intValue();
            boolean bl = false;
            this.putInt(MILEAGE, it3);
        }
    }

    @Override
    @NotNull
    public Car getCar() {
        return new Car(SharedPreferencesModel.DefaultImpls.getString$default(this, VIN, null, 2, null), SharedPreferencesModel.DefaultImpls.getString$default(this, FUEL_TYPE, null, 2, null), SharedPreferencesModel.DefaultImpls.getInt$default(this, EXPECTED_AMOUNT, null, 2, null), SharedPreferencesModel.DefaultImpls.getInt$default(this, MILEAGE, null, 2, null));
    }

    @Override
    public void setTotpSecret(@Nullable String host, @NotNull String key, @NotNull TotpSecret totpSecret) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)totpSecret, (String)"totpSecret");
        this.putString(Companion.getTotpSecretPreferenceKey(SECRET, host, key), totpSecret.getEncryptedSecret());
        this.putInt(Companion.getTotpSecretPreferenceKey(DIGITS, host, key), totpSecret.getDigits());
        this.putInt(Companion.getTotpSecretPreferenceKey(PERIOD, host, key), totpSecret.getPeriod());
        this.putString(Companion.getTotpSecretPreferenceKey(ALGORITHM, host, key), totpSecret.getAlgorithm());
    }

    @Override
    @Nullable
    public TotpSecret getTotpSecret(@Nullable String host, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String encryptedSecret = SharedPreferencesModel.DefaultImpls.getString$default(this, Companion.getTotpSecretPreferenceKey(SECRET, host, key), null, 2, null);
        Integer digits = SharedPreferencesModel.DefaultImpls.getInt$default(this, Companion.getTotpSecretPreferenceKey(DIGITS, host, key), null, 2, null);
        Integer period = SharedPreferencesModel.DefaultImpls.getInt$default(this, Companion.getTotpSecretPreferenceKey(PERIOD, host, key), null, 2, null);
        String algorithm = SharedPreferencesModel.DefaultImpls.getString$default(this, Companion.getTotpSecretPreferenceKey(ALGORITHM, host, key), null, 2, null);
        return encryptedSecret != null && digits != null && period != null && algorithm != null ? new TotpSecret(encryptedSecret, digits, period, algorithm) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeTotpSecret(@Nullable String host, @NotNull String key) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.sharedPreferences.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"sharedPreferences.all");
        Map $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            if (!StringsKt.endsWith$default((String)((String)k), (String)"_payment-authorize", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map totpSecretPrefs = destination$iv$iv;
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removeTotpSecret_u24lambda_u2d10 = editor$iv;
        boolean bl = false;
        Map $this$forEach$iv = totpSecretPrefs;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$removeTotpSecret_u24lambda_u2d10.remove((String)it.getKey());
        }
        editor$iv.apply();
    }

    @Override
    public void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$remove_u24lambda_u2d11 = editor$iv;
        boolean bl = false;
        $this$remove_u24lambda_u2d11.remove(key);
        editor$iv.apply();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcloud/pace/sdk/appkit/persistence/SharedPreferencesImpl$Companion;", "", "()V", "ALGORITHM", "", "DIGITS", "DISABLE_TIME", "EXPECTED_AMOUNT", "FUEL_TYPE", "MILEAGE", "PAYMENT_AUTHORIZE", "PERIOD", "SECRET", "SECURE_DATA", "SESSION_CACHE", "VIN", "getDisableTimePreferenceKey", "host", "getSecureDataPreferenceKey", "key", "getTotpSecretPreferenceKey", "which", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTotpSecretPreferenceKey(@NotNull String which, @Nullable String host, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)which, (String)"which");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return which + (String)(host != null ? "_" + host : "") + "_" + key;
        }

        @NotNull
        public final String getSecureDataPreferenceKey(@NotNull String host, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return "secure_data_" + host + "_" + key;
        }

        @NotNull
        public final String getDisableTimePreferenceKey(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return "disable_time_" + host;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

