/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.appkit.utils;

import cloud.pace.sdk.appkit.utils.JWTUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcloud/pace/sdk/appkit/utils/TokenValidator;", "", "()V", "TEN_MINUTES_IN_SECONDS", "", "isTokenValid", "", "accessToken", "", "cloud.pace.sdk"})
public final class TokenValidator {
    @NotNull
    public static final TokenValidator INSTANCE = new TokenValidator();
    private static final int TEN_MINUTES_IN_SECONDS = 600;

    private TokenValidator() {
    }

    public final boolean isTokenValid(@NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        JSONObject decodedJwtPayload = null;
        long expirationTime = 0L;
        try {
            decodedJwtPayload = JWTUtils.INSTANCE.decodeJwtPayload(accessToken);
            expirationTime = decodedJwtPayload.getLong("exp");
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e, "Failed to decode token " + accessToken + " or its expiration date", new Object[0]);
            return false;
        }
        return expirationTime > TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - (long)600;
    }
}

