/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.idkit.authorization;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.api.API;
import cloud.pace.sdk.appkit.persistence.SharedPreferencesModel;
import cloud.pace.sdk.idkit.IDKit;
import cloud.pace.sdk.idkit.authorization.AuthorizationManager;
import cloud.pace.sdk.idkit.authorization.integrated.AuthorizationWebViewActivity;
import cloud.pace.sdk.idkit.model.FailedRetrievingConfigurationWhileDiscovering;
import cloud.pace.sdk.idkit.model.FailedRetrievingSessionWhileAuthorizing;
import cloud.pace.sdk.idkit.model.FailedRetrievingSessionWhileEnding;
import cloud.pace.sdk.idkit.model.InternalError;
import cloud.pace.sdk.idkit.model.InvalidSession;
import cloud.pace.sdk.idkit.model.OIDConfiguration;
import cloud.pace.sdk.idkit.model.OperationCanceled;
import cloud.pace.sdk.idkit.model.ServiceConfiguration;
import cloud.pace.sdk.idkit.model.UserEndpointNotDefined;
import cloud.pace.sdk.idkit.userinfo.UserInfoApiClient;
import cloud.pace.sdk.idkit.userinfo.UserInfoResponse;
import cloud.pace.sdk.utils.Canceled;
import cloud.pace.sdk.utils.CloudSDKKoinComponent;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.Failure;
import cloud.pace.sdk.utils.IntentResult;
import cloud.pace.sdk.utils.IntentResultResolverFragmentKt;
import cloud.pace.sdk.utils.Ok;
import cloud.pace.sdk.utils.SetupLogger;
import cloud.pace.sdk.utils.Success;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.openid.appauth.AuthState;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.AuthorizationService;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.ClientAuthentication;
import net.openid.appauth.ClientSecretBasic;
import net.openid.appauth.EndSessionRequest;
import net.openid.appauth.EndSessionResponse;
import net.openid.appauth.RegistrationResponse;
import net.openid.appauth.TokenRequest;
import net.openid.appauth.TokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.koin.core.Koin;
import timber.log.Timber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J7\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u001a\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u001aJ7\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u001a\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u001dJ%\u0010\u0010\u001a\u00020\u00132\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001fH\u0000\u00a2\u0006\u0002\b\u0012J\u000f\u0010!\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020$H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J/\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00192\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\b2J\u000f\u00103\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b4J5\u00103\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u0010\u001aJ5\u00103\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u0010\u001dJ%\u00103\u001a\u00020$2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001fH\u0000\u00a2\u0006\u0002\b4J\u001b\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0018\u000106H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u000209H\u0002J(\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019062\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001906H\u0002J1\u0010<\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00112\u001a\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\b=J/\u0010>\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00112\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\b?J8\u0010@\u001a\u00020\u00132\b\u0010A\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010D2\u001a\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J\r\u0010E\u001a\u00020$H\u0000\u00a2\u0006\u0002\bFJ\n\u0010G\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020JH\u0016J,\u0010K\u001a\u00020\u00132\u0006\u0010L\u001a\u00020M2\u001a\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J\u0010\u0010N\u001a\u00020\u00132\u0006\u0010O\u001a\u00020\u000fH\u0002J3\u0010P\u001a\u00020\u00132\b\b\u0002\u0010Q\u001a\u00020$2\u001a\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\bRJ#\u0010S\u001a\u00020\u00132\u0014\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0018\u000106H\u0000\u00a2\u0006\u0002\bUJ\u0015\u0010V\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bWJ/\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020\u00192\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0\u0018\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\b[R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\\"}, d2={"Lcloud/pace/sdk/idkit/authorization/AuthorizationManager;", "Lcloud/pace/sdk/utils/CloudSDKKoinComponent;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "context", "Landroid/content/Context;", "authorizationService", "Lnet/openid/appauth/AuthorizationService;", "sharedPreferencesModel", "Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;", "(Landroid/content/Context;Lnet/openid/appauth/AuthorizationService;Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;)V", "authorizationRequest", "Lnet/openid/appauth/AuthorizationRequest;", "configuration", "Lcloud/pace/sdk/idkit/model/OIDConfiguration;", "session", "Lnet/openid/appauth/AuthState;", "authorize", "Landroid/content/Intent;", "authorize$cloud_pace_sdk", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "completion", "Lkotlin/Function1;", "Lcloud/pace/sdk/utils/Completion;", "", "(Landroidx/appcompat/app/AppCompatActivity;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "completedActivity", "Ljava/lang/Class;", "canceledActivity", "cachedToken", "cachedToken$cloud_pace_sdk", "containsAuthorizationResponse", "", "intent", "containsAuthorizationResponse$cloud_pace_sdk", "containsEndSessionResponse", "containsEndSessionResponse$cloud_pace_sdk", "containsException", "containsException$cloud_pace_sdk", "createAuthorizationRequest", "createNewSession", "createEndSessionRequest", "Lnet/openid/appauth/EndSessionRequest;", "discoverConfiguration", "issuerUri", "Lcloud/pace/sdk/idkit/model/ServiceConfiguration;", "discoverConfiguration$cloud_pace_sdk", "endSession", "endSession$cloud_pace_sdk", "getAdditionalParameters", "", "getAdditionalParameters$cloud_pace_sdk", "getAuthorizationServiceConfiguration", "Lnet/openid/appauth/AuthorizationServiceConfiguration;", "getMergedParameters", "idKitParams", "handleAuthorizationResponse", "handleAuthorizationResponse$cloud_pace_sdk", "handleEndSessionResponse", "handleEndSessionResponse$cloud_pace_sdk", "handleTokenResponse", "tokenResponse", "Lnet/openid/appauth/TokenResponse;", "exception", "Lnet/openid/appauth/AuthorizationException;", "isAuthorizationValid", "isAuthorizationValid$cloud_pace_sdk", "loadSession", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "performTokenRequest", "request", "Lnet/openid/appauth/TokenRequest;", "persistSession", "authState", "refreshToken", "force", "refreshToken$cloud_pace_sdk", "setAdditionalParameters", "params", "setAdditionalParameters$cloud_pace_sdk", "setup", "setup$cloud_pace_sdk", "userInfo", "accessToken", "Lcloud/pace/sdk/idkit/userinfo/UserInfoResponse;", "userInfo$cloud_pace_sdk", "cloud.pace.sdk"})
public final class AuthorizationManager
implements CloudSDKKoinComponent,
DefaultLifecycleObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final SharedPreferencesModel sharedPreferencesModel;
    private OIDConfiguration configuration;
    private AuthorizationRequest authorizationRequest;
    private AuthState session;

    public AuthorizationManager(@NotNull Context context, @NotNull AuthorizationService authorizationService, @NotNull SharedPreferencesModel sharedPreferencesModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)sharedPreferencesModel, (String)"sharedPreferencesModel");
        this.context = context;
        this.authorizationService = authorizationService;
        this.sharedPreferencesModel = sharedPreferencesModel;
    }

    /*
     * WARNING - void declaration
     */
    public final void setup$cloud_pace_sdk(@NotNull OIDConfiguration configuration) {
        void $this$setup_u24lambda_u2d0;
        OIDConfiguration oIDConfiguration;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
        OIDConfiguration oIDConfiguration2 = oIDConfiguration = configuration;
        AuthorizationManager authorizationManager = this;
        boolean bl = false;
        Map map = $this$setup_u24lambda_u2d0.getAdditionalParameters();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        $this$setup_u24lambda_u2d0.setAdditionalParameters(this.getMergedParameters(map));
        authorizationManager.configuration = oIDConfiguration;
        this.createAuthorizationRequest(true);
        AuthState authState = this.loadSession();
        if (authState != null) {
            AuthState it = authState;
            boolean bl2 = false;
            this.session = it;
        }
    }

    public final void setAdditionalParameters$cloud_pace_sdk(@Nullable Map<String, String> params) {
        if (this.configuration != null) {
            Map map;
            OIDConfiguration oIDConfiguration = this.configuration;
            if (oIDConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            }
            if ((map = params) == null) {
                map = MapsKt.emptyMap();
            }
            oIDConfiguration.setAdditionalParameters(this.getMergedParameters(map));
            this.createAuthorizationRequest(false);
        } else {
            SetupLogger.INSTANCE.logSDKWarningIfNeeded();
        }
    }

    @Nullable
    public final Map<String, String> getAdditionalParameters$cloud_pace_sdk() {
        Map<String, String> map;
        if (this.configuration != null) {
            OIDConfiguration oIDConfiguration = this.configuration;
            if (oIDConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            }
            map = oIDConfiguration.getAdditionalParameters();
        } else {
            SetupLogger.INSTANCE.logSDKWarningIfNeeded();
            map = null;
        }
        return map;
    }

    public final void discoverConfiguration$cloud_pace_sdk(@NotNull String issuerUri, @NotNull Function1<? super Completion<ServiceConfiguration>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)issuerUri, (String)"issuerUri");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        AuthorizationServiceConfiguration.fetchFromIssuer((Uri)Uri.parse((String)issuerUri), (arg_0, arg_1) -> AuthorizationManager.discoverConfiguration$lambda-2(completion, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object authorize$cloud_pace_sdk(@NotNull AppCompatActivity var1_1, @NotNull Function1<? super Completion<String>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof authorize.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.authorize$cloud_pace_sdk((AppCompatActivity)null, (Function1<? super Completion<String>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = completion;
                $continuation.label = 1;
                v0 = IntentResultResolverFragmentKt.getResultFor((Activity)activity, this.authorize$cloud_pace_sdk(), (Continuation<? super IntentResult>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                completion = (Function1)$continuation.L$1;
                this = (AuthorizationManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((result = (IntentResult)v0) instanceof Ok) {
                    v1 = ((Ok)result).getData();
                    if (v1 == null) {
                        v2 = null;
                    } else {
                        it = v1;
                        $i$a$-let-AuthorizationManager$authorize$2 = false;
                        this.handleAuthorizationResponse$cloud_pace_sdk(it, (Function1<? super Completion<String>, Unit>)completion);
                        v2 = Unit.INSTANCE;
                    }
                    if (v2 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object authorize$cloud_pace_sdk(@NotNull Fragment var1_1, @NotNull Function1<? super Completion<String>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof authorize.3)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.authorize$cloud_pace_sdk((Fragment)null, (Function1<? super Completion<String>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = completion;
                $continuation.label = 1;
                v0 = IntentResultResolverFragmentKt.getResultFor((Fragment)fragment, this.authorize$cloud_pace_sdk(), (Continuation<? super IntentResult>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                completion = (Function1)$continuation.L$1;
                this = (AuthorizationManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((result = (IntentResult)v0) instanceof Ok) {
                    v1 = ((Ok)result).getData();
                    if (v1 == null) {
                        v2 = null;
                    } else {
                        it = v1;
                        $i$a$-let-AuthorizationManager$authorize$4 = false;
                        this.handleAuthorizationResponse$cloud_pace_sdk(it, (Function1<? super Completion<String>, Unit>)completion);
                        v2 = Unit.INSTANCE;
                    }
                    if (v2 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void authorize$cloud_pace_sdk(@NotNull Class<?> completedActivity, @NotNull Class<?> canceledActivity) {
        Intrinsics.checkNotNullParameter(completedActivity, (String)"completedActivity");
        Intrinsics.checkNotNullParameter(canceledActivity, (String)"canceledActivity");
        int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
        OIDConfiguration oIDConfiguration = this.configuration;
        if (oIDConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        }
        if (oIDConfiguration.getIntegrated()) {
            AuthorizationRequest authorizationRequest = this.authorizationRequest;
            if (authorizationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
                authorizationRequest = null;
            }
            Intent intent = AuthorizationWebViewActivity.Companion.createStartIntent$cloud_pace_sdk(this.context, (AuthorizationManagementRequest)authorizationRequest, PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, completedActivity), (int)flags), PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, canceledActivity), (int)flags));
            intent.addFlags(0x10000000);
            this.context.startActivity(intent);
        } else {
            AuthorizationRequest authorizationRequest = this.authorizationRequest;
            if (authorizationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
                authorizationRequest = null;
            }
            this.authorizationService.performAuthorizationRequest(authorizationRequest, PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, completedActivity), (int)flags), PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, canceledActivity), (int)flags));
        }
    }

    @NotNull
    public final Intent authorize$cloud_pace_sdk() {
        Intent intent;
        OIDConfiguration oIDConfiguration = this.configuration;
        if (oIDConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        }
        if (oIDConfiguration.getIntegrated()) {
            AuthorizationRequest authorizationRequest = this.authorizationRequest;
            if (authorizationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
                authorizationRequest = null;
            }
            intent = AuthorizationWebViewActivity.Companion.createStartIntent$cloud_pace_sdk$default(AuthorizationWebViewActivity.Companion, this.context, (AuthorizationManagementRequest)authorizationRequest, null, null, 12, null);
        } else {
            AuthorizationRequest authorizationRequest = this.authorizationRequest;
            if (authorizationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
                authorizationRequest = null;
            }
            Intent intent2 = this.authorizationService.getAuthorizationRequestIntent(authorizationRequest);
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n            authorizat\u2026izationRequest)\n        }");
            intent = intent2;
        }
        return intent;
    }

    public final void handleAuthorizationResponse$cloud_pace_sdk(@NotNull Intent intent, @NotNull Function1<? super Completion<String>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        AuthorizationResponse response = AuthorizationResponse.fromIntent((Intent)intent);
        AuthorizationException exception = AuthorizationException.fromIntent((Intent)intent);
        if (exception != null) {
            AuthState authState = this.session;
            if (authState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            }
            authState.update(response, exception);
            Timber.Forest.e((Throwable)exception, "Failed to handle authorization response", new Object[0]);
            completion.invoke(new Failure((Throwable)exception));
        } else if (response != null) {
            AuthState authState = this.session;
            if (authState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            }
            authState.update(response, exception);
            TokenRequest tokenRequest = response.createTokenExchangeRequest();
            Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"response.createTokenExchangeRequest()");
            this.performTokenRequest(tokenRequest, completion);
        } else {
            FailedRetrievingSessionWhileAuthorizing throwable = FailedRetrievingSessionWhileAuthorizing.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to handle authorization response", new Object[0]);
            completion.invoke(new Failure(throwable));
        }
    }

    public final void refreshToken$cloud_pace_sdk(boolean force, @NotNull Function1<? super Completion<String>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.isAuthorizationValid$cloud_pace_sdk()) {
            AuthState authState;
            if (force) {
                AuthState authState2 = this.session;
                if (authState2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                    authState2 = null;
                }
                authState2.setNeedsTokenRefresh(true);
            }
            if ((authState = this.session) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            }
            TokenRequest tokenRequest = authState.createTokenRefreshRequest();
            Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"session.createTokenRefreshRequest()");
            this.performTokenRequest(tokenRequest, completion);
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public static /* synthetic */ void refreshToken$cloud_pace_sdk$default(AuthorizationManager authorizationManager, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        authorizationManager.refreshToken$cloud_pace_sdk(bl, (Function1<? super Completion<String>, Unit>)function1);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object endSession$cloud_pace_sdk(@NotNull AppCompatActivity var1_1, @NotNull Function1<? super Completion<Unit>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof endSession.1)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.endSession$cloud_pace_sdk((AppCompatActivity)null, (Function1<? super Completion<Unit>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.endSession$cloud_pace_sdk();
                if (v0 != null) ** GOTO lbl16
                v1 = null;
                ** GOTO lbl48
lbl16:
                // 1 sources

                intent = v0;
                $i$a$-let-AuthorizationManager$endSession$2 = false;
                $continuation.L$0 = completion;
                $continuation.label = 1;
                v2 = IntentResultResolverFragmentKt.getResultFor((Activity)activity, intent, (Continuation<? super IntentResult>)$continuation);
                if (v2 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$a$-let-AuthorizationManager$endSession$2 = false;
                completion = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl29:
                // 2 sources

                if ((result = (IntentResult)v2) instanceof Ok) {
                    v3 = ((Ok)result).getData();
                    if (v3 == null) {
                        v4 = null;
                    } else {
                        it = v3;
                        $i$a$-let-AuthorizationManager$endSession$2$1 = false;
                        IDKit.INSTANCE.handleEndSessionResponse(it, (Function1<? super Completion<Unit>, Unit>)completion);
                        v4 = Unit.INSTANCE;
                    }
                    if (v4 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                v1 = var4_13 = Unit.INSTANCE;
lbl48:
                // 2 sources

                if (var4_13 == null) {
                    completion.invoke(new Failure<T>(FailedRetrievingSessionWhileEnding.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object endSession$cloud_pace_sdk(@NotNull Fragment var1_1, @NotNull Function1<? super Completion<Unit>, Unit> var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof endSession.3)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AuthorizationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.endSession$cloud_pace_sdk((Fragment)null, (Function1<? super Completion<Unit>, Unit>)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.endSession$cloud_pace_sdk();
                if (v0 != null) ** GOTO lbl16
                v1 = null;
                ** GOTO lbl48
lbl16:
                // 1 sources

                intent = v0;
                $i$a$-let-AuthorizationManager$endSession$4 = false;
                $continuation.L$0 = completion;
                $continuation.label = 1;
                v2 = IntentResultResolverFragmentKt.getResultFor((Fragment)fragment, intent, (Continuation<? super IntentResult>)$continuation);
                if (v2 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$a$-let-AuthorizationManager$endSession$4 = false;
                completion = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl29:
                // 2 sources

                if ((result = (IntentResult)v2) instanceof Ok) {
                    v3 = ((Ok)result).getData();
                    if (v3 == null) {
                        v4 = null;
                    } else {
                        it = v3;
                        $i$a$-let-AuthorizationManager$endSession$4$1 = false;
                        IDKit.INSTANCE.handleEndSessionResponse(it, (Function1<? super Completion<Unit>, Unit>)completion);
                        v4 = Unit.INSTANCE;
                    }
                    if (v4 == null) {
                        completion.invoke(new Failure<T>(InternalError.INSTANCE));
                    }
                } else if (result instanceof Canceled) {
                    completion.invoke(new Failure<T>(OperationCanceled.INSTANCE));
                }
                v1 = var4_13 = Unit.INSTANCE;
lbl48:
                // 2 sources

                if (var4_13 == null) {
                    completion.invoke(new Failure<T>(FailedRetrievingSessionWhileEnding.INSTANCE));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean endSession$cloud_pace_sdk(@NotNull Class<?> completedActivity, @NotNull Class<?> canceledActivity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(completedActivity, (String)"completedActivity");
        Intrinsics.checkNotNullParameter(canceledActivity, (String)"canceledActivity");
        int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
        EndSessionRequest endSessionRequest = this.createEndSessionRequest();
        if (endSessionRequest == null) {
            bl = false;
        } else {
            boolean bl2;
            EndSessionRequest it = endSessionRequest;
            boolean bl3 = false;
            OIDConfiguration oIDConfiguration = this.configuration;
            if (oIDConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            }
            if (oIDConfiguration.getIntegrated()) {
                Intent intent = AuthorizationWebViewActivity.Companion.createStartIntent$cloud_pace_sdk(this.context, (AuthorizationManagementRequest)it, PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, completedActivity), (int)flags), PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, canceledActivity), (int)flags));
                intent.addFlags(0x10000000);
                this.context.startActivity(intent);
            } else {
                this.authorizationService.performEndSessionRequest(it, PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, completedActivity), (int)flags), PendingIntent.getActivity((Context)this.context, (int)0, (Intent)new Intent(this.context, canceledActivity), (int)flags));
            }
            bl = bl2 = true;
        }
        return bl;
    }

    @Nullable
    public final Intent endSession$cloud_pace_sdk() {
        Intent intent;
        EndSessionRequest endSessionRequest = this.createEndSessionRequest();
        if (endSessionRequest == null) {
            intent = null;
        } else {
            EndSessionRequest it = endSessionRequest;
            boolean bl = false;
            OIDConfiguration oIDConfiguration = this.configuration;
            if (oIDConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            }
            intent = oIDConfiguration.getIntegrated() ? AuthorizationWebViewActivity.Companion.createStartIntent$cloud_pace_sdk$default(AuthorizationWebViewActivity.Companion, this.context, (AuthorizationManagementRequest)it, null, null, 12, null) : this.authorizationService.getEndSessionRequestIntent(it);
        }
        return intent;
    }

    public final void handleEndSessionResponse$cloud_pace_sdk(@NotNull Intent intent, @NotNull Function1<? super Completion<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        EndSessionResponse response = EndSessionResponse.fromIntent((Intent)intent);
        AuthorizationException exception = AuthorizationException.fromIntent((Intent)intent);
        if (exception != null) {
            Timber.Forest.e((Throwable)exception, "Failed to handle end session response", new Object[0]);
            completion.invoke(new Failure((Throwable)exception));
        } else if (response != null) {
            AuthState authState;
            AuthorizationServiceConfiguration serviceConfiguration;
            IDKit.INSTANCE.disableBiometricAuthentication();
            API.INSTANCE.addAuthorizationHeader(null);
            AuthState authState2 = this.session;
            if (authState2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState2 = null;
            }
            if ((serviceConfiguration = authState2.getAuthorizationServiceConfiguration()) != null) {
                RegistrationResponse lastRegistrationResponse;
                AuthState clearedState = new AuthState(serviceConfiguration);
                AuthState authState3 = this.session;
                if (authState3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                    authState3 = null;
                }
                if ((lastRegistrationResponse = authState3.getLastRegistrationResponse()) != null) {
                    clearedState.update(lastRegistrationResponse);
                }
                this.session = clearedState;
            }
            if ((authState = this.session) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            }
            this.persistSession(authState);
            completion.invoke(new Success<Unit>(Unit.INSTANCE));
        } else {
            FailedRetrievingSessionWhileEnding throwable = FailedRetrievingSessionWhileEnding.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to handle end session response", new Object[0]);
            completion.invoke(new Failure(throwable));
        }
    }

    public final boolean isAuthorizationValid$cloud_pace_sdk() {
        AuthState authState = this.session;
        if (authState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState = null;
        }
        return authState.isAuthorized();
    }

    public final boolean containsAuthorizationResponse$cloud_pace_sdk(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.hasExtra("net.openid.appauth.AuthorizationResponse");
    }

    public final boolean containsEndSessionResponse$cloud_pace_sdk(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.hasExtra("net.openid.appauth.EndSessionResponse");
    }

    public final boolean containsException$cloud_pace_sdk(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return intent.hasExtra("net.openid.appauth.AuthorizationException");
    }

    @Nullable
    public final String cachedToken$cloud_pace_sdk() {
        String string2;
        if (this.session != null) {
            AuthState authState = this.session;
            if (authState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState = null;
            }
            string2 = authState.getAccessToken();
        } else {
            string2 = null;
        }
        return string2;
    }

    public final void userInfo$cloud_pace_sdk(@NotNull String accessToken, @NotNull Function1<? super Completion<UserInfoResponse>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        OIDConfiguration oIDConfiguration = this.configuration;
        if (oIDConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        }
        String it = oIDConfiguration.getUserInfoEndpoint();
        boolean bl = false;
        if (it != null) {
            new UserInfoApiClient(it, accessToken, null, null, 12, null).getUserInfo(completion);
        } else {
            UserEndpointNotDefined throwable = UserEndpointNotDefined.INSTANCE;
            Timber.Forest.e((Throwable)throwable);
            completion.invoke(new Failure(throwable));
        }
    }

    private final Map<String, String> getMergedParameters(Map<String, String> idKitParams) {
        return MapsKt.plus(idKitParams, PACECloudSDK.INSTANCE.getAdditionalQueryParams());
    }

    private final void createAuthorizationRequest(boolean createNewSession) {
        OIDConfiguration oIDConfiguration;
        AuthorizationServiceConfiguration serviceConfiguration = this.getAuthorizationServiceConfiguration();
        if (createNewSession) {
            this.session = new AuthState(serviceConfiguration);
        }
        if ((oIDConfiguration = this.configuration) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        }
        String string2 = oIDConfiguration.getClientId();
        OIDConfiguration oIDConfiguration2 = this.configuration;
        if (oIDConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration2 = null;
        }
        String string3 = oIDConfiguration2.getResponseType();
        OIDConfiguration oIDConfiguration3 = this.configuration;
        if (oIDConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration3 = null;
        }
        AuthorizationRequest.Builder builder = new AuthorizationRequest.Builder(serviceConfiguration, string2, string3, Uri.parse((String)oIDConfiguration3.getRedirectUri()));
        OIDConfiguration oIDConfiguration4 = this.configuration;
        if (oIDConfiguration4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration4 = null;
        }
        List<String> list = oIDConfiguration4.getScopes();
        List list2 = list == null ? null : CollectionsKt.plus((Collection)list, (Object)"openid");
        if (list2 == null) {
            list2 = CollectionsKt.listOf((Object)"openid");
        }
        AuthorizationRequest.Builder builder2 = builder.setScopes((Iterable)list2);
        OIDConfiguration oIDConfiguration5 = this.configuration;
        if (oIDConfiguration5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration5 = null;
        }
        AuthorizationRequest authorizationRequest = builder2.setAdditionalParameters(oIDConfiguration5.getAdditionalParameters()).build();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationRequest, (String)"Builder(serviceConfigura\u2026ers)\n            .build()");
        this.authorizationRequest = authorizationRequest;
    }

    private final EndSessionRequest createEndSessionRequest() {
        EndSessionRequest endSessionRequest;
        AuthState authState = this.session;
        if (authState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState = null;
        }
        String string2 = authState.getIdToken();
        if (string2 == null) {
            endSessionRequest = null;
        } else {
            String it = string2;
            boolean bl = false;
            EndSessionRequest.Builder builder = new EndSessionRequest.Builder(this.getAuthorizationServiceConfiguration()).setIdTokenHint(it);
            OIDConfiguration oIDConfiguration = this.configuration;
            if (oIDConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
                oIDConfiguration = null;
            }
            endSessionRequest = builder.setPostLogoutRedirectUri(Uri.parse((String)oIDConfiguration.getRedirectUri())).build();
        }
        return endSessionRequest;
    }

    private final AuthorizationServiceConfiguration getAuthorizationServiceConfiguration() {
        OIDConfiguration oIDConfiguration = this.configuration;
        if (oIDConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        }
        Uri uri = Uri.parse((String)oIDConfiguration.getAuthorizationEndpoint());
        OIDConfiguration oIDConfiguration2 = this.configuration;
        if (oIDConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration2 = null;
        }
        Uri uri2 = Uri.parse((String)oIDConfiguration2.getTokenEndpoint());
        OIDConfiguration oIDConfiguration3 = this.configuration;
        if (oIDConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration3 = null;
        }
        return new AuthorizationServiceConfiguration(uri, uri2, null, Uri.parse((String)oIDConfiguration3.getEndSessionEndpoint()));
    }

    private final void performTokenRequest(TokenRequest request, Function1<? super Completion<String>, Unit> completion) {
        ClientAuthentication clientAuthentication;
        String clientSecret;
        Timber.Forest.i("Trying to refresh token...", new Object[0]);
        OIDConfiguration oIDConfiguration = this.configuration;
        if (oIDConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            oIDConfiguration = null;
        }
        if ((clientSecret = oIDConfiguration.getClientSecret()) != null) {
            clientAuthentication = (ClientAuthentication)new ClientSecretBasic(clientSecret);
        } else {
            ClientAuthentication clientAuthentication2;
            try {
                AuthState authState = this.session;
                if (authState == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                    authState = null;
                }
                clientAuthentication2 = authState.getClientAuthentication();
            }
            catch (ClientAuthentication.UnsupportedAuthenticationMethod e) {
                Timber.Forest.e((Throwable)e, "Token request cannot be made, client authentication for the token endpoint could not be constructed", new Object[0]);
                completion.invoke(new Failure(e));
                return;
            }
            ClientAuthentication clientAuthentication3 = clientAuthentication2;
            Intrinsics.checkNotNullExpressionValue((Object)clientAuthentication3, (String)"{\n            try {\n    \u2026n\n            }\n        }");
            clientAuthentication = clientAuthentication3;
        }
        ClientAuthentication clientAuthentication4 = clientAuthentication;
        this.authorizationService.performTokenRequest(request, clientAuthentication4, (arg_0, arg_1) -> AuthorizationManager.performTokenRequest$lambda-13(this, completion, arg_0, arg_1));
    }

    private final void handleTokenResponse(TokenResponse tokenResponse, AuthorizationException exception, Function1<? super Completion<String>, Unit> completion) {
        AuthState authState = this.session;
        if (authState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState = null;
        }
        authState.update(tokenResponse, exception);
        AuthState authState2 = this.session;
        if (authState2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            authState2 = null;
        }
        this.persistSession(authState2);
        if (exception != null) {
            Timber.Forest.e((Throwable)exception, "Failed to handle token response", new Object[0]);
            completion.invoke(new Failure((Throwable)exception));
        } else if (tokenResponse != null) {
            AuthState authState3;
            AuthState authState4 = this.session;
            if (authState4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState4 = null;
            }
            String string2 = authState4.getAccessToken();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                API.INSTANCE.addAuthorizationHeader(it);
            }
            if ((authState3 = this.session) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
                authState3 = null;
            }
            completion.invoke(new Success<String>(authState3.getAccessToken()));
            Timber.Forest.i("Token refresh successful", new Object[0]);
        } else {
            FailedRetrievingSessionWhileAuthorizing throwable = FailedRetrievingSessionWhileAuthorizing.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to handle token response", new Object[0]);
            completion.invoke(new Failure(throwable));
        }
    }

    private final void persistSession(AuthState authState) {
        Timber.Forest.i("Persisting session to SharedPreferences", new Object[0]);
        String string2 = authState.jsonSerializeString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authState.jsonSerializeString()");
        this.sharedPreferencesModel.putString("sessionCache", string2);
    }

    private final AuthState loadSession() {
        Object object;
        Timber.Forest.i("Loading session from SharedPreferences", new Object[0]);
        String jsonString = SharedPreferencesModel.DefaultImpls.getString$default(this.sharedPreferencesModel, "sessionCache", null, 2, null);
        CharSequence charSequence = jsonString;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                charSequence = AuthState.jsonDeserialize((String)jsonString);
            }
            catch (JSONException jsonException) {
                Timber.Forest.e((Throwable)jsonException, "Failed retrieving session from SharedPreferences", new Object[0]);
                charSequence = null;
            }
            object = charSequence;
        } else {
            object = null;
        }
        return object;
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.authorizationService.dispose();
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return CloudSDKKoinComponent.DefaultImpls.getKoin(this);
    }

    private static final void discoverConfiguration$lambda-2(Function1 $completion, AuthorizationServiceConfiguration configuration, AuthorizationException exception) {
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        if (exception != null) {
            Timber.Forest.e((Throwable)exception, "Failed to discover configuration", new Object[0]);
            $completion.invoke(new Failure((Throwable)exception));
        } else if (configuration != null) {
            Timber.Forest.i("Configuration discovery successful", new Object[0]);
            Uri uri = configuration.authorizationEndpoint;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"configuration.authorizationEndpoint");
            Uri uri2 = uri;
            uri = configuration.tokenEndpoint;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"configuration.tokenEndpoint");
            $completion.invoke(new Success<ServiceConfiguration>(new ServiceConfiguration(uri2, uri, configuration.endSessionEndpoint, configuration.registrationEndpoint)));
        } else {
            FailedRetrievingConfigurationWhileDiscovering throwable = FailedRetrievingConfigurationWhileDiscovering.INSTANCE;
            Timber.Forest.e((Throwable)throwable, "Failed to discover configuration", new Object[0]);
            $completion.invoke(new Failure(throwable));
        }
    }

    private static final void performTokenRequest$lambda-13(AuthorizationManager this$0, Function1 $completion, TokenResponse tokenResponse, AuthorizationException exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        this$0.handleTokenResponse(tokenResponse, exception, (Function1<? super Completion<String>, Unit>)$completion);
    }
}

