/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.idkit.authorization.integrated;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.appcompat.app.AppCompatActivity;
import cloud.pace.sdk.appkit.AppKit;
import cloud.pace.sdk.idkit.authorization.integrated.AuthorizationWebViewActivity;
import cloud.pace.sdk.utils.CloudSDKKoinComponent;
import cloud.pace.sdk.utils.DeviceUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationManagementResponse;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.EndSessionRequest;
import net.openid.appauth.EndSessionResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.koin.core.Koin;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0012H\u0014J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u0010H\u0002J\"\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcloud/pace/sdk/idkit/authorization/integrated/AuthorizationWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcloud/pace/sdk/utils/CloudSDKKoinComponent;", "()V", "appAuthRedirectScheme", "", "authRequest", "Lnet/openid/appauth/AuthorizationManagementRequest;", "cancelIntent", "Landroid/app/PendingIntent;", "completeIntent", "webView", "Landroid/webkit/WebView;", "extractResponseData", "Landroid/content/Intent;", "responseUri", "Landroid/net/Uri;", "initWebView", "", "intercept", "", "newUri", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "requestFrom", "jsonString", "type", "responseWith", "Lnet/openid/appauth/AuthorizationManagementResponse;", "request", "uri", "sendResultAndFinish", "callback", "cancelData", "resultCode", "", "Companion", "cloud.pace.sdk"})
public final class AuthorizationWebViewActivity
extends AppCompatActivity
implements CloudSDKKoinComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private WebView webView;
    private AuthorizationManagementRequest authRequest;
    @Nullable
    private PendingIntent completeIntent;
    @Nullable
    private PendingIntent cancelIntent;
    @Nullable
    private String appAuthRedirectScheme;
    @NotNull
    private static final String KEY_AUTH_REQUEST = "authRequest";
    @NotNull
    private static final String KEY_AUTH_REQUEST_TYPE = "authRequestType";
    @NotNull
    private static final String KEY_COMPLETE_INTENT = "completeIntent";
    @NotNull
    private static final String KEY_CANCEL_INTENT = "cancelIntent";
    @NotNull
    private static final String KEY_STATE = "state";
    @NotNull
    private static final String REQUEST_TYPE_AUTHORIZATION = "authorization";
    @NotNull
    private static final String REQUEST_TYPE_END_SESSION = "end_session";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        block6: {
            Bundle state;
            super.onCreate(savedInstanceState);
            Bundle bundle = savedInstanceState;
            if (bundle == null) {
                bundle = this.getIntent().getExtras();
            }
            if ((state = bundle) != null) {
                this.completeIntent = (PendingIntent)state.getParcelable(KEY_COMPLETE_INTENT);
                this.cancelIntent = (PendingIntent)state.getParcelable(KEY_CANCEL_INTENT);
                try {
                    String authRequestJson = state.getString(KEY_AUTH_REQUEST);
                    String authRequestType = state.getString(KEY_AUTH_REQUEST_TYPE);
                    AuthorizationManagementRequest request = this.requestFrom(authRequestJson, authRequestType);
                    if (request != null) {
                        this.authRequest = request;
                        this.appAuthRedirectScheme = DeviceUtils.INSTANCE.getAppAuthRedirectScheme((Context)this);
                        this.initWebView();
                        break block6;
                    }
                    Timber.Forest.e("No AuthorizationManagementRequest found matching the request json " + authRequestJson + " and type " + authRequestType, new Object[0]);
                    Intent intent = AuthorizationException.AuthorizationRequestErrors.INVALID_REQUEST.toIntent();
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"INVALID_REQUEST.toIntent()");
                    this.sendResultAndFinish(this.cancelIntent, intent, 0);
                }
                catch (JSONException e) {
                    Timber.Forest.e((Throwable)e, "Could not parse string as json object", new Object[0]);
                    Intent intent = AuthorizationException.AuthorizationRequestErrors.INVALID_REQUEST.toIntent();
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"INVALID_REQUEST.toIntent()");
                    this.sendResultAndFinish(this.cancelIntent, intent, 0);
                }
            } else {
                Timber.Forest.w("No stored state - unable to handle response", new Object[0]);
                Intent intent = AuthorizationException.AuthorizationRequestErrors.INVALID_REQUEST.toIntent();
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"INVALID_REQUEST.toIntent()");
                this.sendResultAndFinish(this.cancelIntent, intent, 0);
            }
        }
    }

    private final AuthorizationManagementRequest requestFrom(String jsonString, String type) {
        if (jsonString == null || type == null) {
            return null;
        }
        JSONObject json = new JSONObject(jsonString);
        String string2 = type;
        return Intrinsics.areEqual((Object)string2, (Object)REQUEST_TYPE_AUTHORIZATION) ? (AuthorizationManagementRequest)AuthorizationRequest.jsonDeserialize((JSONObject)json) : (Intrinsics.areEqual((Object)string2, (Object)REQUEST_TYPE_END_SESSION) ? (AuthorizationManagementRequest)EndSessionRequest.jsonDeserialize((JSONObject)json) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final void initWebView() {
        void $this$initWebView_u24lambda_u2d1;
        WebSettings webSettings;
        WebView webView;
        WebView webView2 = webView = new WebView((Context)this);
        AuthorizationWebViewActivity authorizationWebViewActivity = this;
        boolean bl = false;
        WebSettings $this$initWebView_u24lambda_u2d1_u24lambda_u2d0 = webSettings = $this$initWebView_u24lambda_u2d1.getSettings();
        boolean bl2 = false;
        $this$initWebView_u24lambda_u2d1_u24lambda_u2d0.setJavaScriptEnabled(true);
        $this$initWebView_u24lambda_u2d1_u24lambda_u2d0.setDomStorageEnabled(true);
        $this$initWebView_u24lambda_u2d1_u24lambda_u2d0.setUserAgentString(AppKit.INSTANCE.getUserAgent$cloud_pace_sdk());
        $this$initWebView_u24lambda_u2d1.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ AuthorizationWebViewActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
                WebResourceRequest webResourceRequest = request;
                return AuthorizationWebViewActivity.access$intercept(this.this$0, (Uri)(webResourceRequest == null ? null : webResourceRequest.getUrl()));
            }

            public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable String url) {
                Uri uri;
                AuthorizationWebViewActivity authorizationWebViewActivity = this.this$0;
                String string2 = url;
                if (string2 == null) {
                    uri = null;
                } else {
                    String string3 = string2;
                    AuthorizationWebViewActivity authorizationWebViewActivity2 = authorizationWebViewActivity;
                    boolean bl = false;
                    uri = Uri.parse((String)url);
                    authorizationWebViewActivity = authorizationWebViewActivity2;
                }
                return AuthorizationWebViewActivity.access$intercept(authorizationWebViewActivity, uri);
            }
        });
        $this$initWebView_u24lambda_u2d1.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(@Nullable ConsoleMessage consoleMessage) {
                int n;
                if (consoleMessage == null) {
                    return super.onConsoleMessage(consoleMessage);
                }
                ConsoleMessage.MessageLevel messageLevel = consoleMessage.messageLevel();
                switch (messageLevel == null ? -1 : initWebView.1.WhenMappings.$EnumSwitchMapping$0[messageLevel.ordinal()]) {
                    case 1: {
                        n = 4;
                        break;
                    }
                    case 2: {
                        n = 5;
                        break;
                    }
                    case 3: {
                        n = 6;
                        break;
                    }
                    case 4: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 2;
                    }
                }
                int logLevel = n;
                Timber.Forest.log(logLevel, consoleMessage.message(), new Object[0]);
                return true;
            }
        });
        AuthorizationManagementRequest authorizationManagementRequest = this.authRequest;
        if (authorizationManagementRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)KEY_AUTH_REQUEST);
            authorizationManagementRequest = null;
        }
        $this$initWebView_u24lambda_u2d1.loadUrl(authorizationManagementRequest.toUri().toString());
        authorizationWebViewActivity.webView = webView;
        CookieManager cookieManager = CookieManager.getInstance();
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView3 = null;
        }
        cookieManager.setAcceptThirdPartyCookies(webView3, true);
        WebView.setWebContentsDebuggingEnabled((boolean)true);
        WebView webView4 = this.webView;
        if (webView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView4 = null;
        }
        this.setContentView((View)webView4);
    }

    private final boolean intercept(Uri newUri) {
        boolean bl;
        if (newUri != null && Intrinsics.areEqual((Object)newUri.getScheme(), (Object)this.appAuthRedirectScheme)) {
            Intent responseData = this.extractResponseData(newUri);
            if (responseData != null) {
                responseData.setData(newUri);
                this.sendResultAndFinish(this.completeIntent, responseData, -1);
            } else {
                Timber.Forest.e("Failed to extract OAuth2 response from redirect URI: " + newUri, new Object[0]);
                Intent intent = AuthorizationException.AuthorizationRequestErrors.INVALID_REQUEST.toIntent();
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"INVALID_REQUEST.toIntent()");
                this.sendResultAndFinish(this.cancelIntent, intent, 0);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void sendResultAndFinish(PendingIntent callback2, Intent cancelData, int resultCode) {
        if (callback2 != null) {
            try {
                callback2.send((Context)this, 0, cancelData);
            }
            catch (PendingIntent.CanceledException e) {
                Timber.Forest.e((Throwable)e, "Failed to send cancel intent", new Object[0]);
            }
        } else {
            this.setResult(resultCode, cancelData);
        }
        this.finish();
    }

    private final Intent extractResponseData(Uri responseUri) {
        Object object;
        if (responseUri.getQueryParameterNames().contains("error")) {
            object = AuthorizationException.fromOAuthRedirect((Uri)responseUri).toIntent();
        } else {
            AuthorizationManagementRequest authorizationManagementRequest = this.authRequest;
            if (authorizationManagementRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)KEY_AUTH_REQUEST);
                authorizationManagementRequest = null;
            }
            AuthorizationManagementResponse response = this.responseWith(authorizationManagementRequest, responseUri);
            AuthorizationManagementRequest authorizationManagementRequest2 = this.authRequest;
            if (authorizationManagementRequest2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)KEY_AUTH_REQUEST);
                authorizationManagementRequest2 = null;
            }
            AuthorizationManagementResponse authorizationManagementResponse = response;
            if (!Intrinsics.areEqual((Object)authorizationManagementRequest2.getState(), (Object)(authorizationManagementResponse == null ? null : authorizationManagementResponse.getState()))) {
                AuthorizationManagementResponse authorizationManagementResponse2 = response;
                String string2 = authorizationManagementResponse2 == null ? null : authorizationManagementResponse2.getState();
                AuthorizationManagementRequest authorizationManagementRequest3 = this.authRequest;
                if (authorizationManagementRequest3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)KEY_AUTH_REQUEST);
                    authorizationManagementRequest3 = null;
                }
                Timber.Forest.w("State mismatch: State returned in authorization response (" + string2 + ") does not match state from request (" + authorizationManagementRequest3.getState() + ") - discarding response", new Object[0]);
                object = AuthorizationException.AuthorizationRequestErrors.STATE_MISMATCH.toIntent();
            } else {
                AuthorizationManagementResponse authorizationManagementResponse3 = response;
                object = authorizationManagementResponse3 == null ? null : authorizationManagementResponse3.toIntent();
            }
        }
        return object;
    }

    private final AuthorizationManagementResponse responseWith(AuthorizationManagementRequest request, Uri uri) {
        AuthorizationManagementRequest authorizationManagementRequest = request;
        return authorizationManagementRequest instanceof AuthorizationRequest ? (AuthorizationManagementResponse)new AuthorizationResponse.Builder((AuthorizationRequest)request).fromUri(uri).build() : (authorizationManagementRequest instanceof EndSessionRequest ? (AuthorizationManagementResponse)new EndSessionResponse.Builder((EndSessionRequest)request).setState(uri.getQueryParameter(KEY_STATE)).build() : null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onBackPressed() {
        if (this.webView != null) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            if (webView.canGoBack()) {
                WebView webView2 = this.webView;
                if (webView2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                    webView2 = null;
                }
                webView2.goBack();
                return;
            }
        }
        this.finish();
    }

    protected void onDestroy() {
        if (this.webView != null) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            webView.destroy();
        }
        super.onDestroy();
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return CloudSDKKoinComponent.DefaultImpls.getKoin(this);
    }

    public static final /* synthetic */ boolean access$intercept(AuthorizationWebViewActivity $this, Uri newUri) {
        return $this.intercept(newUri);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0014J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcloud/pace/sdk/idkit/authorization/integrated/AuthorizationWebViewActivity$Companion;", "", "()V", "KEY_AUTH_REQUEST", "", "KEY_AUTH_REQUEST_TYPE", "KEY_CANCEL_INTENT", "KEY_COMPLETE_INTENT", "KEY_STATE", "REQUEST_TYPE_AUTHORIZATION", "REQUEST_TYPE_END_SESSION", "createStartIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "request", "Lnet/openid/appauth/AuthorizationManagementRequest;", "completeIntent", "Landroid/app/PendingIntent;", "cancelIntent", "createStartIntent$cloud_pace_sdk", "requestTypeFor", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent createStartIntent$cloud_pace_sdk(@NotNull Context context, @NotNull AuthorizationManagementRequest request, @Nullable PendingIntent completeIntent, @Nullable PendingIntent cancelIntent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intent intent = new Intent(context, AuthorizationWebViewActivity.class);
            intent.putExtra(AuthorizationWebViewActivity.KEY_AUTH_REQUEST, request.jsonSerializeString());
            intent.putExtra(AuthorizationWebViewActivity.KEY_AUTH_REQUEST_TYPE, this.requestTypeFor(request));
            intent.putExtra(AuthorizationWebViewActivity.KEY_COMPLETE_INTENT, (Parcelable)completeIntent);
            intent.putExtra(AuthorizationWebViewActivity.KEY_CANCEL_INTENT, (Parcelable)cancelIntent);
            return intent;
        }

        public static /* synthetic */ Intent createStartIntent$cloud_pace_sdk$default(Companion companion, Context context, AuthorizationManagementRequest authorizationManagementRequest, PendingIntent pendingIntent, PendingIntent pendingIntent2, int n, Object object) {
            if ((n & 4) != 0) {
                pendingIntent = null;
            }
            if ((n & 8) != 0) {
                pendingIntent2 = null;
            }
            return companion.createStartIntent$cloud_pace_sdk(context, authorizationManagementRequest, pendingIntent, pendingIntent2);
        }

        private final String requestTypeFor(AuthorizationManagementRequest request) {
            AuthorizationManagementRequest authorizationManagementRequest = request;
            return authorizationManagementRequest instanceof AuthorizationRequest ? AuthorizationWebViewActivity.REQUEST_TYPE_AUTHORIZATION : (authorizationManagementRequest instanceof EndSessionRequest ? AuthorizationWebViewActivity.REQUEST_TYPE_END_SESSION : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

