/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.idkit.credentials;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import cloud.pace.sdk.api.API;
import cloud.pace.sdk.api.user.UserAPI;
import cloud.pace.sdk.api.user.generated.model.CreateOTP;
import cloud.pace.sdk.api.user.generated.model.DeviceTOTP;
import cloud.pace.sdk.api.user.generated.model.DeviceTOTPBody;
import cloud.pace.sdk.api.user.generated.model.PinOrPassword;
import cloud.pace.sdk.api.user.generated.model.UserPINBody;
import cloud.pace.sdk.api.user.generated.request.credentials.CheckUserPINAPI;
import cloud.pace.sdk.api.user.generated.request.credentials.CheckUserPasswordAPI;
import cloud.pace.sdk.api.user.generated.request.credentials.CheckUserPinOrPasswordAPI;
import cloud.pace.sdk.api.user.generated.request.credentials.UpdateUserPINAPI;
import cloud.pace.sdk.api.user.generated.request.totp.CreateOTPAPI;
import cloud.pace.sdk.api.user.generated.request.totp.CreateTOTPAPI;
import cloud.pace.sdk.api.user.generated.request.totp.SendmailOTPAPI;
import cloud.pace.sdk.appkit.pay.PayAuthenticationManager;
import cloud.pace.sdk.appkit.persistence.SharedPreferencesModel;
import cloud.pace.sdk.appkit.persistence.TotpSecret;
import cloud.pace.sdk.appkit.utils.BiometricUtils;
import cloud.pace.sdk.appkit.utils.EncryptionUtils;
import cloud.pace.sdk.idkit.authorization.AuthorizationManager;
import cloud.pace.sdk.idkit.credentials.CredentialsManager;
import cloud.pace.sdk.idkit.model.BiometricAuthenticationNotSet;
import cloud.pace.sdk.idkit.model.BiometricAuthenticationNotSupported;
import cloud.pace.sdk.idkit.model.InternalError;
import cloud.pace.sdk.idkit.model.InvalidSession;
import cloud.pace.sdk.idkit.model.PINNotSecure;
import cloud.pace.sdk.poikit.utils.ApiException;
import cloud.pace.sdk.utils.CallBackKt;
import cloud.pace.sdk.utils.CallbackUtilsKt;
import cloud.pace.sdk.utils.CloudSDKKoinComponent;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.Failure;
import cloud.pace.sdk.utils.Success;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import retrofit2.Call;
import retrofit2.Response;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJM\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u001a\b\u0002\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b\u0015J,\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\r\u0010\u001a\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001bJ'\u0010\u001c\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b\u001eJ'\u0010\u001f\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\"J'\u0010#\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b$J'\u0010%\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0014H\u0002J[\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b/J[\u0010(\u001a\u00020\n2\u0006\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b/J7\u00102\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b3J7\u00104\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0000\u00a2\u0006\u0002\b5J2\u00106\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0002J2\u00109\u001a\u00020\n\"\u0004\b\u0000\u0010:*\b\u0012\u0004\u0012\u0002H:0;2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcloud/pace/sdk/idkit/credentials/CredentialsManager;", "Lcloud/pace/sdk/utils/CloudSDKKoinComponent;", "sharedPreferencesModel", "Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;", "payAuthenticationManager", "Lcloud/pace/sdk/appkit/pay/PayAuthenticationManager;", "authorizationManager", "Lcloud/pace/sdk/idkit/authorization/AuthorizationManager;", "(Lcloud/pace/sdk/appkit/persistence/SharedPreferencesModel;Lcloud/pace/sdk/appkit/pay/PayAuthenticationManager;Lcloud/pace/sdk/idkit/authorization/AuthorizationManager;)V", "disableBiometricAuthentication", "", "disableBiometricAuthentication$cloud_pace_sdk", "enableBiometricAuthentication", "pin", "", "password", "otp", "completion", "Lkotlin/Function1;", "Lcloud/pace/sdk/utils/Completion;", "", "enableBiometricAuthentication$cloud_pace_sdk", "getDeviceTOTPBody", "Lcloud/pace/sdk/api/user/generated/model/DeviceTOTPBody;", "getUserPINBody", "Lcloud/pace/sdk/api/user/generated/model/UserPINBody;", "isBiometricAuthenticationEnabled", "isBiometricAuthenticationEnabled$cloud_pace_sdk", "isPINOrPasswordSet", "Lcloud/pace/sdk/api/user/generated/model/PinOrPassword;", "isPINOrPasswordSet$cloud_pace_sdk", "isPINSet", "isPINSet$cloud_pace_sdk", "isPINValid", "isPINValid$cloud_pace_sdk", "isPasswordSet", "isPasswordSet$cloud_pace_sdk", "sendMailOTP", "sendMailOTP$cloud_pace_sdk", "setAuthorizationHeader", "setPINWithBiometry", "fragment", "Landroidx/fragment/app/Fragment;", "title", "subTitle", "cancelText", "isDeviceCredentialsAllowed", "setPINWithBiometry$cloud_pace_sdk", "activity", "Landroidx/fragment/app/FragmentActivity;", "setPINWithOTP", "setPINWithOTP$cloud_pace_sdk", "setPINWithPassword", "setPINWithPassword$cloud_pace_sdk", "updateUserPIN", "totpSecret", "Lcloud/pace/sdk/appkit/persistence/TotpSecret;", "makeBooleanRequest", "T", "Lretrofit2/Call;", "cloud.pace.sdk"})
public final class CredentialsManager
implements CloudSDKKoinComponent {
    @NotNull
    private final SharedPreferencesModel sharedPreferencesModel;
    @NotNull
    private final PayAuthenticationManager payAuthenticationManager;
    @NotNull
    private final AuthorizationManager authorizationManager;

    public CredentialsManager(@NotNull SharedPreferencesModel sharedPreferencesModel, @NotNull PayAuthenticationManager payAuthenticationManager, @NotNull AuthorizationManager authorizationManager) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferencesModel, (String)"sharedPreferencesModel");
        Intrinsics.checkNotNullParameter((Object)payAuthenticationManager, (String)"payAuthenticationManager");
        Intrinsics.checkNotNullParameter((Object)authorizationManager, (String)"authorizationManager");
        this.sharedPreferencesModel = sharedPreferencesModel;
        this.payAuthenticationManager = payAuthenticationManager;
        this.authorizationManager = authorizationManager;
    }

    public final boolean isBiometricAuthenticationEnabled$cloud_pace_sdk() {
        return this.authorizationManager.cachedToken$cloud_pace_sdk() != null && SharedPreferencesModel.DefaultImpls.getTotpSecret$default(this.sharedPreferencesModel, null, null, 3, null) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableBiometricAuthentication$cloud_pace_sdk(@Nullable String pin, @Nullable String password, @Nullable String otp, @NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            void $this$enableBiometricAuthentication_u24lambda_u2d0;
            CreateTOTPAPI.Body body;
            CreateTOTPAPI.Body body2 = body = new CreateTOTPAPI.Body();
            UserAPI.TOTPAPI tOTPAPI = UserAPI.INSTANCE.getTotp(API.INSTANCE);
            CreateTOTPAPI createTOTPAPI = CreateTOTPAPI.INSTANCE;
            boolean bl = false;
            $this$enableBiometricAuthentication_u24lambda_u2d0.setData(this.getDeviceTOTPBody(pin, password, otp));
            Unit unit = Unit.INSTANCE;
            CallbackUtilsKt.enqueue(CreateTOTPAPI.createTOTP$default(createTOTPAPI, tOTPAPI, body, null, null, null, 14, null), (Function1)new Function1<CallBackKt<DeviceTOTP>, Unit>(this, completion){
                final /* synthetic */ CredentialsManager this$0;
                final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                {
                    this.this$0 = $receiver;
                    this.$completion = $completion;
                    super(1);
                }

                public final void invoke(@NotNull CallBackKt<DeviceTOTP> $this$enqueue) {
                    Intrinsics.checkNotNullParameter($this$enqueue, (String)"$this$enqueue");
                    $this$enqueue.setOnResponse((Function1<Response<DeviceTOTP>, Unit>)((Function1)new Function1<Response<DeviceTOTP>, Unit>(this.this$0, this.$completion){
                        final /* synthetic */ CredentialsManager this$0;
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.this$0 = $receiver;
                            this.$completion = $completion;
                            super(1);
                        }

                        public final void invoke(@NotNull Response<DeviceTOTP> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            DeviceTOTP body = (DeviceTOTP)((Object)it.body());
                            if (it.isSuccessful() && body != null) {
                                String secret = body.getSecret();
                                Integer digits = body.getDigits();
                                Integer period = body.getPeriod();
                                DeviceTOTP.Algorithm algorithm = body.getAlgorithm();
                                if (secret != null && digits != null && period != null && algorithm != null) {
                                    try {
                                        SharedPreferencesModel.DefaultImpls.setTotpSecret$default(CredentialsManager.access$getSharedPreferencesModel$p(this.this$0), null, null, new TotpSecret(EncryptionUtils.INSTANCE.encrypt(secret), digits, period, algorithm.getValue()), 3, null);
                                        this.$completion.invoke(new Success<Boolean>(true));
                                    }
                                    catch (Exception e) {
                                        this.$completion.invoke(new Failure<T>(e));
                                    }
                                } else {
                                    this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                                }
                            } else if (it.code() >= 500) {
                                this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                            } else if (it.code() == 401) {
                                this.$completion.invoke(new Failure<T>(InvalidSession.INSTANCE));
                            } else {
                                this.$completion.invoke(new Success<Boolean>(false));
                            }
                        }
                    }));
                    $this$enqueue.setOnFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$completion){
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(1);
                        }

                        public final void invoke(@Nullable Throwable it) {
                            Throwable throwable = it;
                            if (throwable == null) {
                                throwable = InternalError.INSTANCE;
                            }
                            this.$completion.invoke(new Failure<T>(throwable));
                        }
                    }));
                }
            });
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public static /* synthetic */ void enableBiometricAuthentication$cloud_pace_sdk$default(CredentialsManager credentialsManager, String string2, String string3, String string4, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            string4 = null;
        }
        if ((n & 8) != 0) {
            function1 = enableBiometricAuthentication.1.INSTANCE;
        }
        credentialsManager.enableBiometricAuthentication$cloud_pace_sdk(string2, string3, string4, (Function1<? super Completion<Boolean>, Unit>)function1);
    }

    public final void disableBiometricAuthentication$cloud_pace_sdk() {
        SharedPreferencesModel.DefaultImpls.removeTotpSecret$default(this.sharedPreferencesModel, null, null, 3, null);
    }

    public final void isPINSet$cloud_pace_sdk(@NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            this.makeBooleanRequest(CheckUserPINAPI.checkUserPIN$default(CheckUserPINAPI.INSTANCE, UserAPI.INSTANCE.getCredentials(API.INSTANCE), null, null, null, null, 15, null), completion);
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public final void isPasswordSet$cloud_pace_sdk(@NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            this.makeBooleanRequest(CheckUserPasswordAPI.checkUserPassword$default(CheckUserPasswordAPI.INSTANCE, UserAPI.INSTANCE.getCredentials(API.INSTANCE), null, null, null, null, 15, null), completion);
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public final void isPINOrPasswordSet$cloud_pace_sdk(@NotNull Function1<? super Completion<PinOrPassword>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            CallbackUtilsKt.enqueue(CheckUserPinOrPasswordAPI.checkUserPinOrPassword$default(CheckUserPinOrPasswordAPI.INSTANCE, UserAPI.INSTANCE.getCredentials(API.INSTANCE), null, null, null, 7, null), (Function1)new Function1<CallBackKt<PinOrPassword>, Unit>(completion){
                final /* synthetic */ Function1<Completion<PinOrPassword>, Unit> $completion;
                {
                    this.$completion = $completion;
                    super(1);
                }

                public final void invoke(@NotNull CallBackKt<PinOrPassword> $this$enqueue) {
                    Intrinsics.checkNotNullParameter($this$enqueue, (String)"$this$enqueue");
                    $this$enqueue.setOnResponse((Function1<Response<PinOrPassword>, Unit>)((Function1)new Function1<Response<PinOrPassword>, Unit>(this.$completion){
                        final /* synthetic */ Function1<Completion<PinOrPassword>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(1);
                        }

                        public final void invoke(@NotNull Response<PinOrPassword> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            PinOrPassword body = (PinOrPassword)it.body();
                            if (it.isSuccessful() && body != null) {
                                this.$completion.invoke(new Success<PinOrPassword>(body));
                            } else if (it.code() >= 500) {
                                this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                            } else if (it.code() == 401) {
                                this.$completion.invoke(new Failure<T>(InvalidSession.INSTANCE));
                            } else {
                                int n = it.code();
                                String string2 = it.message();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.message()");
                                this.$completion.invoke(new Failure<T>(new ApiException(n, string2, CallbackUtilsKt.getRequestId(it))));
                            }
                        }
                    }));
                    $this$enqueue.setOnFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$completion){
                        final /* synthetic */ Function1<Completion<PinOrPassword>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(1);
                        }

                        public final void invoke(@Nullable Throwable it) {
                            Throwable throwable = it;
                            if (throwable == null) {
                                throwable = InternalError.INSTANCE;
                            }
                            this.$completion.invoke(new Failure<T>(throwable));
                        }
                    }));
                }
            });
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public final void setPINWithBiometry$cloud_pace_sdk(@NotNull Fragment fragment, @NotNull String title, @Nullable String subTitle, @Nullable String cancelText, boolean isDeviceCredentialsAllowed, @NotNull String pin, @NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.payAuthenticationManager.isFingerprintAvailable()) {
            if (this.setAuthorizationHeader()) {
                TotpSecret totpSecret = SharedPreferencesModel.DefaultImpls.getTotpSecret$default(this.sharedPreferencesModel, null, null, 3, null);
                if (totpSecret != null) {
                    BiometricUtils.INSTANCE.requestAuthentication(fragment, title, subTitle, cancelText, isDeviceCredentialsAllowed, (Function0<Unit>)((Function0)new Function0<Unit>(this, pin, totpSecret, completion){
                        final /* synthetic */ CredentialsManager this$0;
                        final /* synthetic */ String $pin;
                        final /* synthetic */ TotpSecret $totpSecret;
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.this$0 = $receiver;
                            this.$pin = $pin;
                            this.$totpSecret = $totpSecret;
                            this.$completion = $completion;
                            super(0);
                        }

                        public final void invoke() {
                            CredentialsManager.access$updateUserPIN(this.this$0, this.$pin, this.$totpSecret, this.$completion);
                        }
                    }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)new Function2<Integer, CharSequence, Unit>(completion){
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(2);
                        }

                        public final void invoke(int errorCode, @NotNull CharSequence errString) {
                            Intrinsics.checkNotNullParameter((Object)errString, (String)"errString");
                            this.$completion.invoke(new Failure<T>(new Throwable("Error code = " + errorCode + " error message = " + errString)));
                        }
                    }));
                } else {
                    completion.invoke(new Failure(BiometricAuthenticationNotSet.INSTANCE));
                }
            } else {
                completion.invoke(new Failure(InvalidSession.INSTANCE));
            }
        } else {
            completion.invoke(new Failure(BiometricAuthenticationNotSupported.INSTANCE));
        }
    }

    public final void setPINWithBiometry$cloud_pace_sdk(@NotNull FragmentActivity activity, @NotNull String title, @Nullable String subTitle, @Nullable String cancelText, boolean isDeviceCredentialsAllowed, @NotNull String pin, @NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.payAuthenticationManager.isFingerprintAvailable()) {
            if (this.setAuthorizationHeader()) {
                TotpSecret totpSecret = SharedPreferencesModel.DefaultImpls.getTotpSecret$default(this.sharedPreferencesModel, null, null, 3, null);
                if (totpSecret != null) {
                    BiometricUtils.INSTANCE.requestAuthentication(activity, title, subTitle, cancelText, isDeviceCredentialsAllowed, (Function0<Unit>)((Function0)new Function0<Unit>(this, pin, totpSecret, completion){
                        final /* synthetic */ CredentialsManager this$0;
                        final /* synthetic */ String $pin;
                        final /* synthetic */ TotpSecret $totpSecret;
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.this$0 = $receiver;
                            this.$pin = $pin;
                            this.$totpSecret = $totpSecret;
                            this.$completion = $completion;
                            super(0);
                        }

                        public final void invoke() {
                            CredentialsManager.access$updateUserPIN(this.this$0, this.$pin, this.$totpSecret, this.$completion);
                        }
                    }), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)new Function2<Integer, CharSequence, Unit>(completion){
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(2);
                        }

                        public final void invoke(int errorCode, @NotNull CharSequence errString) {
                            Intrinsics.checkNotNullParameter((Object)errString, (String)"errString");
                            this.$completion.invoke(new Failure<T>(new Throwable("Error code = " + errorCode + " error message = " + errString)));
                        }
                    }));
                } else {
                    completion.invoke(new Failure(BiometricAuthenticationNotSet.INSTANCE));
                }
            } else {
                completion.invoke(new Failure(InvalidSession.INSTANCE));
            }
        } else {
            completion.invoke(new Failure(BiometricAuthenticationNotSupported.INSTANCE));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateUserPIN(String pin, TotpSecret totpSecret, Function1<? super Completion<Boolean>, Unit> completion) {
        try {
            void $this$updateUserPIN_u24lambda_u2d1;
            UpdateUserPINAPI.Body body;
            String decryptedSecret = EncryptionUtils.INSTANCE.decrypt(totpSecret.getEncryptedSecret());
            String generatedOtp = EncryptionUtils.generateOTP$default(EncryptionUtils.INSTANCE, decryptedSecret, totpSecret.getDigits(), totpSecret.getPeriod(), totpSecret.getAlgorithm(), null, 16, null);
            UpdateUserPINAPI.Body body2 = body = new UpdateUserPINAPI.Body();
            UserAPI.CredentialsAPI credentialsAPI = UserAPI.INSTANCE.getCredentials(API.INSTANCE);
            UpdateUserPINAPI updateUserPINAPI = UpdateUserPINAPI.INSTANCE;
            CredentialsManager credentialsManager = this;
            boolean bl = false;
            $this$updateUserPIN_u24lambda_u2d1.setData(this.getUserPINBody(pin, generatedOtp));
            Unit unit = Unit.INSTANCE;
            credentialsManager.makeBooleanRequest(UpdateUserPINAPI.updateUserPIN$default(updateUserPINAPI, credentialsAPI, body, null, null, null, 14, null), completion);
        }
        catch (Exception e) {
            Timber.Forest.e((Throwable)e, "Could not decrypt the secret while updating the user PIN", new Object[0]);
            completion.invoke(new Failure(e));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setPINWithPassword$cloud_pace_sdk(@NotNull String pin, @NotNull String password, @NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            void $this$setPINWithPassword_u24lambda_u2d2;
            CreateOTP createOTP;
            CreateOTP createOTP2 = createOTP = new CreateOTP();
            UserAPI.TOTPAPI tOTPAPI = UserAPI.INSTANCE.getTotp(API.INSTANCE);
            CreateOTPAPI createOTPAPI = CreateOTPAPI.INSTANCE;
            boolean bl = false;
            $this$setPINWithPassword_u24lambda_u2d2.setPassword(password);
            Unit unit = Unit.INSTANCE;
            CallbackUtilsKt.enqueue(CreateOTPAPI.createOTP$default(createOTPAPI, tOTPAPI, createOTP, null, null, null, 14, null), (Function1)new Function1<CallBackKt<CreateOTP>, Unit>(this, completion, pin){
                final /* synthetic */ CredentialsManager this$0;
                final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                final /* synthetic */ String $pin;
                {
                    this.this$0 = $receiver;
                    this.$completion = $completion;
                    this.$pin = $pin;
                    super(1);
                }

                public final void invoke(@NotNull CallBackKt<CreateOTP> $this$enqueue) {
                    Intrinsics.checkNotNullParameter($this$enqueue, (String)"$this$enqueue");
                    $this$enqueue.setOnResponse((Function1<Response<CreateOTP>, Unit>)((Function1)new Function1<Response<CreateOTP>, Unit>(this.this$0, this.$completion, this.$pin){
                        final /* synthetic */ CredentialsManager this$0;
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        final /* synthetic */ String $pin;
                        {
                            this.this$0 = $receiver;
                            this.$completion = $completion;
                            this.$pin = $pin;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Response<CreateOTP> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            CreateOTP body = (CreateOTP)it.body();
                            if (it.isSuccessful() && body != null) {
                                String otp = body.getOtp();
                                if (otp != null) {
                                    void $this$invoke_u24lambda_u2d0;
                                    UpdateUserPINAPI.Body body2 = new UpdateUserPINAPI.Body();
                                    CredentialsManager credentialsManager = this.this$0;
                                    String string2 = this.$pin;
                                    UpdateUserPINAPI.Body body3 = body2;
                                    UserAPI.CredentialsAPI credentialsAPI = UserAPI.INSTANCE.getCredentials(API.INSTANCE);
                                    UpdateUserPINAPI updateUserPINAPI = UpdateUserPINAPI.INSTANCE;
                                    CredentialsManager credentialsManager2 = this.this$0;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u2d0.setData(CredentialsManager.access$getUserPINBody(credentialsManager, string2, otp));
                                    Unit unit = Unit.INSTANCE;
                                    CredentialsManager.access$makeBooleanRequest(credentialsManager2, UpdateUserPINAPI.updateUserPIN$default(updateUserPINAPI, credentialsAPI, body2, null, null, null, 14, null), this.$completion);
                                } else {
                                    this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                                }
                            } else if (it.code() >= 500) {
                                this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                            } else if (it.code() == 401) {
                                this.$completion.invoke(new Failure<T>(InvalidSession.INSTANCE));
                            } else {
                                int n = it.code();
                                String string3 = it.message();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.message()");
                                this.$completion.invoke(new Failure<T>(new ApiException(n, string3, CallbackUtilsKt.getRequestId(it))));
                            }
                        }
                    }));
                    $this$enqueue.setOnFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$completion){
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(1);
                        }

                        public final void invoke(@Nullable Throwable it) {
                            Throwable throwable = it;
                            if (throwable == null) {
                                throwable = InternalError.INSTANCE;
                            }
                            this.$completion.invoke(new Failure<T>(throwable));
                        }
                    }));
                }
            });
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setPINWithOTP$cloud_pace_sdk(@NotNull String pin, @NotNull String otp, @NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        Intrinsics.checkNotNullParameter((Object)otp, (String)"otp");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            void $this$setPINWithOTP_u24lambda_u2d3;
            CreateTOTPAPI.Body body;
            CreateTOTPAPI.Body body2 = body = new CreateTOTPAPI.Body();
            UserAPI.TOTPAPI tOTPAPI = UserAPI.INSTANCE.getTotp(API.INSTANCE);
            CreateTOTPAPI createTOTPAPI = CreateTOTPAPI.INSTANCE;
            boolean bl = false;
            $this$setPINWithOTP_u24lambda_u2d3.setData(CredentialsManager.getDeviceTOTPBody$default(this, null, null, otp, 3, null));
            Unit unit = Unit.INSTANCE;
            CallbackUtilsKt.enqueue(CreateTOTPAPI.createTOTP$default(createTOTPAPI, tOTPAPI, body, null, null, null, 14, null), (Function1)new Function1<CallBackKt<DeviceTOTP>, Unit>(this, completion, pin){
                final /* synthetic */ CredentialsManager this$0;
                final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                final /* synthetic */ String $pin;
                {
                    this.this$0 = $receiver;
                    this.$completion = $completion;
                    this.$pin = $pin;
                    super(1);
                }

                public final void invoke(@NotNull CallBackKt<DeviceTOTP> $this$enqueue) {
                    Intrinsics.checkNotNullParameter($this$enqueue, (String)"$this$enqueue");
                    $this$enqueue.setOnResponse((Function1<Response<DeviceTOTP>, Unit>)((Function1)new Function1<Response<DeviceTOTP>, Unit>(this.this$0, this.$completion, this.$pin){
                        final /* synthetic */ CredentialsManager this$0;
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        final /* synthetic */ String $pin;
                        {
                            this.this$0 = $receiver;
                            this.$completion = $completion;
                            this.$pin = $pin;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Response<DeviceTOTP> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            DeviceTOTP body = (DeviceTOTP)((Object)it.body());
                            if (it.isSuccessful() && body != null) {
                                String decryptedSecret = body.getSecret();
                                Integer digits = body.getDigits();
                                Integer period = body.getPeriod();
                                DeviceTOTP.Algorithm algorithm = body.getAlgorithm();
                                if (decryptedSecret != null && digits != null && period != null && algorithm != null) {
                                    try {
                                        void $this$invoke_u24lambda_u2d0;
                                        String generatedOtp = EncryptionUtils.generateOTP$default(EncryptionUtils.INSTANCE, decryptedSecret, digits, period, algorithm.getValue(), null, 16, null);
                                        UpdateUserPINAPI.Body body2 = new UpdateUserPINAPI.Body();
                                        CredentialsManager credentialsManager = this.this$0;
                                        String string2 = this.$pin;
                                        UpdateUserPINAPI.Body body3 = body2;
                                        UserAPI.CredentialsAPI credentialsAPI = UserAPI.INSTANCE.getCredentials(API.INSTANCE);
                                        UpdateUserPINAPI updateUserPINAPI = UpdateUserPINAPI.INSTANCE;
                                        CredentialsManager credentialsManager2 = this.this$0;
                                        boolean bl = false;
                                        $this$invoke_u24lambda_u2d0.setData(CredentialsManager.access$getUserPINBody(credentialsManager, string2, generatedOtp));
                                        Unit unit = Unit.INSTANCE;
                                        CredentialsManager.access$makeBooleanRequest(credentialsManager2, UpdateUserPINAPI.updateUserPIN$default(updateUserPINAPI, credentialsAPI, body2, null, null, null, 14, null), this.$completion);
                                    }
                                    catch (Exception e) {
                                        this.$completion.invoke(new Failure<T>(e));
                                    }
                                } else {
                                    this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                                }
                            } else if (it.code() >= 500) {
                                this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                            } else if (it.code() == 401) {
                                this.$completion.invoke(new Failure<T>(InvalidSession.INSTANCE));
                            } else {
                                int n = it.code();
                                String string3 = it.message();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.message()");
                                this.$completion.invoke(new Failure<T>(new ApiException(n, string3, CallbackUtilsKt.getRequestId(it))));
                            }
                        }
                    }));
                    $this$enqueue.setOnFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$completion){
                        final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                        {
                            this.$completion = $completion;
                            super(1);
                        }

                        public final void invoke(@Nullable Throwable it) {
                            Throwable throwable = it;
                            if (throwable == null) {
                                throwable = InternalError.INSTANCE;
                            }
                            this.$completion.invoke(new Failure<T>(throwable));
                        }
                    }));
                }
            });
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    public final boolean isPINValid$cloud_pace_sdk(@NotNull String pin) {
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        String charChain = "0123456789012";
        boolean isCorrectLength = pin.length() == 4;
        char[] cArray = pin.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        boolean isDistinct = ((Collection)ArraysKt.distinct((char[])cArray)).size() >= 3;
        boolean isNoChain = !StringsKt.contains$default((CharSequence)charChain, (CharSequence)pin, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((Object)StringsKt.reversed((CharSequence)charChain)).toString(), (CharSequence)pin, (boolean)false, (int)2, null);
        return isCorrectLength && isDistinct && isNoChain;
    }

    public final void sendMailOTP$cloud_pace_sdk(@NotNull Function1<? super Completion<Boolean>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.setAuthorizationHeader()) {
            this.makeBooleanRequest(SendmailOTPAPI.sendmailOTP$default(SendmailOTPAPI.INSTANCE, UserAPI.INSTANCE.getTotp(API.INSTANCE), null, null, null, 7, null), completion);
        } else {
            completion.invoke(new Failure(InvalidSession.INSTANCE));
        }
    }

    private final boolean setAuthorizationHeader() {
        boolean bl;
        String accessToken = this.authorizationManager.cachedToken$cloud_pace_sdk();
        if (accessToken != null) {
            API.INSTANCE.addAuthorizationHeader(accessToken);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final UserPINBody getUserPINBody(String pin, String otp) {
        void $this$getUserPINBody_u24lambda_u2d5_u24lambda_u2d4;
        UserPINBody.Attributes attributes;
        UserPINBody userPINBody;
        UserPINBody $this$getUserPINBody_u24lambda_u2d5 = userPINBody = new UserPINBody();
        boolean bl = false;
        $this$getUserPINBody_u24lambda_u2d5.setId(UUID.randomUUID().toString());
        $this$getUserPINBody_u24lambda_u2d5.setType(UserPINBody.Type.PIN);
        UserPINBody.Attributes attributes2 = attributes = new UserPINBody.Attributes();
        UserPINBody userPINBody2 = $this$getUserPINBody_u24lambda_u2d5;
        boolean bl2 = false;
        $this$getUserPINBody_u24lambda_u2d5_u24lambda_u2d4.setPin(pin);
        $this$getUserPINBody_u24lambda_u2d5_u24lambda_u2d4.setOtp(otp);
        userPINBody2.setAttributes(attributes);
        return userPINBody;
    }

    /*
     * WARNING - void declaration
     */
    private final DeviceTOTPBody getDeviceTOTPBody(String pin, String password, String otp) {
        void $this$getDeviceTOTPBody_u24lambda_u2d7_u24lambda_u2d6;
        DeviceTOTPBody.Attributes attributes;
        DeviceTOTPBody deviceTOTPBody;
        DeviceTOTPBody $this$getDeviceTOTPBody_u24lambda_u2d7 = deviceTOTPBody = new DeviceTOTPBody();
        boolean bl = false;
        $this$getDeviceTOTPBody_u24lambda_u2d7.setId(UUID.randomUUID().toString());
        $this$getDeviceTOTPBody_u24lambda_u2d7.setType(DeviceTOTPBody.Type.DEVICETOTP);
        DeviceTOTPBody.Attributes attributes2 = attributes = new DeviceTOTPBody.Attributes();
        DeviceTOTPBody deviceTOTPBody2 = $this$getDeviceTOTPBody_u24lambda_u2d7;
        boolean bl2 = false;
        $this$getDeviceTOTPBody_u24lambda_u2d7_u24lambda_u2d6.setPin(pin);
        $this$getDeviceTOTPBody_u24lambda_u2d7_u24lambda_u2d6.setPassword(password);
        $this$getDeviceTOTPBody_u24lambda_u2d7_u24lambda_u2d6.setOtp(otp);
        deviceTOTPBody2.setAttributes(attributes);
        return deviceTOTPBody;
    }

    static /* synthetic */ DeviceTOTPBody getDeviceTOTPBody$default(CredentialsManager credentialsManager, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            string4 = null;
        }
        return credentialsManager.getDeviceTOTPBody(string2, string3, string4);
    }

    private final <T> void makeBooleanRequest(Call<T> $this$makeBooleanRequest, Function1<? super Completion<Boolean>, Unit> completion) {
        CallbackUtilsKt.enqueue($this$makeBooleanRequest, (Function1)new Function1<CallBackKt<T>, Unit>(completion){
            final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull CallBackKt<T> $this$enqueue) {
                Intrinsics.checkNotNullParameter($this$enqueue, (String)"$this$enqueue");
                $this$enqueue.setOnResponse((Function1)new Function1<Response<T>, Unit>(this.$completion){
                    final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                    {
                        this.$completion = $completion;
                        super(1);
                    }

                    public final void invoke(@NotNull Response<T> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        if (it.isSuccessful()) {
                            this.$completion.invoke(new Success<Boolean>(true));
                        } else if (it.code() >= 500) {
                            this.$completion.invoke(new Failure<T>(InternalError.INSTANCE));
                        } else if (it.code() == 401) {
                            this.$completion.invoke(new Failure<T>(InvalidSession.INSTANCE));
                        } else if (it.code() == 406) {
                            this.$completion.invoke(new Failure<T>(PINNotSecure.INSTANCE));
                        } else {
                            this.$completion.invoke(new Success<Boolean>(false));
                        }
                    }
                });
                $this$enqueue.setOnFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$completion){
                    final /* synthetic */ Function1<Completion<Boolean>, Unit> $completion;
                    {
                        this.$completion = $completion;
                        super(1);
                    }

                    public final void invoke(@Nullable Throwable it) {
                        Throwable throwable = it;
                        if (throwable == null) {
                            throwable = InternalError.INSTANCE;
                        }
                        this.$completion.invoke(new Failure<T>(throwable));
                    }
                }));
            }
        });
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return CloudSDKKoinComponent.DefaultImpls.getKoin(this);
    }

    public static final /* synthetic */ SharedPreferencesModel access$getSharedPreferencesModel$p(CredentialsManager $this) {
        return $this.sharedPreferencesModel;
    }

    public static final /* synthetic */ void access$updateUserPIN(CredentialsManager $this, String pin, TotpSecret totpSecret, Function1 completion) {
        $this.updateUserPIN(pin, totpSecret, (Function1<? super Completion<Boolean>, Unit>)completion);
    }

    public static final /* synthetic */ void access$makeBooleanRequest(CredentialsManager $this, Call $receiver, Function1 completion) {
        $this.makeBooleanRequest($receiver, (Function1<? super Completion<Boolean>, Unit>)completion);
    }

    public static final /* synthetic */ UserPINBody access$getUserPINBody(CredentialsManager $this, String pin, String otp) {
        return $this.getUserPINBody(pin, otp);
    }
}

