/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.database;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import cloud.pace.sdk.poikit.database.Converters;
import cloud.pace.sdk.poikit.database.GasStationDAO;
import cloud.pace.sdk.poikit.poi.Address;
import cloud.pace.sdk.poikit.poi.GasStation;
import cloud.pace.sdk.poikit.poi.Geometry;
import cloud.pace.sdk.poikit.poi.OpeningHours;
import cloud.pace.sdk.poikit.poi.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public final class GasStationDAO_Impl
implements GasStationDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<GasStation> __insertionAdapterOfGasStation;
    private final Converters __converters = new Converters();
    private final EntityDeletionOrUpdateAdapter<GasStation> __deletionAdapterOfGasStation;

    public GasStationDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGasStation = new EntityInsertionAdapter<GasStation>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `GasStation` (`name`,`brand`,`openingHours`,`prices`,`currency`,`priceFormat`,`validFrom`,`paymentMethods`,`isConnectedFuelingAvailable`,`isOnlineCoFuGasStation`,`amenities`,`foods`,`loyaltyPrograms`,`postalServices`,`services`,`shopGoods`,`priceComparisonOptOut`,`cofuPaymentMethods`,`id`,`geometry`,`temporary`,`updatedAt`,`latitude`,`longitude`,`encodedAddress`,`countryCode`,`city`,`postalCode`,`suburb`,`state`,`street`,`houseNumber`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, GasStation value) {
                Integer _tmp_15;
                Integer _tmp_12;
                Integer _tmp_5;
                Integer _tmp_4;
                if (value.getName() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getName());
                }
                if (value.getBrand() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getBrand());
                }
                String _tmp = GasStationDAO_Impl.this.__converters.fromOpeningHours(value.getOpeningHours());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = GasStationDAO_Impl.this.__converters.fromPriceList(value.getPrices());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                if (value.getCurrency() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCurrency());
                }
                if (value.getPriceFormat() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPriceFormat());
                }
                long _tmp_2 = GasStationDAO_Impl.this.__converters.fromDate(value.getValidFrom());
                stmt.bindLong(7, _tmp_2);
                String _tmp_3 = GasStationDAO_Impl.this.__converters.fromStringList(value.getPaymentMethods());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                Integer n = value.isConnectedFuelingAvailable() == null ? null : (_tmp_4 = Integer.valueOf(value.isConnectedFuelingAvailable() != false ? 1 : 0));
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_4.intValue());
                }
                Integer n2 = value.isOnlineCoFuGasStation() == null ? null : (_tmp_5 = Integer.valueOf(value.isOnlineCoFuGasStation() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)_tmp_5.intValue());
                }
                String _tmp_6 = GasStationDAO_Impl.this.__converters.fromStringList(value.getAmenities());
                if (_tmp_6 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_6);
                }
                String _tmp_7 = GasStationDAO_Impl.this.__converters.fromStringList(value.getFoods());
                if (_tmp_7 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_7);
                }
                String _tmp_8 = GasStationDAO_Impl.this.__converters.fromStringList(value.getLoyaltyPrograms());
                if (_tmp_8 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_8);
                }
                String _tmp_9 = GasStationDAO_Impl.this.__converters.fromStringList(value.getPostalServices());
                if (_tmp_9 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_9);
                }
                String _tmp_10 = GasStationDAO_Impl.this.__converters.fromStringList(value.getServices());
                if (_tmp_10 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_10);
                }
                String _tmp_11 = GasStationDAO_Impl.this.__converters.fromStringList(value.getShopGoods());
                if (_tmp_11 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_11);
                }
                Integer n3 = value.getPriceComparisonOptOut() == null ? null : (_tmp_12 = Integer.valueOf(value.getPriceComparisonOptOut() != false ? 1 : 0));
                if (_tmp_12 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindLong(17, (long)_tmp_12.intValue());
                }
                String _tmp_13 = GasStationDAO_Impl.this.__converters.fromStringList(value.getCofuPaymentMethods());
                if (_tmp_13 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_13);
                }
                if (value.getId() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getId());
                }
                String _tmp_14 = GasStationDAO_Impl.this.__converters.fromGeometry(value.getGeometry());
                if (_tmp_14 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_14);
                }
                Integer n4 = value.getTemporary() == null ? null : (_tmp_15 = Integer.valueOf(value.getTemporary() != false ? 1 : 0));
                if (_tmp_15 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindLong(21, (long)_tmp_15.intValue());
                }
                long _tmp_16 = GasStationDAO_Impl.this.__converters.fromDate(value.getUpdatedAt());
                stmt.bindLong(22, _tmp_16);
                if (value.getLatitude() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindDouble(23, value.getLatitude().doubleValue());
                }
                if (value.getLongitude() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindDouble(24, value.getLongitude().doubleValue());
                }
                Address _tmpAddress = value.getAddress();
                if (_tmpAddress != null) {
                    if (_tmpAddress.getEncodedAddress() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindString(25, _tmpAddress.getEncodedAddress());
                    }
                    if (_tmpAddress.getCountryCode() == null) {
                        stmt.bindNull(26);
                    } else {
                        stmt.bindString(26, _tmpAddress.getCountryCode());
                    }
                    if (_tmpAddress.getCity() == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmpAddress.getCity());
                    }
                    if (_tmpAddress.getPostalCode() == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindString(28, _tmpAddress.getPostalCode());
                    }
                    if (_tmpAddress.getSuburb() == null) {
                        stmt.bindNull(29);
                    } else {
                        stmt.bindString(29, _tmpAddress.getSuburb());
                    }
                    if (_tmpAddress.getState() == null) {
                        stmt.bindNull(30);
                    } else {
                        stmt.bindString(30, _tmpAddress.getState());
                    }
                    if (_tmpAddress.getStreet() == null) {
                        stmt.bindNull(31);
                    } else {
                        stmt.bindString(31, _tmpAddress.getStreet());
                    }
                    if (_tmpAddress.getHouseNumber() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpAddress.getHouseNumber());
                    }
                } else {
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                }
            }
        };
        this.__deletionAdapterOfGasStation = new EntityDeletionOrUpdateAdapter<GasStation>(__db){

            public String createQuery() {
                return "DELETE FROM `GasStation` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GasStation value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insertGasStations(List<? extends GasStation> gasStations2) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfGasStation.insertAndReturnIdsList(gasStations2);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(List<? extends GasStation> gasStations2) {
        this.__db.assertNotSuspendingTransaction();
        int _total = 0;
        this.__db.beginTransaction();
        try {
            this.__db.setTransactionSuccessful();
            int n = _total += this.__deletionAdapterOfGasStation.handleMultiple(gasStations2);
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GasStation getGasStation(String id2) {
        String _sql = "SELECT * FROM gasstation WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM gasstation WHERE id=?", (int)1);
        int _argIndex = 1;
        if (id2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id2);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            GasStation _result;
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
            int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
            int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
            int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
            int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
            int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
            int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
            int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
            int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
            int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
            int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
            int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
            int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
            int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
            int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
            int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
            int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
            int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
            int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
            int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
            int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
            int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
            if (_cursor.moveToFirst()) {
                Address _tmpAddress;
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                ArrayList<Geometry.CommandGeo> _tmpGeometry = this.__converters.toGeometry(_tmp);
                if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                    String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                    _tmpAddress = new Address(_tmpEncodedAddress);
                    String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                    _tmpAddress.setCountryCode(_tmpCountryCode);
                    String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                    _tmpAddress.setCity(_tmpCity);
                    String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                    _tmpAddress.setPostalCode(_tmpPostalCode);
                    String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                    _tmpAddress.setSuburb(_tmpSuburb);
                    String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                    _tmpAddress.setState(_tmpState);
                    String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                    _tmpAddress.setStreet(_tmpStreet);
                    String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                    _tmpAddress.setHouseNumber(_tmpHouseNumber);
                } else {
                    _tmpAddress = null;
                }
                _result = new GasStation(_tmpId, _tmpGeometry);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result.setName(_tmpName);
                String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                _result.setBrand(_tmpBrand);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                List<OpeningHours> _tmpOpeningHours = this.__converters.toOpeningHours(_tmp_1);
                _result.setOpeningHours(_tmpOpeningHours);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                List<Price> _tmpPrices = this.__converters.toPriceList(_tmp_2);
                _result.setPrices(_tmpPrices);
                String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                _result.setCurrency(_tmpCurrency);
                String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                _result.setPriceFormat(_tmpPriceFormat);
                long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                Date _tmpValidFrom = this.__converters.toDate(_tmp_3);
                _result.setValidFrom(_tmpValidFrom);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                List<String> _tmpPaymentMethods = this.__converters.toStringList(_tmp_4);
                _result.setPaymentMethods(_tmpPaymentMethods);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _result.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _result.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                List<String> _tmpAmenities = this.__converters.toStringList(_tmp_7);
                _result.setAmenities(_tmpAmenities);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                List<String> _tmpFoods = this.__converters.toStringList(_tmp_8);
                _result.setFoods(_tmpFoods);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                List<String> _tmpLoyaltyPrograms = this.__converters.toStringList(_tmp_9);
                _result.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                List<String> _tmpPostalServices = this.__converters.toStringList(_tmp_10);
                _result.setPostalServices(_tmpPostalServices);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                List<String> _tmpServices = this.__converters.toStringList(_tmp_11);
                _result.setServices(_tmpServices);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                List<String> _tmpShopGoods = this.__converters.toStringList(_tmp_12);
                _result.setShopGoods(_tmpShopGoods);
                Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                _result.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                List<String> _tmpCofuPaymentMethods = this.__converters.toStringList(_tmp_14);
                _result.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                _result.setTemporary(_tmpTemporary);
                long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                Date _tmpUpdatedAt = this.__converters.toDate(_tmp_16);
                _result.setUpdatedAt(_tmpUpdatedAt);
                Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                _result.setLatitude(_tmpLatitude);
                Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                _result.setLongitude(_tmpLongitude);
                _result.setAddress(_tmpAddress);
            } else {
                _result = null;
            }
            GasStation gasStation = _result;
            return gasStation;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GasStation> getByIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM gasstation WHERE id IN(");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
            int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
            int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
            int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
            int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
            int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
            int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
            int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
            int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
            int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
            int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
            int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
            int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
            int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
            int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
            int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
            int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
            int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
            int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
            int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
            int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
            int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
            ArrayList<GasStation> _result = new ArrayList<GasStation>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Address _tmpAddress;
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                ArrayList<Geometry.CommandGeo> _tmpGeometry = this.__converters.toGeometry(_tmp);
                if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                    String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                    _tmpAddress = new Address(_tmpEncodedAddress);
                    String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                    _tmpAddress.setCountryCode(_tmpCountryCode);
                    String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                    _tmpAddress.setCity(_tmpCity);
                    String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                    _tmpAddress.setPostalCode(_tmpPostalCode);
                    String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                    _tmpAddress.setSuburb(_tmpSuburb);
                    String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                    _tmpAddress.setState(_tmpState);
                    String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                    _tmpAddress.setStreet(_tmpStreet);
                    String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                    _tmpAddress.setHouseNumber(_tmpHouseNumber);
                } else {
                    _tmpAddress = null;
                }
                GasStation _item_1 = new GasStation(_tmpId, _tmpGeometry);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item_1.setName(_tmpName);
                String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                _item_1.setBrand(_tmpBrand);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                List<OpeningHours> _tmpOpeningHours = this.__converters.toOpeningHours(_tmp_1);
                _item_1.setOpeningHours(_tmpOpeningHours);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                List<Price> _tmpPrices = this.__converters.toPriceList(_tmp_2);
                _item_1.setPrices(_tmpPrices);
                String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                _item_1.setCurrency(_tmpCurrency);
                String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                _item_1.setPriceFormat(_tmpPriceFormat);
                long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                Date _tmpValidFrom = this.__converters.toDate(_tmp_3);
                _item_1.setValidFrom(_tmpValidFrom);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                List<String> _tmpPaymentMethods = this.__converters.toStringList(_tmp_4);
                _item_1.setPaymentMethods(_tmpPaymentMethods);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _item_1.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _item_1.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                List<String> _tmpAmenities = this.__converters.toStringList(_tmp_7);
                _item_1.setAmenities(_tmpAmenities);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                List<String> _tmpFoods = this.__converters.toStringList(_tmp_8);
                _item_1.setFoods(_tmpFoods);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                List<String> _tmpLoyaltyPrograms = this.__converters.toStringList(_tmp_9);
                _item_1.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                List<String> _tmpPostalServices = this.__converters.toStringList(_tmp_10);
                _item_1.setPostalServices(_tmpPostalServices);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                List<String> _tmpServices = this.__converters.toStringList(_tmp_11);
                _item_1.setServices(_tmpServices);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                List<String> _tmpShopGoods = this.__converters.toStringList(_tmp_12);
                _item_1.setShopGoods(_tmpShopGoods);
                Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                _item_1.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                List<String> _tmpCofuPaymentMethods = this.__converters.toStringList(_tmp_14);
                _item_1.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                _item_1.setTemporary(_tmpTemporary);
                long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                Date _tmpUpdatedAt = this.__converters.toDate(_tmp_16);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                _item_1.setLatitude(_tmpLatitude);
                Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                _item_1.setLongitude(_tmpLongitude);
                _item_1.setAddress(_tmpAddress);
                _result.add(_item_1);
            }
            ArrayList<GasStation> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<GasStation>> getByIdsLive(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM gasstation WHERE id IN(");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"gasstation"}, false, (Callable)new Callable<List<GasStation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<GasStation> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)GasStationDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
                    int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
                    int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
                    int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                    int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
                    int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
                    int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
                    int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
                    int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
                    int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
                    int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
                    int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
                    int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
                    int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                    int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
                    int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
                    int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
                    int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
                    int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
                    int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
                    int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
                    int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
                    int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
                    int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
                    int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
                    ArrayList<GasStation> _result = new ArrayList<GasStation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Address _tmpAddress;
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                        ArrayList<Geometry.CommandGeo> _tmpGeometry = GasStationDAO_Impl.this.__converters.toGeometry(_tmp);
                        if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                            String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                            _tmpAddress = new Address(_tmpEncodedAddress);
                            String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                            _tmpAddress.setCountryCode(_tmpCountryCode);
                            String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                            _tmpAddress.setCity(_tmpCity);
                            String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                            _tmpAddress.setPostalCode(_tmpPostalCode);
                            String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                            _tmpAddress.setSuburb(_tmpSuburb);
                            String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                            _tmpAddress.setState(_tmpState);
                            String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                            _tmpAddress.setStreet(_tmpStreet);
                            String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                            _tmpAddress.setHouseNumber(_tmpHouseNumber);
                        } else {
                            _tmpAddress = null;
                        }
                        GasStation _item_1 = new GasStation(_tmpId, _tmpGeometry);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _item_1.setName(_tmpName);
                        String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                        _item_1.setBrand(_tmpBrand);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                        List<OpeningHours> _tmpOpeningHours = GasStationDAO_Impl.this.__converters.toOpeningHours(_tmp_1);
                        _item_1.setOpeningHours(_tmpOpeningHours);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                        List<Price> _tmpPrices = GasStationDAO_Impl.this.__converters.toPriceList(_tmp_2);
                        _item_1.setPrices(_tmpPrices);
                        String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                        _item_1.setCurrency(_tmpCurrency);
                        String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                        _item_1.setPriceFormat(_tmpPriceFormat);
                        long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                        Date _tmpValidFrom = GasStationDAO_Impl.this.__converters.toDate(_tmp_3);
                        _item_1.setValidFrom(_tmpValidFrom);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                        List<String> _tmpPaymentMethods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_4);
                        _item_1.setPaymentMethods(_tmpPaymentMethods);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                        Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        _item_1.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                        Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _item_1.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                        List<String> _tmpAmenities = GasStationDAO_Impl.this.__converters.toStringList(_tmp_7);
                        _item_1.setAmenities(_tmpAmenities);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                        List<String> _tmpFoods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_8);
                        _item_1.setFoods(_tmpFoods);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                        List<String> _tmpLoyaltyPrograms = GasStationDAO_Impl.this.__converters.toStringList(_tmp_9);
                        _item_1.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                        List<String> _tmpPostalServices = GasStationDAO_Impl.this.__converters.toStringList(_tmp_10);
                        _item_1.setPostalServices(_tmpPostalServices);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                        List<String> _tmpServices = GasStationDAO_Impl.this.__converters.toStringList(_tmp_11);
                        _item_1.setServices(_tmpServices);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                        List<String> _tmpShopGoods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_12);
                        _item_1.setShopGoods(_tmpShopGoods);
                        Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                        Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                        _item_1.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                        List<String> _tmpCofuPaymentMethods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_14);
                        _item_1.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                        Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                        Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                        _item_1.setTemporary(_tmpTemporary);
                        long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                        Date _tmpUpdatedAt = GasStationDAO_Impl.this.__converters.toDate(_tmp_16);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                        _item_1.setLatitude(_tmpLatitude);
                        Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                        _item_1.setLongitude(_tmpLongitude);
                        _item_1.setAddress(_tmpAddress);
                        _result.add(_item_1);
                    }
                    ArrayList<GasStation> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GasStation> getAll() {
        String _sql = "SELECT * FROM gasstation";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM gasstation", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
            int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
            int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
            int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
            int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
            int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
            int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
            int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
            int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
            int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
            int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
            int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
            int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
            int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
            int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
            int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
            int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
            int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
            int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
            int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
            int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
            int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
            ArrayList<GasStation> _result = new ArrayList<GasStation>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Address _tmpAddress;
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                ArrayList<Geometry.CommandGeo> _tmpGeometry = this.__converters.toGeometry(_tmp);
                if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                    String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                    _tmpAddress = new Address(_tmpEncodedAddress);
                    String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                    _tmpAddress.setCountryCode(_tmpCountryCode);
                    String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                    _tmpAddress.setCity(_tmpCity);
                    String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                    _tmpAddress.setPostalCode(_tmpPostalCode);
                    String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                    _tmpAddress.setSuburb(_tmpSuburb);
                    String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                    _tmpAddress.setState(_tmpState);
                    String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                    _tmpAddress.setStreet(_tmpStreet);
                    String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                    _tmpAddress.setHouseNumber(_tmpHouseNumber);
                } else {
                    _tmpAddress = null;
                }
                GasStation _item = new GasStation(_tmpId, _tmpGeometry);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                _item.setBrand(_tmpBrand);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                List<OpeningHours> _tmpOpeningHours = this.__converters.toOpeningHours(_tmp_1);
                _item.setOpeningHours(_tmpOpeningHours);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                List<Price> _tmpPrices = this.__converters.toPriceList(_tmp_2);
                _item.setPrices(_tmpPrices);
                String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                _item.setCurrency(_tmpCurrency);
                String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                _item.setPriceFormat(_tmpPriceFormat);
                long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                Date _tmpValidFrom = this.__converters.toDate(_tmp_3);
                _item.setValidFrom(_tmpValidFrom);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                List<String> _tmpPaymentMethods = this.__converters.toStringList(_tmp_4);
                _item.setPaymentMethods(_tmpPaymentMethods);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _item.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _item.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                List<String> _tmpAmenities = this.__converters.toStringList(_tmp_7);
                _item.setAmenities(_tmpAmenities);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                List<String> _tmpFoods = this.__converters.toStringList(_tmp_8);
                _item.setFoods(_tmpFoods);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                List<String> _tmpLoyaltyPrograms = this.__converters.toStringList(_tmp_9);
                _item.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                List<String> _tmpPostalServices = this.__converters.toStringList(_tmp_10);
                _item.setPostalServices(_tmpPostalServices);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                List<String> _tmpServices = this.__converters.toStringList(_tmp_11);
                _item.setServices(_tmpServices);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                List<String> _tmpShopGoods = this.__converters.toStringList(_tmp_12);
                _item.setShopGoods(_tmpShopGoods);
                Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                _item.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                List<String> _tmpCofuPaymentMethods = this.__converters.toStringList(_tmp_14);
                _item.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                _item.setTemporary(_tmpTemporary);
                long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                Date _tmpUpdatedAt = this.__converters.toDate(_tmp_16);
                _item.setUpdatedAt(_tmpUpdatedAt);
                Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                _item.setLatitude(_tmpLatitude);
                Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                _item.setLongitude(_tmpLongitude);
                _item.setAddress(_tmpAddress);
                _result.add(_item);
            }
            ArrayList<GasStation> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<GasStation>> getAllLive() {
        String _sql = "SELECT * FROM gasstation";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM gasstation", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"gasstation"}, false, (Callable)new Callable<List<GasStation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<GasStation> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)GasStationDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
                    int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
                    int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
                    int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                    int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
                    int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
                    int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
                    int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
                    int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
                    int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
                    int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
                    int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
                    int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
                    int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                    int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
                    int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
                    int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
                    int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
                    int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
                    int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
                    int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
                    int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
                    int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
                    int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
                    int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
                    ArrayList<GasStation> _result = new ArrayList<GasStation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Address _tmpAddress;
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                        ArrayList<Geometry.CommandGeo> _tmpGeometry = GasStationDAO_Impl.this.__converters.toGeometry(_tmp);
                        if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                            String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                            _tmpAddress = new Address(_tmpEncodedAddress);
                            String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                            _tmpAddress.setCountryCode(_tmpCountryCode);
                            String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                            _tmpAddress.setCity(_tmpCity);
                            String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                            _tmpAddress.setPostalCode(_tmpPostalCode);
                            String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                            _tmpAddress.setSuburb(_tmpSuburb);
                            String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                            _tmpAddress.setState(_tmpState);
                            String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                            _tmpAddress.setStreet(_tmpStreet);
                            String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                            _tmpAddress.setHouseNumber(_tmpHouseNumber);
                        } else {
                            _tmpAddress = null;
                        }
                        GasStation _item = new GasStation(_tmpId, _tmpGeometry);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _item.setName(_tmpName);
                        String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                        _item.setBrand(_tmpBrand);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                        List<OpeningHours> _tmpOpeningHours = GasStationDAO_Impl.this.__converters.toOpeningHours(_tmp_1);
                        _item.setOpeningHours(_tmpOpeningHours);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                        List<Price> _tmpPrices = GasStationDAO_Impl.this.__converters.toPriceList(_tmp_2);
                        _item.setPrices(_tmpPrices);
                        String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                        _item.setCurrency(_tmpCurrency);
                        String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                        _item.setPriceFormat(_tmpPriceFormat);
                        long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                        Date _tmpValidFrom = GasStationDAO_Impl.this.__converters.toDate(_tmp_3);
                        _item.setValidFrom(_tmpValidFrom);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                        List<String> _tmpPaymentMethods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_4);
                        _item.setPaymentMethods(_tmpPaymentMethods);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                        Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        _item.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                        Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _item.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                        List<String> _tmpAmenities = GasStationDAO_Impl.this.__converters.toStringList(_tmp_7);
                        _item.setAmenities(_tmpAmenities);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                        List<String> _tmpFoods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_8);
                        _item.setFoods(_tmpFoods);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                        List<String> _tmpLoyaltyPrograms = GasStationDAO_Impl.this.__converters.toStringList(_tmp_9);
                        _item.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                        List<String> _tmpPostalServices = GasStationDAO_Impl.this.__converters.toStringList(_tmp_10);
                        _item.setPostalServices(_tmpPostalServices);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                        List<String> _tmpServices = GasStationDAO_Impl.this.__converters.toStringList(_tmp_11);
                        _item.setServices(_tmpServices);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                        List<String> _tmpShopGoods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_12);
                        _item.setShopGoods(_tmpShopGoods);
                        Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                        Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                        _item.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                        List<String> _tmpCofuPaymentMethods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_14);
                        _item.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                        Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                        Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                        _item.setTemporary(_tmpTemporary);
                        long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                        Date _tmpUpdatedAt = GasStationDAO_Impl.this.__converters.toDate(_tmp_16);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                        _item.setLatitude(_tmpLatitude);
                        Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                        _item.setLongitude(_tmpLongitude);
                        _item.setAddress(_tmpAddress);
                        _result.add(_item);
                    }
                    ArrayList<GasStation> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<GasStation>> getInBoundingBoxLive(double minLat, double maxLat, double minLon, double maxLon) {
        String _sql = "SELECT * FROM gasstation WHERE latitude BETWEEN ? AND ? AND longitude BETWEEN ? AND ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM gasstation WHERE latitude BETWEEN ? AND ? AND longitude BETWEEN ? AND ?", (int)4);
        int _argIndex = 1;
        _statement.bindDouble(_argIndex, minLat);
        _argIndex = 2;
        _statement.bindDouble(_argIndex, maxLat);
        _argIndex = 3;
        _statement.bindDouble(_argIndex, minLon);
        _argIndex = 4;
        _statement.bindDouble(_argIndex, maxLon);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"gasstation"}, false, (Callable)new Callable<List<GasStation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<GasStation> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)GasStationDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
                    int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
                    int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
                    int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                    int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
                    int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
                    int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
                    int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
                    int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
                    int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
                    int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
                    int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
                    int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
                    int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                    int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
                    int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
                    int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
                    int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
                    int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
                    int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
                    int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
                    int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
                    int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
                    int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
                    int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                    int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
                    int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
                    ArrayList<GasStation> _result = new ArrayList<GasStation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Address _tmpAddress;
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                        ArrayList<Geometry.CommandGeo> _tmpGeometry = GasStationDAO_Impl.this.__converters.toGeometry(_tmp);
                        if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                            String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                            _tmpAddress = new Address(_tmpEncodedAddress);
                            String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                            _tmpAddress.setCountryCode(_tmpCountryCode);
                            String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                            _tmpAddress.setCity(_tmpCity);
                            String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                            _tmpAddress.setPostalCode(_tmpPostalCode);
                            String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                            _tmpAddress.setSuburb(_tmpSuburb);
                            String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                            _tmpAddress.setState(_tmpState);
                            String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                            _tmpAddress.setStreet(_tmpStreet);
                            String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                            _tmpAddress.setHouseNumber(_tmpHouseNumber);
                        } else {
                            _tmpAddress = null;
                        }
                        GasStation _item = new GasStation(_tmpId, _tmpGeometry);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _item.setName(_tmpName);
                        String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                        _item.setBrand(_tmpBrand);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                        List<OpeningHours> _tmpOpeningHours = GasStationDAO_Impl.this.__converters.toOpeningHours(_tmp_1);
                        _item.setOpeningHours(_tmpOpeningHours);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                        List<Price> _tmpPrices = GasStationDAO_Impl.this.__converters.toPriceList(_tmp_2);
                        _item.setPrices(_tmpPrices);
                        String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                        _item.setCurrency(_tmpCurrency);
                        String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                        _item.setPriceFormat(_tmpPriceFormat);
                        long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                        Date _tmpValidFrom = GasStationDAO_Impl.this.__converters.toDate(_tmp_3);
                        _item.setValidFrom(_tmpValidFrom);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                        List<String> _tmpPaymentMethods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_4);
                        _item.setPaymentMethods(_tmpPaymentMethods);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                        Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        _item.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                        Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _item.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                        List<String> _tmpAmenities = GasStationDAO_Impl.this.__converters.toStringList(_tmp_7);
                        _item.setAmenities(_tmpAmenities);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                        List<String> _tmpFoods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_8);
                        _item.setFoods(_tmpFoods);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                        List<String> _tmpLoyaltyPrograms = GasStationDAO_Impl.this.__converters.toStringList(_tmp_9);
                        _item.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                        List<String> _tmpPostalServices = GasStationDAO_Impl.this.__converters.toStringList(_tmp_10);
                        _item.setPostalServices(_tmpPostalServices);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                        List<String> _tmpServices = GasStationDAO_Impl.this.__converters.toStringList(_tmp_11);
                        _item.setServices(_tmpServices);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                        List<String> _tmpShopGoods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_12);
                        _item.setShopGoods(_tmpShopGoods);
                        Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                        Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                        _item.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                        List<String> _tmpCofuPaymentMethods = GasStationDAO_Impl.this.__converters.toStringList(_tmp_14);
                        _item.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                        Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                        Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                        _item.setTemporary(_tmpTemporary);
                        long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                        Date _tmpUpdatedAt = GasStationDAO_Impl.this.__converters.toDate(_tmp_16);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                        _item.setLatitude(_tmpLatitude);
                        Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                        _item.setLongitude(_tmpLongitude);
                        _item.setAddress(_tmpAddress);
                        _result.add(_item);
                    }
                    ArrayList<GasStation> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GasStation> getInBoundingBox(double minLat, double maxLat, double minLon, double maxLon) {
        String _sql = "SELECT * FROM gasstation WHERE latitude BETWEEN ? AND ? AND longitude BETWEEN ? AND ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM gasstation WHERE latitude BETWEEN ? AND ? AND longitude BETWEEN ? AND ?", (int)4);
        int _argIndex = 1;
        _statement.bindDouble(_argIndex, minLat);
        _argIndex = 2;
        _statement.bindDouble(_argIndex, maxLat);
        _argIndex = 3;
        _statement.bindDouble(_argIndex, minLon);
        _argIndex = 4;
        _statement.bindDouble(_argIndex, maxLon);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfBrand = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"brand");
            int _cursorIndexOfOpeningHours = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"openingHours");
            int _cursorIndexOfPrices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"prices");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfPriceFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceFormat");
            int _cursorIndexOfValidFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"validFrom");
            int _cursorIndexOfPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paymentMethods");
            int _cursorIndexOfIsConnectedFuelingAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isConnectedFuelingAvailable");
            int _cursorIndexOfIsOnlineCoFuGasStation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOnlineCoFuGasStation");
            int _cursorIndexOfAmenities = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"amenities");
            int _cursorIndexOfFoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"foods");
            int _cursorIndexOfLoyaltyPrograms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loyaltyPrograms");
            int _cursorIndexOfPostalServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalServices");
            int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
            int _cursorIndexOfShopGoods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"shopGoods");
            int _cursorIndexOfPriceComparisonOptOut = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceComparisonOptOut");
            int _cursorIndexOfCofuPaymentMethods = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cofuPaymentMethods");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfGeometry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geometry");
            int _cursorIndexOfTemporary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temporary");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latitude");
            int _cursorIndexOfLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"longitude");
            int _cursorIndexOfEncodedAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encodedAddress");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"countryCode");
            int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
            int _cursorIndexOfPostalCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postalCode");
            int _cursorIndexOfSuburb = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"suburb");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfStreet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"street");
            int _cursorIndexOfHouseNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"houseNumber");
            ArrayList<GasStation> _result = new ArrayList<GasStation>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Address _tmpAddress;
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmp = _cursor.isNull(_cursorIndexOfGeometry) ? null : _cursor.getString(_cursorIndexOfGeometry);
                ArrayList<Geometry.CommandGeo> _tmpGeometry = this.__converters.toGeometry(_tmp);
                if (!(_cursor.isNull(_cursorIndexOfEncodedAddress) && _cursor.isNull(_cursorIndexOfCountryCode) && _cursor.isNull(_cursorIndexOfCity) && _cursor.isNull(_cursorIndexOfPostalCode) && _cursor.isNull(_cursorIndexOfSuburb) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStreet) && _cursor.isNull(_cursorIndexOfHouseNumber))) {
                    String _tmpEncodedAddress = _cursor.isNull(_cursorIndexOfEncodedAddress) ? null : _cursor.getString(_cursorIndexOfEncodedAddress);
                    _tmpAddress = new Address(_tmpEncodedAddress);
                    String _tmpCountryCode = _cursor.isNull(_cursorIndexOfCountryCode) ? null : _cursor.getString(_cursorIndexOfCountryCode);
                    _tmpAddress.setCountryCode(_tmpCountryCode);
                    String _tmpCity = _cursor.isNull(_cursorIndexOfCity) ? null : _cursor.getString(_cursorIndexOfCity);
                    _tmpAddress.setCity(_tmpCity);
                    String _tmpPostalCode = _cursor.isNull(_cursorIndexOfPostalCode) ? null : _cursor.getString(_cursorIndexOfPostalCode);
                    _tmpAddress.setPostalCode(_tmpPostalCode);
                    String _tmpSuburb = _cursor.isNull(_cursorIndexOfSuburb) ? null : _cursor.getString(_cursorIndexOfSuburb);
                    _tmpAddress.setSuburb(_tmpSuburb);
                    String _tmpState = _cursor.isNull(_cursorIndexOfState) ? null : _cursor.getString(_cursorIndexOfState);
                    _tmpAddress.setState(_tmpState);
                    String _tmpStreet = _cursor.isNull(_cursorIndexOfStreet) ? null : _cursor.getString(_cursorIndexOfStreet);
                    _tmpAddress.setStreet(_tmpStreet);
                    String _tmpHouseNumber = _cursor.isNull(_cursorIndexOfHouseNumber) ? null : _cursor.getString(_cursorIndexOfHouseNumber);
                    _tmpAddress.setHouseNumber(_tmpHouseNumber);
                } else {
                    _tmpAddress = null;
                }
                GasStation _item = new GasStation(_tmpId, _tmpGeometry);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                String _tmpBrand = _cursor.isNull(_cursorIndexOfBrand) ? null : _cursor.getString(_cursorIndexOfBrand);
                _item.setBrand(_tmpBrand);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfOpeningHours) ? null : _cursor.getString(_cursorIndexOfOpeningHours);
                List<OpeningHours> _tmpOpeningHours = this.__converters.toOpeningHours(_tmp_1);
                _item.setOpeningHours(_tmpOpeningHours);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfPrices) ? null : _cursor.getString(_cursorIndexOfPrices);
                List<Price> _tmpPrices = this.__converters.toPriceList(_tmp_2);
                _item.setPrices(_tmpPrices);
                String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                _item.setCurrency(_tmpCurrency);
                String _tmpPriceFormat = _cursor.isNull(_cursorIndexOfPriceFormat) ? null : _cursor.getString(_cursorIndexOfPriceFormat);
                _item.setPriceFormat(_tmpPriceFormat);
                long _tmp_3 = _cursor.getLong(_cursorIndexOfValidFrom);
                Date _tmpValidFrom = this.__converters.toDate(_tmp_3);
                _item.setValidFrom(_tmpValidFrom);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfPaymentMethods) ? null : _cursor.getString(_cursorIndexOfPaymentMethods);
                List<String> _tmpPaymentMethods = this.__converters.toStringList(_tmp_4);
                _item.setPaymentMethods(_tmpPaymentMethods);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsConnectedFuelingAvailable) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsConnectedFuelingAvailable));
                Boolean _tmpIsConnectedFuelingAvailable = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _item.setConnectedFuelingAvailable(_tmpIsConnectedFuelingAvailable);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsOnlineCoFuGasStation) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOnlineCoFuGasStation));
                Boolean _tmpIsOnlineCoFuGasStation = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _item.setOnlineCoFuGasStation(_tmpIsOnlineCoFuGasStation);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfAmenities) ? null : _cursor.getString(_cursorIndexOfAmenities);
                List<String> _tmpAmenities = this.__converters.toStringList(_tmp_7);
                _item.setAmenities(_tmpAmenities);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfFoods) ? null : _cursor.getString(_cursorIndexOfFoods);
                List<String> _tmpFoods = this.__converters.toStringList(_tmp_8);
                _item.setFoods(_tmpFoods);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfLoyaltyPrograms) ? null : _cursor.getString(_cursorIndexOfLoyaltyPrograms);
                List<String> _tmpLoyaltyPrograms = this.__converters.toStringList(_tmp_9);
                _item.setLoyaltyPrograms(_tmpLoyaltyPrograms);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfPostalServices) ? null : _cursor.getString(_cursorIndexOfPostalServices);
                List<String> _tmpPostalServices = this.__converters.toStringList(_tmp_10);
                _item.setPostalServices(_tmpPostalServices);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfServices) ? null : _cursor.getString(_cursorIndexOfServices);
                List<String> _tmpServices = this.__converters.toStringList(_tmp_11);
                _item.setServices(_tmpServices);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfShopGoods) ? null : _cursor.getString(_cursorIndexOfShopGoods);
                List<String> _tmpShopGoods = this.__converters.toStringList(_tmp_12);
                _item.setShopGoods(_tmpShopGoods);
                Integer _tmp_13 = _cursor.isNull(_cursorIndexOfPriceComparisonOptOut) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPriceComparisonOptOut));
                Boolean _tmpPriceComparisonOptOut = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                _item.setPriceComparisonOptOut(_tmpPriceComparisonOptOut);
                String _tmp_14 = _cursor.isNull(_cursorIndexOfCofuPaymentMethods) ? null : _cursor.getString(_cursorIndexOfCofuPaymentMethods);
                List<String> _tmpCofuPaymentMethods = this.__converters.toStringList(_tmp_14);
                _item.setCofuPaymentMethods(_tmpCofuPaymentMethods);
                Integer _tmp_15 = _cursor.isNull(_cursorIndexOfTemporary) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTemporary));
                Boolean _tmpTemporary = _tmp_15 == null ? null : Boolean.valueOf(_tmp_15 != 0);
                _item.setTemporary(_tmpTemporary);
                long _tmp_16 = _cursor.getLong(_cursorIndexOfUpdatedAt);
                Date _tmpUpdatedAt = this.__converters.toDate(_tmp_16);
                _item.setUpdatedAt(_tmpUpdatedAt);
                Double _tmpLatitude = _cursor.isNull(_cursorIndexOfLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLatitude));
                _item.setLatitude(_tmpLatitude);
                Double _tmpLongitude = _cursor.isNull(_cursorIndexOfLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLongitude));
                _item.setLongitude(_tmpLongitude);
                _item.setAddress(_tmpAddress);
                _result.add(_item);
            }
            ArrayList<GasStation> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

