/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.geo;

import android.location.Location;
import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.appkit.app.api.AppAPI;
import cloud.pace.sdk.poikit.POIKit;
import cloud.pace.sdk.poikit.geo.CofuGasStation;
import cloud.pace.sdk.poikit.geo.ConnectedFuelingStatus;
import cloud.pace.sdk.poikit.geo.GeoAPIFeature;
import cloud.pace.sdk.poikit.geo.GeoAPIManager;
import cloud.pace.sdk.poikit.geo.GeoAPIManagerImpl;
import cloud.pace.sdk.poikit.geo.GeoAPIResponse;
import cloud.pace.sdk.poikit.geo.GeoAPIResponseKt;
import cloud.pace.sdk.poikit.geo.GeoGasStation;
import cloud.pace.sdk.poikit.geo.Geometry;
import cloud.pace.sdk.poikit.geo.GeometryCollection;
import cloud.pace.sdk.poikit.geo.Point;
import cloud.pace.sdk.poikit.poi.GasStation;
import cloud.pace.sdk.poikit.poi.LocationPointKt;
import cloud.pace.sdk.poikit.utils.LatLngKt;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.CoroutineUtilsKt;
import cloud.pace.sdk.utils.Failure;
import cloud.pace.sdk.utils.LocationProvider;
import cloud.pace.sdk.utils.Success;
import cloud.pace.sdk.utils.SystemManager;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u0003./0B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ;\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016\u00f8\u0001\u0000J+\u0010\u0017\u001a\u00020\u000e2\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00150\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016\u00f8\u0001\u0000J;\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00150\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016\u00f8\u0001\u0000J;\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00150\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016\u00f8\u0001\u0000J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J)\u0010#\u001a\u00020\"2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010&J#\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J)\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J;\u0010,\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00150\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002\u00f8\u0001\u0000J+\u0010-\u001a\u00020\u000e2\u001e\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00150\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002\u00f8\u0001\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lcloud/pace/sdk/poikit/geo/GeoAPIManagerImpl;", "Lcloud/pace/sdk/poikit/geo/GeoAPIManager;", "appApi", "Lcloud/pace/sdk/appkit/app/api/AppAPI;", "systemManager", "Lcloud/pace/sdk/utils/SystemManager;", "locationProvider", "Lcloud/pace/sdk/utils/LocationProvider;", "(Lcloud/pace/sdk/appkit/app/api/AppAPI;Lcloud/pace/sdk/utils/SystemManager;Lcloud/pace/sdk/utils/LocationProvider;)V", "appsCache", "Lcloud/pace/sdk/poikit/geo/GeoAPIManagerImpl$AppsCache;", "cofuGasStationsCache", "Lcloud/pace/sdk/poikit/geo/GeoAPIManagerImpl$CofuGasStationsCache;", "apps", "", "latitude", "", "longitude", "completion", "Lkotlin/Function1;", "Lkotlin/Result;", "", "Lcloud/pace/sdk/poikit/geo/GeoGasStation;", "cofuGasStations", "Lcloud/pace/sdk/poikit/geo/CofuGasStation;", "location", "Landroid/location/Location;", "radius", "", "Lcloud/pace/sdk/poikit/poi/GasStation;", "features", "Lcloud/pace/sdk/poikit/geo/GeoAPIFeature;", "getApps", "isAppsCacheValid", "", "isInRadius", "center", "Lcom/google/android/gms/maps/model/LatLng;", "(Ljava/lang/Double;Ljava/lang/Double;Lcom/google/android/gms/maps/model/LatLng;)Z", "isPoiInRange", "poiId", "", "(Ljava/lang/String;Landroid/location/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/String;DDLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAppsCache", "loadCofuGasStationsCache", "AppsCache", "CofuGasStationsCache", "Companion", "cloud.pace.sdk"})
public final class GeoAPIManagerImpl
implements GeoAPIManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppAPI appApi;
    @NotNull
    private final SystemManager systemManager;
    @NotNull
    private final LocationProvider locationProvider;
    @Nullable
    private AppsCache appsCache;
    @Nullable
    private CofuGasStationsCache cofuGasStationsCache;
    @NotNull
    public static final String FUELING_TYPE = "fueling";
    @NotNull
    public static final String APPS_KEY = "apps";
    @NotNull
    public static final String TYPE_KEY = "type";
    @NotNull
    public static final String URL_KEY = "url";
    @NotNull
    public static final String CONNECTED_FUELING_STATUS_KEY = "connectedFuelingStatus";
    private static final int CACHE_MAX_AGE = 3600000;
    private static final int CACHE_RADIUS = 30000;
    private static final int IS_POI_IN_RANGE_DISTANCE_THRESHOLD = 500;

    public GeoAPIManagerImpl(@NotNull AppAPI appApi, @NotNull SystemManager systemManager, @NotNull LocationProvider locationProvider) {
        Intrinsics.checkNotNullParameter((Object)appApi, (String)"appApi");
        Intrinsics.checkNotNullParameter((Object)systemManager, (String)"systemManager");
        Intrinsics.checkNotNullParameter((Object)locationProvider, (String)"locationProvider");
        this.appApi = appApi;
        this.systemManager = systemManager;
        this.locationProvider = locationProvider;
        this.loadCofuGasStationsCache((Function1<? super Result<? extends List<CofuGasStation>>, Unit>)((Function1)1.INSTANCE));
        boolean $i$f$onBackgroundThread = false;
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, this){
            int label;
            final /* synthetic */ GeoAPIManagerImpl this$0;
            {
                this.this$0 = geoAPIManagerImpl;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        (Continuation)this;
                        $i$a$-onBackgroundThread-GeoAPIManagerImpl$2 = false;
                        this.label = 1;
                        v0 = GeoAPIManagerImpl.access$getLocationProvider$p(this.this$0).currentLocation(false, (Continuation<? super Completion<Location>>)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        $i$a$-onBackgroundThread-GeoAPIManagerImpl$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if ((completion = (Completion)v0) instanceof Success) {
                            location = (Location)((Success)completion).getResult();
                            if (location != null) {
                                GeoAPIManagerImpl.access$loadAppsCache(this.this$0, location.getLatitude(), location.getLongitude(), 2.1.INSTANCE);
                            } else {
                                Timber.Forest.e("Failed loading initial apps cache because location is null", new Object[0]);
                            }
                        } else if (completion instanceof Failure) {
                            Timber.Forest.e(((Failure)completion).getThrowable(), "Failed loading initial apps cache", new Object[0]);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void apps(double latitude, double longitude, @NotNull Function1<? super Result<? extends List<GeoGasStation>>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.isAppsCacheValid(latitude, longitude)) {
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl(this.getApps(latitude, longitude))));
        } else {
            this.loadAppsCache(latitude, longitude, (Function1<? super Result<? extends List<GeoAPIFeature>>, Unit>)((Function1)new Function1<Result<? extends List<? extends GeoAPIFeature>>, Unit>(completion, this, latitude, longitude){
                final /* synthetic */ Function1<Result<? extends List<GeoGasStation>>, Unit> $completion;
                final /* synthetic */ GeoAPIManagerImpl this$0;
                final /* synthetic */ double $latitude;
                final /* synthetic */ double $longitude;
                {
                    this.$completion = $completion;
                    this.this$0 = $receiver;
                    this.$latitude = $latitude;
                    this.$longitude = $longitude;
                    super(1);
                }

                public final void invoke(@NotNull Object it) {
                    Object object = it;
                    Function1<Result<? extends List<GeoGasStation>>, Unit> function1 = this.$completion;
                    GeoAPIManagerImpl geoAPIManagerImpl = this.this$0;
                    double d = this.$latitude;
                    double d2 = this.$longitude;
                    if (Result.isSuccess-impl((Object)object)) {
                        List it2 = (List)object;
                        boolean bl = false;
                        function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)GeoAPIManagerImpl.access$getApps(geoAPIManagerImpl, d, d2))));
                    }
                    object = it;
                    function1 = this.$completion;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        boolean bl = false;
                        function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2))));
                    }
                }
            }));
        }
    }

    @Override
    public void features(double latitude, double longitude, @NotNull Function1<? super Result<? extends List<GeoAPIFeature>>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.isAppsCacheValid(latitude, longitude)) {
            AppsCache appsCache = this.appsCache;
            List list = appsCache == null ? null : appsCache.getFeatures();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl(list)));
        } else {
            this.loadAppsCache(latitude, longitude, completion);
        }
    }

    @Override
    public void cofuGasStations(@NotNull Function1<? super Result<? extends List<CofuGasStation>>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        CofuGasStationsCache cache = this.cofuGasStationsCache;
        if (cache != null && this.systemManager.getCurrentTimeMillis() - cache.getTime() <= 3600000L) {
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl(cache.getCofuGasStations())));
        } else {
            this.loadCofuGasStationsCache(completion);
        }
    }

    @Override
    public void cofuGasStations(@NotNull Location location2, int radius, @NotNull Function1<? super Result<? extends List<? extends GasStation>>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        this.cofuGasStations((Function1<? super Result<? extends List<CofuGasStation>>, Unit>)((Function1)new Function1<Result<? extends List<? extends CofuGasStation>>, Unit>(location2, radius, completion){
            final /* synthetic */ Location $location;
            final /* synthetic */ int $radius;
            final /* synthetic */ Function1<Result<? extends List<? extends GasStation>>, Unit> $completion;
            {
                this.$location = $location;
                this.$radius = $radius;
                this.$completion = $completion;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Object result2) {
                LatLng targetLocation = new LatLng(this.$location.getLatitude(), this.$location.getLongitude());
                Object object = result2;
                int n = this.$radius;
                Function1<Result<? extends List<? extends GasStation>>, Unit> function1 = this.$completion;
                if (Result.isSuccess-impl((Object)object)) {
                    void $this$mapTo$iv$iv;
                    void $this$filterTo$iv$iv;
                    List cofuGasStations2 = (List)object;
                    boolean bl = false;
                    Iterable $this$filter$iv = cofuGasStations2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Iterable<T> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        CofuGasStation station = (CofuGasStation)element$iv$iv;
                        boolean bl2 = false;
                        if (!(LatLngKt.distanceTo(station.getCoordinate(), targetLocation) < (double)n)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List cofuGasStationsInRange = (List)destination$iv$iv;
                    Iterable $this$map$iv = cofuGasStationsInRange;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void station;
                        CofuGasStation bl2 = (CofuGasStation)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(TuplesKt.to((Object)station.getId(), (Object)LocationPointKt.toLocationPoint(station.getCoordinate())));
                    }
                    Map locations = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                    POIKit.requestGasStations$default(POIKit.INSTANCE, locations, 0, (Function1)new Function1<Completion<List<? extends GasStation>>, Unit>(function1, (List<CofuGasStation>)cofuGasStationsInRange){
                        final /* synthetic */ Function1<Result<? extends List<? extends GasStation>>, Unit> $completion;
                        final /* synthetic */ List<CofuGasStation> $cofuGasStationsInRange;
                        {
                            this.$completion = $completion;
                            this.$cofuGasStationsInRange = $cofuGasStationsInRange;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Completion<List<GasStation>> gasStations2) {
                            Intrinsics.checkNotNullParameter(gasStations2, (String)"gasStations");
                            Completion<List<GasStation>> completion = gasStations2;
                            if (completion instanceof Success) {
                                void $this$mapNotNullTo$iv$iv;
                                void $this$mapNotNull$iv;
                                Iterable iterable = (Iterable)((Success)gasStations2).getResult();
                                List<CofuGasStation> list = this.$cofuGasStationsInRange;
                                boolean $i$f$mapNotNull = false;
                                void var7_6 = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    GasStation gasStation;
                                    Object v0;
                                    GasStation gasStation2;
                                    block7: {
                                        T element$iv$iv$iv;
                                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                                        boolean bl = false;
                                        gasStation2 = (GasStation)element$iv$iv;
                                        boolean bl2 = false;
                                        Iterable $this$firstOrNull$iv = list;
                                        boolean $i$f$firstOrNull = false;
                                        for (T element$iv : $this$firstOrNull$iv) {
                                            CofuGasStation it = (CofuGasStation)element$iv;
                                            boolean bl3 = false;
                                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)gasStation2.getId())) continue;
                                            v0 = element$iv;
                                            break block7;
                                        }
                                        v0 = null;
                                    }
                                    CofuGasStation cofuGasStation = v0;
                                    if (cofuGasStation != null) {
                                        GasStation gasStation3;
                                        GasStation it = gasStation3 = gasStation2;
                                        boolean bl = false;
                                        it.setAdditionalProperties(cofuGasStation.getProperties());
                                        gasStation = gasStation3;
                                    } else {
                                        gasStation = null;
                                    }
                                    if (gasStation == null) continue;
                                    GasStation it$iv$iv = gasStation;
                                    boolean bl = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                List cofuStations = (List)destination$iv$iv;
                                this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)cofuStations)));
                            } else if (completion instanceof Failure) {
                                this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Failure)gasStations2).getThrowable()))));
                            }
                        }
                    }, 2, null);
                }
                object = result2;
                Function1<Result<? extends List<? extends GasStation>>, Unit> function12 = this.$completion;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    function12.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
                }
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object isPoiInRange(@NotNull String var1_1, @Nullable Location var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        block15: {
            block14: {
                block13: {
                    if (!(var3_3 instanceof isPoiInRange.1)) ** GOTO lbl-1000
                    var9_4 = var3_3;
                    if ((var9_4.label & -2147483648) != 0) {
                        var9_4.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var3_3){
                            Object L$0;
                            Object L$1;
                            /* synthetic */ Object result;
                            final /* synthetic */ GeoAPIManagerImpl this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.isPoiInRange(null, null, (Continuation<? super Boolean>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (location != null) ** GOTO lbl54
                            $continuation.L$0 = this;
                            $continuation.L$1 = poiId;
                            $continuation.label = 1;
                            v0 = this.locationProvider.currentLocation(true, (Continuation<? super Completion<Location>>)$continuation);
                            if (v0 == var10_6) {
                                return var10_6;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            poiId = (String)$continuation.L$1;
                            this = (GeoAPIManagerImpl)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            if (!((currentLocation = (Completion)v0) instanceof Success)) break block13;
                            var6_8 = (Location)((Success)currentLocation).getResult();
                            if (var6_8 != null) break;
                            $continuation.L$0 = this;
                            $continuation.L$1 = poiId;
                            $continuation.label = 2;
                            v1 = this.locationProvider.firstValidLocation((Continuation<? super Completion<Location>>)$continuation);
                            if (v1 == var10_6) {
                                return var10_6;
                            }
                            ** GOTO lbl40
                        }
                        case 2: {
                            poiId = (String)$continuation.L$1;
                            this = (GeoAPIManagerImpl)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl40:
                            // 2 sources

                            if (!((validLocation = (Completion)v1) instanceof Success)) ** GOTO lbl43
                            v2 = (Location)((Success)validLocation).getResult();
                            break block14;
lbl43:
                            // 1 sources

                            if (!(validLocation instanceof Failure)) ** GOTO lbl46
                            v2 = null;
                            break block14;
lbl46:
                            // 1 sources

                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    v2 = var6_8;
                    break block14;
                }
                if (currentLocation instanceof Failure) {
                    v2 = null;
                } else {
                    throw new NoWhenBranchMatchedException();
lbl54:
                    // 1 sources

                    v2 = userLocation = var2_2;
                }
            }
            if (userLocation == null) break block15;
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.label = 3;
            v3 = this.isPoiInRange(poiId, userLocation.getLatitude(), userLocation.getLongitude(), (Continuation<? super Boolean>)$continuation);
            if (v3 == var10_6) {
                return var10_6;
            }
            ** GOTO lbl67
            {
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl67:
                    // 2 sources

                    return v3;
                }
            }
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<GeoGasStation> getApps(double latitude, double longitude) {
        List list;
        AppsCache appsCache = this.appsCache;
        if (appsCache == null) {
            list = null;
        } else {
            List<GeoAPIFeature> list2 = appsCache.getFeatures();
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                GeoAPIFeature it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = list2;
                boolean $i$f$filter = false;
                void var11_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (GeoAPIFeature)element$iv$iv;
                    boolean bl = false;
                    if (!GeoAPIResponseKt.isInRange(it, latitude, longitude, PACECloudSDK.INSTANCE.getConfiguration$cloud_pace_sdk().getAppsDistanceThresholdInMeters())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                $this$filter$iv = list3;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (GeoAPIFeature)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Map appUrls = new LinkedHashMap();
                    Object object = it.getProperties().get(APPS_KEY);
                    List list4 = object instanceof List ? (List)object : null;
                    if (list4 != null) {
                        Iterable $this$forEach$iv = list4;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            Set set;
                            Set set2;
                            String url;
                            Object element$iv;
                            Object app = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map map = app instanceof Map ? (Map)app : null;
                            if (map == null) continue;
                            Map<String, Object> map2 = map;
                            Object object2 = TYPE_KEY;
                            Object v = map2.get(object2);
                            String type = v instanceof String ? (String)v : null;
                            object2 = map;
                            Object[] objectArray = "url";
                            map2 = object2.get(objectArray);
                            String string2 = url = map2 instanceof String ? (String)((Object)map2) : null;
                            if (type == null || url == null) continue;
                            map2 = appUrls;
                            if ((Set)appUrls.get(type) == null) {
                                set2 = null;
                            } else {
                                Set set3;
                                Set $this$getApps_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = set3;
                                boolean bl3 = false;
                                $this$getApps_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.add(url);
                                set2 = set = set3;
                            }
                            if (set2 == null) {
                                objectArray = new String[]{url};
                                set = SetsKt.mutableSetOf((Object[])objectArray);
                            }
                            object2 = set;
                            map2.put(type, object2);
                        }
                    }
                    collection.add(new GeoGasStation(it.getId(), appUrls));
                }
                list = (List)destination$iv$iv;
            }
        }
        List list5 = list;
        return list5 == null ? CollectionsKt.emptyList() : list5;
    }

    private final void loadAppsCache(double latitude, double longitude, Function1<? super Result<? extends List<GeoAPIFeature>>, Unit> completion) {
        this.appApi.getGeoApiApps((Function1<? super Result<GeoAPIResponse>, Unit>)((Function1)new Function1<Result<? extends GeoAPIResponse>, Unit>(latitude, longitude, this, completion){
            final /* synthetic */ double $latitude;
            final /* synthetic */ double $longitude;
            final /* synthetic */ GeoAPIManagerImpl this$0;
            final /* synthetic */ Function1<Result<? extends List<GeoAPIFeature>>, Unit> $completion;
            {
                this.$latitude = $latitude;
                this.$longitude = $longitude;
                this.this$0 = $receiver;
                this.$completion = $completion;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Object result2) {
                Object object = result2;
                double d = this.$latitude;
                double d2 = this.$longitude;
                GeoAPIManagerImpl geoAPIManagerImpl = this.this$0;
                Function1<Result<? extends List<GeoAPIFeature>>, Unit> function1 = this.$completion;
                if (Result.isSuccess-impl((Object)object)) {
                    void $this$filterTo$iv$iv;
                    GeoAPIResponse response = (GeoAPIResponse)object;
                    boolean bl = false;
                    LatLng center = new LatLng(d, d2);
                    long time = GeoAPIManagerImpl.access$getSystemManager$p(geoAPIManagerImpl).getCurrentTimeMillis();
                    Iterable $this$filter$iv = response.getFeatures();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        boolean bl2;
                        block6: {
                            GeoAPIFeature it = (GeoAPIFeature)element$iv$iv;
                            boolean bl3 = false;
                            Iterable $this$all$iv = GeoAPIResponseKt.coordinates(it);
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    LatLng coordinate2 = (LatLng)element$iv;
                                    boolean bl4 = false;
                                    if (GeoAPIManagerImpl.access$isInRadius(geoAPIManagerImpl, coordinate2.latitude, coordinate2.longitude, center)) continue;
                                    bl2 = false;
                                    break block6;
                                }
                                bl2 = true;
                            }
                        }
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List features = (List)destination$iv$iv;
                    GeoAPIManagerImpl.access$setAppsCache$p(geoAPIManagerImpl, new AppsCache(features, time, center));
                    function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)features)));
                }
                object = result2;
                Function1<Result<? extends List<GeoAPIFeature>>, Unit> function12 = this.$completion;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    function12.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
                }
            }
        }));
    }

    private final void loadCofuGasStationsCache(Function1<? super Result<? extends List<CofuGasStation>>, Unit> completion) {
        this.appApi.getGeoApiApps((Function1<? super Result<GeoAPIResponse>, Unit>)((Function1)new Function1<Result<? extends GeoAPIResponse>, Unit>(this, completion){
            final /* synthetic */ GeoAPIManagerImpl this$0;
            final /* synthetic */ Function1<Result<? extends List<CofuGasStation>>, Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$completion = $completion;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Object result2) {
                Object object = result2;
                Function1<Result<? extends List<CofuGasStation>>, Unit> function1 = this.this$0;
                Function1<Result<? extends List<CofuGasStation>>, Unit> function12 = this.$completion;
                if (Result.isSuccess-impl((Object)object)) {
                    void $this$mapTo$iv$iv;
                    GeoAPIResponse response = (GeoAPIResponse)object;
                    boolean bl = false;
                    long time = GeoAPIManagerImpl.access$getSystemManager$p(function1).getCurrentTimeMillis();
                    Iterable $this$map$iv = response.getFeatures();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void $this$mapNotNullTo$iv$iv;
                        List list;
                        void it;
                        GeoAPIFeature geoAPIFeature = (GeoAPIFeature)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        Geometry geometry = it.getGeometry();
                        if (geometry instanceof GeometryCollection) {
                            void $this$filterIsInstanceTo$iv$iv;
                            Iterable $this$filterIsInstance$iv = ((GeometryCollection)it.getGeometry()).getGeometries();
                            boolean $i$f$filterIsInstance = false;
                            Iterable iterable2 = $this$filterIsInstance$iv;
                            Collection destination$iv$iv2 = new ArrayList<E>();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof Point)) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            list = (List)destination$iv$iv2;
                        } else {
                            list = geometry instanceof Point ? CollectionsKt.listOf((Object)it.getGeometry()) : CollectionsKt.emptyList();
                        }
                        List points = list;
                        Iterable $this$mapNotNull$iv = points;
                        boolean $i$f$mapNotNull = false;
                        Iterable $i$f$filterIsInstance = $this$mapNotNull$iv;
                        Collection destination$iv$iv3 = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            CofuGasStation it$iv$iv;
                            ConnectedFuelingStatus connectedFuelingStatus;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl3 = false;
                            Point point = (Point)element$iv$iv;
                            boolean bl4 = false;
                            Double lat = (Double)CollectionsKt.lastOrNull(point.getCoordinates());
                            Double lng = (Double)CollectionsKt.firstOrNull(point.getCoordinates());
                            Object object2 = it.getProperties().get("connectedFuelingStatus");
                            if ((object2 instanceof String ? (String)object2 : null) == null) {
                                connectedFuelingStatus = null;
                            } else {
                                void $this$associateByTo$iv$iv;
                                String status;
                                status = status;
                                boolean bl5 = false;
                                ConnectedFuelingStatus[] $this$associateBy$iv = ConnectedFuelingStatus.values();
                                boolean $i$f$associateBy = false;
                                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
                                ConnectedFuelingStatus[] connectedFuelingStatusArray = $this$associateBy$iv;
                                Map destination$iv$iv4 = new LinkedHashMap<K, V>(capacity$iv);
                                boolean $i$f$associateByTo = false;
                                for (void element$iv$iv2 : $this$associateByTo$iv$iv) {
                                    void p0;
                                    void var48_53 = element$iv$iv2;
                                    Map map = destination$iv$iv4;
                                    boolean bl6 = false;
                                    map.put(p0.getValue(), element$iv$iv2);
                                }
                                connectedFuelingStatus = (ConnectedFuelingStatus)((Object)destination$iv$iv4.get(status));
                            }
                            ConnectedFuelingStatus status = connectedFuelingStatus;
                            if ((lat != null && lng != null ? new CofuGasStation(it.getId(), new LatLng(lat.doubleValue(), lng.doubleValue()), status, it.getProperties()) : (CofuGasStation)null) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl7 = false;
                            destination$iv$iv3.add(it$iv$iv);
                        }
                        collection.add((List)destination$iv$iv3);
                    }
                    List cofuGasStations2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    GeoAPIManagerImpl.access$setCofuGasStationsCache$p(function1, new CofuGasStationsCache(cofuGasStations2, time));
                    function12.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)cofuGasStations2)));
                }
                object = result2;
                function1 = this.$completion;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
                }
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final Object isPoiInRange(String var1_1, double var2_2, double var4_3, Continuation<? super Boolean> var6_4) {
        if (!(var6_4 instanceof isPoiInRange.2)) ** GOTO lbl-1000
        var14_5 = var6_4;
        if ((var14_5.label & -2147483648) != 0) {
            var14_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_4){
                Object L$0;
                Object L$1;
                double D$0;
                double D$1;
                /* synthetic */ Object result;
                final /* synthetic */ GeoAPIManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GeoAPIManagerImpl.access$isPoiInRange(this.this$0, null, 0.0, 0.0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = poiId;
                $continuation.D$0 = latitude;
                $continuation.D$1 = longitude;
                $continuation.label = 1;
                uCont$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                cancellable$iv.initCancellability();
                continuation = (CancellableContinuation)cancellable$iv;
                $i$a$-suspendCancellableCoroutine-GeoAPIManagerImpl$isPoiInRange$3 = false;
                this.features((double)latitude, (double)longitude, (Function1<? super Result<? extends List<GeoAPIFeature>>, Unit>)((Function1)new Function1<Result<? extends List<? extends GeoAPIFeature>>, Unit>((double)latitude, (double)longitude, (CancellableContinuation<? super Boolean>)continuation, (String)poiId){
                    final /* synthetic */ double $latitude;
                    final /* synthetic */ double $longitude;
                    final /* synthetic */ CancellableContinuation<Boolean> $continuation;
                    final /* synthetic */ String $poiId;
                    {
                        this.$latitude = $latitude;
                        this.$longitude = $longitude;
                        this.$continuation = $continuation;
                        this.$poiId = $poiId;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Object response) {
                        Object object = response;
                        double d = this.$latitude;
                        double d2 = this.$longitude;
                        CancellableContinuation<Boolean> cancellableContinuation = this.$continuation;
                        String string2 = this.$poiId;
                        if (Result.isSuccess-impl((Object)object)) {
                            boolean bl;
                            Object v0;
                            block3: {
                                void $this$firstOrNull$iv;
                                List geoAPIFeatures = (List)object;
                                boolean bl2 = false;
                                Iterable iterable = geoAPIFeatures;
                                boolean $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    GeoAPIFeature it = (GeoAPIFeature)element$iv;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)string2)) continue;
                                    v0 = element$iv;
                                    break block3;
                                }
                                v0 = null;
                            }
                            GeoAPIFeature geoAPIFeature = v0;
                            boolean isPoiInRange2 = geoAPIFeature == null ? false : (bl = GeoAPIResponseKt.isInRange(geoAPIFeature, d, d2, 500));
                            CoroutineUtilsKt.resumeIfActive(cancellableContinuation, isPoiInRange2);
                        }
                        object = response;
                        CancellableContinuation<Boolean> cancellableContinuation2 = this.$continuation;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable != null) {
                            Throwable it = throwable;
                            boolean bl = false;
                            CoroutineUtilsKt.resumeIfActive(cancellableContinuation2, false);
                        }
                    }
                }));
                v0 = cancellable$iv.getResult();
                if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v1 = v0;
                if (v0 == var15_7) {
                    return var15_7;
                }
                ** GOTO lbl49
            }
            case 1: {
                $i$f$suspendCancellableCoroutine = false;
                $continuation.D$1;
                $continuation.D$0;
                (String)$continuation.L$1;
                this = (GeoAPIManagerImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    var7_8 = (Boolean)v1;
                }
                catch (Exception var8_10) {
                    var7_8 = false;
                }
                return Boxing.boxBoolean((boolean)(var7_8 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isAppsCacheValid(double latitude, double longitude) {
        AppsCache cache = this.appsCache;
        return cache != null && this.isInRadius(latitude, longitude, cache.getCenter()) && this.systemManager.getCurrentTimeMillis() - cache.getTime() <= 3600000L;
    }

    private final boolean isInRadius(Double latitude, Double longitude, LatLng center) {
        return latitude != null && longitude != null ? LatLngKt.distanceTo(new LatLng(latitude.doubleValue(), longitude.doubleValue()), center) < 30000.0 : false;
    }

    public static final /* synthetic */ List access$getApps(GeoAPIManagerImpl $this, double latitude, double longitude) {
        return $this.getApps(latitude, longitude);
    }

    public static final /* synthetic */ boolean access$isInRadius(GeoAPIManagerImpl $this, Double latitude, Double longitude, LatLng center) {
        return $this.isInRadius(latitude, longitude, center);
    }

    public static final /* synthetic */ SystemManager access$getSystemManager$p(GeoAPIManagerImpl $this) {
        return $this.systemManager;
    }

    public static final /* synthetic */ void access$setAppsCache$p(GeoAPIManagerImpl $this, AppsCache appsCache) {
        $this.appsCache = appsCache;
    }

    public static final /* synthetic */ void access$setCofuGasStationsCache$p(GeoAPIManagerImpl $this, CofuGasStationsCache cofuGasStationsCache) {
        $this.cofuGasStationsCache = cofuGasStationsCache;
    }

    public static final /* synthetic */ Object access$isPoiInRange(GeoAPIManagerImpl $this, String poiId, double latitude, double longitude, Continuation $completion) {
        return $this.isPoiInRange(poiId, latitude, longitude, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ LocationProvider access$getLocationProvider$p(GeoAPIManagerImpl $this) {
        return $this.locationProvider;
    }

    public static final /* synthetic */ void access$loadAppsCache(GeoAPIManagerImpl $this, double latitude, double longitude, Function1 completion) {
        $this.loadAppsCache(latitude, longitude, (Function1<? super Result<? extends List<GeoAPIFeature>>, Unit>)completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcloud/pace/sdk/poikit/geo/GeoAPIManagerImpl$AppsCache;", "", "features", "", "Lcloud/pace/sdk/poikit/geo/GeoAPIFeature;", "time", "", "center", "Lcom/google/android/gms/maps/model/LatLng;", "(Ljava/util/List;JLcom/google/android/gms/maps/model/LatLng;)V", "getCenter", "()Lcom/google/android/gms/maps/model/LatLng;", "getFeatures", "()Ljava/util/List;", "getTime", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cloud.pace.sdk"})
    public static final class AppsCache {
        @NotNull
        private final List<GeoAPIFeature> features;
        private final long time;
        @NotNull
        private final LatLng center;

        public AppsCache(@NotNull List<GeoAPIFeature> features, long time, @NotNull LatLng center) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            this.features = features;
            this.time = time;
            this.center = center;
        }

        @NotNull
        public final List<GeoAPIFeature> getFeatures() {
            return this.features;
        }

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final LatLng getCenter() {
            return this.center;
        }

        @NotNull
        public final List<GeoAPIFeature> component1() {
            return this.features;
        }

        public final long component2() {
            return this.time;
        }

        @NotNull
        public final LatLng component3() {
            return this.center;
        }

        @NotNull
        public final AppsCache copy(@NotNull List<GeoAPIFeature> features, long time, @NotNull LatLng center) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            return new AppsCache(features, time, center);
        }

        public static /* synthetic */ AppsCache copy$default(AppsCache appsCache, List list, long l, LatLng latLng, int n, Object object) {
            if ((n & 1) != 0) {
                list = appsCache.features;
            }
            if ((n & 2) != 0) {
                l = appsCache.time;
            }
            if ((n & 4) != 0) {
                latLng = appsCache.center;
            }
            return appsCache.copy(list, l, latLng);
        }

        @NotNull
        public String toString() {
            return "AppsCache(features=" + this.features + ", time=" + this.time + ", center=" + this.center + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.features).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.time);
            result2 = result2 * 31 + this.center.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppsCache)) {
                return false;
            }
            AppsCache appsCache = (AppsCache)other;
            if (!Intrinsics.areEqual(this.features, appsCache.features)) {
                return false;
            }
            if (this.time != appsCache.time) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.center, (Object)appsCache.center);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcloud/pace/sdk/poikit/geo/GeoAPIManagerImpl$CofuGasStationsCache;", "", "cofuGasStations", "", "Lcloud/pace/sdk/poikit/geo/CofuGasStation;", "time", "", "(Ljava/util/List;J)V", "getCofuGasStations", "()Ljava/util/List;", "getTime", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cloud.pace.sdk"})
    public static final class CofuGasStationsCache {
        @NotNull
        private final List<CofuGasStation> cofuGasStations;
        private final long time;

        public CofuGasStationsCache(@NotNull List<CofuGasStation> cofuGasStations2, long time) {
            Intrinsics.checkNotNullParameter(cofuGasStations2, (String)"cofuGasStations");
            this.cofuGasStations = cofuGasStations2;
            this.time = time;
        }

        @NotNull
        public final List<CofuGasStation> getCofuGasStations() {
            return this.cofuGasStations;
        }

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final List<CofuGasStation> component1() {
            return this.cofuGasStations;
        }

        public final long component2() {
            return this.time;
        }

        @NotNull
        public final CofuGasStationsCache copy(@NotNull List<CofuGasStation> cofuGasStations2, long time) {
            Intrinsics.checkNotNullParameter(cofuGasStations2, (String)"cofuGasStations");
            return new CofuGasStationsCache(cofuGasStations2, time);
        }

        public static /* synthetic */ CofuGasStationsCache copy$default(CofuGasStationsCache cofuGasStationsCache, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = cofuGasStationsCache.cofuGasStations;
            }
            if ((n & 2) != 0) {
                l = cofuGasStationsCache.time;
            }
            return cofuGasStationsCache.copy(list, l);
        }

        @NotNull
        public String toString() {
            return "CofuGasStationsCache(cofuGasStations=" + this.cofuGasStations + ", time=" + this.time + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.cofuGasStations).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.time);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CofuGasStationsCache)) {
                return false;
            }
            CofuGasStationsCache cofuGasStationsCache = (CofuGasStationsCache)other;
            if (!Intrinsics.areEqual(this.cofuGasStations, cofuGasStationsCache.cofuGasStations)) {
                return false;
            }
            return this.time == cofuGasStationsCache.time;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcloud/pace/sdk/poikit/geo/GeoAPIManagerImpl$Companion;", "", "()V", "APPS_KEY", "", "CACHE_MAX_AGE", "", "CACHE_RADIUS", "CONNECTED_FUELING_STATUS_KEY", "FUELING_TYPE", "IS_POI_IN_RANGE_DISTANCE_THRESHOLD", "TYPE_KEY", "URL_KEY", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

