/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.geo;

import cloud.pace.sdk.poikit.geo.GeoAPIFeature;
import cloud.pace.sdk.poikit.geo.Geometry;
import cloud.pace.sdk.poikit.geo.GeometryCollection;
import cloud.pace.sdk.poikit.geo.Point;
import cloud.pace.sdk.poikit.geo.Polygon;
import cloud.pace.sdk.poikit.utils.LatLngKt;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007\u001a\"\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0010\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"GEOMETRY_COLLECTION_NAME", "", "POINT_NAME", "POLYGON_NAME", "coordinates", "", "Lcom/google/android/gms/maps/model/LatLng;", "Lcloud/pace/sdk/poikit/geo/GeoAPIFeature;", "isInRange", "", "latitude", "", "longitude", "distanceThresholdInMeters", "", "toLatLngs", "Lcloud/pace/sdk/poikit/geo/Point;", "Lcloud/pace/sdk/poikit/geo/Polygon;", "cloud.pace.sdk"})
public final class GeoAPIResponseKt {
    @NotNull
    public static final String POLYGON_NAME = "Polygon";
    @NotNull
    public static final String POINT_NAME = "Point";
    @NotNull
    public static final String GEOMETRY_COLLECTION_NAME = "GeometryCollection";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LatLng> coordinates(@NotNull GeoAPIFeature $this$coordinates) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$coordinates, (String)"<this>");
        Geometry geometry = $this$coordinates.getGeometry();
        if (geometry instanceof GeometryCollection) {
            Collection collection;
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((GeometryCollection)$this$coordinates.getGeometry()).getGeometries();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Point)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Point point = (Point)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = GeoAPIResponseKt.toLatLngs(point);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            if (collection2.isEmpty()) {
                void $this$flatMapTo$iv$iv2;
                void $this$flatMap$iv2;
                void $this$filterIsInstanceTo$iv$iv2;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv2 = ((GeometryCollection)$this$coordinates.getGeometry()).getGeometries();
                boolean $i$f$filterIsInstance2 = false;
                Iterable $i$f$flatMapTo2 = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof Polygon)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
                boolean $i$f$flatMap2 = false;
                $this$filterIsInstanceTo$iv$iv2 = $this$flatMap$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    Polygon polygon = (Polygon)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = GeoAPIResponseKt.toLatLngs(polygon);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                collection = (List)destination$iv$iv2;
            } else {
                collection = collection2;
            }
            list = (List)collection;
        } else if (geometry instanceof Point) {
            list = GeoAPIResponseKt.toLatLngs((Point)$this$coordinates.getGeometry());
        } else if (geometry instanceof Polygon) {
            list = GeoAPIResponseKt.toLatLngs((Polygon)$this$coordinates.getGeometry());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    public static final boolean isInRange(@NotNull GeoAPIFeature $this$isInRange, double latitude, double longitude, int distanceThresholdInMeters) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isInRange, (String)"<this>");
            Iterable $this$any$iv = GeoAPIResponseKt.coordinates($this$isInRange);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LatLng coordinate2 = (LatLng)element$iv;
                    boolean bl2 = false;
                    if (!(LatLngKt.distanceTo(coordinate2, new LatLng(latitude, longitude)) < (double)distanceThresholdInMeters)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final List<LatLng> toLatLngs(@NotNull Point $this$toLatLngs) {
        Intrinsics.checkNotNullParameter((Object)$this$toLatLngs, (String)"<this>");
        Double lat = (Double)CollectionsKt.lastOrNull($this$toLatLngs.getCoordinates());
        Double lng = (Double)CollectionsKt.firstOrNull($this$toLatLngs.getCoordinates());
        return lat != null && lng != null ? CollectionsKt.listOf((Object)new LatLng(lat.doubleValue(), lng.doubleValue())) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LatLng> toLatLngs(@NotNull Polygon $this$toLatLngs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toLatLngs, (String)"<this>");
        Iterable $this$flatMap$iv = $this$toLatLngs.getCoordinates();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            List ring = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = ring;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LatLng it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                List coordinate2 = (List)element$iv$iv2;
                boolean bl3 = false;
                Double lat = (Double)CollectionsKt.lastOrNull((List)coordinate2);
                Double lng = (Double)CollectionsKt.firstOrNull((List)coordinate2);
                if ((lat != null && lng != null ? new LatLng(lat.doubleValue(), lng.doubleValue()) : (LatLng)null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

