/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.poi;

import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.poi.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vector_tile.VectorTile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\b"}, d2={"Lcloud/pace/sdk/poikit/poi/Geometry;", "", "()V", "Command", "CommandGeo", "CommandType", "CommandTypeAndCount", "Companion", "cloud.pace.sdk"})
public final class Geometry {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006H\u0002J:\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0004j\b\u0012\u0004\u0012\u00020\f`\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0015\u001a\u00020\u0016J,\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"Lcloud/pace/sdk/poikit/poi/Geometry$Companion;", "", "()V", "convertPoints", "Ljava/util/ArrayList;", "Lcloud/pace/sdk/poikit/poi/Geometry$Command;", "Lkotlin/collections/ArrayList;", "commands", "convertToCommands", "commandType", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "params", "", "extractCommandTypeAndCount", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandTypeAndCount;", "value", "getParamCount", "ct", "makeCommand", "type", "processGeometry", "feature", "Lvector_tile/VectorTile$Tile$Feature;", "processGeometryWithList", "geometry", "", "featureGeomType", "Lvector_tile/VectorTile$Tile$GeomType;", "cloud.pace.sdk"})
    public static final class Companion {
        private Companion() {
        }

        private final int getParamCount(CommandType ct) {
            return 2;
        }

        private final CommandType makeCommand(int type) {
            CommandType commandType;
            switch (type) {
                case 1: {
                    commandType = CommandType.MOVETO;
                    break;
                }
                case 2: {
                    commandType = CommandType.LINETO;
                    break;
                }
                default: {
                    commandType = null;
                }
            }
            return commandType;
        }

        @NotNull
        public final ArrayList<Command> processGeometryWithList(@NotNull List<Integer> geometry, @NotNull VectorTile.Tile.GeomType featureGeomType) {
            Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
            Intrinsics.checkNotNullParameter((Object)((Object)featureGeomType), (String)"featureGeomType");
            ArrayList<Command> commands = new ArrayList<Command>();
            int index = 0;
            while (index < geometry.size()) {
                CommandTypeAndCount cac = this.extractCommandTypeAndCount(((Number)geometry.get(index)).intValue());
                if (featureGeomType == VectorTile.Tile.GeomType.POINT && cac.getCommandType() == CommandType.MOVETO && cac.getCount() == 0) {
                    cac.setCount(2);
                }
                int n = index;
                index = n + 1;
                int index2 = 0;
                ArrayList<Integer> parameters = new ArrayList<Integer>();
                while (index2 < cac.getCount() && index < geometry.size()) {
                    int value = ((Number)geometry.get(index)).intValue();
                    int param = value >> 1 ^ -(value & 1);
                    parameters.add(param);
                    int n2 = index2;
                    index2 = n2 + 1;
                    n2 = index;
                    index = n2 + 1;
                }
                if (parameters.size() != cac.getCount() || cac.getCommandType() == null) continue;
                commands.addAll((Collection<Command>)this.convertToCommands(cac.getCommandType(), parameters));
            }
            return this.convertPoints(commands);
        }

        @NotNull
        public final ArrayList<Command> processGeometry(@NotNull VectorTile.Tile.Feature feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Object object = feature.getGeometryList();
            Intrinsics.checkNotNullExpressionValue(object, (String)"feature.geometryList");
            List<Integer> list = object;
            object = feature.getType();
            Intrinsics.checkNotNullExpressionValue(object, (String)"feature.type");
            return this.processGeometryWithList(list, (VectorTile.Tile.GeomType)((Object)object));
        }

        private final CommandTypeAndCount extractCommandTypeAndCount(int value) {
            int commandInteger = value & 7;
            int count = value >> 3;
            CommandType type = this.makeCommand(commandInteger);
            return new CommandTypeAndCount(type, count * this.getParamCount(type));
        }

        private final ArrayList<Command> convertToCommands(CommandType commandType, ArrayList<Integer> params) {
            ArrayList<Point> points = new ArrayList<Point>();
            int index = 0;
            while (index < params.size()) {
                Integer n = params.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"params[index]");
                int cmdX = ((Number)n).intValue();
                int n2 = index;
                if ((index = n2 + 1) >= params.size()) continue;
                Integer n3 = params.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"params[index]");
                int cmdY = ((Number)n3).intValue();
                points.add(new Point(cmdX, cmdY));
                int n4 = index;
                index = n4 + 1;
            }
            ArrayList<Command> commands = new ArrayList<Command>(params.size());
            for (Point point : points) {
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"point");
                commands.add(new Command(commandType, point));
            }
            return commands;
        }

        private final ArrayList<Command> convertPoints(ArrayList<Command> commands) {
            ArrayList<Command> newCommands = new ArrayList<Command>();
            for (Command command : commands) {
                if (newCommands.size() > 0) {
                    Command command2 = newCommands.get(newCommands.size() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)command2, (String)"newCommands[newCommands.size - 1]");
                    Command previous = command2;
                    Point newPoint = new Point(command.getPoint().getCoordX() + previous.getPoint().getCoordX(), command.getPoint().getCoordY() + previous.getPoint().getCoordY());
                    newCommands.add(new Command(command.getType(), newPoint));
                    continue;
                }
                newCommands.add(command);
            }
            return newCommands;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcloud/pace/sdk/poikit/poi/Geometry$CommandTypeAndCount;", "", "commandType", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "count", "", "(Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;I)V", "getCommandType", "()Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "setCommandType", "(Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;)V", "getCount", "()I", "setCount", "(I)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "cloud.pace.sdk"})
    public static final class CommandTypeAndCount {
        @Nullable
        private CommandType commandType;
        private int count;

        public CommandTypeAndCount(@Nullable CommandType commandType, int count) {
            this.commandType = commandType;
            this.count = count;
        }

        @Nullable
        public final CommandType getCommandType() {
            return this.commandType;
        }

        public final void setCommandType(@Nullable CommandType commandType) {
            this.commandType = commandType;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @Nullable
        public final CommandType component1() {
            return this.commandType;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final CommandTypeAndCount copy(@Nullable CommandType commandType, int count) {
            return new CommandTypeAndCount(commandType, count);
        }

        public static /* synthetic */ CommandTypeAndCount copy$default(CommandTypeAndCount commandTypeAndCount, CommandType commandType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                commandType = commandTypeAndCount.commandType;
            }
            if ((n2 & 2) != 0) {
                n = commandTypeAndCount.count;
            }
            return commandTypeAndCount.copy(commandType, n);
        }

        @NotNull
        public String toString() {
            return "CommandTypeAndCount(commandType=" + this.commandType + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result2 = this.commandType == null ? 0 : this.commandType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.count);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandTypeAndCount)) {
                return false;
            }
            CommandTypeAndCount commandTypeAndCount = (CommandTypeAndCount)other;
            if (this.commandType != commandTypeAndCount.commandType) {
                return false;
            }
            return this.count == commandTypeAndCount.count;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcloud/pace/sdk/poikit/poi/Geometry$Command;", "", "type", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "point", "Lcloud/pace/sdk/poikit/poi/Point;", "(Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;Lcloud/pace/sdk/poikit/poi/Point;)V", "getPoint", "()Lcloud/pace/sdk/poikit/poi/Point;", "setPoint", "(Lcloud/pace/sdk/poikit/poi/Point;)V", "getType", "()Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "setType", "(Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cloud.pace.sdk"})
    public static final class Command {
        @Nullable
        private CommandType type;
        @NotNull
        private Point point;

        public Command(@Nullable CommandType type, @NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            this.type = type;
            this.point = point;
        }

        @Nullable
        public final CommandType getType() {
            return this.type;
        }

        public final void setType(@Nullable CommandType commandType) {
            this.type = commandType;
        }

        @NotNull
        public final Point getPoint() {
            return this.point;
        }

        public final void setPoint(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
            this.point = point;
        }

        @Nullable
        public final CommandType component1() {
            return this.type;
        }

        @NotNull
        public final Point component2() {
            return this.point;
        }

        @NotNull
        public final Command copy(@Nullable CommandType type, @NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return new Command(type, point);
        }

        public static /* synthetic */ Command copy$default(Command command, CommandType commandType, Point point, int n, Object object) {
            if ((n & 1) != 0) {
                commandType = command.type;
            }
            if ((n & 2) != 0) {
                point = command.point;
            }
            return command.copy(commandType, point);
        }

        @NotNull
        public String toString() {
            return "Command(type=" + this.type + ", point=" + this.point + ")";
        }

        public int hashCode() {
            int result2 = this.type == null ? 0 : this.type.hashCode();
            result2 = result2 * 31 + this.point.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Command)) {
                return false;
            }
            Command command = (Command)other;
            if (this.type != command.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.point, (Object)command.point);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcloud/pace/sdk/poikit/poi/Geometry$CommandGeo;", "", "commandType", "Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "locationPoint", "Lcloud/pace/sdk/poikit/poi/LocationPoint;", "(Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;Lcloud/pace/sdk/poikit/poi/LocationPoint;)V", "getCommandType", "()Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "setCommandType", "(Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;)V", "getLocationPoint", "()Lcloud/pace/sdk/poikit/poi/LocationPoint;", "setLocationPoint", "(Lcloud/pace/sdk/poikit/poi/LocationPoint;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cloud.pace.sdk"})
    public static final class CommandGeo {
        @Nullable
        private CommandType commandType;
        @NotNull
        private LocationPoint locationPoint;

        public CommandGeo(@Nullable CommandType commandType, @NotNull LocationPoint locationPoint2) {
            Intrinsics.checkNotNullParameter((Object)locationPoint2, (String)"locationPoint");
            this.commandType = commandType;
            this.locationPoint = locationPoint2;
        }

        @Nullable
        public final CommandType getCommandType() {
            return this.commandType;
        }

        public final void setCommandType(@Nullable CommandType commandType) {
            this.commandType = commandType;
        }

        @NotNull
        public final LocationPoint getLocationPoint() {
            return this.locationPoint;
        }

        public final void setLocationPoint(@NotNull LocationPoint locationPoint2) {
            Intrinsics.checkNotNullParameter((Object)locationPoint2, (String)"<set-?>");
            this.locationPoint = locationPoint2;
        }

        @NotNull
        public String toString() {
            return this.commandType + ": " + this.locationPoint;
        }

        public int hashCode() {
            return this.locationPoint.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof CommandGeo) {
                return ((CommandGeo)other).locationPoint.getLat() == this.locationPoint.getLat() && ((CommandGeo)other).locationPoint.getLon() == this.locationPoint.getLon();
            }
            return false;
        }

        @Nullable
        public final CommandType component1() {
            return this.commandType;
        }

        @NotNull
        public final LocationPoint component2() {
            return this.locationPoint;
        }

        @NotNull
        public final CommandGeo copy(@Nullable CommandType commandType, @NotNull LocationPoint locationPoint2) {
            Intrinsics.checkNotNullParameter((Object)locationPoint2, (String)"locationPoint");
            return new CommandGeo(commandType, locationPoint2);
        }

        public static /* synthetic */ CommandGeo copy$default(CommandGeo commandGeo, CommandType commandType, LocationPoint locationPoint2, int n, Object object) {
            if ((n & 1) != 0) {
                commandType = commandGeo.commandType;
            }
            if ((n & 2) != 0) {
                locationPoint2 = commandGeo.locationPoint;
            }
            return commandGeo.copy(commandType, locationPoint2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcloud/pace/sdk/poikit/poi/Geometry$CommandType;", "", "(Ljava/lang/String;I)V", "MOVETO", "LINETO", "OTHER", "cloud.pace.sdk"})
    public static final class CommandType
    extends Enum<CommandType> {
        public static final /* enum */ CommandType MOVETO = new CommandType();
        public static final /* enum */ CommandType LINETO = new CommandType();
        public static final /* enum */ CommandType OTHER = new CommandType();
        private static final /* synthetic */ CommandType[] $VALUES;

        public static CommandType[] values() {
            return (CommandType[])$VALUES.clone();
        }

        public static CommandType valueOf(String value) {
            return Enum.valueOf(CommandType.class, value);
        }

        static {
            $VALUES = commandTypeArray = new CommandType[]{CommandType.MOVETO, CommandType.LINETO, CommandType.OTHER};
        }
    }
}

