/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.poikit.routing;

import android.text.TextUtils;
import cloud.pace.sdk.poikit.poi.LocationPoint;
import cloud.pace.sdk.poikit.routing.Bearing;
import cloud.pace.sdk.poikit.routing.NavigationApi;
import cloud.pace.sdk.poikit.routing.NavigationApiClient;
import cloud.pace.sdk.poikit.routing.NavigationRequest;
import cloud.pace.sdk.poikit.routing.NavigationResponse;
import cloud.pace.sdk.poikit.routing.Route;
import cloud.pace.sdk.poikit.utils.ApiException;
import cloud.pace.sdk.utils.CallBackKt;
import cloud.pace.sdk.utils.CallbackUtilsKt;
import cloud.pace.sdk.utils.Completion;
import cloud.pace.sdk.utils.Environment;
import cloud.pace.sdk.utils.Failure;
import cloud.pace.sdk.utils.Success;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\n0\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcloud/pace/sdk/poikit/routing/NavigationApiClient;", "", "environment", "Lcloud/pace/sdk/utils/Environment;", "apiKey", "", "(Lcloud/pace/sdk/utils/Environment;Ljava/lang/String;)V", "api", "Lcloud/pace/sdk/poikit/routing/NavigationApi;", "getRoute", "", "request", "Lcloud/pace/sdk/poikit/routing/NavigationRequest;", "completion", "Lkotlin/Function1;", "Lcloud/pace/sdk/utils/Completion;", "Lcloud/pace/sdk/poikit/routing/Route;", "cloud.pace.sdk"})
public final class NavigationApiClient {
    @NotNull
    private final NavigationApi api;

    public NavigationApiClient(@NotNull Environment environment, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.api = NavigationApi.Factory.create(environment.getRoutingBaseUrl(), apiKey);
    }

    /*
     * WARNING - void declaration
     */
    public final void getRoute(@NotNull NavigationRequest request, @NotNull Function1<? super Completion<Route>, Unit> completion) {
        Object[] $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Iterable $this$map$iv = request.getCoordinates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void point;
            LocationPoint locationPoint2 = (LocationPoint)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(point.getLon() + "," + point.getLat());
        }
        List coordPairs = (List)destination$iv$iv;
        String annotations2 = CollectionsKt.joinToString$default((Iterable)request.getAnnotations(), (CharSequence)",", null, null, (int)0, null, (Function1)getRoute.annotations.1.INSTANCE, (int)30, null);
        if (TextUtils.isEmpty((CharSequence)annotations2)) {
            annotations2 = "false";
        }
        List bearings = null;
        List<Bearing> list = request.getBearings();
        List list2 = bearings = list == null ? null : CollectionsKt.toMutableList((Collection)list);
        if (request.getUserCourseInDegrees() != null) {
            $this$mapTo$iv$iv = new Bearing[]{new Bearing((int)request.getUserCourseInDegrees().doubleValue(), 30)};
            bearings = CollectionsKt.mutableListOf((Object[])$this$mapTo$iv$iv);
            Iterable $this$forEach$iv = request.getCoordinates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocationPoint locationPoint3 = (LocationPoint)element$iv;
                boolean bl = false;
                bearings.add(null);
            }
        }
        String bearingString = null;
        if (bearings != null && bearings.size() > 0 && bearings.size() == request.getCoordinates().size()) {
            bearingString = CollectionsKt.joinToString$default((Iterable)bearings, (CharSequence)";", null, null, (int)0, null, (Function1)getRoute.2.INSTANCE, (int)30, null);
        }
        CallbackUtilsKt.enqueue(this.api.route(request.getNavigationMode().getApiName(), CollectionsKt.joinToString$default((Iterable)coordPairs, (CharSequence)";", null, null, (int)0, null, null, (int)62, null), request.getSteps(), bearingString, annotations2, request.getOverview().getApiName(), request.getGeometry().getApiName(), request.getAlternatives()), (Function1)new Function1<CallBackKt<NavigationResponse>, Unit>(completion){
            final /* synthetic */ Function1<Completion<Route>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull CallBackKt<NavigationResponse> $this$enqueue) {
                Intrinsics.checkNotNullParameter($this$enqueue, (String)"$this$enqueue");
                $this$enqueue.setOnResponse((Function1<Response<NavigationResponse>, Unit>)((Function1)new Function1<Response<NavigationResponse>, Unit>(this.$completion){
                    final /* synthetic */ Function1<Completion<Route>, Unit> $completion;
                    {
                        this.$completion = $completion;
                        super(1);
                    }

                    public final void invoke(@NotNull Response<NavigationResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        NavigationResponse body = (NavigationResponse)it.body();
                        if (it.isSuccessful() && body != null) {
                            List<Route> list = body.getRoutes();
                            this.$completion.invoke(new Success<Route>(list == null ? null : list.get(0)));
                        } else {
                            int n = it.code();
                            String string2 = it.message();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.message()");
                            this.$completion.invoke(new Failure<T>(new ApiException(n, string2, CallbackUtilsKt.getRequestId(it))));
                        }
                    }
                }));
                $this$enqueue.setOnFailure((Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$completion){
                    final /* synthetic */ Function1<Completion<Route>, Unit> $completion;
                    {
                        this.$completion = $completion;
                        super(1);
                    }

                    public final void invoke(@Nullable Throwable it) {
                        Throwable throwable = it;
                        if (throwable == null) {
                            throwable = new Exception("Unknown exception");
                        }
                        this.$completion.invoke(new Failure<T>(throwable));
                    }
                }));
            }
        });
    }
}

