/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0006\u0010\u0006\u001a\u00020\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lcloud/pace/sdk/utils/DeviceUtils;", "", "()V", "filterString", "", "string", "getAndroidVersion", "getAppAuthRedirectScheme", "context", "Landroid/content/Context;", "getDeviceModel", "getDeviceModelVersion", "getDeviceName", "getPACERedirectScheme", "cloud.pace.sdk"})
public final class DeviceUtils {
    @NotNull
    public static final DeviceUtils INSTANCE = new DeviceUtils();

    private DeviceUtils() {
    }

    @NotNull
    public final String getAndroidVersion() {
        String string2 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RELEASE");
        return string2;
    }

    @NotNull
    public final String getDeviceName() {
        return this.getDeviceModel() + " (" + this.getDeviceModelVersion() + ")";
    }

    @NotNull
    public final String getDeviceModelVersion() {
        String string2;
        CharSequence charSequence = Build.PRODUCT;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = Build.PRODUCT;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"PRODUCT");
            string2 = this.filterString((String)charSequence);
        } else {
            charSequence = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"DEVICE");
            string2 = this.filterString((String)charSequence);
        }
        return string2;
    }

    @NotNull
    public final String getDeviceModel() {
        CharSequence charSequence = Build.BRAND;
        String manufacturer = !(charSequence == null || charSequence.length() == 0) ? Build.BRAND : Build.MANUFACTURER;
        return this.filterString(manufacturer + " " + Build.MODEL);
    }

    private final String filterString(String string2) {
        int codePoint;
        for (int i = 0; i < string2.length(); i += Character.charCount(codePoint)) {
            codePoint = string2.codePointAt(i);
            if ((codePoint > 31 || codePoint == 9) && codePoint < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string2, 0, i);
            for (int j = i; j < string2.length(); j += Character.charCount(codePoint)) {
                codePoint = string2.codePointAt(j);
                buffer.writeUtf8CodePoint(codePoint > 31 && codePoint < 127 ? codePoint : 63);
            }
            return buffer.readUtf8();
        }
        return string2;
    }

    @Nullable
    public final String getPACERedirectScheme(@NotNull Context context) {
        String string2;
        ApplicationInfo applicationInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo2 = applicationInfo = packageManager == null ? null : packageManager.getApplicationInfo(context.getPackageName(), 128);
        if (applicationInfo2 == null) {
            string2 = null;
        } else {
            Bundle bundle = applicationInfo2.metaData;
            if (bundle == null) {
                string2 = null;
            } else {
                Object object = bundle.get("pace_redirect_scheme");
                string2 = object == null ? null : object.toString();
            }
        }
        return string2;
    }

    @Nullable
    public final String getAppAuthRedirectScheme(@NotNull Context context) {
        String string2;
        ApplicationInfo applicationInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo2 = applicationInfo = packageManager == null ? null : packageManager.getApplicationInfo(context.getPackageName(), 128);
        if (applicationInfo2 == null) {
            string2 = null;
        } else {
            Bundle bundle = applicationInfo2.metaData;
            if (bundle == null) {
                string2 = null;
            } else {
                Object object = bundle.get("appAuthRedirectScheme");
                string2 = object == null ? null : object.toString();
            }
        }
        return string2;
    }
}

