/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.utils;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import cloud.pace.sdk.PACECloudSDK;
import cloud.pace.sdk.idkit.model.OIDConfiguration;
import cloud.pace.sdk.utils.Environment;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0012\u001a\u0094\u0001\u0010\u0014\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\f2\b\b\u0002\u0010\u001a\u001a\u00020\f2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010!\u001a\u00020\u0010\u001a\u000f\u0010\"\u001a\u00020\u0010*\u0004\u0018\u00010#H\u0086\b\u001a\u000f\u0010$\u001a\u00020\u0010*\u0004\u0018\u00010#H\u0086\b\u001a\u0012\u0010%\u001a\u00020\f*\u00020&2\u0006\u0010'\u001a\u00020\u0001\u001a\n\u0010(\u001a\u00020\f*\u00020)\u001a\n\u0010*\u001a\u00020\f*\u00020)\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"dp", "", "", "getDp", "(F)I", "(I)I", "environment", "Lcloud/pace/sdk/utils/Environment;", "Lcloud/pace/sdk/PACECloudSDK;", "getEnvironment", "(Lcloud/pace/sdk/PACECloudSDK;)Lcloud/pace/sdk/utils/Environment;", "resourceUuid", "", "getResourceUuid", "(Ljava/lang/String;)Ljava/lang/String;", "equalsTo", "", "T", "", "other", "getOIDConfiguration", "Lcloud/pace/sdk/idkit/model/OIDConfiguration;", "clientId", "clientSecret", "scopes", "redirectUri", "responseType", "additionalParameters", "", "authorizationEndpoint", "endSessionEndpoint", "tokenEndpoint", "userInfoEndpoint", "integrated", "isNotNullOrBlank", "", "isNotNullOrEmpty", "randomHexString", "Lkotlin/String$Companion;", "length", "toIso8601", "Ljava/util/Date;", "toRfc3339Short", "cloud.pace.sdk"})
public final class ExtensionsKt {
    public static final int getDp(int $this$dp) {
        return (int)TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static final int getDp(float $this$dp) {
        return (int)TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    @Nullable
    public static final String getResourceUuid(@NotNull String $this$resourceUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$resourceUuid, (String)"<this>");
        String[] stringArray = new String[]{":"};
        return (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)$this$resourceUuid, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    public static final boolean isNotNullOrEmpty(@Nullable CharSequence $this$isNotNullOrEmpty) {
        boolean $i$f$isNotNullOrEmpty = false;
        CharSequence charSequence = $this$isNotNullOrEmpty;
        return !(charSequence == null || charSequence.length() == 0);
    }

    public static final boolean isNotNullOrBlank(@Nullable CharSequence $this$isNotNullOrBlank) {
        boolean $i$f$isNotNullOrBlank = false;
        CharSequence charSequence = $this$isNotNullOrBlank;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @NotNull
    public static final String toIso8601(@NotNull Date $this$toIso8601) {
        Intrinsics.checkNotNullParameter((Object)$this$toIso8601, (String)"<this>");
        SimpleDateFormat $this$toIso8601_u24lambda_u2d0 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        boolean bl = false;
        $this$toIso8601_u24lambda_u2d0.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string2 = $this$toIso8601_u24lambda_u2d0.format($this$toIso8601);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyy-M\u2026mat(this@toIso8601)\n    }");
        return string2;
    }

    @NotNull
    public static final String toRfc3339Short(@NotNull Date $this$toRfc3339Short) {
        Intrinsics.checkNotNullParameter((Object)$this$toRfc3339Short, (String)"<this>");
        SimpleDateFormat $this$toRfc3339Short_u24lambda_u2d1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        boolean bl = false;
        $this$toRfc3339Short_u24lambda_u2d1.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string2 = $this$toRfc3339Short_u24lambda_u2d1.format($this$toRfc3339Short);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyy-M\u2026his@toRfc3339Short)\n    }");
        return string2;
    }

    @NotNull
    public static final String randomHexString(@NotNull StringCompanionObject $this$randomHexString, int length) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$randomHexString, (String)"<this>");
        SecureRandom secureRandom = new SecureRandom();
        StringBuffer stringBuilder = new StringBuffer();
        int n2 = 0;
        while (n2 < length) {
            int it = n = n2++;
            boolean bl = false;
            stringBuilder.append(Integer.toHexString(secureRandom.nextInt()));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
        n = 0;
        String string3 = string2.substring(n, length);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public static final <T> boolean equalsTo(@NotNull List<? extends T> $this$equalsTo, @NotNull List<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$equalsTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return $this$equalsTo.size() == other.size() && $this$equalsTo.containsAll((Collection)other);
    }

    @NotNull
    public static final OIDConfiguration getOIDConfiguration(@NotNull Environment $this$getOIDConfiguration, @NotNull String clientId, @Nullable String clientSecret, @Nullable List<String> scopes, @NotNull String redirectUri, @NotNull String responseType, @Nullable Map<String, String> additionalParameters, @Nullable String authorizationEndpoint, @Nullable String endSessionEndpoint, @Nullable String tokenEndpoint, @Nullable String userInfoEndpoint, boolean integrated) {
        OIDConfiguration oIDConfiguration;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getOIDConfiguration), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getOIDConfiguration.ordinal()]) {
            case 1: {
                oIDConfiguration = OIDConfiguration.Companion.development(clientId, clientSecret, scopes, redirectUri, responseType, additionalParameters, authorizationEndpoint, endSessionEndpoint, tokenEndpoint, userInfoEndpoint, integrated);
                break;
            }
            case 2: {
                oIDConfiguration = OIDConfiguration.Companion.sandbox(clientId, clientSecret, scopes, redirectUri, responseType, additionalParameters, authorizationEndpoint, endSessionEndpoint, tokenEndpoint, userInfoEndpoint, integrated);
                break;
            }
            case 3: {
                oIDConfiguration = OIDConfiguration.Companion.staging(clientId, clientSecret, scopes, redirectUri, responseType, additionalParameters, authorizationEndpoint, endSessionEndpoint, tokenEndpoint, userInfoEndpoint, integrated);
                break;
            }
            case 4: {
                oIDConfiguration = OIDConfiguration.Companion.production(clientId, clientSecret, scopes, redirectUri, responseType, additionalParameters, authorizationEndpoint, endSessionEndpoint, tokenEndpoint, userInfoEndpoint, integrated);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return oIDConfiguration;
    }

    public static /* synthetic */ OIDConfiguration getOIDConfiguration$default(Environment environment, String string2, String string3, List list, String string4, String string5, Map map, String string6, String string7, String string8, String string9, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            string5 = "code";
        }
        if ((n & 0x20) != 0) {
            map = null;
        }
        if ((n & 0x40) != 0) {
            string6 = null;
        }
        if ((n & 0x80) != 0) {
            string7 = null;
        }
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        if ((n & 0x200) != 0) {
            string9 = null;
        }
        if ((n & 0x400) != 0) {
            bl = false;
        }
        return ExtensionsKt.getOIDConfiguration(environment, string2, string3, list, string4, string5, map, string6, string7, string8, string9, bl);
    }

    @NotNull
    public static final Environment getEnvironment(@NotNull PACECloudSDK $this$environment) {
        Intrinsics.checkNotNullParameter((Object)$this$environment, (String)"<this>");
        return $this$environment.getConfiguration$cloud_pace_sdk().getEnvironment();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Environment.values().length];
            nArray[Environment.DEVELOPMENT.ordinal()] = 1;
            nArray[Environment.SANDBOX.ordinal()] = 2;
            nArray[Environment.STAGING.ordinal()] = 3;
            nArray[Environment.PRODUCTION.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

