/*
 * Decompiled with CFR 0.152.
 */
package moe.banana.jsonapi2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.banana.jsonapi2.ArrayDocument;
import moe.banana.jsonapi2.Document;
import moe.banana.jsonapi2.ObjectDocument;
import moe.banana.jsonapi2.Resource;
import moe.banana.jsonapi2.ResourceIdentifier;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import retrofit2.Converter;
import retrofit2.Retrofit;

public final class JsonApiConverterFactory
extends Converter.Factory {
    private final Moshi moshi;
    private final boolean lenient;
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/vnd.api+json");

    public static JsonApiConverterFactory create() {
        return JsonApiConverterFactory.create(new Moshi.Builder().build());
    }

    public static JsonApiConverterFactory create(Moshi moshi) {
        return new JsonApiConverterFactory(moshi, false);
    }

    private JsonApiConverterFactory(Moshi moshi, boolean lenient) {
        if (moshi == null) {
            throw new NullPointerException("moshi == null");
        }
        this.moshi = moshi;
        this.lenient = lenient;
    }

    public JsonApiConverterFactory asLenient() {
        return new JsonApiConverterFactory(this.moshi, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonAdapter<?> getAdapterFromType(Type type) {
        Class rawType = Types.getRawType((Type)type);
        if (rawType.isArray() && ResourceIdentifier.class.isAssignableFrom(rawType.getComponentType())) {
            return this.moshi.adapter((Type)Types.newParameterizedType(Document.class, (Type[])new Type[]{rawType.getComponentType()}));
        }
        if (List.class.isAssignableFrom(rawType) && type instanceof ParameterizedType) {
            Type typeParameter = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (!(typeParameter instanceof Class)) return null;
            if (!ResourceIdentifier.class.isAssignableFrom((Class)typeParameter)) return null;
            return this.moshi.adapter((Type)Types.newParameterizedType(Document.class, (Type[])new Type[]{typeParameter}));
        }
        if (ResourceIdentifier.class.isAssignableFrom(rawType)) {
            return this.moshi.adapter((Type)Types.newParameterizedType(Document.class, (Type[])new Type[]{rawType}));
        }
        if (!Document.class.isAssignableFrom(rawType)) return null;
        return this.moshi.adapter((Type)Types.newParameterizedType(Document.class, (Type[])new Type[]{Resource.class}));
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JsonAdapter adapter = this.getAdapterFromType(type);
        if (adapter == null) {
            return null;
        }
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        return new MoshiResponseBodyConverter((JsonAdapter<Document>)adapter, type);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JsonAdapter adapter = this.getAdapterFromType(type);
        if (adapter == null) {
            return null;
        }
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        return new MoshiRequestBodyConverter((JsonAdapter<Document>)adapter, type);
    }

    private static class MoshiRequestBodyConverter<T>
    implements Converter<T, RequestBody> {
        private final JsonAdapter<Document> adapter;
        private final Class<T> rawType;

        MoshiRequestBodyConverter(JsonAdapter<Document> adapter, Type type) {
            this.adapter = adapter;
            this.rawType = Types.getRawType((Type)type);
        }

        public RequestBody convert(T value) throws IOException {
            ArrayDocument arrayDocument;
            Document document;
            if (Document.class.isAssignableFrom(this.rawType)) {
                document = (Document)value;
            } else if (List.class.isAssignableFrom(this.rawType)) {
                arrayDocument = new ArrayDocument();
                List a = (List)value;
                if (!a.isEmpty() && a.get(0) != null && ((ResourceIdentifier)a.get(0)).getContext() != null) {
                    arrayDocument = ((ResourceIdentifier)a.get(0)).getContext().asArrayDocument();
                }
                arrayDocument.addAll((Collection)a);
                document = arrayDocument;
            } else if (this.rawType.isArray()) {
                arrayDocument = new ArrayDocument();
                if (Array.getLength(value) > 0 && ((ResourceIdentifier)Array.get(value, 0)).getContext() != null) {
                    arrayDocument = ((ResourceIdentifier)Array.get(value, 0)).getContext().asArrayDocument();
                }
                for (int i = 0; i != Array.getLength(value); ++i) {
                    arrayDocument.add((ResourceIdentifier)Array.get(value, i));
                }
                document = arrayDocument;
            } else {
                ResourceIdentifier data = (ResourceIdentifier)value;
                ObjectDocument objectDocument = new ObjectDocument();
                if (data.getDocument() != null) {
                    objectDocument = data.getDocument().asObjectDocument();
                }
                objectDocument.set(data);
                document = objectDocument;
            }
            Buffer buffer = new Buffer();
            this.adapter.toJson((BufferedSink)buffer, (Object)document);
            return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
        }
    }

    private static class MoshiResponseBodyConverter<R>
    implements Converter<ResponseBody, R> {
        private final JsonAdapter<Document> adapter;
        private final Class<R> rawType;

        MoshiResponseBodyConverter(JsonAdapter<Document> adapter, Type type) {
            this.adapter = adapter;
            this.rawType = Types.getRawType((Type)type);
        }

        public R convert(ResponseBody value) throws IOException {
            try {
                Document document = (Document)this.adapter.fromJson(value.source());
                if (Document.class.isAssignableFrom(this.rawType)) {
                    Document document2 = document;
                    return (R)document2;
                }
                if (List.class.isAssignableFrom(this.rawType)) {
                    ArrayDocument arrayDocument = document.asArrayDocument();
                    List a = this.rawType.isAssignableFrom(ArrayList.class) ? new ArrayList() : (List)this.rawType.newInstance();
                    a.addAll(arrayDocument);
                    List list = a;
                    return (R)list;
                }
                if (this.rawType.isArray()) {
                    ArrayDocument arrayDocument = document.asArrayDocument();
                    Object a = Array.newInstance(this.rawType.getComponentType(), arrayDocument.size());
                    for (int i = 0; i != Array.getLength(a); ++i) {
                        Array.set(a, i, arrayDocument.get(i));
                    }
                    Object object = a;
                    return (R)object;
                }
                ResourceIdentifier resourceIdentifier = document.asObjectDocument().get();
                return (R)resourceIdentifier;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Cannot find default constructor of [" + this.rawType.getCanonicalName() + "].", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot access default constructor of [" + this.rawType.getCanonicalName() + "].", e);
            }
            finally {
                value.close();
            }
        }
    }
}

