/*
 * PLEASE DO NOT EDIT!
 *
 * Generated by SwagGen with Kotlin template.
 * https://github.com/pace/SwagGen
 */

package cloud.pace.sdk.api.fueling.generated.request.fueling

import cloud.pace.sdk.api.fueling.FuelingAPI
import cloud.pace.sdk.api.fueling.generated.model.PumpResponse
import cloud.pace.sdk.api.request.BaseRequest
import com.google.gson.annotations.SerializedName
import com.squareup.moshi.Json
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.HeaderMap
import retrofit2.http.Path
import retrofit2.http.Query

object WaitOnPumpStatusChangeAPI {

    interface WaitOnPumpStatusChangeService {
        /* Wait for a status change on a given pump */
        /* Uses **long polling** to wait for a status change on a given pump. Returns as soon as the status has changed or after the number of seconds provided by the optional `timeout` query parameter (default timeout is 30 seconds). In case of timeout (408 status code) you're safe to start the request again. Instantaneously returns if `lastStatus` was given and already changed between request. If successful, it returns the same structure as the normal status call
<br><br>
Only use after approaching, otherwise returns `403 Forbidden`.
 */
        @GET("gas-stations/{gasStationId}/pumps/{pumpId}/wait-for-status-change")
        fun waitOnPumpStatusChange(
            @HeaderMap headers: Map<String, String>,
            /* Gas station ID */
            @Path("gasStationId") gasStationId: String,
            /* Pump ID */
            @Path("pumpId") pumpId: String,
            /* Use **long polling** for status updates */
            @Query("update") update: Update? = null,
            /* Pump status */
            @Query("lastStatus") lastStatus: LastStatus? = null,
            /* Timeout in seconds */
            @Query("timeout") timeout: Int? = null
        ): Call<PumpResponse>
    }

    /* Use **long polling** for status updates */
    enum class Update(val value: String) {
        @SerializedName("longPolling")
        @Json(name = "longPolling")
        LONGPOLLING("longPolling")
    }

    /* Pump status */
    enum class LastStatus(val value: String) {
        @SerializedName("free")
        @Json(name = "free")
        FREE("free"),

        @SerializedName("inUse")
        @Json(name = "inUse")
        INUSE("inUse"),

        @SerializedName("readyToPay")
        @Json(name = "readyToPay")
        READYTOPAY("readyToPay"),

        @SerializedName("locked")
        @Json(name = "locked")
        LOCKED("locked"),

        @SerializedName("inTransaction")
        @Json(name = "inTransaction")
        INTRANSACTION("inTransaction"),

        @SerializedName("outOfOrder")
        @Json(name = "outOfOrder")
        OUTOFORDER("outOfOrder")
    }

    open class Request : BaseRequest() {

        fun waitOnPumpStatusChange(
            gasStationId: String,
            pumpId: String,
            update: Update? = null,
            lastStatus: LastStatus? = null,
            timeout: Int? = null,
            readTimeout: Long? = null,
            additionalHeaders: Map<String, String>? = null,
            additionalParameters: Map<String, String>? = null
        ): Call<PumpResponse> {
            val headers = headers(true, "application/vnd.api+json", "application/vnd.api+json", additionalHeaders)

            return retrofit(FuelingAPI.baseUrl, additionalParameters, readTimeout)
                .create(WaitOnPumpStatusChangeService::class.java)
                .waitOnPumpStatusChange(
                    headers,
                    gasStationId,
                    pumpId,
                    update,
                    lastStatus,
                    timeout
                )
        }
    }

    fun FuelingAPI.FuelingAPI.waitOnPumpStatusChange(
        gasStationId: String,
        pumpId: String,
        update: Update? = null,
        lastStatus: LastStatus? = null,
        timeout: Int? = null,
        readTimeout: Long? = null,
        additionalHeaders: Map<String, String>? = null,
        additionalParameters: Map<String, String>? = null
    ) = Request().waitOnPumpStatusChange(
        gasStationId,
        pumpId,
        update,
        lastStatus,
        timeout,
        readTimeout,
        additionalHeaders,
        additionalParameters
    )
}
