/*
 * PLEASE DO NOT EDIT!
 *
 * Generated by SwagGen with Kotlin template.
 * https://github.com/pace/SwagGen
 */

package cloud.pace.sdk.api.pay.generated.request.paymentTransactions

import cloud.pace.sdk.api.pay.PayAPI
import cloud.pace.sdk.api.request.BaseRequest
import com.google.gson.annotations.SerializedName
import com.squareup.moshi.Json
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.HeaderMap
import retrofit2.http.Path
import retrofit2.http.Query

object GetReceiptByFormatAPI {

    interface GetReceiptByFormatService {
        /* Get receipt (download,file) for a single transaction in given file format */
        /* Provides the receipt that has already been sent via email (when processing the payment) as download in the provided file format.
 */
        @GET("receipts/{transactionID}.{fileFormat}")
        fun getReceiptByFormat(
            @HeaderMap headers: Map<String, String>,
            /* ID of the payment transaction */
            @Path("transactionID") transactionID: String,
            /* Format of the expected file */
            @Path("fileFormat") fileFormat: FileFormat? = null,
            /* (Optional) Specify the language you want the returned receipt to be localized in.
Returns the receipt in the default language that is available if the specified language is not available.
Language does not have to be valid language. For example, `language=local` means that the receipt should be displayed
in the language that is determined to be spoken in the area that the point of intereset at which the receipt has been generated at.
*Prefer using the `Accept-Language` header if you use this endpoint on an end-user device.*
 */
            @Query("language") language: String? = null
        ): Call<ResponseBody>
    }

    /* Format of the expected file */
    enum class FileFormat(val value: String) {
        @SerializedName("png")
        @Json(name = "png")
        PNG("png"),

        @SerializedName("pdf")
        @Json(name = "pdf")
        PDF("pdf")
    }

    open class Request : BaseRequest() {

        fun getReceiptByFormat(
            transactionID: String,
            fileFormat: FileFormat? = null,
            language: String? = null,
            readTimeout: Long? = null,
            additionalHeaders: Map<String, String>? = null,
            additionalParameters: Map<String, String>? = null
        ): Call<ResponseBody> {
            val headers = headers(true, "application/json", "application/json", additionalHeaders)

            return retrofit(PayAPI.baseUrl, additionalParameters, readTimeout)
                .create(GetReceiptByFormatService::class.java)
                .getReceiptByFormat(
                    headers,
                    transactionID,
                    fileFormat,
                    language
                )
        }
    }

    fun PayAPI.PaymentTransactionsAPI.getReceiptByFormat(
        transactionID: String,
        fileFormat: FileFormat? = null,
        language: String? = null,
        readTimeout: Long? = null,
        additionalHeaders: Map<String, String>? = null,
        additionalParameters: Map<String, String>? = null
    ) = Request().getReceiptByFormat(
        transactionID,
        fileFormat,
        language,
        readTimeout,
        additionalHeaders,
        additionalParameters
    )
}
