/*
 * PLEASE DO NOT EDIT!
 *
 * Generated by SwagGen with Kotlin template.
 * https://github.com/pace/SwagGen
 */

package cloud.pace.sdk.api.poi.generated.request.apps

import cloud.pace.sdk.api.poi.POIAPI
import cloud.pace.sdk.api.poi.generated.model.LocationBasedApps
import cloud.pace.sdk.api.request.BaseRequest
import cloud.pace.sdk.utils.toIso8601
import com.google.gson.annotations.SerializedName
import com.squareup.moshi.Json
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.HeaderMap
import retrofit2.http.Query
import java.util.Date

object GetAppsAPI {

    interface GetAppsService {
        /* Returns a paginated list of apps */
        /* Returns a paginated list of apps optionally filtered by type and/or query.
 */
        @GET("apps")
        fun getApps(
            @HeaderMap headers: Map<String, String>,
            /* page number */
            @Query("page[number]") pagenumber: Int? = null,
            /* items per page */
            @Query("page[size]") pagesize: Int? = null,
            /* Filter for poi type, no filter returns all types */
            @Query("filter[appType]") filterappType: FilterappType? = null,
            /* Filters the location-based app by its caching method.
 */
            @Query("filter[cache]") filtercache: Filtercache? = null,
            /* Filters location-based apps that were changed (created/updated/deleted) since the given point in time */
            @Query("filter[since]") filtersince: String? = null
        ): Call<LocationBasedApps>
    }

    /* Filter for poi type, no filter returns all types */
    enum class FilterappType(val value: String) {
        @SerializedName("fueling")
        @Json(name = "fueling")
        FUELING("fueling")
    }

    /* Filters the location-based app by its caching method.
     */
    enum class Filtercache(val value: String) {
        @SerializedName("preload")
        @Json(name = "preload")
        PRELOAD("preload"),

        @SerializedName("approaching")
        @Json(name = "approaching")
        APPROACHING("approaching")
    }

    open class Request : BaseRequest() {

        fun getApps(
            pagenumber: Int? = null,
            pagesize: Int? = null,
            filterappType: FilterappType? = null,
            filtercache: Filtercache? = null,
            filtersince: Date? = null,
            readTimeout: Long? = null,
            additionalHeaders: Map<String, String>? = null,
            additionalParameters: Map<String, String>? = null
        ): Call<LocationBasedApps> {
            val headers = headers(true, "application/vnd.api+json", "application/vnd.api+json", additionalHeaders)

            return retrofit(POIAPI.baseUrl, additionalParameters, readTimeout)
                .create(GetAppsService::class.java)
                .getApps(
                    headers,
                    pagenumber,
                    pagesize,
                    filterappType,
                    filtercache,
                    filtersince?.toIso8601()?.dropLast(9)?.let { it + 'Z' }
                )
        }
    }

    fun POIAPI.AppsAPI.getApps(
        pagenumber: Int? = null,
        pagesize: Int? = null,
        filterappType: FilterappType? = null,
        filtercache: Filtercache? = null,
        filtersince: Date? = null,
        readTimeout: Long? = null,
        additionalHeaders: Map<String, String>? = null,
        additionalParameters: Map<String, String>? = null
    ) = Request().getApps(
        pagenumber,
        pagesize,
        filterappType,
        filtercache,
        filtersince,
        readTimeout,
        additionalHeaders,
        additionalParameters
    )
}
