/*
 * PLEASE DO NOT EDIT!
 *
 * Generated by SwagGen with Kotlin template.
 * https://github.com/pace/SwagGen
 */

package cloud.pace.sdk.api.user

import cloud.pace.sdk.api.API

/** Welcome to the PACE User Management API documentation. This API is responsible for user related actions.
# Handling Terms of Service
PACE services often require the acceptance of *Terms of Service* to execute API actions. The terms are required for legal reasons. Some of the API surface may not require the acceptance of terms. Usually, the terms need to be accepted before doing manipulations like `DELETE`, `PUT`, `POST` and similar. If a service requires a user to accept the terms of service a `451 Unavailable For Legal Reasons` status code will be returned together with a `Location` header that indicates the terms that need to be accepted. The URL points to the [GetTerms](#operation/GetTerms) and can then be followed by the [AcceptTerms](#operation/AcceptTerms). The terms can be viewed and accepted with a regular browser.
A simple way to assure that the *terms of service* are accepted, before the user does any action is, to call the [CheckTerms](#operation/CheckTerms) API before the application, together with a `redirectUri` to the next step of the application process.
 */
object UserAPI {

    const val VERSION = "2021-2"
    internal val baseUrl = "${API.baseUrl}/user/$VERSION/"

    class AuditLogAPI
    class CallbacksAPI
    class CredentialsAPI
    class FederatedIdentityAPI
    class OAuth2API
    class PhoneAPI
    class PreferencesAPI
    class SessionsAPI
    class TOTPAPI
    class TermsAPI
    class UserAPI

    val API.auditLog: AuditLogAPI by lazy { AuditLogAPI() }
    val API.callbacks: CallbacksAPI by lazy { CallbacksAPI() }
    val API.credentials: CredentialsAPI by lazy { CredentialsAPI() }
    val API.federatedIdentity: FederatedIdentityAPI by lazy { FederatedIdentityAPI() }
    val API.oAuth2: OAuth2API by lazy { OAuth2API() }
    val API.phone: PhoneAPI by lazy { PhoneAPI() }
    val API.preferences: PreferencesAPI by lazy { PreferencesAPI() }
    val API.sessions: SessionsAPI by lazy { SessionsAPI() }
    val API.totp: TOTPAPI by lazy { TOTPAPI() }
    val API.terms: TermsAPI by lazy { TermsAPI() }
    val API.user: UserAPI by lazy { UserAPI() }
}
