/*
 * PLEASE DO NOT EDIT!
 *
 * Generated by SwagGen with Kotlin template.
 * https://github.com/pace/SwagGen
 */

package cloud.pace.sdk.api.user.generated.request.oAuth2

import cloud.pace.sdk.api.request.BaseRequest
import cloud.pace.sdk.api.user.UserAPI
import cloud.pace.sdk.api.user.generated.model.OAuth2Token
import cloud.pace.sdk.api.user.generated.model.OAuth2TokenExchange
import retrofit2.Call
import retrofit2.http.HeaderMap
import retrofit2.http.POST

object TokenExchangeAPI {

    interface TokenExchangeService {
        /* Exchange User  Token */
        /* Creates a PACE token for a foreign token using the OIDC token-exchange.
The token provided **must** include the following claims (see https://datatracker.ietf.org/doc/html/rfc7519#page-9):
* Claim `aud`: e.g. `"api.pace.cloud"` audience of this token is PACE API, has to match the host requested via HTTP.
  In development or other environments the URL may be different therefore, e.g. `"api.dev.pace.cloud"`.
* Claim `iss`: e.g. `"https://as.example.com"` the issuer of the token, issuer needs to be known to PACE
* Claim `iat`: e.g. `1516239022` time the token was issued
* Claim `exp`: e.g. `1516249022` identifies the expiration time on or after which the JWT MUST NOT
  be accepted for processing
* Claim `sub`: e.g. `"03836e1f-58ed-4d67-baa0-a73bf77b9d5d"` unique account id on the issuer side
* Claim `email`: e.g. `"03836e1f-58ed-4d67-baa0-a73bf77b9d5d@as.example.com"` usually an account proxy email
  (will receive SMTP mails). Usually subject ID + issuer domain to provide a unique account id.
Optionally the token may contain:
* Claim `name`: e.g. `"Jane Doe"` full name of the user (used in emails addressed to the proxy)
* Claim `given_name`: e.g. `"Jane"` given name of the user
* Claim `family_name`: e.g. `"Doe"` family name of the user
* Claim `locale`: e.g. `"de"` or `"en-US"` language code of the user (format ISO 639-1 Alpha-2 [ISO639‑1] language code in lowercase and an ISO 3166-1 Alpha-2 [ISO3166‑1] country code in uppercase, separated by a dash) defaults to `"en"`
* Claim `zoneinfo`: e.g. `"Europe/Paris"` timezone information defaults to `"Europe/Berlin"` (TZ database)
RFCs for reference:
* https://datatracker.ietf.org/doc/html/rfc8693
* https://datatracker.ietf.org/doc/html/rfc7519
 */
        @POST("protocol/openid-connect/token")
        fun tokenExchange(
            @HeaderMap headers: Map<String, String>,
            @retrofit2.http.Body body: OAuth2TokenExchange
        ): Call<OAuth2Token>
    }

    open class Request : BaseRequest() {

        fun tokenExchange(
            body: OAuth2TokenExchange,
            readTimeout: Long? = null,
            additionalHeaders: Map<String, String>? = null,
            additionalParameters: Map<String, String>? = null
        ): Call<OAuth2Token> {
            val headers = headers(true, "application/x-www-form-urlencoded", "application/x-www-form-urlencoded", additionalHeaders)

            return retrofit(UserAPI.baseUrl, additionalParameters, readTimeout)
                .create(TokenExchangeService::class.java)
                .tokenExchange(
                    headers,
                    body
                )
        }
    }

    fun UserAPI.OAuth2API.tokenExchange(
        body: OAuth2TokenExchange,
        readTimeout: Long? = null,
        additionalHeaders: Map<String, String>? = null,
        additionalParameters: Map<String, String>? = null
    ) = Request().tokenExchange(
        body,
        readTimeout,
        additionalHeaders,
        additionalParameters
    )
}
