package cn.atcoder.monitoring.platform.api;

import cn.atcoder.monitoring.platform.domain.common.CommonResponse;
import cn.atcoder.monitoring.platform.domain.datacalc.DataCalcAnalysisKeyDTO;
import cn.atcoder.monitoring.platform.domain.request.DataCalcKeyDTO;

import java.util.List;

/**
 * @author yangjunda1
 * @description
 * @date 4/17/19 4:04 PM
 */
public interface DataCalcAnalysisKeysSoaService {

    /**
     * 保存/修改应用信息
     *
     * @param dataCalcAnalysisKeyDTO
     * @return
     */
    CommonResponse<Boolean> saveKey(DataCalcAnalysisKeyDTO dataCalcAnalysisKeyDTO);

    /**
     * 修改应用信息
     */
    CommonResponse<Boolean> updateKey(DataCalcAnalysisKeyDTO dataCalcAnalysisKeyDTO);

    /**
     * 根据应用id获取应用信息
     */
    CommonResponse<List<DataCalcAnalysisKeyDTO>> selectByAppId(DataCalcKeyDTO dataCalcKeyDTO);

    /**
     * 根据应用id获取应用信息
     */
    CommonResponse<DataCalcAnalysisKeyDTO> selectById(DataCalcKeyDTO dataCalcKeyDTO);

    /**
     * 根据应用id获取应用信息
     */
    CommonResponse<DataCalcAnalysisKeyDTO> selectByIdWithSysName(DataCalcKeyDTO dataCalcKeyDTO);

    /**
     * 根据应用id删除
     */
    CommonResponse<Boolean> delById(DataCalcKeyDTO dataCalcKeyDTO);
}
