package cn.atcoder.monitoring.platform.api;

import cn.atcoder.monitoring.platform.domain.common.CommonResponse;
import cn.atcoder.monitoring.platform.domain.common.PageVo;
import cn.atcoder.monitoring.platform.domain.datacalc.AppMenuVO;
import cn.atcoder.monitoring.platform.domain.datacalc.DataCalcAnalysisTokenResponse;
import cn.atcoder.monitoring.platform.domain.datacalc.DataCalcAnalysisTokenVO;
import cn.atcoder.monitoring.platform.domain.request.ApplicationFindDTO;
import cn.atcoder.monitoring.platform.domain.request.OperatorDTO;
import cn.atcoder.monitoring.platform.domain.request.TokenPageDTO;

import java.util.List;

/**
 * @author yangjunda1
 * @description
 * @date 4/12/19 4:55 PM
 */
public interface DataCalcAnalysisTokenSoaService {

    /**
     * 保存/修改Token信息
     * @param dataCalcAnalysisToken
     * @return
     */
    CommonResponse<Boolean> saveToken(DataCalcAnalysisTokenResponse dataCalcAnalysisToken);

    /**
     * 修改Token信息
     */
    CommonResponse<Boolean> updateToken(DataCalcAnalysisTokenResponse dataCalcAnalysisToken);

    CommonResponse<Boolean> deleteToken(DataCalcAnalysisTokenResponse dataCalcAnalysisToken);
    /**
     * 修改Token信息
     */
    CommonResponse<Boolean> updateTokenStatus(DataCalcAnalysisTokenResponse dataCalcAnalysisToken);

    /**
     * 根据id获取token信息
     */
    CommonResponse<DataCalcAnalysisTokenResponse> selectById(Long id);

    /**
     * 分页查询token vo数据
     * @return
     */
    CommonResponse<PageVo<DataCalcAnalysisTokenVO>> list(TokenPageDTO tokenPageDTO);

    /**
     * 获取某系统下的所有有效token
     * @return
     */
    CommonResponse<List<DataCalcAnalysisTokenResponse>> listAll(ApplicationFindDTO applicationFindDTO);

    /**
     * 获取某用户下的所有有效系统菜单
     * @return
     */
    CommonResponse<List<AppMenuVO>> listAllAppMenus(OperatorDTO operatorDTO);
}
